/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.simple;

import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Steer;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;

public class Arrive
implements ISteeringBehavior,
Serializable {
    static final long serialVersionUID = 1L;
    private final double d_slowingDist;
    private ITpSource d_ptSrc;

    public Arrive(ITpSource ptSrc) {
        this(ptSrc, 1.0);
    }

    public Arrive(ITpSource ptSrc, double slowingDist) {
        this.d_ptSrc = ptSrc;
        this.d_slowingDist = slowingDist;
    }

    @Override
    public double getTimeLimit(KB kb, OccAgent agent) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
    }

    public double getDistanceToGoal(KB kb, OccAgent agent) {
        return agent.getPos().distance(this.d_ptSrc.getTriPoint().p);
    }

    @Override
    public PathFollow getPathFollow(OccAgent agent) {
        return null;
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) {
        LineSeg3D curve = new LineSeg3D(agent.getPos(), this.d_ptSrc.getTriPoint().p);
        return Util.generateSeekCurve(kb, agent, curve, true, EdgeFilters.acceptAll());
    }

    @Override
    public Steer steer(KB world, OccAgent agent, SeekCurve seek, Predicate<OccAgent> agentFilter) {
        Vector3d offset = Util3D.vector(agent.getPos(), this.d_ptSrc.getTriPoint().p);
        if (offset.length() < 0.1) {
            return new Steer(null, Util3D.VEC_ZERO, agent.getDirFacing(), agent.getOcc().priority, 1.0, Filters.acceptAll(), false, new OccAgent[0]);
        }
        double maxVel = OccAgent.getMaxVel(world, agent.getOcc(), offset);
        double distance = offset.length();
        double rampedSpeed = maxVel * (distance / this.d_slowingDist);
        double clippedSpeed = Math.min(rampedSpeed, maxVel);
        Vector3d desired = new Vector3d(offset);
        desired.scale(clippedSpeed / distance);
        desired = Util.projectAlongZEq(agent.getLoc().tri.plane, desired);
        assert (Util.isValid(desired));
        return new Steer(null, desired, desired, agent.getOcc().priority, 1.0, Filters.acceptAll(), false, new OccAgent[0]);
    }
}

