/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import inferno.data2.Occupant;
import inferno.data2.PolygonShape;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class SeekSeparation
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final boolean SSEEKSEP = System.getProperty("SSEEKSEP") != null;
    public static final int FILTERID = -1348979970;
    private final double d_maxSpeed;
    private final Vector2d d_preferredDir2d;
    private final List<Pair<OccAgent, Point3d>> d_nearOccPredictPositions;
    private transient double[] d_cachedStopCost = null;

    public SeekSeparation(KB kb, OccInfo oi, SeekInfo seekInfo, Senses senses, Predicate<OccAgent> separateFrom) {
        Vector3d dir = seekInfo.seekCurve.getTangent(0.0);
        dir.normalize();
        this.d_maxSpeed = OccAgent.getMaxVel(kb, oi.oa.getOcc(), dir);
        this.d_preferredDir2d = new Vector2d(dir.x, dir.y);
        Util2D.safeNormalize(this.d_preferredDir2d, 1.0E-9);
        Collection<OccAgent> nearOccs = senses.getNearOccs(-1348979970, oi);
        this.d_nearOccPredictPositions = new ArrayList<Pair<OccAgent, Point3d>>();
        double reacTime = SeekSeparation.getPredictTime(oi);
        for (OccAgent nearOcc : InvSteerUtil.getOccsAffectingDensity(kb, oi.oa, seekInfo, senses, nearOccs)) {
            if (!separateFrom.test(nearOcc)) continue;
            this.d_nearOccPredictPositions.add(new Pair<OccAgent, Point3d>(nearOcc, Util3D.add(nearOcc.getPos(), (Tuple3d)Util3D.scale(nearOcc.getVel(), reacTime))));
        }
    }

    private static double getPredictTime(OccInfo oi) {
        return (double)oi.oa.getOcc().reacTime * 1.0;
    }

    public double[] getCost(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo, Vector3d dir, boolean isSocialDistancing, Consumer<OccAgent> highCostOccs) {
        double frac;
        double predictSpeed;
        Vector2d testDir;
        Point3d predictPos;
        if (this.d_nearOccPredictPositions.isEmpty()) {
            return new double[]{0.0, oi.cache.maxVel};
        }
        Occupant occ = oi.oa.getOcc();
        if (dir == null) {
            if (this.d_cachedStopCost != null) {
                return this.d_cachedStopCost;
            }
            predictPos = occ.loc;
            testDir = this.d_preferredDir2d;
            if (testDir.lengthSquared() == 0.0) {
                return new double[]{0.0, oi.cache.maxVel};
            }
        } else {
            testDir = new Vector2d(dir.x, dir.y);
            double len = Util2D.safeNormalize(testDir, 1.0E-9);
            if (len == 0.0) {
                return new double[]{0.0, oi.cache.maxVel};
            }
            if (!isSocialDistancing && theUtil.lt0(testDir.dot(this.d_preferredDir2d), 1.0E-6) && !(oi.oa.getOcc().bodyShape instanceof PolygonShape)) {
                return new double[]{1.0, oi.cache.maxVel};
            }
            predictPos = Util3D.add(occ.loc, (Tuple3d)Util3D.scale(dir, oi.cache.maxVel * SeekSeparation.getPredictTime(oi)));
        }
        InvSteerUtil.DensityResult maxDensity = InvSteerUtil.getDensityFromSpacing(kb, oi, predictPos, testDir, this.d_nearOccPredictPositions);
        double d = predictSpeed = maxDensity.density == 0.0 ? this.d_maxSpeed : OccAgent.getMaxVel(kb, occ, maxDensity.density, dir);
        if (SSEEKSEP) {
            double maxSpecificFlow = 1.015;
            double specFlow = predictSpeed * maxDensity.density;
            frac = Math.min(specFlow / maxSpecificFlow, 1.0);
        } else {
            frac = predictSpeed / this.d_maxSpeed;
        }
        double[] cost = new double[]{1.0 - frac * frac, oi.cache.maxVel};
        if (highCostOccs != null && maxDensity.occ != null) {
            if (dir != null && this.d_cachedStopCost == null) {
                this.getCost(kb, oi, senses, seekInfo, null, isSocialDistancing, null);
            }
            if (cost[0] > this.d_cachedStopCost[0]) {
                OccAgent highCostOcc = maxDensity.occ;
                highCostOccs.accept(highCostOcc);
            }
        }
        if (dir == null) {
            this.d_cachedStopCost = cost;
        }
        return cost;
    }
}

