/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering;

import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.vecmath.Vector3d;

public class Steer
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final BiConsumer<KB, OccAgent> NOOP = new NoOp();
    public final Vector3d vel;
    public final Vector3d goalOrient;
    public final double turnVel;
    public final double priority;
    public final double squeezeFactor;
    public final OccAgent[] avoidOccs;
    public final Predicate<OccAgent> collisionFilter;
    public final BiConsumer<KB, OccAgent> postOp;
    public final Object meta;
    public final boolean tightGeometry;

    public Steer(Object meta, Vector3d vel, Vector3d goalOrient, double priority, double squeezeFactor, Predicate<OccAgent> collisionFilter, boolean tightGeometry, OccAgent ... avoidOccs) {
        this(meta, vel, goalOrient, Double.NaN, priority, squeezeFactor, collisionFilter, tightGeometry, NOOP, avoidOccs);
    }

    public Steer(Object meta, Vector3d vel, double turnVel, double priority, double squeezeFactor, Predicate<OccAgent> collisionFilter, boolean tightGeometry, OccAgent ... avoidOccs) {
        this(meta, vel, null, turnVel, priority, squeezeFactor, collisionFilter, tightGeometry, NOOP, avoidOccs);
    }

    private Steer(Object meta, Vector3d vel, Vector3d goalOrient, double turnVel, double priority, double squeezeFactor, Predicate<OccAgent> collisionFilter, boolean tightGeometry, BiConsumer<KB, OccAgent> postOp, OccAgent ... avoidOccs) {
        this.vel = vel;
        this.goalOrient = goalOrient;
        this.turnVel = turnVel;
        this.priority = priority;
        this.squeezeFactor = squeezeFactor;
        this.avoidOccs = avoidOccs;
        this.collisionFilter = collisionFilter;
        this.postOp = postOp;
        this.meta = meta;
        this.tightGeometry = tightGeometry;
    }

    public Steer applyPostOp(BiConsumer<KB, OccAgent> op) {
        return new Steer(this.meta, this.vel, this.goalOrient, this.turnVel, this.priority, this.squeezeFactor, this.collisionFilter, this.tightGeometry, op, this.avoidOccs);
    }

    public Steer applyAvoidOccs(OccAgent ... avoidOccs) {
        return new Steer(this.meta, this.vel, this.goalOrient, this.priority, this.squeezeFactor, this.collisionFilter, this.tightGeometry, avoidOccs);
    }

    private static final class NoOp
    implements BiConsumer<KB, OccAgent>,
    Serializable {
        static final long serialVersionUID = 1L;

        private NoOp() {
        }

        @Override
        public void accept(KB t, OccAgent u) {
        }
    }
}

