/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering;

import inferno.data2.ANode;
import inferno.data2.Mesh;
import inferno.data2.Occupant;
import inferno.data2.SplitEdge;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.IPath;
import inferno.sim.path.Path;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.TriFilters;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.OccPathDebug;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;

public class Shortest
implements Serializable,
IPathPlanner {
    private static final long serialVersionUID = 1L;
    private final List<? extends PathGen.IPathGoal> d_goals;
    private boolean d_firstGen = false;
    private Predicate<WingedEdge> d_edgeFilter;
    private final boolean d_avoidDangerous;

    public Shortest(List<? extends PathGen.IPathGoal> goals, boolean avoidDangerousAreas) {
        this.d_goals = goals;
        this.d_edgeFilter = Filters.acceptAll();
        this.d_avoidDangerous = avoidDangerousAreas;
    }

    public Shortest(PathGen.IPathGoal goal, boolean avoidDangerousAreas) {
        this(Arrays.asList(goal), avoidDangerousAreas);
    }

    @Override
    public IPathPlanner.IStatus getStatus(KB kb, OccAgent agent) {
        return null;
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue queue) {
    }

    @Override
    public boolean update(KB kb, OccAgent oa, boolean forceNewPath) {
        return forceNewPath || !this.d_firstGen;
    }

    @Override
    public IPath getPath(KB kb, OccAgent oa, boolean forceNewPath) {
        TriPoint loc = oa.getLoc();
        double minDistToWall = oa.getGeometryRadius();
        double minD = Double.MAX_VALUE;
        IPath minPath = null;
        List minEdgePath = null;
        ArrayList<? extends PathGen.IPathGoal> sorted = new ArrayList<PathGen.IPathGoal>(this.d_goals);
        Collections.sort(sorted, new IncreasingDist(kb.getMesh(), oa.getGeometryRadius(), loc.p));
        Predicate<PathChange> pathFilter = Shortest.getPathFilter(kb, oa, this.d_avoidDangerous);
        for (PathGen.IPathGoal iPathGoal : sorted) {
            double len;
            Pair<IPath, List<TriEdge>> rawPath = Shortest.createPath(kb, oa, iPathGoal, minDistToWall, minD, pathFilter);
            if (rawPath == null || !((len = ((IPath)rawPath.v1).length(true)) < minD)) continue;
            minD = len;
            minPath = (IPath)rawPath.v1;
            minEdgePath = (List)rawPath.v2;
        }
        this.d_firstGen = true;
        if (minPath == null || minPath.getNumPoints(false) < 2) {
            return null;
        }
        assert (minEdgePath != null);
        this.d_edgeFilter = Shortest.createEdgeFilter(kb, oa, minEdgePath);
        return minPath;
    }

    @Override
    public Predicate<WingedEdge> getTransientEdgeFilter(KB kb, OccAgent agent) {
        return this.d_edgeFilter;
    }

    public static Predicate<PathChange> getPathFilter(KB kb, OccAgent agent, boolean avoidDangerous) {
        Predicate<Tri> triFilter = avoidDangerous ? TriFilters.filterDangerous(Filters.acceptAll(ANode.class), false) : Filters.acceptAll(Tri.class);
        return agent.generatePathFilter(kb, triFilter, EdgeFilters.acceptAll(), OccAgent.PathFilterType.POINT_TO_POINT);
    }

    public static Pair<IPath, List<TriEdge>> createPath(KB kb, OccAgent agent, PathGen.IPathGoal goal, double minDistToWall, double abortDist, Predicate<PathChange> pathFilter) {
        Occupant occ = agent.getOcc();
        OccPathDebug dbgInfo = new OccPathDebug(kb, agent);
        PathGen.IPathResult pathRes = PathGen.getPath(kb.getMesh(), occ.tri, null, null, occ.loc, goal, minDistToWall, abortDist, pathFilter, dbgInfo.getConsumer());
        if (!pathRes.isSuccessful()) {
            return null;
        }
        List<TriPoint> pathPoints = pathRes.getPoints();
        assert (!pathPoints.isEmpty());
        Path path = goal.generatePath(kb, agent, pathPoints, pathRes.getEdges(), EdgeFilters.acceptAll(), false, null, dbgInfo.get());
        assert (path != null);
        if (path == null) {
            return null;
        }
        return new Pair<IPath, List<TriEdge>>(path, pathRes.getEdges());
    }

    public static Predicate<WingedEdge> createEdgeFilter(KB kb, OccAgent oa, List<TriEdge> edgePath) {
        IdentityHashSet allowedDoors = new IdentityHashSet(edgePath.size());
        for (TriEdge tedge : edgePath) {
            if (!tedge.edge.isDoor()) continue;
            allowedDoors.add(tedge.edge);
        }
        return EdgeFilters.filterDangerous(Filters.accept(allowedDoors), oa.getOcc().obeyOnewayDoors);
    }

    private static class IncreasingDist
    implements Comparator<PathGen.IPathGoal> {
        private final SplitEdge[] d_sedges;
        private Point3d d_pt;

        public IncreasingDist(Mesh mesh, double radius, Point3d pt) {
            this.d_pt = pt;
            this.d_sedges = mesh.getShortenedEdges(radius);
        }

        @Override
        public int compare(PathGen.IPathGoal g1, PathGen.IPathGoal g2) {
            double d1 = g1.getMinDistance(this.d_sedges, this.d_pt);
            double d2 = g2.getMinDistance(this.d_sedges, this.d_pt);
            return Double.compare(d1, d2);
        }
    }
}

