/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Mesh;
import inferno.data2.SplitEdge;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.geom.Inter;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.AStar;
import inferno.sim.path.DoorSeek;
import inferno.sim.path.ExitSeek;
import inferno.sim.path.IPath;
import inferno.sim.path.IPathSeek;
import inferno.sim.path.Path;
import inferno.sim.path.PathChange;
import inferno.sim.path.StringPull;
import inferno.sim.path.WaypointSeek;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.geodesics.GeodesicPlanner;
import inferno.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class PathGen
implements Serializable {
    static final long serialVersionUID = 1L;
    public static GeneratorType DEFAULT_GEN_TYPE = GeneratorType.ASTAR;
    private static final boolean DEBUG_PRINT = false;

    private PathGen() {
    }

    private static Point2d p2d(IPathSeek seek) {
        TriPoint tp = seek.getSeekPt();
        return new Point2d(tp.p.x, tp.p.y);
    }

    public static int prunePoints(KB kb, IPath path, int fromIx, boolean pruneDoors) {
        int startIx;
        WingedEdge edge;
        IPathSeek currSeek;
        Point2d curr;
        int nextIx;
        int ptCount = path.getNumPoints(false);
        if (ptCount == 0) {
            return -1;
        }
        if (fromIx >= ptCount - 2) {
            return ptCount - 1;
        }
        IPathSeek seek = path.pointAt(fromIx);
        Point2d from = PathGen.p2d(seek);
        WingedEdge e = Inter.getEdgeForTriPoint(seek.getSeekPt());
        boolean fromTransportDoor = e != null && e.isTransportDoor();
        for (nextIx = fromIx + 1; !(nextIx >= ptCount || !from.epsilonEquals(curr = PathGen.p2d(currSeek = path.pointAt(nextIx)), 1.0E-12) || fromTransportDoor && (edge = Inter.getEdgeForTriPoint(currSeek.getSeekPt())) != null && edge.isTransportDoor()); ++nextIx) {
        }
        if (nextIx == ptCount - 1) {
            return nextIx;
        }
        if (nextIx >= ptCount) {
            return ptCount - 1;
        }
        Point2d next = PathGen.p2d(path.pointAt(nextIx));
        Vector2d dir = Util2D.vector(from, next);
        double prevt = 1.0;
        for (int m = startIx = pruneDoors ? nextIx + 1 : nextIx; m < ptCount; ++m) {
            WingedEdge edge2;
            IPathSeek currSeek2 = path.pointAt(m);
            if (!pruneDoors && (edge2 = Inter.getEdgeForTriPoint(currSeek2.getSeekPt())) != null && edge2.isDoor()) {
                return m;
            }
            Point2d curr2 = PathGen.p2d(currSeek2);
            double t = Inter2D.nearestTOnLine(from, dir, curr2);
            if (theUtil.lt(t, prevt, 1.0E-9) || curr2.distanceSquared(Util2D.linePoint(from, dir, t)) > 1.0E-12) {
                return m - 1;
            }
            prevt = t;
        }
        return ptCount - 1;
    }

    public static IPath getPrunedPath(KB kb, IPath path, boolean pruneDoors) {
        int ptCount = path.getNumPoints(false);
        if (ptCount == 0) {
            return null;
        }
        ArrayList<IPathSeek> newPath = new ArrayList<IPathSeek>();
        newPath.add(path.pointAt(0));
        int fromix = 0;
        while (fromix < ptCount - 1) {
            int nextix = PathGen.prunePoints(kb, path, fromix, pruneDoors);
            if (nextix != fromix) {
                newPath.add(path.pointAt(nextix));
            }
            fromix = nextix;
        }
        if (newPath.size() < 2) {
            return null;
        }
        return new Path(newPath, path.getDebugInfo());
    }

    public static IEdgeGoal newEdgeGoal(WingedEdge ... edges) {
        return edges.length == 1 ? new EdgeGoal(edges[0]) : new MultiEdgeGoal(edges);
    }

    public static IEdgeGoal newEdgeGoal(Collection<WingedEdge> edges) {
        return edges.size() == 1 ? new EdgeGoal(edges.iterator().next()) : new MultiEdgeGoal(edges);
    }

    public static IEdgeGoal newDoorGoal(Collection<ANode> doors) {
        Collection<WingedEdge> edges = theUtil.flatMap(doors, d -> d.getDoorEdges());
        return PathGen.newEdgeGoal(edges);
    }

    public static IEdgeGoal newDoorGoal(ANode door) {
        return PathGen.newEdgeGoal(door.getDoorEdges());
    }

    public static DoorDir getInferredEdgeDir(List<TriEdge> pathEdges, WingedEdge endEdge) {
        if (endEdge.isExit()) {
            return endEdge.getExitDir();
        }
        if (pathEdges.isEmpty()) {
            return DoorDir.POSITIVE;
        }
        for (int m = pathEdges.size() - 1; m >= 0; --m) {
            TriEdge pathEdge = pathEdges.get(m);
            if (pathEdge.edge != endEdge) continue;
            if (m > 0) {
                TriEdge prevEdge = pathEdges.get(m - 1);
                return endEdge.getDir(endEdge.getAdjTri(prevEdge.tri));
            }
            return endEdge.getDir(pathEdge.tri);
        }
        assert (false) : "doorEdge needs to be in pathEdges";
        return DoorDir.POSITIVE;
    }

    private static Point3d getWalkablePointOnEdge(SplitEdge[] shortenedEdges, WingedEdge edge, Point3d p) {
        SplitEdge sedge = shortenedEdges[edge.id];
        return sedge == null ? p : sedge.findClosest(p);
    }

    private static boolean isTravellable(SplitEdge[] sedges, WingedEdge edge) {
        SplitEdge sedge = sedges[edge.id];
        return sedge == null || sedge.isTravellable();
    }

    public static IPathResult getPath(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo) {
        return PathGen.getPath(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo, DEFAULT_GEN_TYPE);
    }

    public static IPathResult getPath(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo, GeneratorType algorithm) {
        Object timer = null;
        IPathResult result = algorithm.algorithm.generatePath(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo);
        return result;
    }

    private static IPathResult getPathAStar(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo) {
        IPathResult result = PathGen.getPathAStar(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo, AStar.DEFAULT_ASTAR_TYPE);
        return result;
    }

    private static IPathResult compareAStar(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo, AStar.IAStar test) {
        IPathResult shortest = PathGen.getPathAStar(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo, new AStar.AStarSampled(1, Integer.MAX_VALUE, 0.1));
        if (!shortest.isSuccessful()) {
            return shortest;
        }
        IPathResult testAlg = PathGen.getPathAStar(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo, test);
        System.out.printf("path diff: %g m%n", testAlg.getLength() - shortest.getLength());
        return shortest;
    }

    private static IPathResult getPathAStar(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo, AStar.IAStar algorithm) {
        IPathResult result = algorithm.generatePath(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo);
        if (result instanceof AStar.AStarSuccess) {
            PathSuccess path = PathGen.getPath(navMesh, startTri, startPt, goal, radius, (AStar.AStarSuccess)result);
            if (path == null) {
                return new PathFailure(1);
            }
            return path;
        }
        return result;
    }

    private static IPathResult getPathGeodesic(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo) {
        GeodesicPlanner gp = new GeodesicPlanner(navMesh);
        return gp.getPath(startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter);
    }

    public static IPathResult testPath(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo) {
        return AStar.getPathAStarDetailed(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo);
    }

    private static PathSuccess getPath(Mesh mesh, Tri startTri, Point3d startingPt, IPathGoal goal, double radius, AStar.AStarSuccess astar) {
        Tri firstTriCorrection;
        TriPoint startPt;
        if (astar == null) {
            return null;
        }
        Pair<AStar.MTSearchNode, List<TriEdge>> path = AStar.getPathEdgePointsAndRootNode(astar.node);
        AStar.MTSearchNode root = (AStar.MTSearchNode)path.v1;
        List<TriEdge> forwardEdges = (List<TriEdge>)path.v2;
        List<TriEdge> spEdges = root.edge != null && forwardEdges.size() >= 2 ? forwardEdges.subList(1, forwardEdges.size()) : forwardEdges;
        List<TriPoint> pts = StringPull.stringPullFixedStartPoint(mesh, spEdges, astar.goalReached, startPt = new TriPoint(firstTriCorrection = root.edge != null ? ((TriEdge)forwardEdges.get((int)0)).tri : startTri, startingPt), goal, radius);
        if (pts == null) {
            return null;
        }
        if (pts.get((int)0).tri != firstTriCorrection) {
            pts = new ArrayList<TriPoint>(pts);
            pts.set(0, new TriPoint(firstTriCorrection, pts.get((int)0).p));
        }
        return new PathSuccess(pts, forwardEdges);
    }

    public static double getPathLength(List<TriPoint> pts) {
        double dist = 0.0;
        TriPoint ptLast = null;
        for (TriPoint pt : pts) {
            if (ptLast != null) {
                dist += ptLast.p.distance(pt.p);
            }
            ptLast = pt;
        }
        return dist;
    }

    private static /* synthetic */ void lambda$getPath$3(AStar.DebugInfo[] debugInfoArray, Consumer consumer, AStar.DebugInfo info) {
        debugInfoArray[0] = info;
        consumer.accept(info);
    }

    public static class PathFailure
    implements IPathResult {
        public final int types;

        public PathFailure(int types) {
            this.types = types;
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }

        @Override
        public double getLength() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public List<TriEdge> getEdges() {
            return null;
        }

        @Override
        public List<TriPoint> getPoints() {
            return null;
        }

        @Override
        public int getFailureCodes() {
            return this.types;
        }
    }

    public static class PathSuccess
    implements IPathResult {
        public final List<TriPoint> points;
        public final List<TriEdge> edges;

        public PathSuccess(List<TriPoint> points, List<TriEdge> edges) {
            this.points = points;
            this.edges = edges;
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }

        @Override
        public double getLength() {
            return PathGen.getPathLength(this.points);
        }

        @Override
        public List<TriEdge> getEdges() {
            return this.edges;
        }

        @Override
        public List<TriPoint> getPoints() {
            return this.points;
        }

        @Override
        public int getFailureCodes() {
            return 0;
        }
    }

    public static interface IPathResult {
        public static final int BOUNDARY = 1;
        public static final int PATH_TOO_NARROW = 2;
        public static final int EDGE_FILTERED = 4;
        public static final int TOO_FAR = 8;

        public boolean isSuccessful();

        public double getLength();

        public List<TriPoint> getPoints();

        public List<TriEdge> getEdges();

        public int getFailureCodes();

        default public boolean test(int type) {
            return (this.getFailureCodes() & type) == type;
        }

        default public boolean testBoundary() {
            return this.test(1);
        }

        default public boolean testPathTooNarrow() {
            return this.test(2);
        }

        default public boolean testEdgeFiltered() {
            return this.test(4);
        }

        default public boolean testTooFar() {
            return this.test(8);
        }
    }

    public static class MultiEdgeGoal
    implements IEdgeGoal {
        static final long serialVersionUID = 1L;
        public final Set<WingedEdge> edges;
        private transient WingedEdge[] d_edgeList;
        private transient Integer d_hashCode;

        public MultiEdgeGoal(WingedEdge ... edges) {
            this(Arrays.asList(edges));
        }

        public MultiEdgeGoal(Collection<? extends WingedEdge> edges) {
            if (edges.size() == 1) {
                this.edges = Collections.singleton(edges.iterator().next());
            } else {
                assert (!(edges instanceof Set) || Util.isOrdered(edges));
                this.edges = edges instanceof Set ? (Set<Object>)edges : new LinkedIdentityHashSet<WingedEdge>(edges);
            }
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof MultiEdgeGoal && ((MultiEdgeGoal)obj).edges.equals(this.edges);
        }

        @Override
        public int hashCode() {
            if (this.d_hashCode == null) {
                this.d_hashCode = 0x6238FEE ^ this.edges.hashCode();
            }
            return this.d_hashCode;
        }

        @Override
        public Set<WingedEdge> getEdges() {
            return this.edges;
        }

        @Override
        public boolean isStatic(KB kb) {
            return true;
        }

        private WingedEdge[] getEdgeList() {
            if (this.d_edgeList == null) {
                this.d_edgeList = theUtil.toArray(this.edges, WingedEdge.class);
            }
            return this.d_edgeList;
        }

        @Override
        public boolean isValid(SplitEdge[] sedges, double radius) {
            for (WingedEdge edge : this.getEdgeList()) {
                if (!PathGen.isTravellable(sedges, edge)) continue;
                return true;
            }
            return false;
        }

        @Override
        public double getMinDistance(SplitEdge[] sedges, Point3d p) {
            double minDistSq = Double.POSITIVE_INFINITY;
            for (WingedEdge edge : this.getEdgeList()) {
                double distSq;
                if (!PathGen.isTravellable(sedges, edge) || !((distSq = Inter3D.distSqToNearestPtOnLineSeg(edge.base.n1.p, edge.base.n2.p, p)) < minDistSq)) continue;
                minDistSq = distSq;
            }
            return minDistSq == Double.POSITIVE_INFINITY ? minDistSq : Math.sqrt(minDistSq);
        }

        @Override
        public double getDistance(SplitEdge[] sedges, GoalDest goalReached, Point3d p) {
            assert (goalReached.edge != null);
            WingedEdge edge = goalReached.edge;
            assert (PathGen.isTravellable(sedges, edge));
            double distsq = Inter3D.distSqToNearestPtOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
            return Math.sqrt(distsq);
        }

        public WingedEdge getClosest(SplitEdge[] sedges, Point3d p) {
            double minDistSq = Double.MAX_VALUE;
            WingedEdge closestEdge = null;
            for (WingedEdge edge : this.getEdgeList()) {
                double distSq;
                if (!PathGen.isTravellable(sedges, edge) || !((distSq = Inter3D.distSqToNearestPtOnLineSeg(edge.base.n1.p, edge.base.n2.p, p)) < minDistSq)) continue;
                minDistSq = distSq;
                closestEdge = edge;
            }
            return closestEdge;
        }

        @Override
        public GoalDest testReached(PathChange pc) {
            if (pc.edge != null && this.edges.contains(pc.edge)) {
                return new GoalDest(pc.edge);
            }
            return null;
        }

        @Override
        public Pair<GoalDest, TriPoint> project(SplitEdge[] shortenedEdges, Point3d p) {
            WingedEdge closestEdge = this.getClosest(shortenedEdges, p);
            if (closestEdge == null) {
                return null;
            }
            return new Pair<GoalDest, TriPoint>(new GoalDest(closestEdge), this.project(closestEdge, shortenedEdges, p));
        }

        @Override
        public TriPoint project(GoalDest reachResult, SplitEdge[] shortenedEdges, Point3d p) {
            return this.project(reachResult != null ? reachResult.edge : null, shortenedEdges, p);
        }

        public TriPoint project(WingedEdge edge, SplitEdge[] shortenedEdges, Point3d p) {
            if (edge == null && (edge = this.getClosest(shortenedEdges, p)) == null) {
                return null;
            }
            p = Inter3D.nearestPointOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
            if ((p = PathGen.getWalkablePointOnEdge(shortenedEdges, edge, p)) == null) {
                return null;
            }
            Tri tri = edge.t1 != null ? edge.t1 : edge.t2;
            return new TriPoint(tri, p);
        }
    }

    public static class EdgeGoal
    implements IEdgeGoal {
        static final long serialVersionUID = 1L;
        public final WingedEdge edge;

        public EdgeGoal(WingedEdge edge) {
            this.edge = edge;
        }

        @Override
        public Set<WingedEdge> getEdges() {
            return Collections.singleton(this.edge);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof EdgeGoal && ((EdgeGoal)obj).edge.id == this.edge.id;
        }

        @Override
        public int hashCode() {
            return 0x1982F32B ^ this.edge.id;
        }

        @Override
        public boolean isStatic(KB kb) {
            return true;
        }

        @Override
        public boolean isValid(SplitEdge[] sedges, double radius) {
            return PathGen.isTravellable(sedges, this.edge);
        }

        @Override
        public double getMinDistance(SplitEdge[] sedges, Point3d p) {
            if (!PathGen.isTravellable(sedges, this.edge)) {
                return Double.POSITIVE_INFINITY;
            }
            double distsq = Inter3D.distSqToNearestPtOnLineSeg(this.edge.base.n1.p, this.edge.base.n2.p, p);
            return Math.sqrt(distsq);
        }

        @Override
        public double getDistance(SplitEdge[] sedges, GoalDest goalReached, Point3d p) {
            return this.getMinDistance(sedges, p);
        }

        @Override
        public GoalDest testReached(PathChange pc) {
            if (pc.edge != null && pc.edge.id == this.edge.id) {
                return new GoalDest(this.edge);
            }
            return null;
        }

        @Override
        public Pair<GoalDest, TriPoint> project(SplitEdge[] shortenedEdges, Point3d p) {
            TriPoint tp = this.project(this.edge, shortenedEdges, p);
            if (tp == null) {
                return null;
            }
            return new Pair<GoalDest, TriPoint>(new GoalDest(this.edge), tp);
        }

        @Override
        public TriPoint project(GoalDest o, SplitEdge[] shortenedEdges, Point3d p) {
            return this.project(o != null ? o.edge : null, shortenedEdges, p);
        }

        public TriPoint project(WingedEdge o, SplitEdge[] shortenedEdges, Point3d p) {
            p = Inter3D.nearestPointOnLineSeg(this.edge.base.n1.p, this.edge.base.n2.p, p);
            if ((p = PathGen.getWalkablePointOnEdge(shortenedEdges, this.edge, p)) == null) {
                return null;
            }
            Tri tri = this.edge.t1 != null ? this.edge.t1 : this.edge.t2;
            return new TriPoint(tri, p);
        }
    }

    public static interface IEdgeGoal
    extends IPathGoal,
    Serializable {
        public Set<WingedEdge> getEdges();

        @Override
        default public Path generatePath(KB kb, OccAgent agent, List<TriPoint> pathPoints, List<TriEdge> pathEdges, Predicate<WingedEdge> edgeFilter, boolean isVirtual, DoorDir doorDir, AStar.DebugInfo dbgInfo) {
            Set<WingedEdge> edges = this.getEdges();
            WingedEdge reachedTarget = null;
            for (int m = pathEdges.size() - 1; m >= 0; --m) {
                TriEdge tedge = pathEdges.get(m);
                if (!edges.contains(tedge.edge)) continue;
                if (!1.$assertionsDisabled && m != pathEdges.size() - 1) {
                    throw new AssertionError((Object)"Target edge should be the last in the list");
                }
                reachedTarget = tedge.edge;
                break;
            }
            if (!1.$assertionsDisabled && reachedTarget == null) {
                throw new AssertionError();
            }
            TriPoint lastPt = pathPoints.get(pathPoints.size() - 1);
            if (reachedTarget != null && reachedTarget.isDoor()) {
                ANode door = reachedTarget.getDoorNode();
                WingedEdge doorEdge = reachedTarget;
                ArrayList<IPathSeek> path = new ArrayList<IPathSeek>(pathPoints.size());
                ANode virtualDoor = isVirtual ? door : null;
                for (int m = 0; m < pathPoints.size() - 1; ++m) {
                    path.add(new WaypointSeek(pathPoints.get(m), edgeFilter, virtualDoor));
                }
                double occRadius = agent.getGeometryRadius();
                if (door.isExitDoor()) {
                    ExitSeek seek = new ExitSeek(kb.getMesh(), door, lastPt, occRadius, edgeFilter);
                    path.add(seek);
                } else {
                    Point3d segmentPt = Inter3D.nearestPointOnLineSeg(doorEdge.base.n1.p, doorEdge.base.n2.p, lastPt.p);
                    Mesh.DoorSegmentEndpoint[] lastSegment = kb.getMesh().getNearestTraversableDoorSegment(occRadius, door, doorEdge, segmentPt);
                    if (lastSegment != null) {
                        Tri destTri;
                        if (doorDir == null) {
                            doorDir = PathGen.getInferredEdgeDir(pathEdges, doorEdge);
                        }
                        if ((destTri = doorEdge.getDestTri(doorDir)) == null) {
                            destTri = doorEdge.getAdjTri(destTri);
                        }
                        if (!1.$assertionsDisabled && destTri == null) {
                            throw new AssertionError();
                        }
                        DoorSeek lastSeek = new DoorSeek(door, lastSegment, new TriPoint(destTri, lastPt.p), edgeFilter, isVirtual);
                        path.add(lastSeek);
                    } else {
                        path.add(new WaypointSeek(lastPt, edgeFilter));
                    }
                }
                return new Path(path, dbgInfo);
            }
            if (!1.$assertionsDisabled) {
                throw new AssertionError((Object)"We don't currently support ending with a non-door edge");
            }
            return null;
        }

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }

    public static class SearchConnection
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final WingedEdgeUse eu;
        public final Tri tri;
        public final boolean isVirtual;

        public SearchConnection(WingedEdgeUse eu, Tri tri, boolean isVirtual) {
            this.eu = eu;
            this.tri = tri;
            this.isVirtual = isVirtual;
        }
    }

    public static class PointGoal
    implements IPathGoal,
    Serializable {
        static final long serialVersionUID = 1L;
        private ITpSource d_ptSrc;

        @Override
        public boolean isValid(SplitEdge[] sedges, double radius) {
            return true;
        }

        public PointGoal(TriPoint pt) {
            this(new ITpSource.ConstTpSource(pt));
        }

        public PointGoal(OccAgent agent) {
            this(new ITpSource.AgentTpSource(agent));
        }

        public PointGoal(ITpSource ptSrc) {
            this.d_ptSrc = ptSrc;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof PointGoal && ((PointGoal)obj).d_ptSrc.getTriPoint().equals(this.d_ptSrc.getTriPoint());
        }

        @Override
        public int hashCode() {
            return 0x23FA3BE ^ this.d_ptSrc.getTriPoint().hashCode();
        }

        @Override
        public boolean isStatic(KB kb) {
            return this.d_ptSrc.isStatic();
        }

        @Override
        public Path generatePath(KB kb, OccAgent agent, List<TriPoint> pathPoints, List<TriEdge> pathEdges, Predicate<WingedEdge> edgeFilter, boolean isVirtual, DoorDir doorDir, AStar.DebugInfo dbgInfo) {
            ArrayList<IPathSeek> seekPts = new ArrayList<IPathSeek>(pathPoints.size() + 1);
            for (int m = 0; m < pathPoints.size(); ++m) {
                seekPts.add(new WaypointSeek(pathPoints.get(m), edgeFilter));
            }
            seekPts.add(new WaypointSeek(this.getTriPoint(), edgeFilter));
            return new Path(seekPts, dbgInfo);
        }

        @Override
        public double getMinDistance(SplitEdge[] sedges, Point3d p) {
            return p.distance(this.d_ptSrc.getTriPoint().p);
        }

        @Override
        public double getDistance(SplitEdge[] sedges, GoalDest goalReached, Point3d p) {
            return this.getMinDistance(sedges, p);
        }

        public double getMinDistance(WingedEdge edge, SplitEdge[] sedges) {
            Point3d p = this.d_ptSrc.getTriPoint().p;
            double neart = Inter3D.nearestTOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
            SplitEdge sedge = sedges[edge.id];
            if (sedge != null) {
                neart = sedge.findClosest(neart);
            }
            Point3d edgep = Util3D.linesegPoint(edge.base.n1.p, edge.base.n2.p, neart);
            return p.distance(edgep);
        }

        public boolean test(PathChange o) {
            return o.tri == this.d_ptSrc.getTriPoint().tri;
        }

        @Override
        public GoalDest testReached(PathChange pc) {
            if (pc.tri == this.d_ptSrc.getTriPoint().tri) {
                return new GoalDest(this.d_ptSrc.getTriPoint());
            }
            return null;
        }

        @Override
        public TriPoint project(GoalDest o, SplitEdge[] shortenedEdges, Point3d p) {
            return this.getTriPoint();
        }

        @Override
        public Pair<GoalDest, TriPoint> project(SplitEdge[] shortenedEdges, Point3d p) {
            TriPoint result = this.getTriPoint();
            return new Pair<GoalDest, TriPoint>(new GoalDest(result), result);
        }

        public TriPoint getTriPoint() {
            return this.d_ptSrc.getTriPoint();
        }
    }

    public static class GoalDest {
        public final TriPoint point;
        public final WingedEdge edge;

        public GoalDest(TriPoint point) {
            this.point = point;
            this.edge = null;
        }

        public GoalDest(WingedEdge edge) {
            this.edge = edge;
            this.point = null;
        }
    }

    public static interface IPathGoal {
        public boolean isStatic(KB var1);

        public boolean isValid(SplitEdge[] var1, double var2);

        public double getMinDistance(SplitEdge[] var1, Point3d var2);

        public double getDistance(SplitEdge[] var1, GoalDest var2, Point3d var3);

        public GoalDest testReached(PathChange var1);

        public TriPoint project(GoalDest var1, SplitEdge[] var2, Point3d var3);

        public Pair<GoalDest, TriPoint> project(SplitEdge[] var1, Point3d var2);

        public Path generatePath(KB var1, OccAgent var2, List<TriPoint> var3, List<TriEdge> var4, Predicate<WingedEdge> var5, boolean var6, DoorDir var7, AStar.DebugInfo var8);

        public int hashCode();

        public boolean equals(Object var1);
    }

    public static interface IPathGen {
        public IPathResult generatePath(Mesh var1, Tri var2, WingedEdge var3, Vertex var4, Point3d var5, IPathGoal var6, double var7, double var9, Predicate<PathChange> var11, Consumer<AStar.DebugInfo> var12);
    }

    public static enum GeneratorType {
        ASTAR((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9) -> PathGen.access$100(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9)),
        GEODESIC((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9) -> PathGen.access$000(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9));

        public final IPathGen algorithm;

        private GeneratorType(IPathGen algorithm) {
            this.algorithm = algorithm;
        }
    }
}

