/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Mesh;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.sim.path.DoorSeek;
import inferno.sim.path.IPathSeek;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.util.Pair;

public class ExitSeek
implements IPathSeek,
Serializable {
    private static final long serialVersionUID = 1L;
    public final ANode door;
    private final TriPoint d_backupPt;
    private final double d_radius;
    private final Predicate<WingedEdge> d_edgeFilter;
    private TriPoint d_currEdgeSeek;
    private Vector3d d_seekDir;
    private boolean d_seekDirCalced = false;
    private double d_obstDist;

    public ExitSeek(Mesh mesh, ANode door, TriPoint backupPt, double radius, Predicate<WingedEdge> edgeFilter) {
        this.door = door;
        this.d_backupPt = backupPt;
        this.d_radius = radius;
        this.d_edgeFilter = edgeFilter;
        this.d_obstDist = Double.POSITIVE_INFINITY;
        this.d_currEdgeSeek = backupPt;
    }

    @Override
    public ExitSeek clone() {
        try {
            ExitSeek es = (ExitSeek)super.clone();
            return es;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public TriPoint updateSeekPt(TriPoint currLoc, double radius, Mesh mesh) {
        WingedEdge edge = null;
        Point3d nearpt = null;
        double nearDistSq = Double.MAX_VALUE;
        for (WingedEdge e : this.door.getDoorEdges()) {
            Point3d pt;
            double distSq;
            if (!mesh.isEdgeTravellable(e, this.d_radius) || !((distSq = currLoc.p.distanceSquared(pt = Inter3D.nearestPointOnLineSeg(e.base.n1.p, e.base.n2.p, currLoc.p))) < nearDistSq)) continue;
            nearDistSq = distSq;
            nearpt = pt;
            edge = e;
        }
        assert (edge != null);
        Tri tri = edge.t1 != null ? edge.t1 : edge.t2;
        this.d_currEdgeSeek = mesh.getUnobstructedPointOnEdge(this.d_radius, new TriPoint(tri, nearpt), edge);
        assert (this.d_currEdgeSeek != null);
        return this.d_currEdgeSeek;
    }

    @Override
    public TriPoint getSeekPt() {
        return this.d_currEdgeSeek;
    }

    @Override
    public boolean updateVisibility(TriPoint currLoc, double radius, Mesh mesh) {
        this.d_obstDist = mesh.getPathObstructionDist(currLoc, this.d_currEdgeSeek, radius, this.d_edgeFilter);
        if (!this.isVisible()) {
            this.d_currEdgeSeek = this.d_backupPt;
            this.d_obstDist = mesh.getPathObstructionDist(currLoc, this.d_currEdgeSeek, radius, this.d_edgeFilter);
        }
        return this.isVisible();
    }

    @Override
    public double getObstructionDist() {
        return this.d_obstDist;
    }

    @Override
    public Vector3d getPredictDir() {
        if (!this.d_seekDirCalced) {
            WingedEdge edge = this.door.getDoorEdges().get(this.door.getDoorEdges().size() / 2);
            assert (edge.t1 == null || edge.t2 == null);
            Tri prevTri = edge.t1 != null ? edge.t1 : edge.t2;
            this.d_seekDir = DoorSeek.calcDoorPredictDir(this.door, this.door.getDoorEdges(), prevTri, false);
            this.d_seekDirCalced = true;
        }
        return this.d_seekDir;
    }

    @Override
    public boolean isVirtual(ANode node) {
        return false;
    }

    @Override
    public Pair<ANode, DoorDir> getTargetDoor() {
        return new Pair<ANode, DoorDir>(this.door, DoorDir.getExitDir(this.door));
    }
}

