/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.sim.KB;
import inferno.sim.path.Estimate;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;

public final class EstimateRealtime
extends Estimate {
    private static final long serialVersionUID = 1L;
    private final ReadWriteLock d_rwLock;
    private final Map<Estimate.DoorToGoalKey, Estimate.DoorToGoalPair> d_expiredCacheEntries = new HashMap<Estimate.DoorToGoalKey, Estimate.DoorToGoalPair>();
    private Thread[] d_writeLockOwner;
    private static int[] JOBS_DONE_SINCE_LAST_CHANGEID = new int[]{0};

    public EstimateRealtime(KB kb) {
        super(kb);
        this.d_rwLock = new ReentrantReadWriteLock();
        int n = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        for (int i = 0; i < n; ++i) {
            Thread t = new Thread((Runnable)new Worker(), "CacheWorker-" + (i + 1));
            t.setPriority(4);
            t.start();
        }
        this.d_writeLockOwner = new Thread[]{null};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseWorkers() {
        Thread[] threadArray = this.d_writeLockOwner;
        synchronized (this.d_writeLockOwner) {
            assert (this.d_writeLockOwner[0] == null || this.d_writeLockOwner[0] == Thread.currentThread());
            this.d_rwLock.writeLock().lock();
            this.d_writeLockOwner[0] = Thread.currentThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeWorkers() {
        Thread[] threadArray = this.d_writeLockOwner;
        synchronized (this.d_writeLockOwner) {
            assert (this.d_writeLockOwner[0] == Thread.currentThread());
            this.d_rwLock.writeLock().unlock();
            this.d_writeLockOwner[0] = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetDoors() {
        assert (this.d_writeLockOwner[0] == Thread.currentThread());
        if (!this.memo_doorToDoorDistance.isEmpty()) {
            this.d_expiredCacheEntries.putAll(this.memo_doorToDoorDistance);
            this.memo_doorToDoorDistance.clear();
            Map<Estimate.DoorToGoalKey, Estimate.DoorToGoalPair> map = this.d_expiredCacheEntries;
            synchronized (map) {
                this.d_expiredCacheEntries.notifyAll();
            }
        } else {
            ++this.d_changeId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Estimate.DoorToGoalPair getDoorToGoalPair(ANode doorStart, PathGen.IPathGoal goal, ANode roomOrigin, Predicate<PathChange> pathFilter) {
        Map[] caches;
        Estimate.DoorToGoalKey key = new Estimate.DoorToGoalKey(doorStart, goal, roomOrigin, pathFilter);
        Map[] mapArray = caches = new Map[]{this.memo_doorToDoorDistance, this.d_expiredCacheEntries};
        int n = mapArray.length;
        for (int i = 0; i < n; ++i) {
            Map cache;
            Map map = cache = mapArray[i];
            synchronized (map) {
                if (cache.containsKey(key)) {
                    return (Estimate.DoorToGoalPair)cache.get(key);
                }
                continue;
            }
        }
        return super.getDoorToGoalPair(doorStart, goal, roomOrigin, pathFilter);
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                boolean iGotTheLastOne;
                Estimate.DoorToGoalKey key;
                Map map = EstimateRealtime.this.d_expiredCacheEntries;
                synchronized (map) {
                    if (EstimateRealtime.this.d_expiredCacheEntries.isEmpty()) {
                        try {
                            EstimateRealtime.this.d_expiredCacheEntries.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                EstimateRealtime.this.d_rwLock.readLock().lock();
                Map map2 = EstimateRealtime.this.d_expiredCacheEntries;
                synchronized (map2) {
                    if (!EstimateRealtime.this.d_expiredCacheEntries.isEmpty()) {
                        key = (Estimate.DoorToGoalKey)EstimateRealtime.this.d_expiredCacheEntries.keySet().iterator().next();
                        EstimateRealtime.this.d_expiredCacheEntries.remove(key);
                        iGotTheLastOne = EstimateRealtime.this.d_expiredCacheEntries.isEmpty();
                    } else {
                        key = null;
                        iGotTheLastOne = false;
                    }
                }
                if (key != null) {
                    Future future = EstimateRealtime.super.doorToGoalDistance(key.doorStart, key.goal, key.roomOrigin, key.pathFilter);
                    try {
                        future.get();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                    int[] nArray = JOBS_DONE_SINCE_LAST_CHANGEID;
                    synchronized (nArray) {
                        int[] nArray2 = JOBS_DONE_SINCE_LAST_CHANGEID;
                        nArray2[0] = nArray2[0] + 1;
                        if (iGotTheLastOne || 1000 <= JOBS_DONE_SINCE_LAST_CHANGEID[0]) {
                            ++EstimateRealtime.this.d_changeId;
                            JOBS_DONE_SINCE_LAST_CHANGEID[0] = 0;
                            if (iGotTheLastOne) {
                                System.out.println("estimate updates completed");
                            }
                        }
                    }
                }
                EstimateRealtime.this.d_rwLock.readLock().unlock();
            }
        }
    }
}

