/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Mesh;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.sim.path.IPathSeek;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class DoorSeek
implements IPathSeek,
Serializable {
    private static final long serialVersionUID = 1L;
    public final ANode door;
    private final Mesh.DoorSegmentEndpoint[] endpoints;
    public final DoorDir dir;
    private final TriPoint backupPt;
    private final Predicate<WingedEdge> edgeFilter;
    private TriPoint currPt;
    private Vector3d d_seekDir;
    private boolean d_seekDirCalced = false;
    private TriPoint currEdgeSeek;
    private double obstDist;
    public final boolean isVirtual;

    public DoorSeek(ANode door, Mesh.DoorSegmentEndpoint[] endpoints, TriPoint backupPt, Predicate<WingedEdge> edgeFilter, boolean isVirtual) {
        this.door = door;
        this.endpoints = endpoints;
        this.isVirtual = isVirtual;
        Supplier<DoorDir> getExitDir = () -> {
            if (door.isExitDoor()) {
                return door.getExitDir();
            }
            return DoorDir.get(door, triPoint.tri);
        };
        this.dir = getExitDir.get();
        this.backupPt = backupPt;
        this.edgeFilter = edgeFilter;
        this.obstDist = Double.POSITIVE_INFINITY;
        this.currEdgeSeek = backupPt;
    }

    @Override
    public DoorSeek clone() {
        try {
            DoorSeek seek = (DoorSeek)super.clone();
            return seek;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public TriPoint updateSeekPt(TriPoint currLoc, double radius, Mesh mesh) {
        this.currEdgeSeek = this.getIdealSeekPt(currLoc, radius, mesh);
        return this.currEdgeSeek;
    }

    @Override
    public TriPoint getSeekPt() {
        return this.currEdgeSeek;
    }

    @Override
    public boolean updateVisibility(TriPoint currLoc, double radius, Mesh mesh) {
        double d = this.obstDist = this.currEdgeSeek != null ? mesh.getPathObstructionDist(currLoc, this.currEdgeSeek, radius, this.edgeFilter) : 0.0;
        if (!this.isVisible()) {
            this.currEdgeSeek = this.backupPt;
            this.obstDist = mesh.getPathObstructionDist(currLoc, this.currEdgeSeek, radius, this.edgeFilter);
        }
        return this.isVisible();
    }

    @Override
    public double getObstructionDist() {
        return this.obstDist;
    }

    private TriPoint getIdealSeekPt(TriPoint currLoc, double radius, Mesh mesh) {
        List<WingedEdge> doorEdges = this.door.getDoorEdges();
        Point3d nearestPt = null;
        WingedEdge nearestEdge = null;
        double nearestDistSq = Double.MAX_VALUE;
        int nedges = this.endpoints[1].edgeIx - this.endpoints[0].edgeIx + 1;
        for (int m = 0; m < nedges; ++m) {
            Point3d p2;
            int edgeIx = this.endpoints[0].edgeIx + m;
            WingedEdge edge = doorEdges.get(edgeIx);
            Point3d p1 = m == 0 ? edge.get(this.endpoints[0].t) : edge.p1();
            Point3d nearpt = Inter3D.nearestPointOnLineSeg(p1, p2 = m == nedges - 1 ? edge.get(this.endpoints[1].t) : edge.p2(), currLoc.p);
            double distSq = nearpt.distanceSquared(currLoc.p);
            if (!(distSq < nearestDistSq)) continue;
            nearestDistSq = distSq;
            nearestPt = nearpt;
            nearestEdge = edge;
        }
        Tri tri = nearestEdge.getDestTri(this.dir);
        this.currPt = new TriPoint(tri, nearestPt);
        return this.currPt;
    }

    @Override
    public Vector3d getPredictDir() {
        if (!this.d_seekDirCalced) {
            List<WingedEdge> doorEdges = this.door.getDoorEdges().subList(this.endpoints[0].edgeIx, this.endpoints[1].edgeIx + 1);
            this.d_seekDir = DoorSeek.calcDoorPredictDir(this.door, doorEdges, this.backupPt.tri, true);
            this.d_seekDirCalced = true;
        }
        return this.d_seekDir;
    }

    public static Vector3d calcDoorPredictDir(ANode door, List<WingedEdge> doorEdges, Tri tri, boolean triIsNext) {
        if (doorEdges.size() > 1 && !theUtil.isUniform(theUtil.map(doorEdges, WingedEdge::getDirN), (v1, v2) -> v1.epsilonEquals((Tuple3d)v2, 1.0E-9))) {
            return null;
        }
        for (WingedEdgeUse eu : tri.eu) {
            if (eu.wedge.getDoorNode() != door) continue;
            Vector3d triNorm = tri.normal;
            if (theUtil.eq0(triNorm.z, 1.0E-6)) {
                triNorm = GeomConstants.VEC3D_ZPOS;
            }
            Vector3d edgeDir = eu.edgeDir();
            Vector3d seekDir = triIsNext ? Util3D.cross(triNorm, edgeDir) : Util3D.cross(edgeDir, triNorm);
            seekDir.normalize();
            return seekDir;
        }
        assert (false);
        return null;
    }

    @Override
    public boolean isVirtual(ANode node) {
        if (!this.isVirtual) {
            return false;
        }
        return !node.getDoors().contains(this.door);
    }

    @Override
    public Pair<ANode, DoorDir> getTargetDoor() {
        return new Pair<ANode, DoorDir>(this.door, this.dir);
    }
}

