/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.Mesh;
import inferno.data2.SpeedModifier;
import inferno.data2.SplitEdge;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.sim.path.IPathHistory;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.StringPull;
import inferno.util.IdSet;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class AStar {
    private static final NextNodeType DEFAULT_NEXT_NODE = NextNodeType.STRING_PULL_FAST;
    public static final IAStar DEFAULT_ASTAR_TYPE = new AStarSingle();
    private static final double DEF_SAMPLE_DIST = 0.5;
    private static final int DEF_MAX_SAMPLE_SEGS = 3;
    private static final int DEF_MIN_SAMPLE_SEGS = 1;

    public static ArrayList<TriEdge> getPathEdgePoints(MTSearchNode goalNode) {
        ArrayList<TriEdge> path = new ArrayList<TriEdge>();
        AStar.getPathEdgePoints(goalNode, path);
        return path;
    }

    public static Pair<MTSearchNode, List<TriEdge>> getPathEdgePointsAndRootNode(MTSearchNode goalNode) {
        ArrayList<TriEdge> path = new ArrayList<TriEdge>();
        MTSearchNode root = AStar.getPathEdgePoints(goalNode, path);
        return new Pair<MTSearchNode, List<TriEdge>>(root, path);
    }

    private static MTSearchNode getPathEdgePoints(MTSearchNode goalNode, List<TriEdge> path) {
        MTSearchNode root = null;
        while (goalNode != null) {
            root = goalNode;
            goalNode.prependCrossedEdges(path);
            goalNode = goalNode.parent;
        }
        return root;
    }

    public static double getPathLength(MTSearchNode pathEnd) {
        return pathEnd.g;
    }

    private static <T> void printNodeData(MTSearchNode node, Function<MTSearchNode, T> mapper) {
        while (node != null) {
            System.out.println(mapper.apply(node));
            node = node.parent;
        }
    }

    private static void printPoints(MTSearchNode node) {
        AStar.printNodeData(node, n -> mTSearchNode.destpt);
    }

    private static void printEdges(MTSearchNode node) {
        AStar.printNodeData(node, n -> mTSearchNode.edge);
    }

    private static void printGs(MTSearchNode node) {
        AStar.printNodeData(node, n -> mTSearchNode.g);
    }

    private static void printFs(MTSearchNode node) {
        AStar.printNodeData(node, n -> mTSearchNode.f);
    }

    public static PathGen.IPathResult getPathAStarDetailed(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, PathGen.IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<DebugInfo> dbgInfo) {
        return DEFAULT_ASTAR_TYPE.generatePath(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo);
    }

    private static int getStartNodes(SplitEdge[] sedges, int startid, Point3d startPt, Tri startTri, WingedEdge startEdge, Vertex startVertex, PathGen.IPathGoal goal, Predicate<PathChange> pathFilter, Collection<MTSearchNode> open, Set<WingedEdge> closed) {
        TriEdge[] edges = Mesh.getTouchingEdges(startTri, startEdge, startVertex, startPt);
        if (edges.length == 0) {
            if (pathFilter.test(new PathChange(startTri, null))) {
                open.add(AStar.getStartNode(sedges, startid++, goal, startTri, null, startPt));
            }
        } else {
            PathChange pc = new PathChange();
            for (TriEdge edge : edges) {
                Tri dstTri = edge.tri;
                if (!pathFilter.test(pc.set(dstTri, edge.edge))) {
                    if (!pathFilter.test(pc.set(null, edge.edge))) continue;
                    dstTri = null;
                }
                if (sedges[edge.edge.id] != null && !sedges[edge.edge.id].isTravellable()) continue;
                closed.add(edge.edge);
                open.add(AStar.getStartNode(sedges, startid++, goal, dstTri, edge.edge, startPt));
            }
        }
        return startid;
    }

    private static MTSearchNode getNextNodeClosestPoint(Mesh mesh, SplitEdge[] sedges, TriPoint startPt, PathGen.IPathGoal goal, double radius, int id, MTSearchNode parent, Tri dstTri, WingedEdge edge) {
        Point3d dstPt = AStar.getClosestPointOnEdge(edge, sedges[edge.id], parent.destpt);
        return new MTSearchNode(id, parent, dstTri, edge, dstPt, parent.corner, parent.g + AStar.getModifiedDistToDest(parent.dstTri, parent.destpt.distance(dstPt)), goal.getMinDistance(sedges, dstPt));
    }

    private static MTSearchNode getNextNodeMidpoint(Mesh mesh, SplitEdge[] sedges, TriPoint startPt, PathGen.IPathGoal goal, double radius, int id, MTSearchNode parent, Tri dstTri, WingedEdge edge) {
        Point3d dstPt = AStar.getMidpointOnEdge(edge, sedges[edge.id]);
        return new MTSearchNode(id, parent, dstTri, edge, dstPt, parent.corner, parent.g + AStar.getModifiedDistToDest(parent.dstTri, parent.destpt.distance(dstPt)), goal.getMinDistance(sedges, dstPt));
    }

    private static double getModifiedDistToDest(Tri crossedTri, double distToDest) {
        if (crossedTri != null && crossedTri.terrain != null && crossedTri.getSpeedModifier().type == SpeedModifier.Type.FACTOR) {
            return distToDest / crossedTri.getSpeedModifier().value;
        }
        return distToDest;
    }

    private static MTSearchNode getNextNodeStringPullFull(Mesh mesh, SplitEdge[] sedges, TriPoint startPt, PathGen.IPathGoal goal, double radius, int id, MTSearchNode parent, Tri dstTri, WingedEdge edge) {
        double h;
        double g;
        TriPoint dstPt;
        ArrayDeque<TriEdge> edges = new ArrayDeque<TriEdge>();
        edges.addFirst(new TriEdge(dstTri, edge));
        MTSearchNode node = parent;
        while (node != null) {
            if (node.edge != null) {
                edges.addFirst(new TriEdge(node.dstTri, node.edge));
            }
            node = node.parent;
        }
        PathGen.GoalDest goalReached = goal.testReached(new PathChange(dstTri, edge, null));
        List<TriPoint> points = StringPull.stringPullFixedStartPoint(mesh, new ArrayList<TriEdge>(edges), goalReached, startPt, goal, radius);
        if (!points.isEmpty()) {
            if (goalReached != null && goalReached.edge == edge) {
                dstPt = points.get(points.size() - 1);
                g = PathGen.getPathLength(points);
                h = 0.0;
            } else if (points.size() >= 2) {
                dstPt = points.get(points.size() - 2);
                g = PathGen.getPathLength(points.subList(0, points.size() - 1));
                h = dstPt.p.distance(points.get((int)(points.size() - 1)).p);
            } else {
                dstPt = startPt;
                g = 0.0;
                h = dstPt.p.distance(points.get((int)0).p);
            }
        } else {
            g = 0.0;
            h = goal.getMinDistance(sedges, startPt.p);
            dstPt = startPt;
        }
        return new MTSearchNode(id, parent, dstTri, edge, dstPt.p, parent.corner, g, h);
    }

    private static MTSearchNode getNextNodeStringPull(Mesh mesh, SplitEdge[] sedges, TriPoint startPt, PathGen.IPathGoal goal, double radius, int id, MTSearchNode parent, Tri dstTri, WingedEdge edge) {
        Pair<CornerNode, Point3d> spresult = AStar.stringPullQuickAndDirty(mesh, sedges, goal, parent, edge);
        CornerNode corner = (CornerNode)spresult.v1;
        Point3d dstPt = (Point3d)spresult.v2;
        double g = AStar.calcG(sedges, parent, dstPt, corner);
        double h = goal.getDistance(sedges, corner.nearestGoal, dstPt);
        MTSearchNode node = new MTSearchNode(id, parent, dstTri, edge, dstPt, corner, g, h);
        AStar.applyEdgeFilter(node, dstTri, edge);
        return node;
    }

    private static Pair<CornerNode, Point3d> stringPullQuickAndDirty(Mesh mesh, SplitEdge[] sedges, PathGen.IPathGoal goal, MTSearchNode parent, WingedEdge edge) {
        MTSearchNode testNode = new MTSearchNode(-1, parent, null, edge, GeomConstants.PNT3D_ORIGIN, parent.corner, 0.0, 0.0);
        CornerNode corner = testNode.parent.corner;
        while (corner.edge != testNode.edge) {
            NextCorner nextCorner = AStar.findNextCorner(mesh, sedges, corner, goal, testNode);
            if (nextCorner == null) {
                Point3d dstPt = AStar.getClosestPointOnEdge(testNode.edge, sedges[testNode.edge.id], corner.nearestGoalPt.p);
                return new Pair<CornerNode, Point3d>(corner, dstPt);
            }
            WingedEdge nextCornerEdge = nextCorner.edge;
            Point3d nextCornerPt = nextCorner.edgePt;
            if (nextCornerEdge == testNode.edge) {
                return new Pair<CornerNode, Point3d>(corner, nextCornerPt);
            }
            Pair<PathGen.GoalDest, TriPoint> projected = goal.project(sedges, nextCornerPt);
            assert (projected != null);
            MTSearchNode cornerNode = parent;
            while (cornerNode != null && cornerNode.edge != nextCornerEdge) {
                cornerNode = cornerNode.parent;
            }
            assert (cornerNode != null);
            double cornerG = cornerNode != null ? AStar.calcG(sedges, cornerNode, nextCornerPt, corner) : corner.g + corner.loc.distance(nextCornerPt);
            corner = new CornerNode(nextCornerEdge, nextCornerPt, cornerG, (PathGen.GoalDest)projected.v1, (TriPoint)projected.v2);
        }
        assert (false);
        return new Pair<CornerNode, Point3d>(corner, corner.loc);
    }

    private static NextCorner findNextCorner(Mesh mesh, SplitEdge[] sedges, CornerNode prevCorner, PathGen.IPathGoal goal, MTSearchNode nextNode) {
        Point3d endPt = prevCorner.nearestGoalPt.p;
        WingedEdge cornerEdge = prevCorner.edge;
        MTSearchNode node = nextNode;
        double[] st = new double[2];
        while (node != null && node.edge != null && node.edge != prevCorner.edge) {
            Pair<Boolean, Point3d> cresult = StringPull.classifySPEdge(prevCorner.loc, endPt, node.edge, sedges, st);
            assert (cresult != null);
            if (!((Boolean)cresult.v1).booleanValue()) {
                if (cornerEdge != prevCorner.edge) break;
                Point3d testEdgePt = nextNode == node ? (Point3d)cresult.v2 : AStar.getClosestPointOnEdge(nextNode.edge, sedges[nextNode.edge.id], endPt);
                return new NextCorner(nextNode.edge, testEdgePt);
            }
            endPt = (Point3d)cresult.v2;
            cornerEdge = node.edge;
            node = node.parent;
        }
        if (cornerEdge != prevCorner.edge) {
            return new NextCorner(cornerEdge, endPt);
        }
        return null;
    }

    private static double calcG(SplitEdge[] sedges, MTSearchNode node, Point3d endPt, CornerNode startCorner) {
        double[] st = new double[2];
        SpeedModifier speedModifier = AStar.getModifier(node.dstTri);
        double totDist = 0.0;
        while (node.edge != null && node.edge != startCorner.edge && node.parent != null) {
            Tri crossedTri = node.parent.dstTri;
            SpeedModifier triMod = AStar.getModifier(crossedTri);
            if (!theUtil.equal(triMod, speedModifier)) {
                Pair<Boolean, Point3d> cresult = StringPull.classifySPEdge(startCorner.loc, endPt, node.edge, sedges, st);
                Point3d isectPt = (Point3d)cresult.v2;
                double segmentDist = isectPt.distance(endPt);
                totDist += segmentDist / AStar.getModFactor(speedModifier);
                speedModifier = triMod;
                endPt = isectPt;
            }
            node = node.parent;
        }
        double finalDist = startCorner.loc.distance(endPt);
        return startCorner.g + (totDist += finalDist / AStar.getModFactor(speedModifier));
    }

    private static SpeedModifier getModifier(Tri tri) {
        if (tri != null && tri.terrain != null && tri.getSpeedModifier().type == SpeedModifier.Type.FACTOR) {
            return tri.getSpeedModifier();
        }
        return null;
    }

    private static double getModFactor(SpeedModifier modifier) {
        return modifier != null ? modifier.value : 1.0;
    }

    private static Point3d getClosestPointOnEdge(WingedEdge edge, SplitEdge sedge, Point3d p) {
        double neart = Inter3D.nearestTOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
        if (sedge == null) {
            return Util3D.linesegPoint(edge.base.n1.p, edge.base.n2.p, neart);
        }
        double sedget = sedge.findClosest(neart);
        assert (!Double.isNaN(sedget));
        return sedge.get(sedget);
    }

    private static Point3d getMidpointOnEdge(WingedEdge edge, SplitEdge sedge) {
        if (sedge == null) {
            return edge.base.midpoint();
        }
        double sedget = sedge.findClosest(0.5);
        assert (!Double.isNaN(sedget));
        return sedge.get(sedget);
    }

    private static MTSearchNode getStartNode(SplitEdge[] sedges, int id, PathGen.IPathGoal goal, Tri startTri, WingedEdge startEdge, Point3d startPt) {
        Pair<PathGen.GoalDest, TriPoint> projected = goal.project(sedges, startPt);
        assert (projected != null);
        MTSearchNode node = new MTSearchNode(id, null, startTri, startEdge, startPt, new CornerNode(startEdge, startPt, 0.0, (PathGen.GoalDest)projected.v1, (TriPoint)projected.v2), 0.0, goal.getDistance(sedges, (PathGen.GoalDest)projected.v1, startPt));
        AStar.applyEdgeFilter(node, startTri, startEdge);
        return node;
    }

    private static void applyEdgeFilter(MTSearchNode node, Tri tri, WingedEdge edge) {
        if (tri != null && tri.node != null && tri.node.isTransportNode() && edge != null && edge.isTransportDoor()) {
            node.edgeFilter = AStar.rejectAllConnectedDoors(tri.node);
        }
    }

    public static Predicate<PathGen.SearchConnection> rejectAllConnectedDoors(final ANode node) {
        return new APredicate<PathGen.SearchConnection>(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean test(PathGen.SearchConnection t) {
                return !t.eu.wedge.isDoor() || !t.eu.wedge.isAdjacent(node);
            }
        };
    }

    public static class DebugInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final List<MTSearchNode> openedNodes = new ArrayList<MTSearchNode>();
        public final PathGen.IPathGoal goal;

        public DebugInfo(PathGen.IPathGoal goal) {
            this.goal = goal;
        }
    }

    private static class NextCorner {
        public final WingedEdge edge;
        public final Point3d edgePt;

        public NextCorner(WingedEdge edge, Point3d edgePt) {
            this.edge = edge;
            this.edgePt = edgePt;
        }
    }

    public static interface IGetNextNode {
        public MTSearchNode get(Mesh var1, SplitEdge[] var2, TriPoint var3, PathGen.IPathGoal var4, double var5, int var7, MTSearchNode var8, Tri var9, WingedEdge var10);
    }

    public static interface IAStar
    extends PathGen.IPathGen {
        @Override
        public PathGen.IPathResult generatePath(Mesh var1, Tri var2, WingedEdge var3, Vertex var4, Point3d var5, PathGen.IPathGoal var6, double var7, double var9, Predicate<PathChange> var11, Consumer<DebugInfo> var12);
    }

    public static class AStarSampled
    implements IAStar,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final int minSamples;
        public final int maxSamples;
        public final double sampleDist;

        public AStarSampled() {
            this(1, 3, 0.5);
        }

        public AStarSampled(int minSamples, int maxSamples, double sampleDist) {
            this.minSamples = minSamples;
            this.maxSamples = maxSamples;
            this.sampleDist = sampleDist;
        }

        @Override
        public PathGen.IPathResult generatePath(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, PathGen.IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<DebugInfo> dbgInfo) {
            if (startTri == null) {
                return new PathGen.PathFailure(8);
            }
            SplitEdge[] sedges = navMesh.getShortenedEdges(radius);
            double minStartDist = goal.getMinDistance(sedges, startPt);
            if (Double.isInfinite(minStartDist)) {
                return new PathGen.PathFailure(2);
            }
            if (minStartDist > abortDist) {
                return new PathGen.PathFailure(8);
            }
            Consumer<MTSearchNode> debugNodes = node -> {};
            if (dbgInfo != null) {
                DebugInfo di = new DebugInfo(goal);
                debugNodes = node -> {
                    DebugInfo dbg = di;
                    dbg.openedNodes.add((MTSearchNode)node);
                };
                dbgInfo.accept(di);
            }
            TreeSet<MTSearchNode> open = new TreeSet<MTSearchNode>();
            HashMap<WingedEdge, List> edgeNodes = new HashMap<WingedEdge, List>();
            int failures = 0;
            MTSearchNode goalNode = null;
            PathGen.GoalDest reachResult = null;
            int nodeid = 0;
            nodeid = AStar.getStartNodes(sedges, nodeid, startPt, startTri, startEdge, startVertex, goal, pathFilter, open, new IdentityHashSet());
            double[] fullSeg = new double[]{0.0, 1.0};
            PathChange pc = new PathChange();
            while (!open.isEmpty()) {
                MTSearchNode node2 = (MTSearchNode)open.pollFirst();
                debugNodes.accept(node2);
                Tri destTri = node2.destTri();
                WingedEdge crossedEdge = node2.destEdge();
                PathGen.GoalDest result = goal.testReached(pc.set(destTri, crossedEdge, node2));
                if (result != null) {
                    if (destTri == null && !crossedEdge.isExit()) {
                        Tri triBefore = node2.parent != null ? node2.parent.dstTri : startTri;
                        node2.dstTri = crossedEdge.getAdjTri(triBefore);
                    }
                    goalNode = node2;
                    reachResult = result;
                    break;
                }
                if (destTri == null) continue;
                for (PathGen.SearchConnection connection : node2.dstTri.searchConnections) {
                    List newEdgeNodes;
                    WingedEdge edge;
                    if (!node2.edgeFilter.test(connection) || (edge = connection.eu.wedge) == crossedEdge) continue;
                    if (edge.isBoundary()) {
                        failures |= 1;
                        continue;
                    }
                    SplitEdge sedge = sedges[edge.id];
                    if (sedge != null && sedge.splits.length == 0) {
                        failures |= 2;
                        continue;
                    }
                    Tri adjTri = connection.tri;
                    if (!pathFilter.test(pc.set(adjTri, edge, node2))) {
                        if (adjTri == null || !pathFilter.test(pc.set(null, edge, node2))) {
                            failures |= 4;
                            continue;
                        }
                        adjTri = null;
                    }
                    List existingEdgeNodes = (newEdgeNodes = edgeNodes.computeIfAbsent(edge, e -> new ArrayList())).isEmpty() ? null : newEdgeNodes;
                    int ix = 0;
                    double[] segs = sedge == null ? fullSeg : sedge.splits;
                    int m = 0;
                    while (m < segs.length) {
                        double t1 = segs[m++];
                        double t2 = segs[m++];
                        double elen = edge.base.length();
                        int nsegs = Math.min(Math.max(this.minSamples, (int)Math.ceil((t2 - t1) * elen / this.sampleDist)), this.maxSamples);
                        double toffset = 0.5 / (double)nsegs;
                        double insamples = 1.0 / (double)nsegs;
                        int n = 0;
                        while (n < nsegs) {
                            double h;
                            double t = theUtil.lerp(t1, t2, toffset + (double)n * insamples);
                            Point3d p = edge.base.get(t);
                            MTSearchNode existingNode = existingEdgeNodes != null ? (MTSearchNode)existingEdgeNodes.get(ix) : null;
                            double g = node2.g + AStar.getModifiedDistToDest(node2.dstTri, node2.destpt.distance(p));
                            double f = g + (h = existingNode != null ? existingNode.f - existingNode.g : goal.getMinDistance(sedges, p));
                            if (!(f > abortDist)) {
                                MTSearchNode tentativeNode;
                                if (existingNode == null) {
                                    tentativeNode = new MTSearchNode(nodeid++, node2, adjTri, edge, p, node2.corner, g, h);
                                    open.add(tentativeNode);
                                    newEdgeNodes.add(tentativeNode);
                                } else if (g < existingNode.g) {
                                    open.remove(existingNode);
                                    tentativeNode = new MTSearchNode(nodeid++, node2, adjTri, edge, p, node2.corner, g, h);
                                    open.add(tentativeNode);
                                    existingEdgeNodes.set(ix, tentativeNode);
                                }
                            }
                            ++n;
                            ++ix;
                        }
                    }
                }
            }
            if (goalNode != null) {
                return new AStarSuccess(goalNode, reachResult);
            }
            return new PathGen.PathFailure(failures);
        }
    }

    public static class AStarStringPull
    implements IAStar,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public PathGen.IPathResult generatePath(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, PathGen.IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<DebugInfo> dbgInfo) {
            if (startTri == null) {
                return new PathGen.PathFailure(8);
            }
            SplitEdge[] sedges = navMesh.getShortenedEdges(radius);
            double minStartDist = goal.getMinDistance(sedges, startPt);
            if (Double.isInfinite(minStartDist)) {
                return new PathGen.PathFailure(2);
            }
            if (minStartDist > abortDist) {
                return new PathGen.PathFailure(8);
            }
            Consumer<MTSearchNode> debugNodes = node -> {};
            if (dbgInfo != null) {
                DebugInfo di = new DebugInfo(goal);
                debugNodes = node -> debugInfo.openedNodes.add((MTSearchNode)node);
                dbgInfo.accept(di);
            }
            TreeSet<MTSearchNode> open = new TreeSet<MTSearchNode>();
            int failures = 0;
            MTSearchNode goalNode = null;
            PathGen.GoalDest reachResult = null;
            int nodeid = 0;
            nodeid = AStar.getStartNodes(sedges, nodeid, startPt, startTri, startEdge, startVertex, goal, pathFilter, open, new IdentityHashSet());
            PathChange pc = new PathChange();
            while (!open.isEmpty()) {
                MTSearchNode node2 = (MTSearchNode)open.pollFirst();
                debugNodes.accept(node2);
                Tri destTri = node2.destTri();
                WingedEdge crossedEdge = node2.destEdge();
                PathGen.GoalDest result = goal.testReached(pc.set(destTri, crossedEdge, node2));
                if (result != null) {
                    if (destTri == null && !crossedEdge.isExit()) {
                        Tri triBefore = node2.parent != null ? node2.parent.dstTri : startTri;
                        node2.dstTri = crossedEdge.getAdjTri(triBefore);
                    }
                    goalNode = node2;
                    reachResult = result;
                    break;
                }
                if (destTri == null) continue;
                for (PathGen.SearchConnection connection : node2.dstTri.searchConnections) {
                    WingedEdge edge;
                    if (!node2.edgeFilter.test(connection) || node2.contains(edge = connection.eu.wedge)) continue;
                    if (edge.isBoundary()) {
                        failures |= 1;
                        continue;
                    }
                    SplitEdge sedge = sedges[edge.id];
                    if (sedge != null && sedge.splits.length == 0) {
                        failures |= 2;
                        continue;
                    }
                    Tri adjTri = connection.tri;
                    if (!pathFilter.test(pc.set(adjTri, edge, node2))) {
                        if (adjTri == null || !pathFilter.test(pc.set(null, edge, node2))) {
                            failures |= 4;
                            continue;
                        }
                        adjTri = null;
                    }
                    MTSearchNode tentativeNode = AStar.getNextNodeStringPullFull(navMesh, sedges, new TriPoint(startTri, startPt), goal, radius, nodeid, node2, adjTri, edge);
                    if (tentativeNode.f > abortDist) continue;
                    open.add(tentativeNode);
                    ++nodeid;
                }
            }
            if (goalNode != null) {
                return new AStarSuccess(goalNode, reachResult);
            }
            return new PathGen.PathFailure(failures);
        }
    }

    public static class AStarSingle
    implements IAStar,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final IGetNextNode nextNode;

        public AStarSingle() {
            this(DEFAULT_NEXT_NODE.getNextNode);
        }

        public AStarSingle(IGetNextNode nextNode) {
            this.nextNode = nextNode;
        }

        @Override
        public PathGen.IPathResult generatePath(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, PathGen.IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<DebugInfo> dbgInfo) {
            if (startTri == null) {
                return new PathGen.PathFailure(8);
            }
            SplitEdge[] sedges = navMesh.getShortenedEdges(radius);
            double minStartDist = goal.getMinDistance(sedges, startPt);
            if (Double.isInfinite(minStartDist)) {
                return new PathGen.PathFailure(2);
            }
            if (minStartDist > abortDist) {
                return new PathGen.PathFailure(8);
            }
            Consumer<MTSearchNode> debugNodes = node -> {};
            if (dbgInfo != null) {
                DebugInfo di = new DebugInfo(goal);
                debugNodes = node -> debugInfo.openedNodes.add((MTSearchNode)node);
                dbgInfo.accept(di);
            }
            TreeSet<MTSearchNode> open = new TreeSet<MTSearchNode>();
            IdSet closed = new IdSet();
            LinkedIdentityHashMap<WingedEdge, MTSearchNode> edgeNodes = new LinkedIdentityHashMap<WingedEdge, MTSearchNode>();
            int failures = 0;
            MTSearchNode goalNode = null;
            PathGen.GoalDest reachResult = null;
            int nodeid = 0;
            nodeid = AStar.getStartNodes(sedges, nodeid, startPt, startTri, startEdge, startVertex, goal, pathFilter, open, closed);
            PathChange pc = new PathChange();
            while (!open.isEmpty()) {
                MTSearchNode node2 = (MTSearchNode)open.pollFirst();
                debugNodes.accept(node2);
                Tri destTri = node2.destTri();
                WingedEdge crossedEdge = node2.destEdge();
                PathGen.GoalDest result = goal.testReached(pc.set(destTri, crossedEdge, node2));
                if (result != null) {
                    if (destTri == null && !crossedEdge.isExit()) {
                        Tri triBefore = node2.parent != null ? node2.parent.dstTri : startTri;
                        node2.dstTri = crossedEdge.getAdjTri(triBefore);
                    }
                    goalNode = node2;
                    reachResult = result;
                    break;
                }
                if (destTri == null) continue;
                if (crossedEdge != null) {
                    closed.add(crossedEdge);
                    edgeNodes.remove(crossedEdge);
                }
                for (PathGen.SearchConnection connection : node2.dstTri.searchConnections) {
                    MTSearchNode existingNode;
                    WingedEdge edge;
                    if (!node2.edgeFilter.test(connection) || (edge = connection.eu.wedge) == crossedEdge || closed.contains(edge)) continue;
                    if (edge.isBoundary()) {
                        failures |= 1;
                        continue;
                    }
                    SplitEdge sedge = sedges[edge.id];
                    if (sedge != null && sedge.splits.length == 0) {
                        failures |= 2;
                        continue;
                    }
                    Tri adjTri = connection.tri;
                    if (!pathFilter.test(pc.set(adjTri, edge, node2))) {
                        if (adjTri == null || !pathFilter.test(pc.set(null, edge, node2))) {
                            failures |= 4;
                            continue;
                        }
                        adjTri = null;
                    }
                    MTSearchNode tentativeNode = this.nextNode.get(navMesh, sedges, new TriPoint(startTri, startPt), goal, radius, nodeid, node2, adjTri, edge);
                    if (tentativeNode.f > abortDist || (existingNode = (MTSearchNode)edgeNodes.get(edge)) != null && !(tentativeNode.g < existingNode.g)) continue;
                    if (existingNode != null) {
                        open.remove(existingNode);
                    }
                    open.add(tentativeNode);
                    edgeNodes.put(edge, tentativeNode);
                    ++nodeid;
                }
            }
            if (goalNode != null) {
                return new AStarSuccess(goalNode, reachResult);
            }
            return new PathGen.PathFailure(failures);
        }
    }

    public static class AStarSuccess
    implements PathGen.IPathResult {
        public final MTSearchNode node;
        public final PathGen.GoalDest goalReached;

        public AStarSuccess(MTSearchNode node, PathGen.GoalDest goalReached) {
            this.node = node;
            this.goalReached = goalReached;
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }

        @Override
        public double getLength() {
            return this.node.g;
        }

        @Override
        public List<TriEdge> getEdges() {
            return null;
        }

        @Override
        public List<TriPoint> getPoints() {
            return null;
        }

        @Override
        public int getFailureCodes() {
            return 0;
        }
    }

    public static class MTSearchNode
    implements Comparable<MTSearchNode>,
    IPathHistory,
    Serializable {
        static final long serialVersionUID = 1L;
        public final int id;
        public final MTSearchNode parent;
        public final int pathCount;
        public final double g;
        public final double f;
        public final WingedEdge edge;
        public Tri dstTri;
        public final Point3d destpt;
        public final CornerNode corner;
        public Predicate<PathGen.SearchConnection> edgeFilter;

        public MTSearchNode(int id, MTSearchNode parent, Tri dstTri, WingedEdge edge, Point3d dstPt, CornerNode corner, double g, double h) {
            this.id = id;
            this.parent = parent;
            this.pathCount = parent != null ? parent.pathCount + 1 : 1;
            this.edge = edge;
            this.dstTri = dstTri;
            this.destpt = dstPt;
            this.corner = corner;
            this.g = g;
            this.f = g + h;
            this.edgeFilter = parent != null ? parent.edgeFilter : Predicates.alwaysTrue();
        }

        @Override
        public boolean isVisited(ANode room) {
            MTSearchNode node = this.parent;
            while (node != null) {
                if (node.destTri() != null && node.destTri().node == room) {
                    return true;
                }
                node = node.parent;
            }
            return false;
        }

        public boolean contains(WingedEdge edge) {
            MTSearchNode p = this;
            while (p != null) {
                if (edge == p.edge) {
                    return true;
                }
                p = p.parent;
            }
            return false;
        }

        public void prependCrossedEdges(List<TriEdge> edges) {
            if (this.edge == null || edges.size() > 0 && this.edge.equals(edges.get((int)0).edge)) {
                return;
            }
            edges.add(0, new TriEdge(this.dstTri, this.edge));
        }

        public Tri destTri() {
            return this.dstTri;
        }

        public WingedEdge destEdge() {
            return this.edge;
        }

        public Point3d destPt() {
            return this.destpt;
        }

        public double distToDest() {
            return this.parent != null ? this.parent.destpt.distance(this.destpt) : 0.0;
        }

        public int getPathCount() {
            return this.pathCount;
        }

        @Override
        public int compareTo(MTSearchNode o) {
            int result = Double.compare(this.f, o.f);
            if (result == 0) {
                if (this.equals(o)) {
                    return 0;
                }
                int count1 = this.getPathCount();
                int count2 = o.getPathCount();
                assert (this.id != o.id);
                return count1 == count2 ? Integer.signum(this.id - o.id) : Integer.signum(count1 - count2);
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MTSearchNode)) {
                return false;
            }
            MTSearchNode node = (MTSearchNode)obj;
            boolean result = this.g == node.g && this.f == node.f && theUtil.equal(this.dstTri, node.dstTri) && theUtil.equal(this.edge, node.edge) && this.destpt.equals(node.destpt);
            return result;
        }

        public String toString() {
            if (this.parent == null) {
                return "Node[f=" + this.s(this.f) + " pt=" + this.destPt().toString() + "]";
            }
            return "...Node[f=" + this.s(this.f) + " pt=" + this.destPt().toString() + "]";
        }

        private double s(double d) {
            int i = (int)(d * 100.0);
            return (double)i / 100.0;
        }
    }

    public static class CornerNode
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final WingedEdge edge;
        public final Point3d loc;
        public final double g;
        public final PathGen.GoalDest nearestGoal;
        public final TriPoint nearestGoalPt;

        public CornerNode(WingedEdge edge, Point3d loc, double g, PathGen.GoalDest nearestGoal, TriPoint nearestGoalPt) {
            this.edge = edge;
            this.loc = loc;
            this.g = g;
            this.nearestGoal = nearestGoal;
            this.nearestGoalPt = nearestGoalPt;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof CornerNode && ((CornerNode)obj).edge == this.edge && ((CornerNode)obj).g == this.g && ((CornerNode)obj).loc.equals(this.loc);
        }
    }

    public static enum NextNodeType {
        MIDPOINT((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8) -> AStar.access$300(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8)),
        CLOSEST_POINT((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8) -> AStar.access$200(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8)),
        STRING_PULL_FAST((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8) -> AStar.access$100(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8)),
        STRING_PULL_FULL((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8) -> AStar.access$000(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8));

        public final IGetNextNode getNextNode;

        private NextNodeType(IGetNextNode getNextNode) {
            this.getNextNode = getNextNode;
        }
    }
}

