/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.ai;

import inferno.data2.ai.IGoal;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.sim.DoorQueue;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.IAiCore;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.inverse.StandStill;
import java.io.Serializable;
import java.util.List;

public class SevereInjuryAiCore
implements IAiCore,
Serializable {
    private ISteeringBehavior d_steer = new StandStill();
    private IGoalInstance d_goalInstance = null;

    @Override
    public void init(KB kb, OccAgent agent) {
        List<IGoal> goalSequence = agent.getOcc().behavior.goals;
        IGoal currentGoal = goalSequence.get(agent.getGoalIx());
        this.d_goalInstance = currentGoal.begin(kb, agent);
    }

    @Override
    public ISteeringBehavior getSteering(OccAgent agent) {
        return this.d_steer;
    }

    @Override
    public boolean isSeeking(KB kb, OccAgent agent) {
        return false;
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        this.d_steer.doorCrossed(t, agent, door);
    }

    @Override
    public IProgressNote getProgress(KB kb, OccAgent agent) {
        return IProgressNote.PROGRESSING;
    }

    @Override
    public void preMove(KB kb, OccAgent agent, double dt) {
    }

    @Override
    public void update(Engine e, KB kb, OccAgent agent) {
        agent.updateStats(kb, e.getCurrentDt());
    }
}

