/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.ai;

import inferno.data2.ai.IGoal;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.sim.BehaviorSim;
import inferno.sim.DoorQueue;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.AGoalAiCore;
import inferno.sim.steering.ISteeringBehavior;
import java.util.Deque;
import java.util.List;

public class DefaultAiCore
extends AGoalAiCore {
    private static final long serialVersionUID = 1L;
    private ISteeringBehavior d_steer = null;

    private boolean isInitialized() {
        return this.d_steer != null;
    }

    @Override
    public ISteeringBehavior getSteering(OccAgent agent) {
        assert (this.isInitialized());
        return this.d_steer;
    }

    @Override
    public IProgressNote getProgress(KB kb, OccAgent agent) {
        return this.getCurrentGoalInstance(agent).getProgress(kb, agent);
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        assert (this.isInitialized());
        this.getCurrentGoalInstance(agent).doorCrossed(agent, door);
        this.d_steer.doorCrossed(t, agent, door);
    }

    @Override
    public void init(KB kb, OccAgent agent) {
        assert (!this.isInitialized());
        this.initGoal(kb, agent, agent.getGoalIx());
    }

    private void initGoal(KB kb, OccAgent agent, int goalIx) {
        List<IGoal> goalSequence = agent.getOcc().behaviorStack.peek().behavior.goals;
        IGoal currentGoal = goalSequence.get(goalIx);
        IGoalInstance ginst = currentGoal.begin(kb, agent);
        this.recordGoal(kb, agent, ginst);
        this.d_steer = ginst.generateSteeringBehavior(kb, agent);
    }

    @Override
    public void update(Engine e, KB kb, OccAgent agent) {
        assert (this.isInitialized());
        Deque<BehaviorSim.BehaviorInProgress> behaviorStack = agent.getOcc().behaviorStack;
        IGoalInstance currGoal = this.getCurrentGoalInstance(agent);
        currGoal.update(agent);
        if (currGoal.needsNewSteeringBehavior(kb, agent)) {
            this.d_steer = currGoal.generateSteeringBehavior(kb, agent);
        }
        if (currGoal.isReached(kb, agent)) {
            currGoal.end(kb, agent);
            List<IGoal> goalSequence = behaviorStack.peek().behavior.goals;
            boolean initNewGoal = true;
            if (agent.getGoalIx() + 1 >= goalSequence.size()) {
                behaviorStack.pop();
                if (currGoal.isAlwaysTerminal()) {
                    behaviorStack.clear();
                }
                while (!behaviorStack.isEmpty() && agent.getGoalIx() + 1 >= behaviorStack.peek().behavior.size()) {
                    behaviorStack.pop();
                }
                if (behaviorStack.isEmpty()) {
                    agent.finish(kb);
                    initNewGoal = false;
                }
            }
            if (initNewGoal) {
                int currentGoalIx = agent.getGoalIx();
                this.initGoal(kb, agent, currentGoalIx + 1);
                agent.setGoalIx(currentGoalIx + 1);
            }
        }
        this.updateSeeking(kb, agent);
        agent.updateStats(kb, e.getCurrentDt());
    }

    @Override
    public void preMove(KB kb, OccAgent agent, double dt) {
        this.getCurrentGoalInstance(agent).preMove(kb, agent, dt);
    }

    @Override
    public void processLost(OccAgent agent) {
        this.getCurrentGoalInstance(agent).processLost();
    }
}

