/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.Mesh;
import inferno.data2.OccLocator;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccGroup;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.WriterIntl;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathGen;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.UnorderedPair;

public class SocialDistanceTransientWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    public static final double SD_COLLISION_RADIUS = 0.1;
    private final KB d_kb;
    private final double d_detectionRadius;
    private final SerializedOutputStream d_strmOut;
    private transient PrintStream d_out;

    public SocialDistanceTransientWriter(KB kb, double detectionRadius) {
        this.d_kb = kb;
        this.d_detectionRadius = detectionRadius;
        this.d_strmOut = new SerializedOutputStream(kb.getParams().out_sd_transient);
    }

    public void open(Param params) throws FileNotFoundException {
        this.d_out = Output.openTxtStream(this.d_strmOut);
    }

    @Override
    public void close() throws IOException {
        if (this.d_out != null) {
            Output.close(this.d_out);
        }
    }

    public void writeHeader() {
        String quotedJoined = Arrays.stream(Header.values()).map(h -> "\"" + h.get() + "\"").collect(Collectors.joining(", "));
        this.d_out.println(quotedJoined);
        this.d_out.flush();
    }

    private Pair<Integer, String> filterToDist(OccAgent root, List<OccAgent> agents, double maxDistance) {
        StringBuilder sb = new StringBuilder();
        Point3d rootPos = root.getPos();
        int n = 0;
        for (OccAgent nearAgent : agents) {
            double distance = rootPos.distance(nearAgent.getPos());
            if (!(distance <= maxDistance)) continue;
            if (++n > 1) {
                sb.append(" ");
            }
            sb.append(nearAgent.getId());
        }
        return new Pair<Integer, String>(n, sb.toString());
    }

    public static double getSocialDistance(Mesh m, OccAgent a, OccAgent b, double abortDist) {
        boolean blocked = m.isPathObstructed(a.getLoc(), b.getLoc(), 0.1, EdgeFilters.acceptAll());
        if (!blocked) {
            return a.getPos().distance(b.getPos());
        }
        PathGen.PointGoal pathGoal = new PathGen.PointGoal(b.getLoc());
        PathGen.IPathResult searchResult = PathGen.getPath(m, a.getLoc().tri, null, null, a.getLoc().p, pathGoal, 0.1, abortDist, Predicates.alwaysTrue(), null);
        return searchResult.getLength();
    }

    public void writeFrame(double t) {
        if (this.d_kb.getActiveAgents().isEmpty()) {
            return;
        }
        Mesh m = this.d_kb.getMesh();
        Optional<OccAgent> maxIdAgent = this.d_kb.getActiveAgents().stream().max(Comparator.comparingInt(agent -> agent.getId()));
        ArrayList<Object> nearOccsData = new ArrayList<Object>(Collections.nCopies(maxIdAgent.get().getId() + 1, null));
        ArrayList<Object> nearestOccData = new ArrayList<Object>(Collections.nCopies(maxIdAgent.get().getId() + 1, null));
        ConcurrentHashMap distMap = new ConcurrentHashMap(this.d_kb.getActiveAgents().size(), 0.75f, Runtime.getRuntime().availableProcessors());
        this.d_kb.getActiveAgents().parallelStream().forEach(agent -> {
            List<OccAgent> nearOccs = this.d_kb.findOccs((ITest<AABox>)new BoundingSphere(agent.getPos(), this.d_detectionRadius), OccLocator.exclude(agent, Filters.acceptAll()), true);
            nearOccsData.set(agent.getId(), nearOccs);
            for (OccAgent nearOcc2 : nearOccs) {
                distMap.computeIfAbsent(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, nearOcc2), key -> SocialDistanceTransientWriter.getSocialDistance(m, agent, nearOcc2, this.d_detectionRadius));
            }
            Optional<OccAgent> nearestOcc = nearOccs.stream().filter(nearOcc -> Double.isFinite((Double)distMap.get(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, (OccAgent)nearOcc)))).min(Comparator.comparingDouble(nearOcc -> (Double)distMap.get(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, (OccAgent)nearOcc))));
            nearestOccData.set(agent.getId(), nearestOcc);
        });
        ArrayList<Object> valuesData = new ArrayList<Object>(Collections.nCopies(maxIdAgent.get().getId() + 1, null));
        this.d_kb.getActiveAgents().parallelStream().forEach(agent -> {
            ArrayList<String> values = new ArrayList<String>();
            String nearestId = "";
            String nearestName = "";
            String nearestDist = "";
            Optional nearestOcc = (Optional)nearestOccData.get(agent.getId());
            if (nearestOcc.isPresent()) {
                OccAgent nearest = (OccAgent)nearestOcc.get();
                nearestDist = String.format("%8.2f", distMap.get(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, nearest)));
                nearestId = "" + nearest.getOcc().id;
                nearestName = nearest.getOcc().name;
            }
            String groupId = "";
            if (agent.getOcc().occupantGroup != null) {
                OccGroup og = agent.getOcc().occupantGroup;
                groupId = Integer.toString(og.getID());
            }
            values.add(String.format(Locale.ENGLISH, "%9.2f", t));
            values.add(String.format(Locale.ENGLISH, "\"%5s\"", agent.getOcc().id));
            values.add(String.format(Locale.ENGLISH, "\"%8s\"", agent.getOcc().name));
            values.add(String.format(Locale.ENGLISH, "\"%5s\"", groupId));
            values.add(String.format(Locale.ENGLISH, "\"%5s\"", nearestId));
            values.add(String.format(Locale.ENGLISH, "\"%8s\"", nearestName));
            values.add(String.format(Locale.ENGLISH, "\"%8s\"", nearestDist));
            List nearOccs = (List)nearOccsData.get(agent.getId());
            Pair<Integer, String> m1 = this.filterToDist((OccAgent)agent, nearOccs, 1.0);
            values.add(String.format(Locale.ENGLISH, "%8s", m1.v1));
            values.add(String.format(Locale.ENGLISH, "\"%9s\"", m1.v2));
            Pair<Integer, String> m2 = this.filterToDist((OccAgent)agent, nearOccs, 2.0);
            values.add(String.format(Locale.ENGLISH, "%8s", m2.v1));
            values.add(String.format(Locale.ENGLISH, "\"%9s\"", m2.v2));
            Pair<Integer, String> m3 = this.filterToDist((OccAgent)agent, nearOccs, 3.0);
            values.add(String.format(Locale.ENGLISH, "%8s", m3.v1));
            values.add(String.format(Locale.ENGLISH, "\"%9s\"", m3.v2));
            String rowStr = String.join((CharSequence)", ", values);
            valuesData.set(agent.getId(), rowStr);
        });
        for (OccAgent agent2 : this.d_kb.getActiveAgents()) {
            String rowStr = (String)valuesData.get(agent2.getId());
            this.d_out.println(rowStr);
        }
        this.d_out.flush();
    }

    public static enum Header implements Supplier<WriterIntl.ColHeader>
    {
        TIME(WriterIntl.intl("Time (s)")),
        OCC_ID(WriterIntl.intl("ID")),
        OCC_NAME(WriterIntl.intl("Name")),
        OCC_GROUP_ID(WriterIntl.intl("Group ID")),
        CLOSEST_ID(WriterIntl.intl("Closest Occupant ID")),
        CLOSEST_NAME(WriterIntl.intl("Closest Occupant Name")),
        CLOSEST_DIST(WriterIntl.intl("Closest Occupant Distance (m)")),
        WITHIN_1M(WriterIntl.intl("Occupants Within 1m (count)")),
        WITHIN_1M_ID(WriterIntl.intl("Occupants Within 1m IDs")),
        WITHIN_2M(WriterIntl.intl("Occupants Within 2m (count)")),
        WITHIN_2M_ID(WriterIntl.intl("Occupants Within 2m IDs")),
        WITHIN_3M(WriterIntl.intl("Occupants Within 3m (count)")),
        WITHIN_3M_ID(WriterIntl.intl("Occupants Within 3m IDs"));

        public final WriterIntl.ColHeader val;

        private Header(WriterIntl.ColHeader val) {
            this.val = val;
        }

        public String toString() {
            return this.val.toString();
        }

        @Override
        public WriterIntl.ColHeader get() {
            return this.val;
        }
    }
}

