/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.Mesh;
import inferno.data2.OccLocator;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccGroup;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.SocialDistanceTransientWriter;
import inferno.sim.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.UnorderedPair;

public class SocialDistanceAccumulatedWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private static final double UPDATE_INTERVAL = 0.5;
    private final KB d_kb;
    private final double d_detectionRadius;
    private final ConcurrentMap<OccAgent, Map<OccAgent, Double>> d_data;
    private final SerializedOutputStream d_strmOut;
    private transient PrintStream d_out;
    private final ConcurrentMap<OccAgent, Double> d_lastUpdate;

    public SocialDistanceAccumulatedWriter(KB kb, double detectionRadius) {
        this.d_kb = kb;
        this.d_detectionRadius = detectionRadius;
        this.d_data = new ConcurrentHashMap<OccAgent, Map<OccAgent, Double>>();
        this.d_lastUpdate = new ConcurrentHashMap<OccAgent, Double>();
        this.d_strmOut = new SerializedOutputStream(kb.getParams().out_sd_accumulated);
    }

    public void open(Param params) throws FileNotFoundException {
        this.d_out = Output.openTxtStream(this.d_strmOut);
    }

    @Override
    public void close() throws IOException {
        if (this.d_out != null) {
            Output.close(this.d_out);
        }
    }

    public void writeHeader() {
        String quotedJoined = Arrays.stream(Header.values()).map(h -> "\"" + h.get() + "\"").collect(Collectors.joining(", "));
        this.d_out.println(quotedJoined);
        this.d_out.flush();
    }

    private Pair<Integer, String> filterToTime(Map<OccAgent, Double> agentSdMap, double minTime) {
        Map<OccAgent, Double> overTime = agentSdMap.entrySet().stream().filter(entry -> (Double)entry.getValue() >= minTime).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List overTimeIds = overTime.keySet().stream().map(agent -> Integer.toString(agent.getOcc().getId())).collect(Collectors.toList());
        String ids = String.join((CharSequence)" ", overTimeIds);
        return new Pair<Integer, String>(overTime.size(), ids);
    }

    public void writeOuptut() {
        ArrayList sortedAgents = new ArrayList(this.d_data.keySet());
        Collections.sort(sortedAgents, (k1, k2) -> Integer.compare(k1.getId(), k2.getId()));
        for (OccAgent agent : sortedAgents) {
            ArrayList<String> values = new ArrayList<String>();
            String groupId = "";
            if (agent.getOcc().occupantGroup != null) {
                OccGroup og = agent.getOcc().occupantGroup;
                groupId = Integer.toString(og.getID());
            }
            values.add(String.format(Locale.ENGLISH, "\"%8s\"", agent.getOcc().getId()));
            values.add(String.format(Locale.ENGLISH, "\"%8s\"", agent.getOcc().name));
            values.add(String.format(Locale.ENGLISH, "\"%8s\"", groupId));
            values.add(String.format(Locale.ENGLISH, "%9.2f", this.d_detectionRadius));
            Map agentSdMap = (Map)this.d_data.get(agent);
            String longestId = "";
            String longestName = "";
            String longestTime = "";
            int countOver60 = 0;
            String csvOver60 = "";
            int countOver300 = 0;
            String csvOver300 = "";
            if (agentSdMap != null && !agentSdMap.isEmpty()) {
                ArrayList contacts = new ArrayList(agentSdMap.keySet());
                contacts.sort((o1, o2) -> -Double.compare((Double)agentSdMap.get(o1), (Double)agentSdMap.get(o2)));
                OccAgent longest = (OccAgent)contacts.get(0);
                longestId = "" + longest.getId();
                longestName = longest.getName();
                longestTime = String.format("%9.2f", agentSdMap.get(longest));
                Pair<Integer, String> over60 = this.filterToTime(agentSdMap, 60.0);
                countOver60 = (Integer)over60.v1;
                csvOver60 = (String)over60.v2;
                Pair<Integer, String> over300 = this.filterToTime(agentSdMap, 300.0);
                countOver300 = (Integer)over300.v1;
                csvOver300 = (String)over300.v2;
            }
            values.add(String.format(Locale.ENGLISH, "\"%5s\"", longestId));
            values.add(String.format(Locale.ENGLISH, "\"%10s\"", longestName));
            values.add(String.format(Locale.ENGLISH, "%10s", longestTime));
            values.add(String.format(Locale.ENGLISH, "%10s", countOver60));
            values.add(String.format(Locale.ENGLISH, "\"%10s\"", csvOver60));
            values.add(String.format(Locale.ENGLISH, "%10s", countOver300));
            values.add(String.format(Locale.ENGLISH, "\"%10s\"", csvOver300));
            String rowStr = String.join((CharSequence)", ", values);
            this.d_out.println(rowStr);
        }
        this.d_out.flush();
    }

    public void update(boolean forceUpdateAll) {
        ConcurrentHashMap distMap = new ConcurrentHashMap(this.d_kb.getActiveAgents().size(), 0.75f, Runtime.getRuntime().availableProcessors());
        this.d_kb.getActiveAgents().parallelStream().forEach(agent -> {
            if (!this.d_data.containsKey(agent)) {
                this.d_data.put((OccAgent)agent, new HashMap());
                this.d_lastUpdate.put((OccAgent)agent, this.d_kb.getCurrentSimTime());
                return;
            }
            double dt = this.d_kb.getCurrentSimTime() - (Double)this.d_lastUpdate.get(agent);
            if (dt < 0.5 & !forceUpdateAll) {
                return;
            }
            List<OccAgent> nearOccs = this.d_kb.findOccs((ITest<AABox>)new BoundingSphere(agent.getPos(), this.d_detectionRadius), OccLocator.exclude(agent, Filters.acceptAll()), true);
            Mesh m = this.d_kb.getMesh();
            for (OccAgent nearOcc : nearOccs) {
                double distance = distMap.computeIfAbsent(new UnorderedPair<OccAgent, OccAgent>((OccAgent)agent, nearOcc), upair -> SocialDistanceTransientWriter.getSocialDistance(m, (OccAgent)upair.v1, (OccAgent)upair.v2, this.d_detectionRadius));
                if (!Double.isFinite(distance) || !(distance <= this.d_detectionRadius)) continue;
                Map agentSdMap = (Map)this.d_data.get(agent);
                Double prevDt = (Double)agentSdMap.get(nearOcc);
                if (prevDt == null) {
                    prevDt = 0.0;
                }
                agentSdMap.put(nearOcc, prevDt + dt);
            }
            this.d_lastUpdate.put((OccAgent)agent, this.d_kb.getCurrentSimTime());
        });
    }

    public static enum Header implements Supplier<WriterIntl.ColHeader>
    {
        ID(WriterIntl.intl("ID")),
        NAME(WriterIntl.intl("Name")),
        GROUP_ID(WriterIntl.intl("Group ID")),
        SD(WriterIntl.intl("SD (m)")),
        LONGEST_ID(WriterIntl.intl("Longest Occupant ID")),
        LONGEST_Name(WriterIntl.intl("Longest Occupant Name")),
        LONGEST_TIME(WriterIntl.intl("Longest Occupant Time (s)")),
        OVER_60(WriterIntl.intl("Occupants > 60s (count)")),
        OVER_60_ID(WriterIntl.intl("Occupants > 60s IDs")),
        OVER_300(WriterIntl.intl("Occupants > 300s (count)")),
        OVER_300_ID(WriterIntl.intl("Occupants > 300s IDs"));

        public final WriterIntl.ColHeader val;

        private Header(WriterIntl.ColHeader val) {
            this.val = val;
        }

        public String toString() {
            return this.val.toString();
        }

        @Override
        public WriterIntl.ColHeader get() {
            return this.val;
        }
    }
}

