/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.Occupant;
import inferno.sim.BehaviorSim;
import inferno.sim.IOccGroup;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccGroupType;
import inferno.sim.OccProfileSim;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class OccGroup
implements IOccGroup,
Serializable {
    static final long serialVersionUID = 1L;
    public final String groupName;
    public final double slowdownTime;
    public final boolean requiresLeader;
    public final boolean respectSocialDist;
    public final OccProfileSim.CompRestrictions componentRestrictions;
    public final Color color;
    public final Color templateColor;
    public final OccProfileSim leaderProfile;
    public BehaviorSim behavior;
    public OccGroupType type;
    public double slowDownStart;
    private final double d_maxDistance;
    private double d_currMaxDist;
    private final int groupID;
    private OccAgent leader;
    private Occupant leaderInitOcc;
    private List<OccAgent> newDynamicMembers = new ArrayList<OccAgent>();
    private FinishedGoalsCounter finishedGoalCounter;
    private boolean initialized = false;
    private boolean active = false;
    private final Set<OccAgent> activeAgents = new LinkedHashSet<OccAgent>();
    private Integer minSize;
    private boolean isReady = false;
    private Map<OccProfileSim, Integer> minSizeProfMap;
    private Map<OccProfileSim, Integer> prefSizeProfMap;
    private Map<OccProfileSim, Integer> usedProfilesMap;
    private SpeedState speedState;
    private boolean d_intIsDisconnected = false;
    private boolean d_extIsDisconnected = false;
    private double lastDisconnectedReset = Double.NEGATIVE_INFINITY;
    private Set<OccAgent> occsInTheWay;
    private double minSpeed = Double.MAX_VALUE;
    private List<Occupant> initOccs;

    public OccGroup(int groupID, String groupName, double maxDistance, double slowdownTime, boolean requiresLeader, boolean respectSocialDist, Color color, Color templateColor) {
        this(groupID, groupName, maxDistance, slowdownTime, requiresLeader, respectSocialDist, 0, null, null, null, color, templateColor);
    }

    public OccGroup(int groupID, String groupName, double maxDistance, double slowdownTime, boolean requiresLeader, boolean respectSocialDist, Integer minSize, Map<OccProfileSim, Integer> minSizeProfMap, Map<OccProfileSim, Integer> prefSizeProfMap, OccProfileSim leaderProfile, Color color, Color templateColor) {
        this.groupID = groupID;
        this.groupName = groupName;
        this.d_currMaxDist = this.d_maxDistance = maxDistance;
        this.slowdownTime = slowdownTime;
        this.requiresLeader = requiresLeader;
        this.minSize = minSize;
        this.minSizeProfMap = minSizeProfMap;
        this.prefSizeProfMap = prefSizeProfMap;
        this.leaderProfile = leaderProfile;
        this.color = color;
        this.templateColor = templateColor;
        this.occsInTheWay = new HashSet<OccAgent>();
        this.respectSocialDist = respectSocialDist;
        if (minSizeProfMap != null) {
            this.usedProfilesMap = new LinkedHashMap<OccProfileSim, Integer>();
        }
        this.finishedGoalCounter = new FinishedGoalsCounter(this.activeAgents, this);
        this.componentRestrictions = new OccProfileSim.CompRestrictions();
    }

    @Override
    public void update(KB kb) {
        this.init(kb);
        this.addNewMembers(kb);
        boolean bl = this.active = (this.active || this.shouldActivate()) && !this.shouldDeactivate();
        if (!this.active) {
            return;
        }
        ArrayList<OccAgent> toRemove = new ArrayList<OccAgent>();
        for (OccAgent agent : this.activeAgents) {
            this.updateAgent(agent, toRemove);
        }
        this.activeAgents.removeAll(toRemove);
        if (!toRemove.isEmpty() && toRemove.stream().anyMatch(a -> (double)a.getOcc().maxVel == this.minSpeed)) {
            this.updateMinSpeed();
        }
        this.d_extIsDisconnected = this.d_intIsDisconnected;
        this.updateSpeedState(kb);
        this.updateMaxDist(kb);
    }

    private void updateMaxDist(KB kb) {
        double maxDist = this.d_maxDistance;
        if (this.respectSocialDist) {
            maxDist = 0.0;
            for (OccAgent agent : this.activeAgents) {
                float sd = agent.getSocialDistance();
                if (Float.isNaN(sd)) continue;
                maxDist = Math.max(maxDist, (double)sd);
            }
            maxDist += this.d_maxDistance;
        }
        this.d_currMaxDist = maxDist;
    }

    private void updateMinSpeed() {
        this.minSpeed = Double.MAX_VALUE;
        for (OccAgent a : this.activeAgents) {
            if (!((double)a.getOcc().maxVel < this.minSpeed)) continue;
            this.minSpeed = a.getOcc().maxVel;
        }
    }

    private void updateAgent(OccAgent agent, List<OccAgent> toRemove) {
        if (agent.isDone() || agent.getOcc().occupantGroup != this) {
            toRemove.add(agent);
        } else {
            this.finishedGoalCounter.updateAgent(agent);
        }
    }

    private void addNewMembers(KB kb) {
        this.newDynamicMembers.sort((a1, a2) -> (int)Math.signum(a1.getOcc().priority - a2.getOcc().priority));
        for (OccAgent a : this.newDynamicMembers) {
            this.addMember(a);
        }
        if (this.requiresLeader && this.leader == null) {
            for (OccAgent agent : this.newDynamicMembers) {
                if (!agent.getOcc().isGroupLeader) continue;
                this.leader = agent;
                break;
            }
        }
        this.newDynamicMembers.clear();
    }

    private void addMember(OccAgent a) {
        this.activeAgents.add(a);
        this.finishedGoalCounter.addAgent(a);
        if (this.usedProfilesMap != null) {
            this.usedProfilesMap.compute(a.getOcc().parentProfile, (prof, oldVal) -> {
                if (oldVal == null) {
                    return 1;
                }
                return oldVal + 1;
            });
        }
        if ((double)a.getOcc().maxVel < this.minSpeed) {
            this.minSpeed = a.getOcc().maxVel;
        }
        this.componentRestrictions.add(a.getOcc().compRestrictions);
        a.getOcc().occupantGroup = this;
    }

    private boolean shouldActivate() {
        return !this.activeAgents.isEmpty();
    }

    private boolean shouldDeactivate() {
        return this.activeAgents.isEmpty();
    }

    private void init(KB kb) {
        if (!this.initialized) {
            if (this.leaderInitOcc != null) {
                OccAgent agent = kb.getAgent(this.leaderInitOcc.id);
                assert (agent != null);
                this.setLeader(agent);
                this.leaderInitOcc = null;
            }
            if (this.initOccs != null) {
                for (Occupant occ : this.initOccs) {
                    OccAgent agent = kb.getAgent(occ.id);
                    assert (agent != null);
                    this.joinInstantly(agent);
                }
                this.initOccs = null;
            }
            this.initialized = true;
        }
    }

    public Set<OccAgent> getHighestRankingAgents() {
        return this.finishedGoalCounter.getHighestRankingAgents();
    }

    public int getMembersRanking(OccAgent agent) {
        return this.finishedGoalCounter.getMembersRanking(agent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Group ").append(this.groupID).append(":");
        if (this.leader != null) {
            sb.append("Leader:").append(this.leader.getName()).append(";");
        }
        sb.append("[");
        for (OccAgent member : this.activeAgents) {
            sb.append(member.getName()).append(";");
        }
        sb.append("]");
        return sb.toString();
    }

    public OccAgent getLeader() {
        return this.leader;
    }

    public boolean hasLeader() {
        return this.leader != null;
    }

    @Override
    public synchronized void joinDynamically(OccAgent agent) {
        this.newDynamicMembers.add(agent);
    }

    public void joinInstantly(OccAgent member) {
        this.addMember(member);
        if (this.requiresLeader && this.leader == null && (this.leaderProfile == null || this.leaderProfile == member.getOcc().parentProfile)) {
            this.setLeader(member);
            member.getOcc().isGroupLeader = true;
        }
    }

    public Set<OccAgent> getMembers() {
        return Collections.unmodifiableSet(this.activeAgents);
    }

    public boolean isMember(OccAgent agent) {
        return this.activeAgents.contains(agent);
    }

    @Override
    public int getID() {
        return this.groupID;
    }

    @Override
    public boolean requiresLeader() {
        return this.requiresLeader;
    }

    @Override
    public boolean respectSocialDist() {
        return this.respectSocialDist;
    }

    @Override
    public BehaviorSim getBehavior() {
        return this.behavior;
    }

    @Override
    public double getMaxDistance() {
        return this.d_maxDistance;
    }

    @Override
    public double getCurrentMaxDist() {
        return this.d_currMaxDist;
    }

    @Override
    public double getSlowdownTime() {
        return this.slowdownTime;
    }

    public synchronized boolean isReady() {
        if (this.usedProfilesMap == null) {
            this.isReady = this.isReady || this.activeAgents.size() >= this.minSize;
        } else if (!this.isReady) {
            boolean profilesReady = true;
            for (OccProfileSim prof : this.minSizeProfMap.keySet()) {
                if (this.usedProfilesMap.getOrDefault(prof, 0) >= this.minSizeProfMap.get(prof)) continue;
                profilesReady = false;
                break;
            }
            this.isReady = this.isReady || profilesReady;
        }
        return this.isReady;
    }

    public void setIsReady(boolean isReady) {
        this.isReady = isReady;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    public void setLeader(OccAgent leader) {
        this.leader = leader;
    }

    public boolean canJoin(OccAgent member) {
        if (this.prefSizeProfMap != null) {
            OccProfileSim prof = member.getOcc().parentProfile;
            if (this.prefSizeProfMap.containsKey(prof)) {
                return false;
            }
            return this.prefSizeProfMap.get(prof) > this.usedProfilesMap.getOrDefault(prof, 0);
        }
        return !this.isReady();
    }

    private void updateSpeedState(KB kb) {
        if (!this.isReady) {
            this.speedState = SpeedState.STOP;
        } else if (this.d_intIsDisconnected) {
            if (!this.occsInTheWay.isEmpty()) {
                this.speedState = SpeedState.GO;
            } else if (this.speedState == SpeedState.GO) {
                this.speedState = SpeedState.SLOW_DOWN;
                this.slowDownStart = kb.getCurrentSimTime();
            } else if (this.speedState == SpeedState.SLOW_DOWN && kb.getCurrentSimTime() - this.slowDownStart > this.slowdownTime) {
                this.speedState = SpeedState.STOP;
            }
        } else {
            this.speedState = SpeedState.GO;
        }
    }

    public synchronized void setDisconnected(boolean disconnected, double currentTime) {
        if (this.lastDisconnectedReset != currentTime) {
            this.d_intIsDisconnected = true;
            this.lastDisconnectedReset = currentTime;
        }
        this.d_intIsDisconnected &= disconnected;
    }

    public boolean isDisconnected() {
        return this.d_extIsDisconnected;
    }

    public SpeedState getSpeedState() {
        return this.speedState;
    }

    public synchronized void setInTheWay(OccAgent agent, boolean isInTheWay) {
        if (isInTheWay) {
            this.occsInTheWay.add(agent);
        } else {
            this.occsInTheWay.remove(agent);
        }
    }

    public int getCurrentSize() {
        return this.getMembers().size();
    }

    public double getMinVel() {
        return this.minSpeed;
    }

    public void addOccOnInit(Occupant occ) {
        if (occ == null) {
            return;
        }
        if (this.initOccs == null) {
            this.initOccs = new ArrayList<Occupant>();
        }
        this.initOccs.add(occ);
    }

    public void addLeaderOnInit(Occupant occ) {
        this.leaderInitOcc = occ;
    }

    public List<Occupant> getInitOccs() {
        return this.initOccs;
    }

    public Occupant getInitLeader() {
        return this.leaderInitOcc;
    }

    public OccProfileSim getNextProfile(Random rnd) {
        if (this.prefSizeProfMap != null) {
            ArrayList<OccProfileSim> profs = new ArrayList<OccProfileSim>(this.prefSizeProfMap.keySet());
            Collections.shuffle(profs, rnd);
            for (OccProfileSim prof : profs) {
                int remaining = this.prefSizeProfMap.get(prof) - this.usedProfilesMap.getOrDefault(prof, 0);
                if (remaining <= 0) continue;
                return prof;
            }
        }
        return null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public static enum SpeedState {
        GO,
        SLOW_DOWN,
        STOP;

    }

    public static class FinishedGoalsCounter
    implements Serializable {
        static final long serialVersionUID = 1L;
        private final ArrayList<Set<OccAgent>> ranking;
        private final IdentityHashMap<OccAgent, Integer> startingGoalIDs;
        private OccGroup group;

        public FinishedGoalsCounter(Collection<OccAgent> agents, OccGroup occGroup) {
            this.group = occGroup;
            this.ranking = new ArrayList();
            this.ranking.add(new LinkedHashSet<OccAgent>(agents));
            this.startingGoalIDs = new IdentityHashMap();
        }

        public void addAgent(OccAgent a) {
            this.ranking.get(0).add(a);
        }

        public void addAgents(List<OccAgent> newDynamicMembers) {
            this.ranking.get(0).addAll(newDynamicMembers);
        }

        public void updateAgent(OccAgent agent) {
            int i;
            int finishedGoals = agent.getGoalIx() - this.startingGoalIDs.computeIfAbsent(agent, a -> a.getGoalIx());
            if (finishedGoals >= this.ranking.size()) {
                for (i = this.ranking.size(); i <= finishedGoals; ++i) {
                    this.ranking.add(new LinkedHashSet());
                }
            }
            if (!this.ranking.get(finishedGoals).contains(agent)) {
                for (i = 0; i < finishedGoals; ++i) {
                    this.ranking.get(i).remove(agent);
                }
                this.ranking.get(finishedGoals).add(agent);
            }
        }

        public Set<OccAgent> getHighestRankingAgents() {
            LinkedHashSet highestRanking = new LinkedHashSet(this.ranking.get(this.ranking.size() - 1));
            highestRanking.retainAll(this.group.activeAgents);
            return Collections.unmodifiableSet(highestRanking);
        }

        public int getMembersRanking(OccAgent agent) {
            if (!this.startingGoalIDs.containsKey(agent)) {
                return 0;
            }
            int starting = this.startingGoalIDs.get(agent);
            int current = !agent.isDone() ? agent.getGoalIx() : 0;
            return current - starting;
        }
    }
}

