/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.PredefTag;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccStats;
import inferno.sim.Output;
import inferno.sim.Param;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.function.DoubleFunction;

public class OccDataCumulativeWriter {
    public static PrintStream open(Param p) throws FileNotFoundException {
        return Output.openTxtStream(new SerializedOutputStream(p.out_occ_cumulative));
    }

    public static void close(PrintStream out) {
        Output.close(out);
    }

    private static String strFormatValue(String printfStr, String nanStr, double value) {
        return Double.isNaN(value) || Double.isInfinite(value) ? nanStr : String.format(Locale.ENGLISH, printfStr, value);
    }

    private static String escape(String str) {
        if (!str.contains(",") && !str.contains("\"")) {
            return str;
        }
        String escaped = str.replace("\"", "\"\"");
        return "\"" + escaped + "\"";
    }

    private static String escape(String format, Object ... args) {
        return OccDataCumulativeWriter.escape(String.format(format, args));
    }

    public static void write(PrintStream out, KB kb, OccStats stats) {
        ArrayList<TagSummary> tagSummaries = new ArrayList<TagSummary>();
        for (Tag tag : kb.getTags()) {
            if (tag.predefined) continue;
            boolean everTagged = tag.getAnyWereEverTagged();
            boolean everUntagged = tag.getAnyWereEverUntagged();
            if (!everTagged && !everUntagged) continue;
            tagSummaries.add(new TagSummary(tag, everTagged, everUntagged));
        }
        Tag exitTag = kb.getPredefTag(PredefTag.EXITED);
        out.printf("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "id", "name", "exit time(s)", "active time(s)", "jam time total(s)", "jam time max continuous(s)", String.format("%s jam time", Tri.Terrain.OPEN.description), String.format("%s jam time", Tri.Terrain.STAIR.description), String.format("%s jam time", Tri.Terrain.RAMP.description), "start time(s)", "finish time(s)", "distance (m)");
        for (TagSummary tag : tagSummaries) {
            String name = tag.tag.name;
            if (tag.tagged && tag.untagged) {
                out.printf(",%s", OccDataCumulativeWriter.escape("%s time total(s)", name));
                out.printf(",%s", OccDataCumulativeWriter.escape("tag:%s time last(s)", name));
                out.printf(",%s", OccDataCumulativeWriter.escape("untag:%s time last(s)", name));
                continue;
            }
            if (tag.tagged) {
                out.printf(",%s", OccDataCumulativeWriter.escape("%s time(s)", name));
                continue;
            }
            if (!tag.untagged) continue;
            out.printf(",%s", OccDataCumulativeWriter.escape("untag:%s time(s)", name));
        }
        out.println();
        out.flush();
        DoubleFunction<String> doubleFunction = d -> OccDataCumulativeWriter.strFormatValue("%.3f", " ", d);
        double currTime = kb.getCurrentSimTime();
        for (OccAgent oa : stats.getAllAgentsEver(kb)) {
            String name = OccDataCumulativeWriter.escape(oa.getOcc().name);
            out.printf("%06d,%9s,%9s,%9s,%9s,%9s,%9s,%9s,%9s,%9s,%9s,%9s", oa.getId(), name, doubleFunction.apply(exitTag.getInfo((OccAgent)oa).tLastTagged), doubleFunction.apply(stats.getActiveTime(oa)), doubleFunction.apply(stats.getSlowTimeTotal(oa)), doubleFunction.apply(stats.getSlowTimeMc(oa)), doubleFunction.apply(stats.getOpenSlowTimeTotal(oa)), doubleFunction.apply(stats.getStairsSlowTimeTotal(oa)), doubleFunction.apply(stats.getRampsSlowTimeTotal(oa)), doubleFunction.apply(stats.getStartTime(oa)), doubleFunction.apply(stats.getFinishTime(oa)), doubleFunction.apply(stats.getTravelDistance(oa)));
            for (TagSummary tag : tagSummaries) {
                double t;
                Tag.Info ti = tag.tag.getInfo(oa);
                if (tag.tagged && tag.untagged) {
                    out.printf(",%9s", doubleFunction.apply(ti.getTAccum(currTime)));
                }
                if (tag.tagged) {
                    t = ti.tLastTagged;
                    out.printf(",%9s", doubleFunction.apply(t));
                }
                if (!tag.untagged) continue;
                t = ti.tLastUntagged == 0.0 ? Double.NaN : ti.tLastUntagged;
                out.printf(",%9s", doubleFunction.apply(t));
            }
            out.println();
        }
        out.flush();
    }

    private static class TagSummary {
        public final Tag tag;
        public final boolean tagged;
        public final boolean untagged;

        public TagSummary(Tag tag, boolean tagged, boolean untagged) {
            this.tag = tag;
            this.tagged = tagged;
            this.untagged = untagged;
        }
    }
}

