/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.ANode;
import inferno.data2.CylinderShape;
import inferno.data2.DoorDir;
import inferno.data2.EdgeData;
import inferno.data2.ElevatorLevel;
import inferno.data2.IAgentBodyShape;
import inferno.data2.IElevator;
import inferno.data2.IIdentifiable;
import inferno.data2.Mesh;
import inferno.data2.OccAnim;
import inferno.data2.OccLocator;
import inferno.data2.Occupant;
import inferno.data2.PathSpeedHistory;
import inferno.data2.PolygonShape;
import inferno.data2.PredefTag;
import inferno.data2.SplitEdge;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.data2.ai.AssistOccupantsGoal;
import inferno.data2.ai.ControlledOccGoal;
import inferno.data2.ai.ExitGoal;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.WaitUntilInsideGoal;
import inferno.data2.value.IFunction1d;
import inferno.geom.Inter;
import inferno.geom.Plane3d;
import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.geom.WallSlider;
import inferno.sim.AgentVehicle;
import inferno.sim.AssistedEvacClientAgent;
import inferno.sim.BehaviorSim;
import inferno.sim.DoorQueue;
import inferno.sim.ElevatorModel;
import inferno.sim.IAgent;
import inferno.sim.IFormationLeaderAgent;
import inferno.sim.IRelation;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.OccEnvData;
import inferno.sim.OccGroup;
import inferno.sim.OccProfileSim;
import inferno.sim.OccStats;
import inferno.sim.Param;
import inferno.sim.ai.AiUtil;
import inferno.sim.ai.IAiCore;
import inferno.sim.ai.LostAiCore;
import inferno.sim.ai.ReqAssistedByAiCore;
import inferno.sim.ai.SevereInjuryAiCore;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.IPath;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathFilters;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Steer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class OccAgent
implements Serializable,
IIdentifiable,
IAgent {
    static final long serialVersionUID = 1L;
    public static final boolean COLLIDE_ONLY_IF_VISIBLE = System.getProperty("OccAgent.COLLIDE_ALWAYS") == null;
    private static final boolean RANDOM_STEER_OFFSET = System.getProperty("OccAgent.RANDOM_STEER_OFFSET") != null;
    private static final Logger LOGGER = Logger.getLogger(OccAgent.class.getName());
    private static final boolean TEST_ENGINE_THREAD_CRASH = false;
    private static final boolean TEST_NONENGINE_THREAD_CRASH = false;
    private static final PathFollow.Status IDLING_STATUS = new PathFollow.Status(null, 0.0, null);
    public static final boolean USE_NONLINEAR_ACCEL = false;
    public static final double MIN_COMFORT = 0.01;
    public static final boolean USE_COMPONENT_ACCEL = true;
    public static final IUpdator DEFAULT_UPDATOR = new DefaultUpdator();
    public static final double DIST_TO_WALL_TOL = 0.001;
    private static final Plane3d Z_PLANE = new Plane3d(new Vector3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0));
    private static final double FLAT_SLOPE_TOL = Math.tan(Math.toRadians(10.0));
    private final Occupant d_occ;
    private transient IAiCore d_aiCore;
    private transient LostAiCore d_lostAiCore;
    private transient Steer d_lastSteer = null;
    private IParametric3D d_seekCurve;
    private boolean d_behaviorIsSeeking;
    private transient OccAgent d_occHit;
    private transient PathSpeedHistory d_pathSpeedHistory;
    private double d_dtModified = 0.0;
    public double d_realTimeModifier = 1.0;
    private boolean d_selected = false;
    private transient Map<Class<?>, IRelation> d_relations;
    private transient List<ANode> d_nonClearedDoors;
    private transient UpdatePacket d_nextLoc;
    private OccStats.PerAgentData d_stats;
    private transient IUpdator d_updator;
    private PathFollow.Status d_pathFollowStatus = PathFollow.UNKNOWN_STATUS;
    private AgentVehicle d_vehicle;
    private transient AssistedEvacClientAgent d_assistedEvacClientModule;
    private double d_tLastModified = Double.NaN;

    public OccAgent(KB kb, Param param, Occupant occ) {
        assert (occ != null);
        this.d_occ = occ;
        this.d_updator = DEFAULT_UPDATOR;
        this.d_seekCurve = null;
        this.d_pathSpeedHistory = new PathSpeedHistory(param.max_pathspeed_history, param.pathspeed_history_freq);
        this.d_pathSpeedHistory.record(0.0, 0.0);
        this.moveToNode(kb, null, this.d_occ.tri.node, 0.0);
        Random r = new Random(this.d_occ.rseed + 154134165521572644L);
        this.d_realTimeModifier = r.nextDouble();
        if (occ.reqAssistedBy) {
            this.setAiCore(new ReqAssistedByAiCore());
        } else {
            this.setAiCore(AiUtil.newCore(this));
        }
        this.d_relations = Collections.emptyMap();
        this.d_nonClearedDoors = new ArrayList<ANode>(1);
        this.d_stats = new OccStats.PerAgentData();
        this.initVehicle(kb);
        if (this.d_vehicle != null) {
            this.d_occ.anim = this.d_vehicle.calcOccAnim(this.getLoc(), this.getVel(), () -> this.d_occ.anim);
        }
    }

    public void writeSelfRefData(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_aiCore);
        oos.writeObject(this.d_lostAiCore);
        oos.writeObject(this.d_lastSteer);
        oos.writeObject(this.d_occHit);
        oos.writeObject(this.d_pathSpeedHistory);
        oos.writeObject(this.d_relations);
        oos.writeObject(this.d_nonClearedDoors);
        oos.writeObject(this.d_nextLoc);
        oos.writeObject(this.d_updator);
        oos.writeObject(this.d_assistedEvacClientModule);
        if (this.d_assistedEvacClientModule != null) {
            this.d_assistedEvacClientModule.writeSelfRefData(oos);
        }
    }

    public void readSelfRefData(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_aiCore = (IAiCore)ois.readObject();
        this.d_lostAiCore = (LostAiCore)ois.readObject();
        this.d_lastSteer = (Steer)ois.readObject();
        this.d_occHit = (OccAgent)ois.readObject();
        this.d_pathSpeedHistory = (PathSpeedHistory)ois.readObject();
        this.d_relations = (Map)ois.readObject();
        this.d_nonClearedDoors = (List)ois.readObject();
        this.d_nextLoc = (UpdatePacket)ois.readObject();
        this.d_updator = (IUpdator)ois.readObject();
        this.d_assistedEvacClientModule = (AssistedEvacClientAgent)ois.readObject();
        if (this.d_assistedEvacClientModule != null) {
            this.d_assistedEvacClientModule.readSelfRefData(ois);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_vehicle != null) {
            this.d_vehicle.setAgent(this);
        }
    }

    public IUpdator getUpdator() {
        return this.d_updator;
    }

    public void setUpdator(IUpdator updator) {
        this.d_updator = updator;
    }

    public int getGoalIx() {
        if (this.d_occ.behaviorStack.isEmpty()) {
            return 0;
        }
        return this.d_occ.behaviorStack.peek().goalIndex;
    }

    public void setGoalIx(int index) {
        BehaviorSim.BehaviorInProgress bp = this.d_occ.behaviorStack.pop();
        this.d_occ.behaviorStack.push(new BehaviorSim.BehaviorInProgress(bp.behavior, index));
        this.d_pathFollowStatus = PathFollow.UNKNOWN_STATUS;
        if (!AiUtil.getPreviousGoal(this).wasImmediate()) {
            if (this.d_occ.dynamicCompRestrictions != null) {
                this.d_occ.dynamicCompRestrictions.clearTempElevatorRestrictions();
            }
            if (this.d_occ.elevatorWaitTime != null) {
                this.d_occ.elevatorWaitTime.reset();
            }
        }
    }

    public void setCanMove(boolean canMove) {
        this.d_occ.canMove = canMove;
    }

    public boolean getMoveWhileIdle() {
        return this.d_occ.canMove;
    }

    @Override
    public int getId() {
        return this.d_occ.id;
    }

    public String getName() {
        return this.d_occ.name;
    }

    public void addRelation(IRelation r) {
        if (this.d_relations.isEmpty()) {
            this.d_relations = new HashMap();
        }
        this.d_relations.put(r.getClass(), r);
    }

    public void removeRelation(IRelation r) {
        this.d_relations.remove(r.getClass());
        if (this.d_relations.isEmpty()) {
            this.d_relations = Collections.emptyMap();
        }
    }

    public IRelation getRelation(Class<?> clazz) {
        return this.d_relations.get(clazz);
    }

    public Collection<IRelation> getRelations() {
        return this.d_relations.values();
    }

    public IAiCore getAiCore() {
        return this.d_aiCore;
    }

    public void setAiCore(IAiCore thinks) {
        this.d_aiCore = thinks;
    }

    public IGoalInstance getCurrentGoalInstance(KB kb) {
        return AiUtil.getCurrentGoal(this);
    }

    public IGoal getCurrentGoal() {
        if (this.d_lostAiCore != null) {
            return this.d_lostAiCore.getCurrentGoalInstance(this).getGoal();
        }
        return AiUtil.getCurrentGoal(this).getGoal();
    }

    public double getComfortDist(KB kb) {
        return this.getComfortDist(kb, this.d_occ.squeezeFactor);
    }

    public double getComfortDist(KB kb, double squeezeFactor) {
        if (squeezeFactor != 1.0 || this.d_occ.nodeSqueezeFactor != 1.0f) {
            double reduction = this.d_occ.bodyShape.getEnclosingRadius() - this.getCollisionShape(this.d_occ.getCollisionFactor(squeezeFactor)).getEnclosingRadius();
            assert (reduction >= 0.0);
            return (double)this.d_occ.comfortDist + reduction;
        }
        return this.d_occ.comfortDist;
    }

    public ISeekGoal getPreviousSeekGoal() {
        return AiUtil.getPreviousSeek(this).getGoal();
    }

    public IProgressNote getProgress(KB kb) {
        if (theUtil.eq0(this.d_occ.maxVel, 1.0E-6)) {
            return IProgressNote.PROGRESSING;
        }
        IProgressNote aiProgress = this.d_lostAiCore != null ? this.d_lostAiCore.getProgress(kb, this) : this.d_aiCore.getProgress(kb, this);
        return new OccProgressNote(this.getOcc().behaviorStack.peek(), aiProgress);
    }

    public void finish(KB kb) {
        if (this.d_occ.curNode != null) {
            this.moveToNode(kb, null, null, kb.getCurrentSimTime());
        }
        this.d_occ.finish(kb.getCurrentSimTime());
        kb.getPredefTag(PredefTag.FINISHED).tag(kb.getCurrentSimTime(), this);
    }

    public void finishNoExit(KB kb) {
        this.d_occ.finishNoExit();
        kb.getPredefTag(PredefTag.FINISHED).tag(kb.getCurrentSimTime(), this);
    }

    public String toString() {
        return "[OccAgent] " + this.d_occ.name + ": " + this.d_occ.loc;
    }

    public void setSelected(boolean selected) {
        this.d_selected = selected;
    }

    public boolean isSelected() {
        return this.d_selected;
    }

    public Occupant getOcc() {
        return this.d_occ;
    }

    public float getMass() {
        return this.d_occ.mass;
    }

    public double getOccupantRadius() {
        return this.d_occ.bodyShape.getOccRadius();
    }

    public double getGeometryRadius() {
        return this.d_occ.bodyShape.getGeomRadius();
    }

    public double getHeight() {
        return this.d_occ.bodyShape.getHeight();
    }

    public void getAllPossibleRadii(boolean geom, DoubleConsumer result) {
        result.accept(geom ? this.getGeometryRadius() : this.getOccupantRadius());
        this.d_occ.behavior.getFutureProfileValues(new IdentityHashSet(), OccProfileSim.PROP_SHAPE, shape -> shape.getAllWidths(geom, w -> result.accept(w * 0.5)));
    }

    public double[] getRadiusRangeEver(boolean geom) {
        return this.getRangeOverAllPossible(OccProfileSim.PROP_SHAPE, geom ? this.d_occ.bodyShape.getGeomRadius() : this.d_occ.bodyShape.getOccRadius(), shape -> {
            double[] range = shape.getWidthRange(geom);
            range[0] = range[0] * 0.5;
            range[1] = range[1] * 0.5;
            return range;
        });
    }

    /*
     * Exception decompiling
     */
    public double[] getMaxVelRangeEver() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> double[] getRangeOverAllPossible(OccProfileSim.IOccProp<T> prop, double currVal, Function<T, double[]> getRange) {
        double[] range = new double[]{currVal, currVal};
        this.d_occ.behavior.getFutureProfileValues(new IdentityHashSet(), prop, val -> {
            double[] vr = (double[])getRange.apply(val);
            dArray[0] = Math.min(range[0], vr[0]);
            dArray[1] = Math.max(range[1], vr[1]);
        });
        return range;
    }

    public double getCollisionFactor() {
        return this.d_occ.getCollisionFactor();
    }

    public double getCollisionFactor(double squeezeFactor) {
        return this.d_occ.getCollisionFactor(squeezeFactor);
    }

    public Vector3d getVel() {
        return new Vector3d(this.d_occ.vel);
    }

    public TriPoint getLoc() {
        return new TriPoint(this.d_occ.tri, this.d_occ.loc);
    }

    public Point3d getPos() {
        return new Point3d(this.d_occ.loc);
    }

    public Vector3d getDirFacing() {
        return new Vector3d(this.d_occ.orient);
    }

    @Override
    public boolean isDone() {
        return this.d_occ.isDone();
    }

    public double dtModified() {
        return this.d_dtModified;
    }

    public static double getMaxVel(KB kb, Occupant occ, Vector3d travelDir) {
        return OccAgent.getMaxVel(kb, occ, 0.0, travelDir);
    }

    public static double getMaxVel(KB kb, Occupant occ, double density, Vector3d travelDir) {
        if (!occ.canMove) {
            return 0.0;
        }
        Tri.Terrain terrainType = occ.tri.terrain;
        double maxVel = occ.maxVel;
        switch (terrainType) {
            case STAIR: {
                maxVel = occ.stairSpeed.getMaxSpeed(occ, density, travelDir);
                break;
            }
            case RAMP: {
                maxVel = occ.rampSpeed.getMaxSpeed(occ, density, travelDir);
                break;
            }
            default: {
                maxVel = OccAgent.getMaxOpenVel(kb, occ, density);
            }
        }
        if (kb.getParams().smvSmokeSlowEnable) {
            return OccAgent.clampOnVisibility(kb.getOccEnvData(), occ, maxVel);
        }
        return maxVel;
    }

    private static double clampOnVisibility(OccEnvData envData, Occupant occ, double terrainMaxVel) {
        return terrainMaxVel * OccAgent.getVisibilityReduction(envData, occ);
    }

    private static double getVisibilityReduction(OccEnvData envData, Occupant occ) {
        Map<OccEnvData.QInfo, Double> agentInfoMap = envData.getValues(occ);
        if (agentInfoMap == null) {
            return 1.0;
        }
        OccEnvData.QInfo visInfo = envData.getSupportedQuantities().get("SOOT VISIBILITY");
        if (visInfo == null) {
            return 1.0;
        }
        double fdsVis = agentInfoMap.get(visInfo);
        IFunction1d visProfile = occ.parentProfile.getProperty(OccProfileSim.PROP_VISIBILITY_REDUCTION);
        return visProfile.get(fdsVis);
    }

    private static double getMaxOpenVel(KB kb, Occupant occ, double density) {
        return KnownFuncs.getOpenSpeed(occ.maxVel, !occ.movingTerrainPref.standing, occ.fundamental, occ.tri, density);
    }

    public static double getTotalMaxVel(KB kb, Occupant occ) {
        if (!occ.canMove) {
            return 0.0;
        }
        Tri.Terrain terrainType = occ.tri.terrain;
        switch (terrainType) {
            case STAIR: {
                return occ.stairSpeed.getAbsoluteMaxSpeed(occ, 0.0);
            }
            case RAMP: {
                return occ.rampSpeed.getAbsoluteMaxSpeed(occ, 0.0);
            }
        }
        return OccAgent.getMaxOpenVel(kb, occ, 0.0);
    }

    public double getAccelTime(KB kb) {
        return kb.getParams().inertia ? 1.0 / (double)this.d_occ.accelFactor : 0.0;
    }

    public double getMaxStartAccel(KB kb) {
        return Math.abs(this.d_occ.maxVel) * this.d_occ.accelFactor;
    }

    public double getMaxStopAccel(KB kb) {
        double factor = this.d_occ.decelFactor;
        return this.getMaxStartAccel(kb) * factor;
    }

    public double getMaxRadialAccel(KB kb) {
        double factor = this.d_occ.radialAccelFactor;
        return this.getMaxStartAccel(kb) * factor;
    }

    public double getAverageSpeedAlongPath(KB kb, double tVAvg) {
        return this.getPathSpeedHistory().getAverage(kb.getCurrentSimTime(), tVAvg);
    }

    public static double calcStopTime(double vel, double stopAccel) {
        return vel / stopAccel;
    }

    public static double calcSpeedupTime(double iniVel, double maxVel, double startAccel) {
        return (maxVel - iniVel) / startAccel;
    }

    public static double calcTravelTime(double iniVel, double maxVel, double accel, double dist) {
        double tSpeedupToMaxVel;
        double v2 = Math.sqrt(iniVel * iniVel + 2.0 * accel * dist);
        double v3 = Math.max(-iniVel + v2, -iniVel - v2);
        double t = v3 / accel;
        if (t <= (tSpeedupToMaxVel = OccAgent.calcSpeedupTime(iniVel, maxVel, accel))) {
            return t;
        }
        double distCovered = OccAgent.calcDistance(iniVel, accel, tSpeedupToMaxVel);
        assert (dist > distCovered);
        double remainingDist = dist - distCovered;
        double tConstant = remainingDist / maxVel;
        return tSpeedupToMaxVel + tConstant;
    }

    public static double calcTravelDist(double iniVel, double maxVel, double accel, double time) {
        double tSpeedupToMaxVel = OccAgent.calcSpeedupTime(iniVel, maxVel, accel);
        if (time <= tSpeedupToMaxVel) {
            return iniVel * time + 0.5 * accel * time * time;
        }
        double dist1 = iniVel * tSpeedupToMaxVel + 0.5 * accel * tSpeedupToMaxVel * tSpeedupToMaxVel;
        double t2 = time - tSpeedupToMaxVel;
        double dist2 = maxVel * t2;
        return dist1 + dist2;
    }

    public static double calcVelChangeDist(double v0, double vf, double accel) {
        double d = (vf * vf - v0 * v0) / (2.0 * accel);
        return Math.abs(d);
    }

    public static double calcStopDist(double vel, double stopAccel) {
        return 0.5 * vel * vel / stopAccel;
    }

    public static double calcDistance(double iniVel, double accel, double time) {
        return iniVel * time + 0.5 * accel * time * time;
    }

    public static double calcVelToStop(double stopAccel, double dist) {
        return Math.sqrt(2.0 * stopAccel * dist);
    }

    public static double calcMaxVelToStop(double v0, double accel, double dist) {
        return Math.sqrt(accel * dist + 0.5 * v0 * v0);
    }

    public static double calcMaxVel(double vc, double vf, double accel, double decel, double dist) {
        assert (accel != 0.0 && decel != 0.0);
        return Math.sqrt((2.0 * dist * accel * decel + decel * vc * vc + accel * vf * vf) / (accel + decel));
    }

    public PathFollow getPathFollow() {
        return this.d_aiCore.getSteering(this).getPathFollow(this);
    }

    public boolean isWaiting(KB kb) {
        return this.d_lostAiCore != null || !this.d_behaviorIsSeeking || !this.d_aiCore.isSeeking(kb, this);
    }

    public boolean isBehaviorSeeking() {
        return this.d_behaviorIsSeeking;
    }

    public double getWaitingEndTime(KB kb) {
        IGoalInstance currInst = this.getCurrentGoalInstance(null);
        if (!(currInst instanceof IIdleGoalInstance)) {
            return currInst instanceof AssistOccupantsGoal.Instance && ((AssistOccupantsGoal.Instance)currInst).isWaiting() ? Double.POSITIVE_INFINITY : -1.0;
        }
        return ((IIdleGoalInstance)currInst).getEndTime(kb);
    }

    public double getPriority(KB kb) {
        return this.d_occ.priority;
    }

    public void moveToNode(KB kb, DoorQueue crossedDoor, ANode n, double t) {
        ANode oldNode = this.d_occ.curNode;
        if (oldNode != n) {
            this.d_occ.curNode = n;
            if (oldNode != null) {
                oldNode.exit(kb, this, crossedDoor, t);
                if (n != null) {
                    for (Tag tag : oldNode.getTags()) {
                        tag.untag(t, this);
                    }
                }
            }
            if (n != null) {
                n.enter(kb, this, crossedDoor, t);
                for (Tag tag : n.getTags()) {
                    tag.tag(t, this);
                }
            }
            if (crossedDoor != null) {
                this.d_aiCore.doorCrossed(t, this, crossedDoor);
                IFormationLeaderAgent formationLeader = this.getOcc().formationLeader;
                if (formationLeader != null) {
                    formationLeader.formationCrossingDoor(crossedDoor, this, crossedDoor.getDir(n));
                }
            }
        }
        if (n == null && oldNode != null) {
            oldNode.incrementExitCount();
        }
    }

    public ISteeringBehavior getSteeringBehavior() {
        return this.getAiCore().getSteering(this);
    }

    public void initVehicle(KB kb) {
        if (this.getShape() instanceof PolygonShape) {
            if (this.d_vehicle == null || !this.d_vehicle.isValid()) {
                if (this.d_vehicle != null) {
                    this.d_vehicle.abandon(kb, this);
                }
                this.d_vehicle = new AgentVehicle(kb, this);
            }
        } else if (this.d_vehicle != null) {
            this.d_vehicle.abandon(kb, this);
            this.d_vehicle = null;
        }
    }

    public boolean hasVehicle() {
        return this.d_vehicle != null;
    }

    public AgentVehicle getVehicle() {
        return this.d_vehicle;
    }

    public boolean isAssisting(KB kb, OccAgent client) {
        IGoalInstance goal = this.getCurrentGoalInstance(kb);
        return goal instanceof AssistOccupantsGoal.Instance && ((AssistOccupantsGoal.Instance)goal).getCurrentClient() == client;
    }

    @Override
    public boolean init(KB kb, Param p) {
        if (!this.initNonVehicle(kb, p)) {
            return false;
        }
        if (this.d_vehicle != null) {
            this.d_vehicle.init(kb, p);
        }
        return true;
    }

    private boolean initNonVehicle(KB kb, Param p) {
        this.d_aiCore.init(kb, this);
        try {
            SeekCurve curve = this.d_aiCore.getSteering(this).generateSeekCurve(kb, this);
            this.d_seekCurve = curve.curve;
            this.d_behaviorIsSeeking = curve.seeking;
        }
        catch (LostException e) {
            this.d_lostAiCore = this.getLostAiCore(kb);
            try {
                SeekCurve curve = this.d_lostAiCore.getSteering(this).generateSeekCurve(kb, this);
                this.d_seekCurve = curve.curve;
                this.d_behaviorIsSeeking = curve.seeking;
                return true;
            }
            catch (LostException e2) {
                LOGGER.log(Level.SEVERE, String.format("[error] occ %s: unable to start wait forever behavior.\n", this.d_occ.name));
                LOGGER.log(Level.SEVERE, e2.toString(), e2);
                return false;
            }
        }
        Vector3d seekOrient = this.d_seekCurve.getTangent(0.0);
        if (seekOrient.lengthSquared() > 0.0 && this.d_occ.bodyShape instanceof CylinderShape) {
            seekOrient.normalize();
            this.d_occ.orient = seekOrient;
        }
        Util.projectAlongZEq(Z_PLANE, this.d_occ.orient);
        this.d_occ.displayOrient = this.d_occ.orient;
        this.updateCanMove();
        return true;
    }

    public OccStats.PerAgentData getStats() {
        return this.d_stats;
    }

    public OccAgent getAvoidOcc() {
        if (this.d_lastSteer != null && this.d_lastSteer.avoidOccs.length > 0) {
            return this.d_lastSteer.avoidOccs[0];
        }
        return this.d_occHit;
    }

    public OccAgent[] getAvoidOccs() {
        return this.d_lastSteer != null ? this.d_lastSteer.avoidOccs : new OccAgent[]{};
    }

    public List<OccAgent> getWaitingOccs(KB kb) {
        return kb.getCycleBreaker().getWaitingOccs(kb, this);
    }

    public Steer getLastSteer() {
        return this.d_lastSteer;
    }

    public PathSpeedHistory getPathSpeedHistory() {
        return this.d_pathSpeedHistory;
    }

    public boolean isSocialDistancingEnabled() {
        return !Float.isNaN(this.d_occ.socialDist);
    }

    public float getSocialDistance() {
        return this.d_occ.socialDist;
    }

    public float getSocialDistance(OccAgent other) {
        if (!this.isSocialDistancingEnabled()) {
            return 0.0f;
        }
        if (this.d_occ.occupantGroup == null || this.d_occ.occupantGroup.respectSocialDist) {
            return this.d_occ.socialDist;
        }
        return this.d_occ.occupantGroup.isMember(other) ? 0.0f : this.d_occ.socialDist;
    }

    public Optional<OccGroup> getGroup() {
        return Optional.ofNullable(this.d_occ.occupantGroup);
    }

    public boolean isGroupedWith(OccAgent other) {
        if (this.d_occ.occupantGroup != null) {
            return this.d_occ.occupantGroup.isMember(other);
        }
        return false;
    }

    public boolean isSlow(KB kb) {
        return this.isSlow(kb, this.d_occ.vel.length());
    }

    public boolean isSlow(KB kb, double speed) {
        return this.isSlow(kb, speed, this.d_occ.slowFactor);
    }

    public boolean isSlow(KB kb, double speed, double slowFactor) {
        return this.getSpeedFraction(kb, speed) <= slowFactor;
    }

    private double getSpeedFraction(KB kb, double speed) {
        return speed / OccAgent.getMaxVel(kb, this.d_occ, this.d_occ.vel);
    }

    public boolean isStuck(KB kb) {
        return !this.isDone() && !this.d_occ.waiting && !this.isWaiting(kb) && theUtil.le0(this.getVel().dot(this.getSeekDir()), 1.0E-9);
    }

    protected Vector3d getSeekDir() {
        if (this.d_seekCurve == null) {
            return GeomConstants.VEC3D_ZERO;
        }
        Vector3d dir = this.d_seekCurve.getTangent(0.0);
        Util.safeNormalize(dir, 1.0E-6);
        return dir;
    }

    public IParametric3D getSeekCurve() {
        return this.d_seekCurve;
    }

    private double getFreePassTime(KB kb, double dt) {
        OccAgent avoid = this.getAvoidOcc();
        if (avoid == null) {
            return dt * 1.01;
        }
        Vector3d dir1 = this.getSeekCurve().getTangent(0.0);
        dir1.normalize();
        Vector3d dir2 = Util3D.vector(this.getPos(), avoid.getPos());
        double freePassDist = dir1.dot(dir2) * 2.0;
        if (freePassDist <= 0.0) {
            return dt * 1.01;
        }
        double freePassTime = 0.0;
        if (kb.getParams().inertia) {
            double a = this.getMaxStartAccel(kb);
            freePassTime = Math.sqrt(2.0 * a * freePassDist) / a;
        } else {
            double maxVel;
            if (kb.getParams().vel_from_density) {
                double density = this.d_occ.tri.node.getNumOccupants() > 1 ? this.d_occ.tri.node.getDensity() : 0.0;
                maxVel = OccAgent.getMaxVel(kb, this.getOcc(), density, dir1);
            } else {
                maxVel = OccAgent.getMaxVel(kb, this.getOcc(), dir1);
            }
            freePassTime = freePassDist / maxVel;
        }
        return Math.max(dt * 1.01, freePassTime);
    }

    @Override
    public void preMove(KB kb, Param p, double dt) {
        this.d_aiCore.preMove(kb, this, dt);
        if (this.d_occ.waiting && this.d_occ.isPassive) {
            return;
        }
        assert (!this.isDone());
        try {
            if (kb.getForceIdle() && !(this.getCurrentGoal() instanceof ControlledOccGoal)) {
                throw new LostException();
            }
            SeekCurve curve = this.d_aiCore.getSteering(this).generateSeekCurve(kb, this);
            if (this.d_occ.waiting) {
                assert (!this.d_occ.isPassive) : "Passive agents cannot switch doors.";
                if (this.d_occ.doorQueue != null) {
                    ANode oldTargetNode;
                    Pair<ANode, DoorDir> newTarget = this.getTargetDoor(true);
                    ANode newTargetNode = newTarget != null ? (ANode)newTarget.v1 : null;
                    ANode aNode = oldTargetNode = this.d_occ.targetDoor != null ? (ANode)this.d_occ.targetDoor.v1 : null;
                    if (newTargetNode != oldTargetNode) {
                        ((DoorQueue)this.d_occ.doorQueue.v1).removeFromQueue(this);
                    }
                }
                return;
            }
            Steer steer = this.steer(kb, p, dt, curve);
            this.d_nextLoc = this.d_updator.calcUpdate(kb, p, dt, this, steer, curve);
        }
        catch (LostException e) {
            if (this.d_occ.doorQueue != null) {
                return;
            }
            this.d_aiCore.processLost(this);
            LostAiCore lostAiCore = this.getLostAiCore(kb);
            try {
                SeekCurve curve = lostAiCore.getSteering(this).generateSeekCurve(kb, this);
                Steer steer = this.steer(kb, p, dt, lostAiCore, curve);
                this.d_nextLoc = this.d_updator.calcUpdate(kb, p, dt, this, steer, curve);
                this.d_nextLoc.lostAiCore = lostAiCore;
            }
            catch (LostException e2) {
                LOGGER.log(Level.SEVERE, String.format("[error] occ %s: unable to start wait forever behavior.\n", this.d_occ.name));
                LOGGER.log(Level.SEVERE, e2.toString(), e);
                this.d_nextLoc = null;
                return;
            }
        }
    }

    protected LostAiCore getLostAiCore(KB kb) {
        LostAiCore lostAiCore = this.d_lostAiCore;
        if (lostAiCore == null) {
            lostAiCore = new LostAiCore();
            lostAiCore.init(kb, this);
        }
        return lostAiCore;
    }

    public boolean isLost() {
        return this.d_lostAiCore != null;
    }

    public void impell(Vector3d vel, double turnVel) {
        assert (this.d_occ.behavior.size() == 1 && this.getCurrentGoal() instanceof ControlledOccGoal);
        ControlledOccGoal.Controls controls = (ControlledOccGoal.Controls)this.d_aiCore.getSteering(this);
        controls.set(vel, turnVel);
    }

    private Steer steer(KB kb, Param p, double dt, SeekCurve seekCurve) {
        return this.steer(kb, p, dt, this.d_aiCore, seekCurve);
    }

    private Steer steer(KB kb, Param p, double dt, IAiCore core, SeekCurve seekCurve) {
        ISteeringBehavior behavior = core.getSteering(this);
        Predicate<OccAgent> agentFilter = Filters.acceptAll(OccAgent.class);
        return behavior.steer(kb, this, seekCurve, agentFilter);
    }

    public void enterQueue(DoorQueue queue, DoorDir dir, double t) {
        this.d_occ.waiting = true;
        this.d_occ.doorQueue = new Pair<DoorQueue, DoorDir>(queue, dir);
    }

    public void exitQueue(KB kb, DoorQueue queue, ANode destNode, double t) {
        this.d_occ.waiting = false;
        this.d_occ.prevNode = this.d_occ.curNode;
        assert (this.d_occ.doorQueue != null && queue == this.d_occ.doorQueue.v1);
        queue.getNode().exit(kb, this, queue, t);
        this.moveToNode(kb, queue, destNode, t);
        this.modified(t);
    }

    private void modified(double time) {
        this.d_dtModified = time;
    }

    private UpdatePacket calcTravel(KB kb, Param p, double dt, Steer steer, SeekCurve seekCurve) {
        Vector3d vel;
        TriPoint prevLoc = this.getLoc();
        if (this.d_occ.isPassive) {
            vel = steer.vel;
        } else if (p.inertia) {
            Vector3d steeringForce;
            Vector3d dv = Inter.sub(steer.vel, (Tuple3d)this.getVel());
            double dvMag = dv.length();
            if (dvMag == 0.0) {
                steeringForce = new Vector3d(0.0, 0.0, 0.0);
            } else {
                Vector3d radialAccel;
                Vector3d tanAccel;
                Vector3d desAccel = Util3D.scale(dv, 1.0 / dt);
                Vector3d tanComp = new Vector3d(this.getVel());
                double speed0 = Util3D.safeNormalize(tanComp, 1.0E-9);
                double desTanAccelMag = speed0 > 0.0 ? desAccel.dot(tanComp) : steer.vel.length() / dt;
                double maxTanAccelMag = desTanAccelMag < 0.0 ? this.getMaxStopAccel(kb) : this.getMaxStartAccel(kb);
                double tanAccelMag = Math.signum(desTanAccelMag) * Math.min(maxTanAccelMag, Math.abs(desTanAccelMag));
                if (speed0 > 0.0) {
                    tanAccel = Util3D.scale(tanComp, tanAccelMag);
                } else {
                    Vector3d dir1 = new Vector3d(steer.vel);
                    Util.safeNormalize(dir1, 1.0E-9);
                    dir1.scale(tanAccelMag);
                    tanAccel = dir1;
                }
                Util.projectAlongZEq(new Plane3d(GeomConstants.VEC3D_ZPOS, prevLoc.p), tanComp);
                double speed1 = steer.vel.length();
                if (theUtil.eq0(speed0, 1.0E-6) || theUtil.eq0(speed1, 1.0E-6)) {
                    radialAccel = GeomConstants.VEC3D_ZERO;
                } else {
                    Vector3d radialComp = Util3D.cross(GeomConstants.VEC3D_ZPOS, tanComp);
                    Util3D.safeNormalize(radialComp, 1.0E-9);
                    double desRadialAccelMag = desAccel.dot(radialComp);
                    double maxRadialAccelMag = this.getMaxRadialAccel(kb);
                    double radialAccelMag = Math.signum(desRadialAccelMag) * Math.min(maxRadialAccelMag, Math.abs(desRadialAccelMag));
                    radialAccel = Util3D.scale(radialComp, radialAccelMag);
                }
                Vector3d accel = Util3D.add(tanAccel, (Tuple3d)radialAccel);
                Util.projectAlongZEq(prevLoc.tri.plane, accel);
                steeringForce = Inter.scaleEq(accel, this.getMass());
            }
            Vector3d accel = Inter.scale(steeringForce, 1.0 / (double)this.getMass());
            vel = Inter.add(this.d_occ.vel, (Tuple3d)Inter.scale(accel, dt));
            if (this.d_occ.bodyShape instanceof PolygonShape) {
                double turningRate = Math.PI / this.d_occ.bodyShape.getMinTurnaroundTime();
                double tolerance = turningRate * dt;
                vel = ((PolygonShape)this.d_occ.bodyShape).snapVelToOrient(vel, tolerance);
            }
            if (vel.dot(vel) < 1.0E-6) {
                vel.set(0.0, 0.0, 0.0);
            }
        } else {
            double maxVel;
            if (p.vel_from_density) {
                double density = prevLoc.tri.node.getNumOccupants() > 1 ? prevLoc.tri.node.getDensity() : 0.0;
                maxVel = Math.min(steer.vel.length(), OccAgent.getMaxVel(kb, this.getOcc(), density, steer.vel));
            } else {
                maxVel = OccAgent.getMaxVel(kb, this.getOcc(), steer.vel);
            }
            vel = new Vector3d(steer.vel);
            if (vel.lengthSquared() > 0.0) {
                vel.normalize();
                vel.scale(maxVel);
            }
        }
        List<OccAgent> potCollisionAgents = Collections.emptyList();
        double desiredSpeed = vel.length();
        if (desiredSpeed > 0.0) {
            double velLenSq;
            Util.projectAlongZEq(prevLoc.tri.plane, vel);
            if (seekCurve.wallSlider != null) {
                this.correctTravelDirForWallSlide(kb, vel, vel, seekCurve.wallSlider);
            }
            if (p.handle_collisions && !this.d_occ.isPassive) {
                potCollisionAgents = this.getPotentialAgentHits(kb, vel, desiredSpeed, dt, steer);
                if (!p.inertia) {
                    Vector3d correctedAgentSlide = new Vector3d();
                    OccAgent slideAgent = this.correctTravelDirForAgentSlide(potCollisionAgents, vel, correctedAgentSlide);
                    if (slideAgent != null) {
                        steer = steer.applyAvoidOccs(slideAgent);
                    }
                    vel.set(correctedAgentSlide);
                }
            }
            if ((velLenSq = vel.dot(vel)) > 0.0) {
                vel.scale(desiredSpeed / Math.sqrt(velLenSq));
                Util.projectAlongZEq(prevLoc.tri.plane, vel);
            }
        }
        UpdatePacket nextLoc = this.calcTravel(kb, p, dt, potCollisionAgents, vel, steer, seekCurve.transientPathFilter);
        nextLoc.orient = this.calcOrient(kb, p, dt, steer, nextLoc.vel);
        nextLoc.displayOrient = this.calcDisplayOrient(kb, p, dt, steer, nextLoc.vel, nextLoc.loc, nextLoc.orient, seekCurve);
        Pair<OccAnim, OccAnim> anims = this.calcAnim(nextLoc.loc, nextLoc.vel);
        nextLoc.anim = (OccAnim)((Object)anims.v1);
        nextLoc.vehicleAnim = (OccAnim)((Object)anims.v2);
        nextLoc.steer = steer;
        nextLoc.seek = seekCurve;
        nextLoc.targetDoor = this.getTargetDoor(true);
        nextLoc.callElevator = this.getCallElevator(kb.getElevatorModel(), kb.getMesh(), nextLoc.loc);
        nextLoc.tempElevatorRestrictions = nextLoc.loc.tri.node.getElevatorRestrictions();
        return nextLoc;
    }

    public Pair<ANode, DoorDir> getTargetDoor(boolean live) {
        if (!live) {
            return this.d_occ.targetDoor;
        }
        PathFollow pf = this.getPathFollow();
        if (pf == null) {
            return null;
        }
        IPath path = pf.getPath();
        if (path == null) {
            return null;
        }
        return path.getTargetDoor();
    }

    public boolean isSeverelyInjured() {
        return this.getAiCore() instanceof SevereInjuryAiCore;
    }

    public boolean isAwaitingAssistance() {
        return this.getAiCore() instanceof ReqAssistedByAiCore && this.getRelation(IRelation.AssistedBy.class) == null;
    }

    public boolean isControlled() {
        return this.getCurrentGoal() instanceof ControlledOccGoal;
    }

    protected Pair<OccAnim, OccAnim> calcAnim(TriPoint loc, Vector3d vel) {
        OccAnim anim = this.calcNonVehicleAnim(loc, vel);
        if (this.d_vehicle != null) {
            OccAnim occAnim = this.d_vehicle.calcOccAnim(loc, vel, () -> anim);
            return new Pair<OccAnim, OccAnim>(occAnim, anim);
        }
        return new Pair<OccAnim, OccAnim>(anim, anim);
    }

    protected OccAnim calcNonVehicleAnim(TriPoint loc, Vector3d vel) {
        double speed = vel.length();
        double terrainSpeed = loc.tri.getSpeedModifier().getTerrainSpeed();
        if ((speed = Math.max(0.0, speed - terrainSpeed)) < 0.004) {
            if (this.isAwaitingAssistance()) {
                return OccAnim.INJUREDSIT;
            }
            if (this.isSeverelyInjured()) {
                return OccAnim.INJUREDLAY;
            }
            return OccAnim.STANDIDLE;
        }
        if (Math.abs(loc.tri.actualSlope) <= FLAT_SLOPE_TOL) {
            return OccAnim.MOVEFLAT;
        }
        return vel.z >= 0.0 ? OccAnim.WALKUPSTAIRS : OccAnim.WALKDOWNSTAIRS;
    }

    private Vector3d calcOrient(KB kb, Param p, double dt, Steer steer, Vector3d newVel) {
        return this.calcOrient(kb, p, dt, this.d_occ.orient, steer.goalOrient, steer.turnVel, newVel, steer.vel, steer.collisionFilter);
    }

    private Vector3d calcOrient(KB kb, Param p, double dt, Vector3d currOrient, Vector3d goalOrient, double turnVel, Vector3d newVel, Vector3d steerVel, Predicate<OccAgent> collisionFilter) {
        if (p.inertia) {
            if (goalOrient != null && !GeomConstants.VEC3D_ZERO.equals(goalOrient)) {
                goalOrient = Util.projectAlongZ(Z_PLANE, goalOrient);
                return this.getNewOrientation(kb, currOrient, goalOrient, this.d_occ.vel, newVel, steerVel, dt, collisionFilter);
            }
            if (goalOrient == null && !Double.isNaN(turnVel)) {
                return OccAgent.getNewOrientation(currOrient, turnVel, dt);
            }
            return Util.projectAlongZ(Z_PLANE, newVel);
        }
        if (goalOrient != null && !GeomConstants.VEC3D_ZERO.equals(goalOrient)) {
            return Util.projectAlongZ(Z_PLANE, goalOrient);
        }
        if (goalOrient == null && !Double.isNaN(turnVel)) {
            return OccAgent.getNewOrientation(currOrient, turnVel, dt);
        }
        return Util.projectAlongZ(Z_PLANE, newVel);
    }

    private Vector3d calcDisplayOrient(KB kb, Param p, double dt, Steer steer, Vector3d nextVel, TriPoint nextLoc, Vector3d nextOrient, SeekCurve seekCurve) {
        if (this.getShape().getPrefersLateralAvoidance()) {
            if (seekCurve.curve != null) {
                Vector3d dorient = Util3D.vector(nextLoc.p, seekCurve.curve.get(1.0));
                Util3D.safeNormalize(dorient, 1.0E-6);
                if (dorient.lengthSquared() > 0.0) {
                    return this.calcOrient(kb, p, dt, this.d_occ.displayOrient, dorient, Double.NaN, nextVel, steer.vel, steer.collisionFilter);
                }
            }
            return this.d_occ.displayOrient;
        }
        return nextOrient;
    }

    private static Collection<ANode> getPossibleElevatorRooms(Pair<ANode, DoorDir> targetDoor) {
        ANode targetNode;
        if (targetDoor != null && (targetNode = ((ANode)targetDoor.v1).getDestNode((DoorDir)((Object)targetDoor.v2))) != null && targetNode.getElevatorLevel() != null) {
            return Collections.singleton(targetNode);
        }
        return Collections.emptySet();
    }

    private ElevatorLevel getCallElevator(ElevatorModel elevatorModel, Mesh mesh, TriPoint nextLoc) {
        Collection<ANode> elevatorRooms;
        if (this.getCurrentGoal() instanceof ControlledOccGoal) {
            elevatorRooms = elevatorModel.getAllElevatorRooms();
        } else {
            Pair<ANode, DoorDir> targetDoor = this.getTargetDoor(false);
            elevatorRooms = OccAgent.getPossibleElevatorRooms(targetDoor);
        }
        if (!elevatorRooms.isEmpty()) {
            double maxCallDist = -1.7976931348623157E308;
            for (ANode room : elevatorRooms) {
                ElevatorLevel roomElevatorLevel = room.getElevatorLevel();
                double callDist = elevatorModel.findElevator(roomElevatorLevel).getCallDistance();
                if (!(callDist > maxCallDist)) continue;
                maxCallDist = callDist;
            }
            double radOffset = maxCallDist <= 0.1 ? 0.1 : 0.0;
            Predicate<PathChange> includeEdgeFilter = o -> o.edge != null && o.edge.isDoor();
            List<Mesh.EdgeDist> nearDoors = mesh.getCloseEdges(nextLoc.tri, nextLoc.p, nextLoc.tri.node, (maxCallDist += radOffset + this.getGeometryRadius()) + this.d_occ.bodyShape.getGeomRadius(), includeEdgeFilter);
            for (Mesh.EdgeDist ed : nearDoors) {
                ANode[] nodes;
                WingedEdge edge = ed.edge;
                assert (edge.isDoor());
                for (ANode node : nodes = new ANode[]{edge.getNode1(), edge.getNode2()}) {
                    if (node == null || node.getElevatorLevel() == null || !elevatorRooms.contains(node) || !theUtil.le(Math.sqrt(ed.distSq) - this.getGeometryRadius() - radOffset, elevatorModel.findElevator(node.getElevatorLevel()).getCallDistance(), 1.0E-6)) continue;
                    return node.getElevatorLevel();
                }
            }
        }
        return null;
    }

    private void correctTravelDirForWallSlide(KB kb, Vector3d dirProposed, Vector3d outTravelDir, WallSlider wallSlider) {
        assert (outTravelDir != null);
        Vector3d slideDir = Util.getSlideDir(this, dirProposed, wallSlider, false, false);
        kb.getProps().setDbg(this.d_occ, "geom_collide", Boolean.valueOf(slideDir != null));
        if (slideDir == null) {
            outTravelDir.set(dirProposed);
        } else {
            outTravelDir.set(slideDir);
        }
    }

    private OccAgent correctTravelDirForAgentSlide(List<OccAgent> potCollisionAgents, Vector3d dirProposed, Vector3d outTravelDir) {
        outTravelDir.set(dirProposed);
        if (potCollisionAgents.isEmpty()) {
            return null;
        }
        Point2d xyLoc = new Point2d(this.d_occ.loc.x, this.d_occ.loc.y);
        Vector2d xyTravelDir = new Vector2d(dirProposed.x, dirProposed.y);
        double occHeight = this.d_occ.bodyShape.getHeight();
        double biggestDot = 0.0;
        OccAgent occ = null;
        for (OccAgent oa : potCollisionAgents) {
            Occupant o = oa.getOcc();
            Point3d oLoc = o.loc;
            Point2d oXYLoc = new Point2d(oLoc.x, oLoc.y);
            if (!(this.d_occ.loc.z + occHeight >= oLoc.z) || !(this.d_occ.loc.z <= oLoc.z + o.bodyShape.getHeight()) || !theUtil.le(xyLoc.distance(oXYLoc), this.getCollisionShape().getEnclosingRadius() + oa.getCollisionShape().getEnclosingRadius(), 0.01)) continue;
            Vector2d vec = Util2D.vector(xyLoc, oXYLoc);
            vec.normalize();
            double dot = xyTravelDir.dot(vec);
            if (!(dot >= biggestDot)) continue;
            biggestDot = dot;
            occ = oa;
        }
        if (occ != null) {
            Point3d occLoc = occ.getOcc().loc;
            Vector3d newDir = new Vector3d(this.d_occ.loc.y - occLoc.y, occLoc.x - this.d_occ.loc.x, 0.0);
            newDir.normalize();
            dirProposed = Util3D.normalize(dirProposed);
            double dot = dirProposed.dot(newDir);
            double scale = theUtil.eq0(dot, 0.17) ? 0.0 : dot;
            newDir.scale(scale);
            outTravelDir.set(newDir);
            return occ;
        }
        return null;
    }

    private List<OccAgent> getPotentialAgentHits(KB kb, Vector3d dirProposed, double maxVelMag, double dt, Steer steer) {
        double xyDistSq = dirProposed.x * dirProposed.x + dirProposed.y * dirProposed.y;
        if (theUtil.eq0(xyDistSq, 1.0E-6)) {
            return Collections.emptyList();
        }
        double travelRad = (maxVelMag + kb.getMaxInUseVel()) * dt + this.getCollisionShape().getEnclosingRadius();
        List<OccAgent> potCollisionAgents = kb.findOccs(OccLocator.testCyl(this, travelRad, new thunderheadeng.geometry.Plane3d[0]), OccLocator.exclude(this, steer.collisionFilter), false);
        if (!kb.getParams().reactive_steering) {
            IGoal currGoal = this.getCurrentGoal();
            if (currGoal instanceof WaitUntilInsideGoal) {
                potCollisionAgents.clear();
            } else {
                for (int m = potCollisionAgents.size() - 1; m >= 0; --m) {
                    OccAgent other = potCollisionAgents.get(m);
                    if (this.isCollidable(other, currGoal)) continue;
                    potCollisionAgents.remove(m);
                }
            }
        }
        return potCollisionAgents;
    }

    private boolean isCollidable(OccAgent occ2, IGoal currGoal) {
        Vector3d dir2;
        if (!occ2.getCurrentGoal().equals(currGoal)) {
            return false;
        }
        if (currGoal instanceof IIdleGoal) {
            return true;
        }
        Vector3d dir1 = Util3D.normalize(this.getSeekCurve().getTangent(0.0));
        return dir1.dot(dir2 = Util3D.normalize(occ2.getSeekCurve().getTangent(0.0))) >= 0.0;
    }

    public IAgentBodyShape getShape() {
        return this.d_occ.bodyShape;
    }

    public IAgentBodyShape getCollisionShape() {
        return this.d_occ.bodyShape.adjust(this.d_occ.getCollisionFactor());
    }

    public IAgentBodyShape getCollisionShape(double sizeFactor) {
        return this.d_occ.bodyShape.adjust(sizeFactor);
    }

    private static double getEarliestPossibleHitTime(Point3d thisPos, double thisEnclosingRadius, double thisSpeed, OccAgent other, double otherEnclosingRadius, double otherSpeed) {
        double dist2d = Util.dist2d(thisPos, other.getPos());
        double gap2d = dist2d - thisEnclosingRadius - otherEnclosingRadius;
        return gap2d / (thisSpeed + otherSpeed);
    }

    public Pair<OccAgent, Double> detectOccCollision(KB kb, Collection<OccAgent> sortedCollAgents, Function<OccAgent, IAgentBodyShape> getOtherShape, Function<OccAgent, Vector3d> getOtherVel, IAgentBodyShape shape, Point3d pos, Vector3d vel, double mint, double maxt, boolean onlyIfVisible) {
        OccAgent occHit = null;
        double nearestHitT = Double.MAX_VALUE;
        double speed1 = vel.length();
        double eradius1 = shape.getEnclosingRadius();
        for (OccAgent collAgent : sortedCollAgents) {
            if (collAgent == this) continue;
            IAgentBodyShape shape2 = getOtherShape.apply(collAgent);
            Vector3d vel2 = getOtherVel.apply(collAgent);
            double speed2 = vel2.length();
            double t2 = OccAgent.getEarliestPossibleHitTime(shape.getCenter(), eradius1, speed1, collAgent, shape2.getEnclosingRadius(), speed2);
            if (t2 > nearestHitT) break;
            double collt = Inter.getOccCollision(shape, vel, shape2, vel2, 1.0E-6);
            if (Double.isInfinite(collt) || collt >= maxt - mint || collt >= nearestHitT || onlyIfVisible && !this.isVisible(kb, collAgent)) continue;
            occHit = collAgent;
            nearestHitT = Math.max(0.0, collt);
        }
        double hitTime = nearestHitT < Double.MAX_VALUE ? nearestHitT + mint : nearestHitT;
        return new Pair<Object, Double>(occHit, hitTime);
    }

    public List<OccAgent> sortPotentialCollisionAgents(Function<OccAgent, IAgentBodyShape> getAgentShape, ToDoubleFunction<OccAgent> getSpeed, IAgentBodyShape thisShape, double thisSpeed, Collection<OccAgent> agents) {
        List<OccAgent> sourceList = agents instanceof RandomAccess && agents instanceof List ? (List)agents : new ArrayList<OccAgent>(agents);
        Point3d thisLoc = thisShape.getCenter();
        double eradius = thisShape.getEnclosingRadius();
        Function<OccAgent, Double> getMinHitTime = a -> OccAgent.getEarliestPossibleHitTime(thisLoc, eradius, thisSpeed, a, ((IAgentBodyShape)getAgentShape.apply((OccAgent)a)).getEnclosingRadius(), getSpeed.applyAsDouble((OccAgent)a));
        double[] times = new double[sourceList.size()];
        for (int m = 0; m < sourceList.size(); ++m) {
            times[m] = getMinHitTime.apply(sourceList.get(m));
        }
        return IntStream.range(0, sourceList.size()).boxed().sorted((a1, a2) -> Double.compare(times[a1], times[a2])).map(i -> (OccAgent)sourceList.get((int)i)).collect(Collectors.toList());
    }

    public Pair<OccAgent, Double> getOccCollision(KB kb, double maxt, Function<OccAgent, IAgentBodyShape> getOtherShape, Function<OccAgent, Vector3d> getOtherVel, ToDoubleFunction<OccAgent> getOtherSpeed, Function<Point3d, IAgentBodyShape> shape, Vector3d vel, Point3d loc, List<Mesh.EdgeCrossing> crossedEdges, Collection<OccAgent> collAgents, boolean collAgentsSorted, boolean onlyIfVisible) {
        return this.getOccCollision(kb, maxt, getOtherShape, getOtherVel, getOtherSpeed, shape, vel, loc, crossedEdges, collAgents, Predicates.alwaysTrue(), collAgentsSorted, onlyIfVisible);
    }

    public Pair<OccAgent, Double> getOccCollision(KB kb, double maxt, Function<OccAgent, IAgentBodyShape> getOtherShape, Function<OccAgent, Vector3d> getOtherVel, ToDoubleFunction<OccAgent> getOtherSpeed, Function<Point3d, IAgentBodyShape> shape, Vector3d vel, Point3d loc, List<Mesh.EdgeCrossing> crossedEdges, Collection<OccAgent> collAgents, Predicate<OccAgent> isAgentVis, boolean collAgentsSorted, boolean onlyIfVisible) {
        Pair<Object, Double> firstOccHit = new Pair<Object, Double>(null, maxt);
        if (collAgents.isEmpty()) {
            return firstOccHit;
        }
        Collection<OccAgent> sortedCollAgents = collAgents;
        if (!collAgentsSorted) {
            sortedCollAgents = this.sortPotentialCollisionAgents(getOtherShape, getOtherSpeed, shape.apply(loc), vel.length(), collAgents);
        }
        sortedCollAgents = !Predicates.alwaysTrue(isAgentVis) ? theUtil.filter(sortedCollAgents, isAgentVis) : sortedCollAgents;
        Vector3d prevVel = vel;
        Vector3d lastDirN = new Vector3d(prevVel);
        double lastDirLen = Util3D.safeNormalize(lastDirN, 1.0E-9);
        double prevt = 0.0;
        Point3d prevp = loc;
        for (int m = 0; m < crossedEdges.size(); ++m) {
            Mesh.EdgeCrossing cross = crossedEdges.get(m);
            Vector3d dirn = new Vector3d(cross.tangentVel);
            double dirLen = Util3D.safeNormalize(dirn, 1.0E-9);
            if (lastDirN.epsilonEquals(dirn, 1.0E-6)) continue;
            if (lastDirLen > 0.0) {
                Pair<OccAgent, Double> occHit = this.detectOccCollision(kb, sortedCollAgents, getOtherShape, getOtherVel, shape.apply(prevp), prevp, prevVel, prevt, cross.t, onlyIfVisible);
                if ((Double)occHit.v2 < (Double)firstOccHit.v2) {
                    firstOccHit = occHit;
                    prevt = (Double)firstOccHit.v2;
                    break;
                }
            }
            prevp = cross.enterLoc.p;
            prevt = cross.t;
            prevVel = cross.tangentVel;
            lastDirN = dirn;
            lastDirLen = dirLen;
        }
        if (prevt < (Double)firstOccHit.v2) {
            Pair<OccAgent, Double> occHit = this.detectOccCollision(kb, sortedCollAgents, getOtherShape, getOtherVel, shape.apply(prevp), prevp, prevVel, prevt, (Double)firstOccHit.v2, onlyIfVisible);
            if ((Double)occHit.v2 < (Double)firstOccHit.v2) {
                firstOccHit = occHit;
            }
        }
        return firstOccHit;
    }

    public Predicate<PathChange> generatePathFilter(KB kb, Predicate<Tri> triFilter, Predicate<WingedEdge> edgeFilter, PathFilterType type) {
        edgeFilter = this.getEdgeFilter(kb, edgeFilter, type);
        triFilter = this.getTriFilter(kb, triFilter, type);
        Predicate<PathChange> edgePF = PathFilters.filterEdges(edgeFilter);
        if (this.d_occ.obeyOnewayDoors) {
            edgePF = Predicates.and(edgePF, PathFilters.rejectInvalidOnewayCrossings());
        }
        switch (type) {
            case POINT_TO_POINT: 
            case LOCAL: 
            case TRANSIENT: {
                edgePF = Predicates.or(edgePF, this.getCorrectionFilter(edgeFilter));
                break;
            }
        }
        Predicate<PathChange> triPF = PathFilters.filterTriangles(true, triFilter);
        Predicate<PathChange> pathFilter = Predicates.and(edgePF, triPF);
        return pathFilter;
    }

    private Predicate<WingedEdge> getEdgeFilter(KB kb, Predicate<WingedEdge> edgeFilter, PathFilterType type) {
        switch (type) {
            case POINT_TO_POINT: 
            case LOCAL: 
            case DOOR_TO_GOAL: {
                edgeFilter = Predicates.and(edgeFilter, EdgeFilters.rejectPermanentlyClosedDoors());
                IFormationLeaderAgent formationLeader = this.getOcc().formationLeader;
                if (formationLeader != null) {
                    edgeFilter = Predicates.or(edgeFilter, new EdgeFilters.AcceptPartiallyTraversedDoors(formationLeader));
                }
                edgeFilter = Predicates.and(edgeFilter, this.getOcc().getRestrictedDoorsFilter());
                return edgeFilter;
            }
            case TRANSIENT: {
                if (this.getCurrentGoal() instanceof ExitGoal) {
                    ExitGoal eg = (ExitGoal)this.getCurrentGoal();
                    if (eg.exits != null) {
                        edgeFilter = Predicates.and(edgeFilter, EdgeFilters.filterExits(Filters.accept(eg.exits)));
                    }
                } else if (!(this.getCurrentGoal() instanceof ControlledOccGoal)) {
                    edgeFilter = Predicates.and(edgeFilter, EdgeFilters.rejectAllExits());
                }
                edgeFilter = Predicates.and(edgeFilter, EdgeFilters.rejectAllClosedDoors());
                IFormationLeaderAgent formationLeader = this.getOcc().formationLeader;
                if (formationLeader != null) {
                    edgeFilter = Predicates.or(edgeFilter, new EdgeFilters.AcceptPartiallyTraversedDoors(formationLeader));
                }
                edgeFilter = Predicates.and(edgeFilter, this.getOcc().getRestrictedDoorsFilter());
                return edgeFilter;
            }
        }
        return edgeFilter;
    }

    private Predicate<Tri> getTriFilter(KB kb, Predicate<Tri> triFilter, PathFilterType type) {
        OccProfileSim.CompRestrictions componentRestrictions;
        OccProfileSim.CompRestrictions compRestrictions = componentRestrictions = this.getOcc().occupantGroup != null ? this.getOcc().occupantGroup.componentRestrictions : this.getOcc().compRestrictions;
        if (componentRestrictions != null) {
            triFilter = Predicates.and(triFilter, componentRestrictions.getRestrictedCompsFilter(this.getCurrentGoal()));
        }
        return triFilter;
    }

    private Predicate<PathChange> getCorrectionFilter(Predicate<WingedEdge> edgeFilter) {
        Predicate<PathChange> filter = PathFilters.acceptNodeCorrections(this.d_occ.curNode);
        for (int m = 0; m < 3; ++m) {
            WingedEdge edge = this.d_occ.tri.eu[m].wedge;
            if (edge.isBoundary() || edgeFilter.test(edge) || edge.getNode1() != edge.getNode2()) continue;
            DoorDir dir = edge.getDir(this.d_occ.tri);
            filter = Predicates.or(filter, PathFilters.acceptDoorDir(edge, dir));
        }
        return filter;
    }

    public Mesh.EdgeCrossing getCrossedEdges(Mesh mesh, TriPoint loc, Vector3d vel, Predicate<PathChange> pathFilter, double maxt) throws Mesh.CrossedEdgesException {
        Mesh.EdgeCrossing crossings = mesh.getCrossedEdges(loc.tri, loc.p, vel, pathFilter, maxt);
        if (this.d_occ.curNode != loc.tri.node && vel.lengthSquared() > 0.0) {
            WingedEdge crossEdge = this.getEdge(loc);
            if (crossEdge == null) {
                LOGGER.log(Level.WARNING, String.format("[OccAgent.getCrossedEdges] failed to find current edge: occ=%s, curNode=%s, tri.node=%s, loc=%s%n", this.d_occ.name, this.d_occ.curNode.name, loc.tri.node.name, loc));
                return crossings;
            }
            Mesh.EdgeCrossing firstCrossing = crossings;
            if (firstCrossing != null) {
                while (firstCrossing.parent != null) {
                    firstCrossing = firstCrossing.parent;
                }
                if (firstCrossing.enterLoc.tri == crossEdge.t1 || firstCrossing.enterLoc.tri == crossEdge.t2) {
                    return crossings;
                }
            }
            if (crossEdge.getDir(vel) != crossEdge.getDir(this.d_occ.curNode)) {
                if (!pathFilter.test(new PathChange(loc.tri, crossEdge))) {
                    crossings = new Mesh.EdgeCrossing(null, crossEdge, loc.p, loc.tri, loc.p, new Vector3d(vel), 0.0, Mesh.EdgeCrossing.Type.BOUNDARY);
                } else {
                    Point3d dest = Util3D.linePoint(loc.p, vel, maxt);
                    Mesh.EdgeCrossing newFirst = new Mesh.EdgeCrossing(null, crossEdge, loc.p, loc.tri, dest, new Vector3d(vel), 0.0, Mesh.EdgeCrossing.Type.CROSS);
                    if (firstCrossing != null) {
                        firstCrossing.parent = newFirst;
                    } else {
                        crossings = newFirst;
                    }
                }
                crossings.finalizeCrossings();
            }
        }
        return crossings;
    }

    private WingedEdge getEdge(TriPoint loc) {
        int ecount = 0;
        WingedEdge edge = null;
        for (int m = 0; m < 3; ++m) {
            WingedEdge tedge = loc.tri.eu[m].wedge;
            ANode adjNode = tedge.getAdjNode(loc.tri.node);
            if (adjNode != this.d_occ.curNode) continue;
            ++ecount;
            edge = tedge;
        }
        if (ecount == 1) {
            assert (edge.whichSide(loc.p, 1.0E-6) == 0.0);
            return edge;
        }
        if (ecount == 0) {
            return null;
        }
        WingedEdge closestEdge = null;
        double closestDistSq = 1.0E-9;
        for (int m = 0; m < 3; ++m) {
            double distsq;
            WingedEdge tedge = loc.tri.eu[m].wedge;
            ANode adjNode = tedge.getAdjNode(loc.tri.node);
            if (adjNode != this.d_occ.curNode || !((distsq = Inter3D.distSqToNearestPtOnLineSeg(tedge.p1(), tedge.p2(), loc.p)) < closestDistSq)) continue;
            closestDistSq = distsq;
            closestEdge = tedge;
        }
        return closestEdge;
    }

    private static double getCollisionRadius(Mesh mesh, Occupant occ, boolean tightGeometry) {
        double meshRadius = mesh.getCachedRadius(tightGeometry ? occ.bodyShape.getGeomRadius() : occ.bodyShape.getOccRadius());
        return meshRadius + 1.0E-6;
    }

    public IAgentBodyShape getGeomCollisionShape(KB kb, boolean safeShape, boolean tightGeometry) {
        return this.getGeomCollisionShape(kb, this.getPos(), safeShape, tightGeometry);
    }

    public IAgentBodyShape getGeomCollisionShape(KB kb, Point3d loc, boolean safeShape, boolean tightGeometry) {
        return OccAgent.getGeomCollisionShape(this.getOcc(), kb, loc, safeShape, tightGeometry);
    }

    public static IAgentBodyShape getGeomCollisionShape(Occupant occ, KB kb, Point3d loc, boolean safeShape, boolean tightGeometry) {
        IAgentBodyShape shape = occ.bodyShape;
        if (shape instanceof CylinderShape || safeShape || !kb.getParams().reactive_steering) {
            double collisionRadius = OccAgent.getCollisionRadius(kb.getMesh(), occ, tightGeometry);
            return new CylinderShape(loc, collisionRadius, collisionRadius, shape.getHeight(), shape.getDir(), occ.id);
        }
        return shape.moveTo(loc);
    }

    public boolean hasTightGeomRepresentation() {
        return this.getOccupantRadius() != this.getGeometryRadius();
    }

    private EdgeCrossings getEdgeCrossings(KB kb, Param p, double dt, Collection<OccAgent> collAgents, Vector3d vel, Predicate<PathChange> transientPathFilter, Steer steer) {
        if (vel.dot(vel) <= 1.0E-12) {
            return new EdgeCrossings(Collections.emptyList(), 0.0, null);
        }
        try {
            boolean freePass;
            double maxt = dt;
            List<Object> crossedEdges = Collections.emptyList();
            Mesh meshGeom = kb.getMesh();
            TriPoint prevLoc = this.getLoc();
            Predicate<PathChange> pathFilter = transientPathFilter;
            double crossingsMaxt = maxt;
            Mesh.EdgeCrossing crossings = this.getCrossedEdges(meshGeom, prevLoc, vel, pathFilter, maxt);
            if (crossings != null && crossings.type.terminal) {
                crossingsMaxt = maxt = crossings.t;
            }
            IAgentBodyShape shape = this.getGeomCollisionShape(kb, prevLoc.p, false, steer.tightGeometry);
            Mesh.EdgeCrossing boundaryCrossing = meshGeom.getBoundaryHit(prevLoc.tri, prevLoc.p, vel, pathFilter, maxt, shape);
            boolean bl = freePass = this.d_vehicle != null && this.d_vehicle.getFreePass() && boundaryCrossing != null && boundaryCrossing.t <= 1.0E-6;
            if (freePass) {
                IAgentBodyShape safeShape = this.getGeomCollisionShape(kb, prevLoc.p, true, steer.tightGeometry);
                boundaryCrossing = meshGeom.getBoundaryHit(prevLoc.tri, prevLoc.p, vel, pathFilter, maxt, safeShape);
            }
            if (boundaryCrossing != null) {
                assert (boundaryCrossing.t < maxt || boundaryCrossing.t == 0.0 && maxt == 0.0);
                maxt = boundaryCrossing.t;
                if (theUtil.eq0(maxt, 1.0E-6)) {
                    return new EdgeCrossings(Collections.emptyList(), 0.0, null);
                }
                while (crossings != null && crossings.t >= maxt) {
                    crossings = crossings.parent;
                }
            }
            if (crossings != null) {
                crossedEdges = crossings.flatten();
            }
            double collFactor = this.getCollisionFactor(steer.squeezeFactor);
            Pair<OccAgent, Double> occMaxt = this.getOccCollision(kb, maxt, OccAgent::getCollisionShape, a -> GeomConstants.VEC3D_ZERO, a -> 0.0, tp -> this.d_occ.bodyShape.adjust((Point3d)tp, collFactor), vel, prevLoc.p, crossedEdges, collAgents, false, COLLIDE_ONLY_IF_VISIBLE);
            boolean bl2 = freePass = this.d_vehicle != null && this.d_vehicle.getFreePass() && occMaxt != null && (Double)occMaxt.v2 <= 1.0E-6;
            if ((Double)occMaxt.v2 < maxt && !freePass && theUtil.eq0(maxt = ((Double)occMaxt.v2).doubleValue(), 1.0E-6)) {
                return new EdgeCrossings(Collections.emptyList(), 0.0, (OccAgent)occMaxt.v1);
            }
            if (maxt < crossingsMaxt) {
                crossings = this.getCrossedEdges(meshGeom, prevLoc, vel, pathFilter, maxt);
                if (crossings != null) {
                    if (crossings.type.terminal) {
                        maxt = crossings.t;
                    }
                    crossedEdges = crossings.flatten();
                } else {
                    crossedEdges = Collections.emptyList();
                }
            }
            if (!crossedEdges.isEmpty() && crossedEdges.get((int)(crossedEdges.size() - 1)).type == Mesh.EdgeCrossing.Type.BOUNDARY) {
                return new EdgeCrossings(Collections.emptyList(), 0.0, null);
            }
            return new EdgeCrossings(crossedEdges, maxt, (OccAgent)occMaxt.v1);
        }
        catch (Mesh.CrossedEdgesException e) {
            assert (false) : String.format("Agent `%s` had a problem with edge crossing.", this.getOcc().name);
            e.printStackTrace();
            return new EdgeCrossings(Collections.emptyList(), 0.0, null);
        }
    }

    private UpdatePacket calcTravel(KB kb, Param p, double dt, Collection<OccAgent> collAgents, Vector3d vel, Steer steer, Predicate<PathChange> transientPathFilter) {
        boolean polygonFreePass;
        UpdatePacket nextLoc = new UpdatePacket(this.d_occ);
        EdgeCrossings crossings = this.getEdgeCrossings(kb, p, dt, collAgents, vel, transientPathFilter, steer);
        List<Mesh.EdgeCrossing> crossedEdges = crossings.crossings;
        double maxt = crossings.maxt;
        boolean bl = polygonFreePass = this.d_vehicle != null ? this.d_vehicle.getFreePass() : false;
        if (!p.inertia && this.d_vehicle != null) {
            polygonFreePass = true;
        }
        if ((maxt == 0.0 || this.d_occ.bodyShape instanceof PolygonShape && maxt < dt) && !polygonFreePass) {
            vel = Util3D.scale(vel, 0.0);
        }
        nextLoc.occHit = crossings.occHit;
        PathFollow pathFollow = this.getPathFollow();
        nextLoc.pfStatus = pathFollow != null ? pathFollow.getStatus(kb, this) : IDLING_STATUS;
        this.calcTravel(kb, p, dt, collAgents, vel, maxt, crossedEdges, nextLoc);
        return nextLoc;
    }

    private UpdatePacket calcTravel(KB kb, Param p, double dt, Collection<OccAgent> collAgents, Vector3d vel, double maxt, List<Mesh.EdgeCrossing> crossedEdges, UpdatePacket nextLoc) {
        Vector3d prevVel;
        TriPoint prevLoc;
        Mesh.EdgeCrossing crossing;
        DoorDir reenterDir = this.getReenterDir(kb, vel, maxt, crossedEdges, this.d_occ.doorQueue);
        if (reenterDir != null) {
            nextLoc.reenterDir = reenterDir;
            nextLoc.vel = new Vector3d(0.0, 0.0, 0.0);
            return nextLoc;
        }
        Mesh.EdgeCrossing newQueueCross = null;
        Mesh.EdgeCrossing cross = null;
        DoorQueue currQueue = this.d_occ.doorQueue != null ? (DoorQueue)this.d_occ.doorQueue.v1 : null;
        ArrayList<Mesh.EdgeCrossing> crossedDoors = new ArrayList<Mesh.EdgeCrossing>(crossedEdges.size());
        for (int m = 0; m < crossedEdges.size(); ++m) {
            cross = crossedEdges.get(m);
            if (!this.getRecordAsDoorEdge(kb, cross.edge, currQueue)) continue;
            if (newQueueCross != null && theUtil.gt(cross.t, newQueueCross.t, 1.0E-9)) break;
            crossedDoors.add(cross);
            DoorDir crossDir = cross.edge.getExitDir(cross.enterLoc.tri);
            if (this.isQueueableDoor(kb, cross.edge, crossDir, cross.enterLoc.tri)) {
                newQueueCross = cross;
            }
            if (cross.edge.isExit()) break;
        }
        Iterator m = crossedDoors.iterator();
        while (m.hasNext() && (crossing = (Mesh.EdgeCrossing)m.next()) != newQueueCross) {
            nextLoc.crossedDoors.add(new Pair<ANode, DoorDir>(crossing.edge.data.node, crossing.edge.getExitDir(crossing.enterLoc.tri)));
        }
        if (newQueueCross != null) {
            nextLoc.queueDoor = new Pair<ANode, DoorDir>(newQueueCross.edge.data.node, newQueueCross.edge.getExitDir(newQueueCross.enterLoc.tri));
            maxt = newQueueCross.t;
            prevLoc = this.adjustQueueLoc(newQueueCross, kb.getMesh().getShortenedEdge(this.getGeometryRadius(), newQueueCross.edge));
            prevVel = newQueueCross.tangentVel.lengthSquared() == 0.0 ? vel : newQueueCross.tangentVel;
        } else if (crossedEdges.isEmpty()) {
            prevLoc = new TriPoint(this.d_occ.tri, Util3D.linePoint(this.d_occ.loc, vel, maxt));
            prevVel = vel;
        } else {
            Mesh.EdgeCrossing lastCross = crossedEdges.get(crossedEdges.size() - 1);
            if (lastCross.edge.isExit()) {
                maxt = lastCross.t;
                prevLoc = this.adjustQueueLoc(lastCross, kb.getMesh().getShortenedEdge(this.getGeometryRadius(), lastCross.edge));
                prevVel = lastCross.tangentVel;
            } else {
                prevLoc = new TriPoint(lastCross.enterLoc.tri, lastCross.destPt);
                prevVel = lastCross.tangentVel;
            }
        }
        double distTravelled = vel.length() * maxt;
        this.calcLoc(kb, prevLoc, prevVel, distTravelled, dt, nextLoc);
        return nextLoc;
    }

    private TriPoint adjustQueueLoc(Mesh.EdgeCrossing doorCross, SplitEdge splitEdge) {
        Tri flatTri;
        boolean triGood2;
        boolean triGood1 = doorCross.edge.t1 != null && !theUtil.eq0(doorCross.edge.t1.normal.z, 1.0E-9);
        boolean bl = triGood2 = doorCross.edge.t2 != null && !theUtil.eq0(doorCross.edge.t2.normal.z, 1.0E-9);
        if (triGood1 && triGood2) {
            Tri finalTri = doorCross.edge.triForPt(doorCross.enterLoc.p);
            if (finalTri.containsExact(doorCross.enterLoc.p)) {
                return new TriPoint(finalTri, doorCross.enterLoc.p);
            }
            flatTri = doorCross.edge.t1.normal.z > doorCross.edge.t2.normal.z ? doorCross.edge.t1 : doorCross.edge.t2;
        } else {
            if (!triGood1 && !triGood2) {
                LOGGER.log(Level.WARNING, String.format("[0x22f9] Trying to queue at a door between two bad triangles: " + this.d_occ.name, new Object[0]));
                LOGGER.log(Level.WARNING, String.format("[0x22f9] T1=%s, T2=%s", doorCross.edge.t1, doorCross.edge.t2));
                return doorCross.enterLoc;
            }
            Tri tri = flatTri = triGood1 ? doorCross.edge.t1 : doorCross.edge.t2;
        }
        WingedEdgeUse eu = doorCross.edge == flatTri.eu[0].wedge ? flatTri.eu[0] : (doorCross.edge == flatTri.eu[1].wedge ? flatTri.eu[1] : flatTri.eu[2]);
        Vector3d edgeDir = eu.edgeDir();
        Vector3d shiftVel = new Vector3d(edgeDir.y, -edgeDir.x, 0.0);
        double travelSide = eu.wedge.whichSide(shiftVel, 1.0E-9);
        boolean travellingInto = travelSide != 0.0 && eu.wedge.getTri(travelSide) == flatTri;
        double travelMult = travellingInto ? 1.0E-9 : -1.0E-9;
        Point3d startPoint = splitEdge != null ? splitEdge.findClosest(doorCross.enterLoc.p) : Inter3D.nearestPointOnLineSeg(doorCross.edge.p1(), doorCross.edge.p2(), doorCross.enterLoc.p);
        for (double m = 1.0; m < 5.0; m += 1.0) {
            double t = travelMult * m;
            Point3d newLoc = Util3D.linePoint(startPoint, shiftVel, t);
            if (!flatTri.containsExact(newLoc)) continue;
            return new TriPoint(flatTri, newLoc);
        }
        LOGGER.log(Level.WARNING, String.format("[0x92384] Could not find a valid triangle location for occ: " + this.d_occ.name, new Object[0]));
        return doorCross.enterLoc;
    }

    private DoorDir getReenterDir(KB kb, Vector3d vel, double maxt, List<Mesh.EdgeCrossing> crossedEdges, Pair<DoorQueue, DoorDir> exitedDoorQueue) {
        boolean wantsToStay;
        if (exitedDoorQueue == null || ((DoorQueue)exitedDoorQueue.v1).getR1() == ((DoorQueue)exitedDoorQueue.v1).getR2()) {
            return null;
        }
        if (this.getOcc().formationLeader != null && this.getOcc().formationLeader.isFreePassDoor((DoorQueue)exitedDoorQueue.v1)) {
            return null;
        }
        boolean shouldStay = this.d_occ.prevNode == this.d_occ.curNode;
        if (shouldStay == (wantsToStay = this.stayingInNode(vel, maxt, crossedEdges, (DoorQueue)exitedDoorQueue.v1))) {
            return null;
        }
        if (shouldStay) {
            return (DoorDir)((Object)exitedDoorQueue.v2);
        }
        return ((DoorDir)((Object)exitedDoorQueue.v2)).opposite();
    }

    private boolean stayingInNode(Vector3d vel, double maxt, List<Mesh.EdgeCrossing> crossedEdges, DoorQueue exitedDoorQueue) {
        assert (exitedDoorQueue != null);
        if (!crossedEdges.isEmpty()) {
            Mesh.EdgeCrossing firstCross = crossedEdges.get(0);
            if (firstCross.edge.isDoor() && firstCross.edge.data.node.doorQueue == exitedDoorQueue && firstCross.t <= maxt) {
                return firstCross.enterLoc.tri.node == this.d_occ.prevNode;
            }
        }
        return vel.lengthSquared() > 0.0 && this.d_occ.tri.node == this.d_occ.prevNode;
    }

    private void calcLoc(KB kb, TriPoint newLoc, Vector3d newVel, double distTravelled, double dt, UpdatePacket nextLoc) {
        AssistedEvacClientAgent client;
        int spot;
        double velMagDt = newVel.length() * dt;
        double distTol = Math.min(velMagDt * 0.01, 1.0E-4);
        nextLoc.locModified = this.d_occ.tri != newLoc.tri || !this.d_occ.loc.epsilonEquals(newLoc.p, distTol);
        nextLoc.loc = newLoc;
        nextLoc.displayLoc = newLoc;
        if (this.d_occ.formationLeader instanceof AssistedEvacClientAgent && this.d_occ.formationLeader.getOccAgent().getShape().getPrefersLateralAvoidance() && (spot = (client = (AssistedEvacClientAgent)this.d_occ.formationLeader).getAttachedSpot(this)) != -1) {
            OccAgent cagent = client.getOccAgent();
            nextLoc.displayLoc = client.getDesiredHelperPosition(kb, cagent.getPos(), cagent.getOcc().displayOrient, spot, this, this.d_occ.displayLoc, Predicates.alwaysTrue());
        }
        if (velMagDt == 0.0) {
            nextLoc.vel = new Vector3d(0.0, 0.0, 0.0);
        } else {
            nextLoc.vel = new Vector3d(newVel);
            nextLoc.vel.scale(distTravelled / velMagDt);
        }
    }

    private boolean getNodesConsistent() {
        if (this.d_occ.curNode == null) {
            return true;
        }
        Tri.PointTest inTri = this.d_occ.tri.test(this.d_occ.loc, 1.0E-6);
        if (inTri == Tri.PointTest.INSIDE && this.d_occ.tri.node != this.d_occ.curNode) {
            LOGGER.log(Level.WARNING, String.format("[OccAgent.checkNodeConsistency] failed: occ=%s, tri.node=%s, curNode=%s; loc=%s%n", this.d_occ.name, this.d_occ.tri.node.name, this.d_occ.curNode, this.getLoc()));
        }
        return true;
    }

    public double getMaxRotationalSpeed(KB kb) {
        if (!this.d_occ.canMove) {
            return 0.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    private Vector3d getNewOrientation(KB kb, Vector3d orient0, Vector3d goalOrient, Vector3d vel0, Vector3d vel1, Vector3d goalVel, double dt, Predicate<OccAgent> collisionFilter) {
        OccAgent agent = this;
        if (goalOrient.lengthSquared() > 0.0) {
            double angle;
            Vector3d dir1;
            double speed1;
            double maxSpeed = this.getMaxRotationalSpeed(kb);
            if (maxSpeed == 0.0) {
                return orient0;
            }
            goalOrient = new Vector3d(goalOrient);
            goalOrient.normalize();
            if (orient0.epsilonEquals(goalOrient, 0.001)) {
                return goalOrient;
            }
            Vector3d goalDir = new Vector3d(goalVel);
            Util.safeNormalize(goalDir, 1.0E-6);
            boolean orientForward = goalOrient.epsilonEquals(goalDir, 1.0E-6);
            Vector3d orientDir = goalOrient;
            if (orientForward && (speed1 = Util.safeNormalize(dir1 = new Vector3d(vel1), 1.0E-6)) > 0.0) {
                orientDir = dir1;
            }
            double maxVel = OccAgent.getMaxVel(kb, this.d_occ, orient0);
            double physicalTurnaroundTime = OccAgent.calcStopTime(maxVel, agent.getMaxStopAccel(kb)) + OccAgent.calcSpeedupTime(0.0, maxVel, agent.getMaxStartAccel(kb));
            double minTurnaroundTime = this.d_occ.bodyShape.getMinTurnaroundTime();
            double turnaroundTime = Math.min(physicalTurnaroundTime, minTurnaroundTime);
            double turningRate = Math.PI / turnaroundTime;
            turningRate = Math.min(turningRate, maxSpeed);
            Vector3d turnAxis = Util3D.cross(orient0, goalOrient);
            if (turnAxis.lengthSquared() == 0.0) {
                turnAxis = GeomConstants.VEC3D_ZPOS;
            }
            if ((angle = Util3D.angle(orient0, orientDir, turnAxis)) < 0.0) {
                angle = Math.PI * 2 + angle;
            }
            double dir = Math.signum(turnAxis.dot(GeomConstants.VEC3D_ZPOS));
            double rot = dir * Math.min(angle, turningRate * dt);
            if (this.d_vehicle != null) {
                Vector3d test = OccAgent.rotateZ(orient0, rot);
                if (this.d_vehicle.getFreePass()) {
                    return test;
                }
                PolygonShape shape = (PolygonShape)this.d_occ.bodyShape;
                PolygonShape newShape = shape.translateToAndRotate(shape.getCenter(), rot);
                if (newShape.testCollisionAll(kb, 0.0, collisionFilter, this)) {
                    return orient0;
                }
                return test;
            }
            return OccAgent.rotateZ(orient0, rot);
        }
        return orient0;
    }

    private static Vector3d getNewOrientation(Vector3d oldOrient, double turnVel, double dt) {
        if (theUtil.eq0(turnVel, 1.0E-6)) {
            return new Vector3d(oldOrient);
        }
        double angle = turnVel * dt;
        return OccAgent.rotateZ(oldOrient, angle);
    }

    private static Vector3d rotateZ(Vector3d oldOrient, double angle) {
        Matrix3d ROT = new Matrix3d();
        ROT.rotZ(angle);
        Vector3d newOrient = new Vector3d(oldOrient);
        ROT.transform(newOrient);
        return newOrient;
    }

    private boolean getRecordAsDoorEdge(KB kb, WingedEdge edge, DoorQueue ignoreQueue) {
        if (edge == null) {
            return false;
        }
        EdgeData ed = edge.data;
        return ed != null && edge.isDoor() && ed.node != this.d_occ.curNode && (ed.node.doorQueue != ignoreQueue || this.getOcc().formationLeader != null && this.getOcc().formationLeader.isFreePassDoor(ignoreQueue));
    }

    private boolean isQueueableDoor(KB kb, WingedEdge edge, DoorDir crossDir, Tri enterTri) {
        if (kb.getParams().reactive_steering && !edge.data.node.doorQueue.isQueueable(kb, crossDir)) {
            return false;
        }
        if (this.getOcc().formationLeader != null && (this.getOcc().formationLeader.isFreePassDoor(edge.getDoorQueue()) || this.getOcc().formationLeader.isPartiallyInNodeFormation(edge.getDestNode(crossDir)))) {
            return false;
        }
        if (edge.getNode1() != edge.getNode2()) {
            return edge.getDestNode(crossDir) != this.d_occ.curNode;
        }
        return edge.getDestTri(crossDir) != this.d_occ.tri;
    }

    protected UpdatePacket getUpdatePacket() {
        return this.d_nextLoc;
    }

    @Override
    public void update(KB kb, Param p, double dt) {
        if (this.d_vehicle != null) {
            this.d_vehicle.preUpdate(kb, p, dt);
        }
        if (this.d_nextLoc != null) {
            this.update(kb, p, dt, this.d_nextLoc);
            this.d_nextLoc = null;
        } else if (this.d_occ.waiting) {
            Pair<OccAnim, OccAnim> anims = this.calcAnim(new TriPoint(this.d_occ.tri, this.d_occ.loc), new Vector3d(0.0, 0.0, 0.0));
            this.d_occ.anim = (OccAnim)((Object)anims.v1);
            if (this.d_vehicle != null) {
                this.d_vehicle.setAnim((OccAnim)((Object)anims.v2));
            }
        }
        if (this.d_vehicle != null) {
            this.d_vehicle.postUpdate(kb, p, dt);
        }
    }

    public boolean isVisible(KB kb, OccAgent otherAgent) {
        Mesh geomMesh = kb.getMesh();
        for (TriPoint tpThis : this.getShape().getVisibilityPoints(kb, this)) {
            for (TriPoint tpOther : otherAgent.getShape().getVisibilityPoints(kb, otherAgent)) {
                if (geomMesh.isPathObstructed(tpThis.tri, tpThis.p, tpOther.tri, tpOther.p, 0.0, EdgeFilters.acceptAll())) continue;
                return true;
            }
        }
        return false;
    }

    public double calcNextUpdate(KB kb, double updateInterval) {
        if (RANDOM_STEER_OFFSET || kb.getParams().realtime) {
            return OccAgent.calcNextRealtimeUpdate(this.d_realTimeModifier, updateInterval, kb.getCurrentSimTime());
        }
        return kb.getCurrentSimTime() + updateInterval;
    }

    private static double calcNextRealtimeUpdate(double randomOffsetModifier, double updateInterval, double currTime) {
        double offset = randomOffsetModifier * updateInterval;
        double mult = Math.ceil((currTime - offset) / updateInterval);
        double nextUpdateTime = offset + updateInterval * mult;
        if (theUtil.le(nextUpdateTime, currTime, 1.0E-6)) {
            nextUpdateTime += updateInterval;
        }
        assert (updateInterval == 0.0 || nextUpdateTime > currTime);
        return nextUpdateTime;
    }

    private void update(KB kb, Param p, double dt, UpdatePacket nextLoc) {
        assert (this.d_nextLoc != null);
        double abst = kb.getCurrentSimTime();
        this.d_occ.totalDistanceMeters += this.d_occ.loc.distance(nextLoc.loc.p);
        this.d_occ.loc = nextLoc.loc.p;
        this.d_occ.tri = nextLoc.loc.tri;
        this.d_occ.displayLoc = nextLoc.displayLoc;
        this.d_occ.vel = nextLoc.vel;
        this.d_pathSpeedHistory.record(abst, this, this.d_occ.vel);
        this.d_occ.orient = nextLoc.orient;
        this.d_occ.displayOrient = nextLoc.displayOrient;
        this.d_occ.anim = nextLoc.anim;
        if (this.d_vehicle != null) {
            this.d_vehicle.setAnim(nextLoc.vehicleAnim);
        }
        this.d_occ.priority = nextLoc.steer.priority;
        this.d_occ.squeezeFactor = (float)nextLoc.steer.squeezeFactor;
        this.d_occ.targetDoor = nextLoc.targetDoor;
        if (nextLoc.locModified) {
            this.modified(abst);
        }
        this.d_lastSteer = nextLoc.steer;
        this.d_seekCurve = nextLoc.seek.curve;
        this.d_behaviorIsSeeking = nextLoc.seek.seeking;
        this.d_occHit = nextLoc.occHit;
        Pair<DoorQueue, DoorDir> exitedQueue = this.d_occ.doorQueue;
        this.d_occ.prevNode = null;
        this.d_occ.doorQueue = null;
        if (this.d_occ.bodyShape instanceof CylinderShape) {
            ((CylinderShape)this.d_occ.bodyShape).update(this.d_occ.loc, this.d_occ.orient);
        }
        if (nextLoc.reenterDir != null) {
            assert (exitedQueue != null);
            ((DoorQueue)exitedQueue.v1).reEnter(kb, this, abst, nextLoc.reenterDir);
        } else {
            for (int m2 = this.d_nonClearedDoors.size() - 1; m2 >= 0; --m2) {
                ANode door = this.d_nonClearedDoors.get(m2);
                if (!OccAgent.isDoorCleared(door, this.d_occ)) continue;
                this.d_nonClearedDoors.remove(m2);
            }
            for (Pair<ANode, DoorDir> crossedDoorInfo : nextLoc.crossedDoors) {
                ANode doorNode = (ANode)crossedDoorInfo.v1;
                boolean cleared = !this.d_nonClearedDoors.contains(doorNode);
                doorNode.doorQueue.passThrough(kb, abst, this, (DoorDir)((Object)crossedDoorInfo.v2), cleared);
                if (!cleared || OccAgent.isDoorCleared(doorNode, this.d_occ)) continue;
                this.d_nonClearedDoors.add(doorNode);
            }
            if (nextLoc.queueDoor != null) {
                ((ANode)nextLoc.queueDoor.v1).enter(kb, this, ((ANode)nextLoc.queueDoor.v1).doorQueue, abst);
                ((ANode)nextLoc.queueDoor.v1).doorQueue.enter(kb, this, abst, (DoorDir)((Object)nextLoc.queueDoor.v2));
            }
        }
        if (nextLoc.callElevator != null || nextLoc.targetDoor != null && ((ANode)nextLoc.targetDoor.v1).isElevatorDoor() && this.getOcc().curNode.getElevatorLevel() == null && this.getAvoidOcc() != null) {
            this.d_occ.elevatorWaitTime.decreaseRemainingWaitTime(dt);
        }
        if (this.d_lostAiCore != nextLoc.lostAiCore) {
            this.d_lostAiCore = nextLoc.lostAiCore;
            this.modified(kb.getCurrentSimTime());
        }
        if (nextLoc.callElevator != null) {
            nextLoc.callElevator.call();
        }
        float f = this.d_occ.terrainSpeed = this.d_occ.tri != null ? (float)this.d_occ.tri.getSpeedModifier().getTerrainSpeed() : 0.0f;
        assert (this.getNodesConsistent());
        this.d_pathFollowStatus = nextLoc.pfStatus;
        if (nextLoc.tempElevatorRestrictions != null) {
            if (this.getOcc().dynamicCompRestrictions == null) {
                this.getOcc().dynamicCompRestrictions = new OccProfileSim.DynamicCompRestrictions();
            }
            this.getOcc().dynamicCompRestrictions.addTempElevatorRestrictions(nextLoc.tempElevatorRestrictions);
        }
        this.getAssistedEvacClientModule().ifPresent(m -> {
            m.update(kb, p, dt);
            if (m.willEnd()) {
                this.d_assistedEvacClientModule = null;
                this.getOcc().formationLeader = null;
            }
        });
        nextLoc.steer.postOp.accept(kb, this);
        this.updateCanMove();
    }

    protected void updateCanMove() {
        if (this.d_assistedEvacClientModule != null) {
            this.d_assistedEvacClientModule.updateCanMove();
        } else {
            this.setCanMove(!this.d_occ.requiresAssistance);
        }
    }

    private static boolean isDoorCleared(ANode door, Occupant occ) {
        if (door.getDoorEdges().isEmpty()) {
            return true;
        }
        double geomRadius = occ.bodyShape.getGeomRadius();
        double geomRadiusSq = geomRadius * geomRadius;
        for (WingedEdge we : door.getDoorEdges()) {
            double distSq = Inter2D.distSqToNearestPtOnLineSeg(we.base.n1.p.x, we.base.n1.p.y, we.base.n2.p.x, we.base.n2.p.y, occ.loc.x, occ.loc.y);
            if (!theUtil.lt(distSq, geomRadiusSq, 1.0E-9)) continue;
            return false;
        }
        return true;
    }

    public boolean isActive() {
        return !this.isDone() && !(this.getCurrentGoal() instanceof IIdleGoal);
    }

    public void updateStats(KB kb, double dt) {
        OccStats.PerAgentData data = this.d_stats;
        boolean isActive = this.isActive();
        if (isActive) {
            data.tActive += dt;
        }
        double v = this.getVel().length();
        boolean currentStepIsSlow = isActive && v <= kb.getParams().low_speed_threshold;
        ANode currentNode = this.getOcc().curNode;
        if (currentStepIsSlow) {
            data.tSlowTotal += dt;
            data.tSlowMaxContinuousCurrent += dt;
            data.tSlowMaxContinuous = Math.max(data.tSlowMaxContinuous, data.tSlowMaxContinuousCurrent);
            if (currentNode != null) {
                if (currentNode.getTerrain().isStair()) {
                    data.tStairsSlowTotal += dt;
                } else if (currentNode.getTerrain().isRamp()) {
                    data.tRampsSlowTotal += dt;
                } else {
                    data.tOpenSlowTotal += dt;
                }
            }
        } else {
            data.tSlowMaxContinuousCurrent = 0.0;
        }
    }

    public int getCorrespondingOccCount() {
        if (this.d_vehicle != null) {
            return this.d_vehicle.getCorrespondingOccCount();
        }
        return 1;
    }

    public int getFormationCorrespondingOccCount() {
        if (this.d_occ.formationLeader == null) {
            return this.getCorrespondingOccCount();
        }
        return this.d_occ.formationLeader.getFormationCorrespondingOccCount();
    }

    public int getFormationSize() {
        if (this.d_occ.formationLeader == null) {
            return 1;
        }
        return this.d_occ.formationLeader.getFormationSize();
    }

    public double getRemainingDistance() {
        return this.d_pathFollowStatus.remainingDist;
    }

    public PathFollow.Status getPathStatus() {
        return this.d_pathFollowStatus;
    }

    public Optional<AssistedEvacClientAgent> getAssistedEvacClientModule() {
        return Optional.ofNullable(this.d_assistedEvacClientModule);
    }

    public List<Point3d> getStaticAttachedAgentsPositions() {
        if (this.d_vehicle != null) {
            return this.d_vehicle.getStaticAttachedAgentsPositions();
        }
        return Collections.emptyList();
    }

    public <T> void getFutureProfileValues(OccProfileSim.IOccProp<T> prop, Consumer<? super T> result) {
        this.d_occ.behavior.getFutureProfileValues(new IdentityHashSet(), prop, result);
    }

    public void initAssistedEvacClientModule(KB kb) {
        this.d_assistedEvacClientModule = new AssistedEvacClientAgent(this.d_occ, this, this.getStaticAttachedAgentsPositions(), kb);
    }

    public boolean isModifiedSince(double t, boolean isOutputTime) {
        return Double.isNaN(this.d_tLastModified) ? false : (isOutputTime ? t <= this.d_tLastModified : t < this.d_tLastModified);
    }

    public void markModified(double t) {
        this.d_tLastModified = t;
    }

    public static class UpdatePacket
    implements Serializable {
        static final long serialVersionUID = 1L;
        public TriPoint loc;
        public TriPoint displayLoc;
        public Vector3d vel;
        public Vector3d orient;
        public Vector3d displayOrient;
        public OccAnim anim;
        public OccAnim vehicleAnim;
        public boolean locModified = false;
        public Steer steer;
        public SeekCurve seek = null;
        public OccAgent occHit = null;
        public List<Pair<ANode, DoorDir>> crossedDoors = new ArrayList<Pair<ANode, DoorDir>>(2);
        public Pair<ANode, DoorDir> queueDoor = null;
        public DoorDir reenterDir = null;
        public LostAiCore lostAiCore = null;
        public ElevatorLevel callElevator = null;
        public Pair<ANode, DoorDir> targetDoor = null;
        public PathFollow.Status pfStatus = PathFollow.UNKNOWN_STATUS;
        public Map<IElevator, Set<ANode>> tempElevatorRestrictions = null;

        public UpdatePacket(Occupant occ) {
            this.displayLoc = this.loc = new TriPoint(occ.tri, occ.loc);
            this.vel = occ.vel;
            this.orient = occ.orient;
            this.displayOrient = occ.orient;
            this.anim = occ.anim;
        }
    }

    private static class EdgeCrossings {
        public final List<Mesh.EdgeCrossing> crossings;
        public final double maxt;
        public final OccAgent occHit;

        public EdgeCrossings(List<Mesh.EdgeCrossing> crossings, double maxt, OccAgent occHit) {
            this.crossings = crossings;
            this.maxt = maxt;
            this.occHit = occHit;
        }
    }

    public static enum PathFilterType {
        POINT_TO_POINT,
        LOCAL,
        DOOR_TO_GOAL,
        TRANSIENT;

    }

    public static class DefaultUpdator
    implements IUpdator,
    Serializable {
        static final long serialVersionUID = 1L;

        @Override
        public UpdatePacket calcUpdate(KB kb, Param p, double dt, OccAgent agent, Steer steer, SeekCurve seekCurve) {
            return agent.calcTravel(kb, p, dt, steer, seekCurve);
        }
    }

    public static interface IUpdator {
        public UpdatePacket calcUpdate(KB var1, Param var2, double var3, OccAgent var5, Steer var6, SeekCurve var7);
    }

    private static class OccProgressNote
    implements IProgressNote {
        private final BehaviorSim.BehaviorInProgress d_behaviorInProgress;
        private final IProgressNote d_goalProgress;

        public OccProgressNote(BehaviorSim.BehaviorInProgress behaviorInProgress, IProgressNote goalProgress) {
            this.d_behaviorInProgress = behaviorInProgress;
            this.d_goalProgress = goalProgress;
        }

        @Override
        public boolean isMakingProgress(KB kb, Object src, IProgressNote prevProgress) {
            if (!(prevProgress instanceof OccProgressNote)) {
                return true;
            }
            OccProgressNote prevNote = (OccProgressNote)prevProgress;
            if (prevNote.d_behaviorInProgress != this.d_behaviorInProgress) {
                return true;
            }
            return this.d_goalProgress.isMakingProgress(kb, src, prevNote.d_goalProgress);
        }
    }
}

