/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.AElevatorScheduler;
import inferno.data2.ANode;
import inferno.data2.ElevatorLevel;
import inferno.data2.EvacElevator;
import inferno.data2.IElevator;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.sim.KB;
import inferno.sim.path.PathGen;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class ElevatorModel
implements Serializable {
    private static final long serialVersionUID = 492666562082182514L;
    private List<IElevator> d_elevators = new ArrayList<IElevator>();
    private Map<Serializable, Set<IElevator>> d_elevatorLinkedSets = new LinkedHashMap<Serializable, Set<IElevator>>();
    private Map<IElevator, AElevatorScheduler> d_elevatorSchedulers;
    private Collection<ANode> memo_getAllElevatorRooms = null;

    public ElevatorModel() {
        this.d_elevatorLinkedSets.put(null, new LinkedHashSet());
        this.d_elevatorSchedulers = new HashMap<IElevator, AElevatorScheduler>();
    }

    public void init() {
        for (IElevator elevator : this.d_elevators) {
            elevator.init();
            this.d_elevatorSchedulers.put(elevator, new EvacElevatorScheduler());
        }
    }

    public void linkElevators(Collection<IElevator> elevs) {
        this.d_elevatorLinkedSets.get(null).removeAll(elevs);
        LinkedHashSet<IElevator> linkSet = new LinkedHashSet<IElevator>(elevs);
        this.d_elevatorLinkedSets.put(new KeyObj(), linkSet);
    }

    public Collection<Set<IElevator>> getLinkedElevators() {
        ArrayList<Set<IElevator>> elevatorSets = new ArrayList<Set<IElevator>>(this.d_elevatorLinkedSets.size());
        for (Map.Entry<Serializable, Set<IElevator>> entry : this.d_elevatorLinkedSets.entrySet()) {
            if (entry.getKey() == null || entry.getValue().size() <= 1) continue;
            elevatorSets.add(entry.getValue());
        }
        return elevatorSets;
    }

    public void addElevator(IElevator elev) {
        this.d_elevatorLinkedSets.get(null).add(elev);
        this.d_elevators.add(elev);
    }

    public IElevator getElevator(int id) {
        return this.d_elevators.get(id);
    }

    public List<IElevator> getElevators() {
        return Collections.unmodifiableList(this.d_elevators);
    }

    public void update(KB kb) {
        for (IElevator iElevator : this.d_elevators) {
            iElevator.update(kb);
        }
        for (Object object : this.d_elevatorLinkedSets.keySet()) {
            if (object == null) {
                for (IElevator elev : this.d_elevatorLinkedSets.get(object)) {
                    this.d_elevatorSchedulers.get(elev).processHallCallsIndividual(kb, elev, elev.getInServiceLevels());
                }
                continue;
            }
            Set<IElevator> elevs = this.d_elevatorLinkedSets.get(object);
            IElevator elevator = elevs.iterator().next();
            this.d_elevatorSchedulers.get(elevator).processHallCallsLinked(kb, elevs);
        }
        for (IElevator iElevator : this.d_elevators) {
            this.d_elevatorSchedulers.get(iElevator).clearCallStates(iElevator);
        }
    }

    public IElevator findElevator(ElevatorLevel level) {
        for (IElevator el : this.d_elevators) {
            ElevatorLevel elev = el.getLevel(level.levelId);
            if (elev != level) continue;
            return el;
        }
        return null;
    }

    public synchronized Collection<ANode> getAllElevatorRooms() {
        if (this.memo_getAllElevatorRooms == null) {
            this.memo_getAllElevatorRooms = new ArrayDeque<ANode>();
            for (IElevator elev : this.d_elevators) {
                for (ElevatorLevel elevLev : elev.getLevels()) {
                    this.memo_getAllElevatorRooms.add(elevLev.pickupNode);
                }
            }
        }
        return this.memo_getAllElevatorRooms;
    }

    public double getTransportTime(ElevatorLevel elevatorLevel) {
        if (elevatorLevel != null) {
            return elevatorLevel.getDischargeTimeTot(this.findElevator(elevatorLevel).getTargetLevel());
        }
        return 0.0;
    }

    public Set<ANode> getTransportDoors(ElevatorLevel elevatorLevel) {
        Set<ANode> transportDoors = Collections.emptySet();
        if (elevatorLevel != null) {
            transportDoors = new LinkedIdentityHashSet<ANode>();
            ANode dischargeNode = this.findElevator(elevatorLevel).getTargetNodeFor(elevatorLevel);
            transportDoors.addAll(dischargeNode.getDoorsOutOfRoom());
        }
        return transportDoors;
    }

    private List<PathGen.SearchConnection> getTransportEdges(WingedEdge edge, ANode node, Map<ANode, List<PathGen.SearchConnection>> dischargeConnectionCache) {
        ElevatorLevel elevatorLevel;
        if (edge.isDoor() && (elevatorLevel = node.getElevatorLevel()) != null) {
            IElevator elevator = this.findElevator(elevatorLevel);
            ANode dischargeNode = elevator.getTargetNode();
            return dischargeConnectionCache.computeIfAbsent(dischargeNode, dnode -> {
                ArrayList<PathGen.SearchConnection> connections = new ArrayList<PathGen.SearchConnection>();
                block0: for (WingedEdge dischargeDoor : dischargeNode.getDoorEdges()) {
                    Tri dischargeTri = dischargeDoor.getTri(dischargeNode);
                    for (int n = 0; n < 3; ++n) {
                        if (!dischargeTri.eu[n].wedge.equals(dischargeDoor)) continue;
                        connections.add(new PathGen.SearchConnection(dischargeTri.eu[n], dischargeDoor.getAdjTri(dischargeTri), true));
                        continue block0;
                    }
                }
                if (elevator.isDoubleDeck()) {
                    ANode upperDischargeNode = elevator.getUpperTargetNode();
                    block2: for (WingedEdge dischargeDoor : upperDischargeNode.getDoorEdges()) {
                        Tri dischargeTri = dischargeDoor.getTri(upperDischargeNode);
                        for (int n = 0; n < 3; ++n) {
                            if (!dischargeTri.eu[n].wedge.equals(dischargeDoor)) continue;
                            connections.add(new PathGen.SearchConnection(dischargeTri.eu[n], dischargeDoor.getAdjTri(dischargeTri), true));
                            continue block2;
                        }
                    }
                }
                return connections;
            });
        }
        return Collections.emptyList();
    }

    public void initTriSearchConnections(Tri[] tris) {
        IdentityHashMap<ANode, List<PathGen.SearchConnection>> dischargeConnectionCache = new IdentityHashMap<ANode, List<PathGen.SearchConnection>>();
        for (Tri tri : tris) {
            int m;
            ArrayList<PathGen.SearchConnection> connections = new ArrayList<PathGen.SearchConnection>();
            for (m = 0; m < 3; ++m) {
                connections.add(new PathGen.SearchConnection(tri.eu[m], tri.t[m], false));
            }
            for (m = 0; m < 3; ++m) {
                connections.addAll(this.getTransportEdges(tri.eu[m].wedge, tri.node, dischargeConnectionCache));
            }
            tri.searchConnections = theUtil.toArray(connections, PathGen.SearchConnection.class);
        }
    }

    private static class EvacElevatorScheduler
    extends AElevatorScheduler<EvacElevator>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private EvacElevatorScheduler() {
        }

        @Override
        public ElevatorLevel shouldReRouteTo(EvacElevator elevator, Collection<ElevatorLevel> allLinkedLevels) {
            assert (elevator.getState() == IElevator.ElevatorState.MOVING_TO_FLOOR);
            if (elevator.isOpeningForPickup()) {
                return null;
            }
            Point3d dischargePos = elevator.getTargetNode().getGeometryBounds().getMin();
            Point3d elevPos = new Point3d(elevator.getActiveLevel().pickupNode.getGeometryBounds().getMin());
            elevPos.sub(dischargePos);
            elevPos.scale(elevator.getPickupProgress());
            elevPos.add(dischargePos);
            ArrayList<ElevatorLevel> prioritySortedLevels = new ArrayList<ElevatorLevel>(allLinkedLevels);
            Collections.sort(prioritySortedLevels, elevator.getFloorSorter());
            for (ElevatorLevel elevLevel : prioritySortedLevels) {
                if (elevLevel == elevator.getActiveLevel() || elevator.isDoubleDeck() && elevLevel == elevator.getDoubleDeckLevelPairs().getUpperLevel(elevator.getActiveLevel())) {
                    return null;
                }
                if (!elevLevel.isHallCallActive() || !elevator.isLevelInService(elevLevel.levelId) || elevator.isDoubleDeck() && elevator.getTargetLevel(elevLevel) == elevator.getActiveLevel()) continue;
                Point3d newPickupPos = elevLevel.pickupNode.getGeometryBounds().getMin();
                double distSqToDischarge = dischargePos.distanceSquared(elevPos);
                double distSqToNewPickup = elevPos.distanceSquared(newPickupPos);
                double distSqFull = dischargePos.distanceSquared(newPickupPos);
                if (!(distSqToDischarge < distSqFull) || !(distSqToNewPickup < distSqFull)) continue;
                return elevLevel;
            }
            return null;
        }

        @Override
        public void processHallCallsIndividual(KB kb, EvacElevator elevator, Collection<ElevatorLevel> elevatorLevels) {
            ElevatorLevel newPickup;
            IElevator.ElevatorState state = elevator.getState();
            if (state == IElevator.ElevatorState.READY) {
                ElevatorLevel callLvl = this.getTopPriorityHallCall(elevator, elevatorLevels);
                if (callLvl != null) {
                    elevator.beginPickup(kb, callLvl.levelId);
                }
            } else if (state == IElevator.ElevatorState.MOVING_TO_FLOOR && (newPickup = this.shouldReRouteTo(elevator, elevatorLevels)) != null) {
                elevator.changePickupTo(kb.getCurrentSimTime(), newPickup.levelId);
            }
        }

        public ElevatorLevel getTopPriorityHallCall(EvacElevator elevator, Collection<ElevatorLevel> allLinkedInServiceLevels) {
            ArrayList<ElevatorLevel> prioritySortedLevels = new ArrayList<ElevatorLevel>(allLinkedInServiceLevels);
            Collections.sort(prioritySortedLevels, elevator.getFloorSorter());
            for (ElevatorLevel elevLevel : prioritySortedLevels) {
                if (!elevLevel.isHallCallActive() || !elevator.isLevelInService(elevLevel.levelId)) continue;
                return elevLevel;
            }
            return null;
        }
    }

    private static class KeyObj
    implements Serializable {
        private static final long serialVersionUID = 3316529401959403292L;

        private KeyObj() {
        }
    }
}

