/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.OccPriority;
import inferno.sim.IDoorFlowrate;
import inferno.sim.IFormationLeaderAgent;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Param;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.ToDoubleFunction;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.theUtil;

public class DoorQueue
implements Serializable {
    static final long serialVersionUID = 1L;
    private double d_effWidth;
    private IDoorFlowrate d_flowrate;
    private ANode d_node;
    private ANode d_r1;
    private ANode d_r2;
    private final NavigableSet<EnqueuedOcc> d_queue1;
    private final NavigableSet<EnqueuedOcc> d_queue2;
    private final Map<OccAgent, EnqueuedOcc> d_allEnqueued;
    private final UsageHistory d_r1Usage;
    private final UsageHistory d_r2Usage;
    private double d_tPrevRelease;
    private DoorDir d_prevDir;
    private final IDistributedVal<UnitDouble> d_waitTime;
    private Map<Pair<Double, ANode>, Set<OccAgent>> d_waitingAgents = Collections.emptyMap();
    private Map<OccAgent, Pair<Double, ANode>> d_revWaitingAgents = Collections.emptyMap();
    private Map<OccAgent, List<OccAgent>> d_waitingAgentFormations = Collections.emptyMap();
    private HashMap<OccAgent, DoorDir> d_waitingForRemoval;
    private static final IDoorFlowrate s_largeFlowrate = new IDoorFlowrate.Fixed(Double.MAX_VALUE);

    public DoorQueue(Param p, ANode n, ANode r1, ANode r2, IDoorFlowrate flowrate, double effWidth, IDistributedVal<UnitDouble> waitTime) {
        assert (flowrate == null || flowrate instanceof IDoorFlowrate.Fixed);
        this.d_flowrate = flowrate;
        this.d_node = n;
        this.d_r1 = r1;
        this.d_r2 = r2;
        this.d_effWidth = effWidth;
        this.d_waitTime = waitTime;
        this.d_tPrevRelease = Double.NEGATIVE_INFINITY;
        this.d_prevDir = null;
        this.d_queue1 = new TreeSet<EnqueuedOcc>(EnqueuedOccComparer.INSTANCE);
        this.d_queue2 = new TreeSet<EnqueuedOcc>(EnqueuedOccComparer.INSTANCE);
        this.d_allEnqueued = new IdentityHashMap<OccAgent, EnqueuedOcc>();
        this.d_r1Usage = new UsageHistory();
        this.d_r2Usage = new UsageHistory();
        this.d_waitingForRemoval = new HashMap();
    }

    public QueuePosition getPosition(OccAgent agent) {
        EnqueuedOcc eo = this.d_allEnqueued.get(agent);
        if (eo == null) {
            return null;
        }
        int pos = this.getQueue(eo.dir).headSet(eo).size();
        return new QueuePosition(eo.dir, pos, eo.t);
    }

    public double getEffWidth() {
        return this.d_effWidth;
    }

    public IDoorFlowrate getFlowrate() {
        return this.d_flowrate;
    }

    public IDoorFlowrate getFinalFlowrate(KB kb) {
        IDoorFlowrate flowrate;
        IDoorFlowrate iDoorFlowrate = flowrate = this.d_flowrate == null ? kb.getDefaultFlowrate() : this.d_flowrate;
        if (!flowrate.isFinite(kb) && (this.d_r1 != null && this.d_r1.hasOccLimit() || this.d_r2 != null && this.d_r2.hasOccLimit())) {
            flowrate = s_largeFlowrate;
        }
        return flowrate;
    }

    public double getMaxFlowrate(KB kb, DoorDir dir) {
        return this.getFinalFlowrate(kb).getMaxFlowrate(kb, this, dir);
    }

    public double getNominalFlowrate(KB kb, DoorDir dir) {
        double maxFlowrate = this.getMaxFlowrate(kb, dir);
        double nominal = this.d_effWidth * 1.32;
        return Math.min(nominal, maxFlowrate);
    }

    public boolean isQueueable(KB kb, DoorDir dir) {
        return this.d_waitTime != null || this.getFinalFlowrate(kb).isFinite(kb);
    }

    public ANode getR1() {
        return this.d_r1;
    }

    public ANode getR2() {
        return this.d_r2;
    }

    public ANode getAdjNode(ANode node) {
        ANode node1 = this.getR1();
        return node1 == node ? this.getR2() : node1;
    }

    private double getReleaseDT(KB kb, DoorDir dir, OccAgent agent) {
        double correspondingOccCount = agent.getFormationSize();
        double flowrate = this.getFinalFlowrate(kb).getMaxFlowrate(kb, this, dir);
        return flowrate == 0.0 ? 0.0 : correspondingOccCount * 1.0 / flowrate;
    }

    public boolean isExitDoor() {
        return this.d_r1 == null || this.d_r2 == null;
    }

    public DoorDir getExitDir() {
        assert (this.isExitDoor());
        assert (this.getR1() == null || this.getR2() == null);
        return this.getR1() == null ? DoorDir.POSITIVE : DoorDir.NEGATIVE;
    }

    public boolean isInternal() {
        return this.d_r1 == this.d_r2;
    }

    public boolean isElevatorDoor() {
        boolean node1El = this.getR1() != null && this.getR1().getElevatorLevel() != null;
        boolean node2El = this.getR2() != null && this.getR2().getElevatorLevel() != null;
        return node1El != node2El;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Door Queue[");
        sb.append("name=" + this.d_node.name);
        sb.append(", size=" + this.size());
        sb.append("]");
        return sb.toString();
    }

    public ANode getNode() {
        return this.d_node;
    }

    public int size() {
        return this.d_queue1.size() + this.d_queue2.size();
    }

    public ANode dest(DoorDir dir) {
        switch (dir) {
            case POSITIVE: {
                return this.d_r1;
            }
            case NEGATIVE: {
                return this.d_r2;
            }
        }
        assert (false);
        return null;
    }

    public ANode src(DoorDir dir) {
        switch (dir) {
            case POSITIVE: {
                return this.d_r2;
            }
            case NEGATIVE: {
                return this.d_r1;
            }
        }
        assert (false);
        return null;
    }

    public DoorDir getDir(ANode dstNode) {
        return dstNode == this.d_r1 ? DoorDir.POSITIVE : DoorDir.NEGATIVE;
    }

    private NavigableSet<EnqueuedOcc> getQueue(DoorDir dir) {
        switch (dir) {
            case POSITIVE: {
                return this.d_queue1;
            }
            case NEGATIVE: {
                return this.d_queue2;
            }
        }
        assert (false);
        return null;
    }

    public int getNumQueued(DoorDir dir) {
        return this.getQueue(dir).size();
    }

    public boolean isQueued(OccAgent agent, DoorDir dir) {
        EnqueuedOcc eo = this.d_allEnqueued.get(agent);
        return eo != null && eo.dir == dir;
    }

    public DoorDir getQueueDir(OccAgent agent) {
        EnqueuedOcc eo = this.d_allEnqueued.get(agent);
        return eo != null ? eo.dir : null;
    }

    public UsageHistory getUsage(DoorDir direction) {
        switch (direction) {
            case POSITIVE: {
                return this.d_r1Usage;
            }
            case NEGATIVE: {
                return this.d_r2Usage;
            }
        }
        assert (false);
        return null;
    }

    public void passThrough(KB kb, double t, OccAgent occ, DoorDir dir, boolean doorCleared) {
        ANode doorNode = this.d_node;
        doorNode.passThrough(kb, occ, this, t);
        ANode destNode = this.dest(dir);
        occ.moveToNode(kb, this, destNode, t);
        if (doorCleared) {
            UsageHistory history = this.getUsage(dir);
            history.increment();
        }
    }

    public synchronized Object enter(KB kb, OccAgent occ, double t, DoorDir dir) {
        IFormationLeaderAgent formationLeader = occ.getOcc().formationLeader;
        if (formationLeader != null) {
            formationLeader.getFormation().forEach(a -> {
                a.getOcc().waiting = true;
            });
        }
        EnqueuedOcc enqueuedOcc = new EnqueuedOcc(occ, t, dir);
        if (this.getQueue(dir).add(enqueuedOcc)) {
            this.d_allEnqueued.put(occ, enqueuedOcc);
        }
        occ.enterQueue(this, dir, kb.getCurrentSimTime());
        return occ;
    }

    public synchronized void reEnter(KB kb, OccAgent agent, double t, DoorDir dir) {
        this.getNode().enter(kb, agent, this, t);
        this.enter(kb, agent, t, dir);
    }

    private void exitToPrev(KB kb, double t, NavigableSet<EnqueuedOcc> queue, boolean isClosedForAll, boolean forceExit) {
        if (queue.isEmpty()) {
            return;
        }
        for (EnqueuedOcc eo : new ArrayList<EnqueuedOcc>(queue)) {
            if (!forceExit && !isClosedForAll && !this.d_node.isClosed(kb, eo.occ)) continue;
            this.exit(kb, eo, eo.dir.opposite(), t);
        }
    }

    private boolean isNext(EnqueuedOcc occ, EnqueuedOcc oppOcc) {
        assert (occ != null || oppOcc != null);
        if (occ == null) {
            return false;
        }
        if (oppOcc == null) {
            return true;
        }
        if (this.d_prevDir != null) {
            return occ.dir != this.d_prevDir;
        }
        return EnqueuedOccComparer.INSTANCE.compare(occ, oppOcc) < 0;
    }

    public synchronized void removeFromQueue(OccAgent agent) {
        if (!this.d_waitingForRemoval.containsKey(agent)) {
            this.d_waitingForRemoval.put(agent, (DoorDir)((Object)agent.getOcc().doorQueue.v2));
        }
    }

    public boolean updateQueue(KB kb, double dt) {
        double tNextRelease;
        double flowrateDT;
        EnqueuedOcc eo2;
        this.releaseWaitingAgents(kb);
        if (this.d_queue1.isEmpty() && this.d_queue2.isEmpty()) {
            return true;
        }
        double t1 = kb.getCurrentSimTime();
        double t2 = t1 + dt;
        for (DoorDir o : this.d_waitingForRemoval.values()) {
            this.exitToPrev(kb, t2, this.getQueue(o), false, true);
        }
        this.d_waitingForRemoval.clear();
        this.exitToPrev(kb, t2, this.d_queue1, this.d_node.isPhysicallyClosed(), false);
        this.exitToPrev(kb, t2, this.d_queue2, this.d_node.isPhysicallyClosed(), false);
        if (this.d_node.isPhysicallyClosed() || this.d_queue1.isEmpty() && this.d_queue2.isEmpty()) {
            this.d_prevDir = null;
            return true;
        }
        EnqueuedOcc eo1 = !this.d_queue1.isEmpty() ? (EnqueuedOcc)this.d_queue1.first() : null;
        EnqueuedOcc enqueuedOcc = eo2 = !this.d_queue2.isEmpty() ? (EnqueuedOcc)this.d_queue2.first() : null;
        if (!this.isNext(eo1, eo2)) {
            EnqueuedOcc temp = eo1;
            eo1 = eo2;
            eo2 = temp;
        }
        assert (eo1 != null);
        double d = flowrateDT = eo1 != null && eo2 != null ? Math.max(this.getReleaseDT(kb, eo1.dir, eo1.occ), this.getReleaseDT(kb, eo2.dir, eo2.occ)) : this.getReleaseDT(kb, eo1.dir, eo1.occ);
        if (eo1.occ.getOcc().formationLeader != null && (eo1.occ.getOcc().formationLeader.isFreePassDoor(this) || eo1.occ.getOcc().formationLeader.isPartiallyInNodeFormation(this.dest(eo1.dir)))) {
            flowrateDT = 0.0;
        }
        if ((tNextRelease = this.d_tPrevRelease + flowrateDT) > t2) {
            return true;
        }
        ANode o1rNext = this.dest(eo1.dir);
        ANode o1rPrev = this.src(eo1.dir);
        if (o1rNext == null || o1rNext == o1rPrev || o1rNext.hasRoomFor(eo1.occ, kb)) {
            double tExit;
            this.d_tPrevRelease = tExit = this.exit(kb, eo1, eo1.dir, tNextRelease);
        } else {
            if (eo2 == null) {
                this.exitToPrev(kb, t2, this.getQueue(eo1.dir), false, true);
                return true;
            }
            tNextRelease = this.d_tPrevRelease + 2.0 * flowrateDT;
            if (tNextRelease < t2) {
                double tExit1 = this.exit(kb, eo1, eo1.dir, tNextRelease);
                double tExit2 = this.exit(kb, eo2, eo2.dir, tNextRelease);
                this.d_tPrevRelease = Math.max(tExit1, tExit2);
            } else {
                return true;
            }
        }
        return this.d_queue1.isEmpty() && this.d_queue2.isEmpty();
    }

    private void releaseWaitingAgents(KB kb) {
        if (this.d_waitingAgents.isEmpty()) {
            return;
        }
        ArrayList<Pair<Double, ANode>> toRemove = null;
        for (Map.Entry<Pair<Double, ANode>, Set<OccAgent>> entry : this.d_waitingAgents.entrySet()) {
            if (!theUtil.le((Double)entry.getKey().v1, kb.getCurrentSimTime(), 1.0E-6)) continue;
            for (OccAgent occ : entry.getValue()) {
                List<OccAgent> formation;
                occ.getOcc().waiting = false;
                occ.exitQueue(kb, this, (ANode)entry.getKey().v2, kb.getCurrentSimTime());
                if (this.d_waitingAgentFormations.isEmpty() || (formation = this.d_waitingAgentFormations.remove(occ)) == null) continue;
                if (this.d_waitingAgentFormations.isEmpty()) {
                    this.d_waitingAgentFormations = Collections.emptyMap();
                }
                formation.forEach(agent -> {
                    agent.getOcc().waiting = false;
                });
            }
            if (toRemove == null) {
                toRemove = new ArrayList<Pair<Double, ANode>>();
            }
            toRemove.add(entry.getKey());
        }
        if (toRemove != null) {
            toRemove.forEach(k -> {
                Set<OccAgent> agents = this.d_waitingAgents.remove(k);
                assert (agents != null);
                this.d_revWaitingAgents.keySet().removeAll(agents);
            });
            if (this.d_waitingAgents.isEmpty()) {
                this.d_waitingAgents = Collections.emptyMap();
                this.d_revWaitingAgents = Collections.emptyMap();
            }
        }
    }

    public IDistributedVal getWaitTime() {
        return this.d_waitTime;
    }

    public double getWaitTime(KB kb, DoorDir dir, OccAgent agent) {
        ToDoubleFunction<OccAgent> getTime = a -> {
            Pair<Double, ANode> entry = this.d_revWaitingAgents.get(a);
            if (entry != null && entry.v2 == this.dest(dir)) {
                return Math.max(0.0, kb.getCurrentSimTime() - (Double)entry.v1);
            }
            return Double.NaN;
        };
        double time = getTime.applyAsDouble(agent);
        if (!Double.isNaN(time)) {
            return time;
        }
        for (OccAgent formOcc : this.d_waitingAgentFormations.getOrDefault(agent, Collections.emptyList())) {
            if (formOcc == agent || Double.isNaN(time = getTime.applyAsDouble(formOcc))) continue;
            return time;
        }
        if (this.d_waitTime == null) {
            return 0.0;
        }
        return this.getFutureWaitTime(agent);
    }

    private double getFutureWaitTime(OccAgent agent) {
        Random r = new Random(agent.getOcc().rseed);
        return this.d_waitTime.getValue(r).get(SI.SECOND);
    }

    private double exit(KB kb, EnqueuedOcc eo, DoorDir forcedDir, double tNextRelease) {
        NavigableSet<EnqueuedOcc> queue = this.getQueue(eo.dir);
        DoorDir desiredDir = eo.dir;
        OccAgent o = eo.occ;
        IFormationLeaderAgent formationLeader = o.getOcc().formationLeader;
        List<OccAgent> updateOccs = formationLeader != null ? formationLeader.getFormation() : Collections.singletonList(o);
        for (OccAgent agent2 : updateOccs) {
            EnqueuedOcc aeo = this.d_allEnqueued.remove(agent2);
            if (aeo == null) continue;
            queue.remove(aeo);
        }
        ANode prevRoom = this.src(desiredDir);
        ANode destRoom = this.dest(forcedDir);
        if (destRoom != null) {
            assert (prevRoom != null);
            updateOccs.forEach(agent -> {
                if (agent.getOcc().curNode != prevRoom) {
                    prevRoom.willExit((OccAgent)agent);
                }
                if (agent.getOcc().curNode != destRoom) {
                    destRoom.willEnter((OccAgent)agent);
                }
            });
        }
        if (desiredDir == forcedDir) {
            updateOccs.forEach(agent -> this.getUsage(desiredDir).increment());
            this.d_prevDir = desiredDir;
        }
        double tExit = Math.max(eo.t, tNextRelease);
        if (this.d_waitTime == null || o.getOcc().curNode == destRoom) {
            updateOccs.forEach(agent -> {
                agent.getOcc().waiting = false;
            });
            o.exitQueue(kb, this, destRoom, tExit);
        } else {
            if (this.d_waitingAgents.isEmpty()) {
                this.d_waitingAgents = new LinkedHashMap<Pair<Double, ANode>, Set<OccAgent>>();
                this.d_revWaitingAgents = new IdentityHashMap<OccAgent, Pair<Double, ANode>>();
            }
            double wait = this.getFutureWaitTime(o);
            Pair<Double, ANode> releaseEntry = new Pair<Double, ANode>(kb.getCurrentSimTime() + wait, destRoom);
            Set waiting = this.d_waitingAgents.computeIfAbsent(releaseEntry, k -> new LinkedHashSet());
            waiting.add(o);
            this.d_revWaitingAgents.put(o, releaseEntry);
            if (updateOccs.size() > 1) {
                if (this.d_waitingAgentFormations.isEmpty()) {
                    this.d_waitingAgentFormations = new LinkedHashMap<OccAgent, List<OccAgent>>();
                }
                this.d_waitingAgentFormations.put(o, updateOccs);
            }
        }
        return tExit;
    }

    public boolean contains(OccAgent agent) {
        if (this.d_allEnqueued.containsKey(agent)) {
            return true;
        }
        if (this.d_revWaitingAgents.containsKey(agent)) {
            return true;
        }
        for (List<OccAgent> occs : this.d_waitingAgentFormations.values()) {
            if (!occs.contains(agent)) continue;
            return true;
        }
        return false;
    }

    private static class EnqueuedOccComparer
    implements Serializable,
    Comparator<EnqueuedOcc> {
        static final long serialVersionUID = 1L;
        public static final EnqueuedOccComparer INSTANCE = new EnqueuedOccComparer();

        private EnqueuedOccComparer() {
        }

        @Override
        public int compare(EnqueuedOcc o1, EnqueuedOcc o2) {
            if (o1 == o2) {
                return 0;
            }
            assert (o1.occ != o2.occ);
            if (o1.t != o2.t) {
                return Double.compare(o1.t, o2.t);
            }
            int compare = OccPriority.compareStrict(o1.priority, o2.priority);
            if (compare != 0) {
                return compare;
            }
            return o1.occ.getOcc().id - o2.occ.getOcc().id;
        }
    }

    private static class EnqueuedOcc
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final OccAgent occ;
        public final double t;
        public final DoorDir dir;
        public final double priority;

        public EnqueuedOcc(OccAgent occ, double t, DoorDir dir) {
            this.occ = occ;
            this.t = t;
            this.dir = dir;
            this.priority = occ.getOcc().priority;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof EnqueuedOcc && ((EnqueuedOcc)obj).occ == this.occ && ((EnqueuedOcc)obj).t == this.t && ((EnqueuedOcc)obj).dir == this.dir && ((EnqueuedOcc)obj).priority == this.priority;
        }
    }

    public static class UsageHistory
    implements Serializable {
        static final long serialVersionUID = 1L;
        private int count;

        public synchronized void increment() {
            ++this.count;
        }

        public int get() {
            return this.count;
        }
    }

    public static final class QueuePosition {
        public final DoorDir dir;
        public final int pos;
        public final double t;

        public QueuePosition(DoorDir dir, int pos, double t) {
            this.dir = dir;
            this.pos = pos;
            this.t = t;
        }
    }
}

