/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import common.geom.Trig;
import inferno.data2.ANode;
import inferno.data2.CylinderShape;
import inferno.data2.DoorDir;
import inferno.data2.Mesh;
import inferno.data2.Occupant;
import inferno.data2.PolygonShape;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.ai.ExitGoal;
import inferno.geom.Util;
import inferno.geom.WallSlider;
import inferno.sim.DoorQueue;
import inferno.sim.IAgent;
import inferno.sim.IFormationLeaderAgent;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Param;
import inferno.sim.ai.AiUtil;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathFilters;
import inferno.sim.steering.ITpSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class AssistedEvacClientAgent
implements IAgent,
IFormationLeaderAgent,
Serializable {
    static final long serialVersionUID = 1L;
    private Occupant occ;
    private transient OccAgent[] attachedAgents;
    private int requiredAttachedAgentsCount;
    private int reservedSpotsCount;
    private boolean isFullyOccupied = false;
    private boolean isUnoccupied = true;
    private boolean detach = false;
    private final TriPoint[] attachedAgentsPositions;
    private transient List<Pair<OccAgent, Double>> reservations = new ArrayList<Pair<OccAgent, Double>>();
    private transient Map<OccAgent, Integer> reservedSpots = new ConcurrentHashMap<OccAgent, Integer>();
    private int attachedAgentsCount;
    private transient Map<OccAgent, Integer> indexMap = new IdentityHashMap<OccAgent, Integer>();
    private PriorityQueue<Integer> remainingFreeAttachedAgentsPositions;
    private transient Map<DoorQueue, DoorCrossing> freePassDoors = new HashMap<DoorQueue, DoorCrossing>();
    private OccAgent agent;
    private List<Point3d> staticAttachedAgentsPositions;
    private KB kb;
    private boolean willEnd = false;

    public AssistedEvacClientAgent(Occupant occ, OccAgent agent, List<Point3d> getStaticAttachedAgentsPositions, KB kb) {
        this.occ = occ;
        this.agent = agent;
        this.staticAttachedAgentsPositions = getStaticAttachedAgentsPositions;
        this.kb = kb;
        this.requiredAttachedAgentsCount = getStaticAttachedAgentsPositions.size();
        this.attachedAgentsPositions = new TriPoint[this.requiredAttachedAgentsCount];
        Arrays.fill(this.attachedAgentsPositions, new TriPoint(null, new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY)));
        this.attachedAgents = new OccAgent[this.requiredAttachedAgentsCount];
        this.init(kb, kb.getParams());
    }

    public void writeSelfRefData(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.attachedAgents);
        oos.writeObject(this.freePassDoors);
        oos.writeObject(this.reservations);
        oos.writeObject(this.reservedSpots);
        oos.writeObject(this.indexMap);
    }

    public void readSelfRefData(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.attachedAgents = (OccAgent[])ois.readObject();
        this.freePassDoors = (Map)ois.readObject();
        this.reservations = (List)ois.readObject();
        this.reservedSpots = (Map)ois.readObject();
        this.indexMap = (Map)ois.readObject();
    }

    public void preMoveAssistedEvacClients(KB kb) {
        this.resolveReservations();
        OccAgent.UpdatePacket nextLoc = this.agent.getUpdatePacket();
        this.updateAttachedAgentsPositions(kb, this.occ.loc, this.occ.orient, nextLoc != null ? nextLoc.seek.transientPathFilter : Filters.alwaysTrue());
    }

    private boolean shouldHelpersDetach(KB kb) {
        double distToGoal;
        return this.attachedAgentsCount != 0 && AiUtil.getCurrentGoal(this.agent).getGoal() instanceof ExitGoal && Double.isFinite(distToGoal = this.agent.getPathFollow().getRemainingDistance(this.agent, true)) && distToGoal < this.occ.bodyShape.getEnclosingRadius() + 1.0;
    }

    private void resolveReservations() {
        this.reservations.sort(new Comparator<Pair<OccAgent, Double>>(){

            @Override
            public int compare(Pair<OccAgent, Double> o1, Pair<OccAgent, Double> o2) {
                int comp = Double.isInfinite((Double)o1.v2) && Double.isInfinite((Double)o2.v2) ? 0 : theUtil.compare((Double)o1.v2, (Double)o2.v2, 1.0E-6);
                if (comp != 0) {
                    return comp;
                }
                return -Double.compare(((OccAgent)o1.v1).getOcc().priority, ((OccAgent)o2.v1).getOcc().priority);
            }
        });
        for (Pair<OccAgent, Double> res : this.reservations) {
            OccAgent oa = (OccAgent)res.v1;
            if (this.reservedSpotsCount == this.requiredAttachedAgentsCount) break;
            if (this.reservedSpots.get(oa) != null) continue;
            if (this.remainingFreeAttachedAgentsPositions.isEmpty()) break;
            Integer spot = this.remainingFreeAttachedAgentsPositions.poll();
            ++this.reservedSpotsCount;
            this.reservedSpots.put(oa, spot);
        }
        this.reservations.clear();
    }

    @Override
    public boolean init(KB kb, Param p) {
        this.remainingFreeAttachedAgentsPositions = new PriorityQueue();
        this.updateAttachedAgentsPositions(kb, this.occ.loc, this.occ.orient, Filters.alwaysTrue());
        for (int id = 0; id < this.attachedAgentsPositions.length; ++id) {
            this.remainingFreeAttachedAgentsPositions.add(id);
        }
        this.update(kb, p, 0.0);
        return true;
    }

    public TriPoint getDesiredHelperPosition(KB kb, Point3d clientPos, Vector3d clientOrient, int spot, OccAgent helper, TriPoint oldHelperLoc, Predicate<PathChange> tPathFilter) {
        BiFunction<TriPoint, Point3d, TriPoint> findAttachedAgentPos = (helperLoc, pNew) -> {
            Predicate<PathChange> pathFilter = tPathFilter;
            Pair<ANode, DoorDir> targetDoor = this.agent.getTargetDoor(false);
            if (targetDoor != null) {
                Predicate<WingedEdge> rejectFlowrateDoors = EdgeFilters.rejectAllFlowrateDoors(kb);
                Predicate<PathChange> filter = Filters.or(PathFilters.filterEdges(rejectFlowrateDoors), PathFilters.acceptDoorDir((ANode)targetDoor.v1, (DoorDir)((Object)((Object)targetDoor.v2))));
                pathFilter = Filters.and(pathFilter, filter);
            }
            TriPoint newLoc1 = this.findPointOnMesh(this.agent.getLoc(), (Point3d)pNew, helper, pathFilter);
            if (helper == null || helperLoc == null || helperLoc.tri == null) {
                return newLoc1;
            }
            double dist1 = Util.dist2d(newLoc1.p, pNew);
            TriPoint newLoc2 = this.findPointOnMesh((TriPoint)helperLoc, (Point3d)pNew, helper, pathFilter);
            double dist2 = Util.dist2d(newLoc2.p, pNew);
            return dist1 <= dist2 ? newLoc1 : newLoc2;
        };
        Point3d pivot = clientPos;
        Point3d attachedAgentPos = this.staticAttachedAgentsPositions.get(spot);
        Point3d pNew2 = new Point3d(attachedAgentPos);
        pNew2.add(clientPos);
        Vector3d ref = new Vector3d(1.0, 0.0, clientPos.z);
        double angle = Trig.angle(ref, clientOrient);
        PolygonShape.rotatePoint(pNew2, pivot, angle);
        return pNew2.equals(oldHelperLoc.p) && oldHelperLoc.tri != null ? oldHelperLoc : findAttachedAgentPos.apply(oldHelperLoc, pNew2);
    }

    private void updateAttachedAgentsPositions(KB kb, Point3d position, Vector3d direction, Predicate<PathChange> tPathFilter) {
        OccAgent[] resSpots = new OccAgent[this.staticAttachedAgentsPositions.size()];
        for (Map.Entry<OccAgent, Integer> entry : this.reservedSpots.entrySet()) {
            resSpots[entry.getValue().intValue()] = entry.getKey();
        }
        for (int m = 0; m < this.staticAttachedAgentsPositions.size(); ++m) {
            TriPoint oldLoc = this.attachedAgentsPositions[m];
            OccAgent helper = this.attachedAgents[m];
            if (helper == null) {
                helper = resSpots[m];
            }
            this.attachedAgentsPositions[m] = this.getDesiredHelperPosition(kb, position, direction, m, helper, oldLoc, tPathFilter);
        }
    }

    public synchronized boolean attachAgent(OccAgent agent, ITpSource spot) {
        if (spot instanceof ITpSource.BackupTpSource) {
            spot = ((ITpSource.BackupTpSource)spot).desired;
        }
        assert (spot instanceof AttachmentTpSrc);
        if (!(spot instanceof AttachmentTpSrc)) {
            return false;
        }
        int index = ((AttachmentTpSrc)spot).ix;
        assert (index != -1);
        this.attachedAgents[index] = agent;
        this.indexMap.put(agent, index);
        agent.getOcc().isPassive = true;
        agent.getOcc().formationLeader = this;
        ++this.attachedAgentsCount;
        return true;
    }

    public boolean isFullyOccupied() {
        return this.isFullyOccupied;
    }

    public boolean isUnoccupied() {
        return this.isUnoccupied;
    }

    public boolean shouldDetach() {
        return this.detach || this.agent.isDone();
    }

    public synchronized void detachAgent(OccAgent agent) {
        for (int i = 0; i < this.attachedAgents.length; ++i) {
            if (this.attachedAgents[i] == null || !this.attachedAgents[i].equals(agent)) continue;
            this.attachedAgents[i] = null;
            this.indexMap.remove(agent);
            agent.getOcc().isPassive = false;
            agent.getOcc().formationLeader = null;
            --this.attachedAgentsCount;
            this.cancelReservation(agent);
            break;
        }
        if (this.attachedAgentsCount == 0) {
            this.updateMovement();
            this.willEnd = true;
        }
    }

    public synchronized void requestReservation(OccAgent agent, double dist) {
        this.reservations.add(new Pair<OccAgent, Double>(agent, dist));
    }

    public synchronized boolean cancelReservation(OccAgent agent) {
        Integer spot = this.reservedSpots.get(agent);
        if (spot != null) {
            this.reservedSpots.remove(agent);
            --this.reservedSpotsCount;
            this.remainingFreeAttachedAgentsPositions.add(spot);
            return true;
        }
        return false;
    }

    public AttachmentTpSrc getReservedSpot(OccAgent agent) {
        Integer spot = this.reservedSpots.get(agent);
        if (spot == null) {
            return null;
        }
        return new AttachmentTpSrc(this, spot);
    }

    public ITpSource getReservedSpotWithBackup(OccAgent agent) {
        AttachmentTpSrc spot = this.getReservedSpot(agent);
        if (spot == null) {
            return null;
        }
        return new ITpSource.BackupTpSource(spot, new ITpSource.AgentTpSource(agent));
    }

    public synchronized ITpSource getAttachedAgentsPos(OccAgent agent) {
        Integer index = this.indexMap.get(agent);
        assert (index != null);
        return new AttachmentTpSrc(this, index);
    }

    public boolean isAttached(OccAgent agent) {
        return this.getAttachedSpot(agent) != -1;
    }

    public int getAttachedSpot(OccAgent agent) {
        for (int i = 0; i < this.attachedAgents.length; ++i) {
            if (!Objects.equals(this.attachedAgents[i], agent)) continue;
            return i;
        }
        return -1;
    }

    public Set<OccAgent> getReservedSpots() {
        return this.reservedSpots.keySet();
    }

    public boolean isPartiallyReserved() {
        return this.reservedSpotsCount > 0 && this.reservedSpotsCount < this.requiredAttachedAgentsCount;
    }

    public boolean isFullyReserved() {
        return this.reservedSpotsCount == this.requiredAttachedAgentsCount;
    }

    public int getMissingReservationCount() {
        return this.requiredAttachedAgentsCount - this.reservedSpotsCount;
    }

    public int getMissingAttachedAgentsCount() {
        return this.requiredAttachedAgentsCount - this.attachedAgentsCount;
    }

    public int getAttachedAgentsCount() {
        return this.attachedAgentsCount;
    }

    public int getRequiredAttachedAgentsCount() {
        return this.requiredAttachedAgentsCount;
    }

    @Override
    public List<OccAgent> getFormation() {
        ArrayList<OccAgent> formation = new ArrayList<OccAgent>();
        this.getFormation(formation::add);
        return formation;
    }

    public void getFormation(Consumer<OccAgent> formation) {
        formation.accept(this.agent);
        for (OccAgent agent : this.attachedAgents) {
            if (agent == null) continue;
            formation.accept(agent);
        }
    }

    @Override
    public int getFormationSize() {
        return this.getFormation().size();
    }

    @Override
    public void formationCrossingDoor(DoorQueue door, OccAgent crossingAgent, DoorDir doorDir) {
        DoorCrossing dc = this.freePassDoors.get(door);
        if (dc == null) {
            ArrayList<OccAgent> agents = new ArrayList<OccAgent>(Arrays.asList(this.attachedAgents));
            agents.add(this.agent);
            dc = new DoorCrossing(agents, doorDir);
            this.freePassDoors.put(door, dc);
        }
        if (doorDir.equals((Object)dc.doorDir)) {
            dc.addCrossing(crossingAgent);
        } else {
            dc.removeCrossing(crossingAgent);
        }
        if (dc.allCrossed() || dc.allBackedUp()) {
            this.freePassDoors.remove(door);
        }
    }

    @Override
    public boolean isFreePassDoor(DoorQueue door) {
        return this.freePassDoors.containsKey(door);
    }

    @Override
    public boolean isPartiallyInNodeFormation(ANode node) {
        return this.getFormation().stream().anyMatch(agent -> Objects.equals(agent.getOcc().curNode, node));
    }

    @Override
    public boolean formationInLimitedNode() {
        List<OccAgent> formation = this.getFormation();
        if (formation.isEmpty()) {
            return false;
        }
        for (OccAgent a : formation) {
            if (a.getOcc().curNode.getMaxOccupants() == Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    private TriPoint findPointOnMesh(TriPoint startLoc, Point3d pNew, OccAgent helper, Predicate<PathChange> pathFilter) {
        double distLast;
        Mesh mesh = this.kb.getMesh();
        if (helper == null) {
            return new TriPoint(null, pNew);
        }
        double traceRadius = Math.min(this.agent.getGeometryRadius(), helper != null ? helper.getGeometryRadius() : Double.POSITIVE_INFINITY);
        TriPoint lastValidLoc = startLoc;
        Vector3d dir = Util3D.vector(startLoc.p, pNew);
        dir.z = 0.0;
        double dist = distLast = dir.length();
        double distTol = 0.1;
        while (dist > distTol) {
            Mesh.ShapeTrace trace = mesh.traceMovingShape(lastValidLoc, dir, pathFilter, 1.0, new CylinderShape(lastValidLoc.p, traceRadius, traceRadius, 0.0, dir, this.occ.id));
            if (trace == null) {
                return lastValidLoc;
            }
            dist = Util.dist2d(trace.loc.p, pNew);
            if (dist >= distLast) {
                return lastValidLoc;
            }
            if (dist <= distTol) {
                return trace.loc;
            }
            lastValidLoc = trace.loc;
            distLast = dist;
            Vector3d newDir = Util3D.vector(lastValidLoc.p, pNew);
            newDir.z = 0.0;
            if (trace.boundary != null) {
                WallSlider slider = new WallSlider(lastValidLoc.p, pathFilter, Collections.singletonList(trace.boundary));
                newDir = slider.slide(newDir, false);
            }
            dir = newDir;
        }
        return lastValidLoc;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public void preMove(KB kb, Param p, double dt) {
    }

    @Override
    public void update(KB kb, Param p, double dt) {
        this.isFullyOccupied = this.attachedAgentsCount == this.requiredAttachedAgentsCount;
        boolean bl = this.isUnoccupied = this.attachedAgentsCount == 0;
        if (this.attachedAgentsCount == 0) {
            if (this.occ.formationLeader == this) {
                this.occ.formationLeader = null;
            }
        } else {
            assert (this.occ.formationLeader == null || this.occ.formationLeader == this) : String.format("Formation leader unexpectedly set to %s", this.occ.formationLeader.getName());
            if (this.occ.formationLeader == null) {
                this.occ.formationLeader = this;
            }
        }
        this.updateMovement();
    }

    private void updateMovement() {
        if (this.shouldHelpersDetach(this.kb)) {
            this.detach = true;
            this.agent.getOcc().requiresAssistance = false;
            this.reservedSpots.clear();
        }
        this.updateCanMove();
    }

    public void updateCanMove() {
        boolean canMove = !this.occ.requiresAssistance || this.isFullyOccupied() || this.detach;
        this.agent.setCanMove(canMove);
    }

    @Override
    public String getName() {
        return this.agent.getName();
    }

    @Override
    public OccAgent getOccAgent() {
        return this.agent;
    }

    @Override
    public int getFormationCorrespondingOccCount() {
        int correspondingOccCount = 0;
        for (OccAgent a : this.getFormation()) {
            correspondingOccCount += a.getCorrespondingOccCount();
        }
        return correspondingOccCount;
    }

    public Occupant getOcc() {
        return this.getOccAgent().getOcc();
    }

    public boolean willEnd() {
        return this.willEnd;
    }

    public static class AttachmentTpSrc
    implements ITpSource,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final AssistedEvacClientAgent agent;
        public final int ix;
        public final TriPoint loc;

        public AttachmentTpSrc(AssistedEvacClientAgent agent, int ix) {
            this.agent = agent;
            this.ix = ix;
            this.loc = agent.attachedAgentsPositions[ix];
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof AttachmentTpSrc && ((AttachmentTpSrc)obj).agent == this.agent && ((AttachmentTpSrc)obj).ix == this.ix;
        }

        public int hashCode() {
            return 0x11238BE ^ System.identityHashCode(this.agent) + this.ix;
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public TriPoint getTriPoint() {
            return this.loc;
        }
    }

    private static class DoorCrossing
    implements Serializable {
        static final long serialVersionUID = 1L;
        private HashMap<OccAgent, Boolean> passedThrough = new HashMap();
        private DoorDir doorDir;

        public DoorCrossing(List<OccAgent> agents, DoorDir doorDir) {
            this.doorDir = doorDir;
            for (OccAgent agent : agents) {
                this.passedThrough.put(agent, false);
            }
        }

        public boolean allCrossed() {
            for (Boolean crossed : this.passedThrough.values()) {
                if (crossed.booleanValue()) continue;
                return false;
            }
            return true;
        }

        public boolean allBackedUp() {
            for (Boolean crossed : this.passedThrough.values()) {
                if (!crossed.booleanValue()) continue;
                return false;
            }
            return true;
        }

        public void addCrossing(OccAgent crossingAgent) {
            this.passedThrough.put(crossingAgent, true);
        }

        public void removeCrossing(OccAgent crossingAgent) {
            this.passedThrough.put(crossingAgent, false);
        }
    }
}

