/*
 * Decompiled with CFR 0.152.
 */
package inferno.io.fdsout;

import inferno.io.fdsout.DataFinder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import vtk.vtkCharArray;
import vtk.vtkCompositeDataProbeFilter;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkFloatArray;
import vtk.vtkPointData;
import vtk.vtkPoints;
import vtk.vtkUnstructuredGrid;

public class DataInquisitor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<Integer, SoftReference<vtkDataObject>> d_memoGetVtkDataAt = new HashMap<Integer, SoftReference<vtkDataObject>>();
    private DataFinder d_source;
    private long d_lastUpdate;

    public DataInquisitor(DataFinder source) {
        this.d_source = source;
        this.d_lastUpdate = Long.MIN_VALUE;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.d_memoGetVtkDataAt = new HashMap<Integer, SoftReference<vtkDataObject>>();
    }

    public String toString() {
        return String.format("DataInquisitor[d_source=%s,d_lastUpdate=%s]", this.d_source.getClass().getSimpleName(), this.d_lastUpdate);
    }

    public double[] getTimeRange() {
        Float[] times = this.d_source.getTimes();
        if (times.length < 2) {
            return new double[]{0.0, 0.0};
        }
        return new double[]{times[0].floatValue(), times[times.length - 1].floatValue()};
    }

    public DataFinder.Quantity[] getQuantities() {
        try {
            this.update();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.d_source.getQuantities();
    }

    public void update() throws IOException {
        if (this.d_lastUpdate < this.d_source.getLastModified()) {
            this.d_source.update();
            this.d_lastUpdate = this.d_source.getLastModified();
        }
    }

    public double[][] probeInterp(float t, List<Point3d> pts) {
        Object[] times = this.d_source.getTimes();
        if (times.length == 0) {
            return new double[0][];
        }
        int pos = Arrays.binarySearch(times, Float.valueOf(t));
        if (0 <= pos) {
            return this.probeDirect(pos, pts);
        }
        int insertAt = -(pos + 1);
        if (insertAt == 0) {
            return this.probeDirect(0, pts);
        }
        if (insertAt == times.length) {
            return this.probeDirect(insertAt - 1, pts);
        }
        double dt = ((Float)times[insertAt]).floatValue() - ((Float)times[insertAt - 1]).floatValue();
        double f0 = (double)(t - ((Float)times[insertAt - 1]).floatValue()) / dt;
        double f1 = 1.0 - f0;
        double[][] v0 = this.probeDirect(insertAt - 1, pts);
        double[][] v1 = this.probeDirect(insertAt, pts);
        double[][] v = new double[pts.size()][v0[0].length];
        for (int j = 0; j < pts.size(); ++j) {
            for (int i = 0; i < v[j].length; ++i) {
                v[j][i] = f0 * v0[j][i] + f1 * v1[j][i];
            }
        }
        return v;
    }

    private vtkDataObject memoGetVtkDataAt(int tPos) {
        SoftReference<vtkDataObject> ref;
        vtkDataObject obj;
        if (this.d_memoGetVtkDataAt.containsKey(tPos) && (obj = (ref = this.d_memoGetVtkDataAt.get(tPos)).get()) != null) {
            return obj;
        }
        vtkDataObject plt3dData = this.d_source.getVtkDataAt(tPos);
        SoftReference<vtkDataObject> ref2 = new SoftReference<vtkDataObject>(plt3dData);
        this.d_memoGetVtkDataAt.put(tPos, ref2);
        return plt3dData;
    }

    public double[][] probeDirect(int tPos, List<Point3d> ptsJava) {
        return this.probeDirectVTK(tPos, ptsJava);
    }

    private static double[] convertFloatsToDoubles(float[] input) {
        if (input == null) {
            return null;
        }
        double[] output = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    public double[][] probeDirectVTK(int tPos, List<Point3d> ptsJava) {
        vtkDataObject plt3dData = this.memoGetVtkDataAt(tPos);
        vtkPoints pts = new vtkPoints();
        float[] ptsJavaArr = new float[ptsJava.size() * 3];
        int ix = 0;
        for (Point3d p : ptsJava) {
            ptsJavaArr[ix++] = (float)p.x;
            ptsJavaArr[ix++] = (float)p.y;
            ptsJavaArr[ix++] = (float)p.z;
        }
        vtkFloatArray vtkArray = new vtkFloatArray();
        vtkArray.SetNumberOfComponents(3);
        vtkArray.SetJavaArray(ptsJavaArr);
        pts.SetData(vtkArray);
        vtkUnstructuredGrid ptsGrid = new vtkUnstructuredGrid();
        ptsGrid.SetPoints(pts);
        vtkCompositeDataProbeFilter probe = new vtkCompositeDataProbeFilter();
        probe.SetSourceData(plt3dData);
        probe.SetInputData(ptsGrid);
        probe.SetPassPartialArrays(true);
        probe.Update();
        return this.dataSetToArray(probe.GetOutput());
    }

    private double[][] dataSetToArray(vtkDataSet ds) {
        int n = ds.GetNumberOfPoints();
        vtkPointData pd = ds.GetPointData();
        int numArrays = pd.GetNumberOfArrays();
        double[][] values = new double[ds.GetNumberOfPoints()][numArrays];
        for (int ai = 0; ai < numArrays; ++ai) {
            int i;
            vtkDataArray array = pd.GetArray(ai);
            if (array instanceof vtkFloatArray) {
                float[] arr = ((vtkFloatArray)array).GetJavaArray();
                for (i = 0; i < n; ++i) {
                    values[i][ai] = arr[i];
                }
                continue;
            }
            if (array instanceof vtkCharArray) {
                char[] arr = ((vtkCharArray)array).GetJavaArray();
                for (i = 0; i < n; ++i) {
                    values[i][ai] = arr[i];
                }
                continue;
            }
            for (int i2 = 0; i2 < n; ++i2) {
                values[i2][ai] = array.GetTuple1(i2);
            }
        }
        return values;
    }
}

