/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import inferno.data2.TriPoint;
import inferno.geom.ConnectedMesh;
import inferno.geom.IValueField;
import java.io.Serializable;
import java.util.function.IntToDoubleFunction;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.TriInterpolator3d;

public class ValueFld
implements Serializable,
IValueField<Double> {
    static final long serialVersionUID = 1L;
    public final int id;
    public final IntToDoubleFunction vertVals;
    public final ConnectedMesh mesh;
    public final TriInterpolator3d[] triInfo;
    public final double[] dataBounds;

    public ValueFld(int id, ConnectedMesh nodeMesh, TriInterpolator3d[] triInfo, float[] vertVals, float[] dataBounds) {
        this(id, nodeMesh, triInfo, new FloatVals(vertVals), new double[]{dataBounds[0], dataBounds[1]});
    }

    public ValueFld(int id, ConnectedMesh nodeMesh, TriInterpolator3d[] triInfo, double[] vertVals, double[] dataBounds) {
        this(id, nodeMesh, triInfo, new DoubleVals(vertVals), dataBounds);
    }

    public ValueFld(int id, ConnectedMesh nodeMesh, TriInterpolator3d[] triInfo, IntToDoubleFunction vertVals, double[] dataBounds) {
        this.id = id;
        this.mesh = nodeMesh;
        this.triInfo = triInfo;
        this.vertVals = vertVals;
        this.dataBounds = dataBounds;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValueFld)) {
            return false;
        }
        return this.id == ((ValueFld)obj).id;
    }

    @Override
    public Double getValue(TriPoint tp) {
        ConnectedMesh.Tri tri = this.mesh.find(tp.p);
        if (tri == null) {
            return Double.NaN;
        }
        return this.getValue(tri, tp.p);
    }

    public double getValue(ConnectedMesh.Tri tri, Point3d p) {
        double v1 = this.vertVals.applyAsDouble(tri.verts[0].id);
        double v2 = this.vertVals.applyAsDouble(tri.verts[1].id);
        double v3 = this.vertVals.applyAsDouble(tri.verts[2].id);
        return this.triInfo[tri.id].interpolate(p, v1, v2, v3);
    }

    public static TriInterpolator3d[] calcTriInfo(ConnectedMesh mesh) {
        TriInterpolator3d[] tris = new TriInterpolator3d[mesh.tris.length];
        for (int m = 0; m < mesh.tris.length; ++m) {
            ConnectedMesh.Tri t = mesh.tris[m];
            tris[m] = new TriInterpolator3d(t.verts[0].p, t.verts[1].p, t.verts[2].p);
        }
        return tris;
    }

    private static class DoubleVals
    implements Serializable,
    IntToDoubleFunction {
        public final double[] vals;

        public DoubleVals(double[] vals) {
            this.vals = vals;
        }

        @Override
        public double applyAsDouble(int value) {
            return this.vals[value];
        }
    }

    private static class FloatVals
    implements Serializable,
    IntToDoubleFunction {
        public final float[] vals;

        public FloatVals(float[] vals) {
            this.vals = vals;
        }

        @Override
        public double applyAsDouble(int value) {
            return this.vals[value];
        }
    }
}

