/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import inferno.data2.Edge;
import inferno.data2.Mesh;
import inferno.data2.Occupant;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.geom.Inter;
import inferno.geom.Plane3d;
import inferno.geom.PreciseGeom;
import inferno.geom.SeekCurve;
import inferno.geom.WallSlider;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.PathChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Spline3D;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class Util {
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());
    public static final int[] PLUS1MOD3 = new int[]{1, 2, 0};
    public static final int[] MINUS1MOD3 = new int[]{2, 0, 1};

    public static boolean isValid(Tuple3d t) {
        return !Double.isNaN(t.x) && !Double.isNaN(t.y) && !Double.isNaN(t.z);
    }

    public static Point3d edgeCenter(Point3d l1, Point3d l2) {
        return new Point3d((l1.x + l2.x) * 0.5, (l1.y + l2.y) * 0.5, (l1.z + l2.z) * 0.5);
    }

    public static TriPoint traverseSingleTriangle(TriPoint start, Vector3d velocity, double t) {
        Point3d p = Util3D.linePoint(start.p, velocity, t);
        return new TriPoint(start.tri, p);
    }

    public static double projectTAlongZ(Vector3d ldir, double t) {
        double dx2dy2 = Util.lengthSquared2d(ldir);
        return t * Math.sqrt(1.0 + ldir.z * ldir.z / dx2dy2);
    }

    public static Vector3d projectAlongZ(Plane3d plane, Vector3d dir) {
        return Util.projectAlongZ(new Vector3d(), plane, dir, true);
    }

    public static Vector3d projectAlongZEq(Plane3d plane, Vector3d dir) {
        return Util.projectAlongZ(dir, plane, dir, true);
    }

    public static Vector3d projectAlongZ(Vector3d result, Plane3d plane, Vector3d dir, boolean reLengthen) {
        double tol = 1.0E-12;
        if (theUtil.eq0(dir.x, 1.0E-12) && theUtil.eq0(dir.y, 1.0E-12) || theUtil.eq0(plane.z, 1.0E-12) || theUtil.eq0(plane.x * dir.x + plane.y * dir.y + plane.z * dir.z, 1.0E-12)) {
            result.set(dir);
            return result;
        }
        double dirz = (-plane.x * dir.x - plane.y * dir.y) / plane.z;
        if (reLengthen) {
            double len = dir.length();
            result.set(dir.x, dir.y, dirz);
            Util3D.safeNormalize(result, 1.0E-12);
            result.scale(len);
        } else {
            result.set(dir.x, dir.y, dirz);
        }
        return result;
    }

    public static Point3d projectAlongZ(Point3d pOut, Point3d pIn, Plane3d plane) {
        if (plane.z == 0.0) {
            pOut.set(pIn);
            return pOut;
        }
        double newz = -(plane.w + plane.x * pIn.x + plane.y * pIn.y) / plane.z;
        pOut.set(pIn.x, pIn.y, newz);
        return pOut;
    }

    public static TriPoint traceInTri(Tri tri, Point3d source, Vector3d dir, double t) {
        return new TriPoint(tri, Util.projectAlongZEq(Util3D.linePoint(source, dir, t), tri.plane));
    }

    public static Point3d projectAlongZEq(Point3d p, Plane3d plane) {
        Util.projectAlongZ(p, p, plane);
        return p;
    }

    public static Point3d projectAlongZ(Point3d p, Plane3d plane) {
        Point3d pOut = new Point3d();
        Util.projectAlongZ(pOut, p, plane);
        return pOut;
    }

    public static double getAngle(Vector3d vec, thunderheadeng.geometry.Plane3d plane) {
        double angle;
        Vector3d normal = plane.getNormal();
        Vector3d projectedVec = Util.reject(vec, normal);
        double d = angle = theUtil.eq0(projectedVec.lengthSquared(), 1.0E-9) ? 1.5707963267948966 : projectedVec.angle(vec);
        if (vec.dot(normal) < 0.0) {
            angle = -angle;
        }
        return angle;
    }

    public static Vector3d project(Vector3d vec, thunderheadeng.geometry.Plane3d plane, boolean reLengthen) {
        Vector3d normal = plane.getNormal();
        Vector3d rejection = Util.reject(vec, normal);
        if (reLengthen) {
            double len = Util3D.safeNormalize(rejection, 1.0E-9);
            if (len == 0.0) {
                return null;
            }
            rejection.scale(vec.length());
        }
        return rejection;
    }

    public static Vector3d reject(Vector3d a, Vector3d b) {
        assert (theUtil.eq(b.length(), 1.0, 1.0E-6));
        double dot = a.dot(b);
        return new Vector3d(a.x - b.x * dot, a.y - b.y * dot, a.z - b.z * dot);
    }

    public static Pair<Vector3d, Point3d> getWallNorm(WingedEdge edge, Point3d relLoc) {
        Point3d pOnWall;
        Edge wall = edge.base;
        double wdx = wall.n2.p.x - wall.n1.p.x;
        double wdy = wall.n2.p.y - wall.n1.p.y;
        if (theUtil.eq0(wdx * wdx + wdy * wdy, 1.0E-9)) {
            pOnWall = wall.n1.p;
        } else {
            double t = Inter2D.nearestTOnLine(wall.n1.p.x, wall.n1.p.y, wdx, wdy, relLoc.x, relLoc.y);
            if (t < 0.0) {
                t = 0.0;
            } else if (t > 1.0) {
                t = 1.0;
            }
            pOnWall = Util3D.linesegPoint(wall.n1.p, wall.n2.p, t);
        }
        Vector3d wallNorm = Util.vector2d(pOnWall, relLoc);
        double len = Util.safeNormalize(wallNorm, 1.0E-12);
        if (len == 0.0) {
            return null;
        }
        return new Pair<Vector3d, Point3d>(wallNorm, pOnWall);
    }

    public static Vector3d getWallNorm(WingedEdge edge, Predicate<PathChange> pathFilter) {
        Vertex v2;
        Vertex v1;
        Tri t;
        if (edge.t1 == null) {
            t = edge.t2;
        } else if (edge.t2 == null) {
            t = edge.t1;
        } else {
            PathChange pc = new PathChange(edge.t1, edge);
            Tri tri = t = !pathFilter.test(pc) ? edge.t2 : edge.t1;
        }
        if (t == edge.t1) {
            v1 = edge.base.n1;
            v2 = edge.base.n2;
        } else {
            v1 = edge.base.n2;
            v2 = edge.base.n1;
        }
        double dx = v2.p.x - v1.p.x;
        double dy = v2.p.y - v1.p.y;
        Vector3d wallNorm = new Vector3d(-dy, dx, 0.0);
        if (Util.safeNormalize(wallNorm, 1.0E-9) == 0.0) {
            return null;
        }
        return wallNorm;
    }

    public static Pair<Vector3d, Point3d> getWallNorm(WingedEdge edge, Predicate<PathChange> pathFilter, Point3d relLoc) {
        Pair<Vector3d, Point3d> wallNorm = Util.getWallNorm(edge, relLoc);
        if (wallNorm == null) {
            Point3d e2;
            Point3d e1;
            double t;
            Vector3d vec = Util.getWallNorm(edge, pathFilter);
            if (vec == null) {
                vec = new Vector3d(1.0, 0.0, 0.0);
            }
            if (Double.isNaN(t = Util.tOnLineSeg2d(e1 = edge.p1(), e2 = edge.p2(), relLoc))) {
                t = Inter3D.nearestTOnLineSeg(e1, e2, relLoc);
            } else if (t > 1.0) {
                t = 1.0;
            } else if (t < 0.0) {
                t = 0.0;
            }
            Point3d p = Util3D.linesegPoint(e1, e2, t);
            wallNorm = new Pair<Vector3d, Point3d>(vec, p);
        }
        return wallNorm;
    }

    public static Vector3d getSlideDir(OccAgent agent, Vector3d proposedDir, WallSlider slider, boolean normalize, boolean alignWithTri) {
        Vector3d result = slider.slide(proposedDir, normalize);
        if (alignWithTri) {
            Util.projectAlongZEq(agent.getOcc().tri.plane, result);
        }
        return result;
    }

    public static WallSlider getWallSlider(KB kb, OccAgent agent, Predicate<PathChange> pathSlideFilter) {
        double nearRadius;
        Occupant occ = agent.getOcc();
        double searchRadius = nearRadius = kb.getMesh().getCachedRadius(agent.getGeometryRadius()) + 0.001;
        if (agent.getOcc().tri.testAnyFlags(1)) {
            double maxVel = OccAgent.getTotalMaxVel(kb, occ);
            searchRadius += maxVel * kb.getDt();
        }
        List<Mesh.EdgeDist> closeBoundaries = kb.getMesh().getCloseBoundaries(occ.tri, occ.loc, occ.curNode, nearRadius, searchRadius, pathSlideFilter);
        return new WallSlider(agent.getPos(), pathSlideFilter, new ArrayList<WingedEdge>(theUtil.map(closeBoundaries, ed -> ed.edge)));
    }

    public static IParametric3D newCurve(Point3d ... points) {
        if (points.length == 2) {
            return new LineSeg3D(points[0], points[1]);
        }
        Point3d p1 = points[0];
        Point3d p2 = points[points.length - 1];
        Point3d c1 = points[1];
        Point3d c2 = points.length == 4 ? points[2] : c1;
        boolean c1p1eq = c1.epsilonEquals(p1, 1.0E-6);
        boolean c2p2eq = c2.epsilonEquals(p2, 1.0E-6);
        if (c1p1eq && c2p2eq) {
            return new LineSeg3D(p1, p2);
        }
        if (c1p1eq) {
            return new Spline3D.Quadratic(p1, c2, p2);
        }
        if (c2p2eq) {
            return new Spline3D.Quadratic(p1, c1, p2);
        }
        if (c1.epsilonEquals(c2, 1.0E-6)) {
            return new Spline3D.Quadratic(p1, c1, p2);
        }
        return new Spline3D.Cubic(p1, c1, c2, p2);
    }

    public static void rotate(Vector3d axis, double theta, Vector3d vOrig, Vector3d vDest) {
        if (vDest == null) {
            return;
        }
        Matrix3d rotate_xform = new Matrix3d();
        AxisAngle4d rotate_rot = new AxisAngle4d();
        rotate_rot.set(axis, theta);
        rotate_xform.set(rotate_rot);
        vDest.set(vOrig);
        rotate_xform.transform(vDest);
    }

    public static double[] getTriInterpParams(Point3d pt, Point3d a, Point3d b, Point3d c) {
        return Util.getTriInterpParams(pt.distance(a), pt.distance(b), pt.distance(c));
    }

    public static double[] getTriInterpParams(Point2d pt, Point2d a, Point2d b, Point2d c) {
        return Util.getTriInterpParams(pt.distance(a), pt.distance(b), pt.distance(c));
    }

    private static double[] getTriInterpParams(double d1, double d2, double d3) {
        double sumDiff = d1 + d2 + d3;
        double f1 = 1.0 - d1 / sumDiff;
        double f2 = 1.0 - d2 / sumDiff;
        double f3 = 1.0 - d3 / sumDiff;
        return new double[]{f1, f2, f3};
    }

    public static double triInterp(double[] interpParams, double aVal, double bVal, double cVal) {
        return interpParams[0] * aVal + interpParams[1] * bVal + interpParams[2] * cVal;
    }

    public static double triInterp(Point3d pt, Point3d a, Point3d b, Point3d c, double aVal, double bVal, double cVal) {
        double[] f = Util.getTriInterpParams(pt, a, b, c);
        return Util.triInterp(f, aVal, bVal, cVal);
    }

    public static Vector3d triInterp(Point3d pt, Point3d a, Point3d b, Point3d c, Vector3d aVal, Vector3d bVal, Vector3d cVal) {
        double[] f = Util.getTriInterpParams(pt, a, b, c);
        return new Vector3d(Util.triInterp(f, aVal.x, bVal.x, cVal.x), Util.triInterp(f, aVal.y, bVal.y, cVal.y), Util.triInterp(f, aVal.z, bVal.z, cVal.z));
    }

    public static Point3d triCenter(Point3d a, Point3d b, Point3d c) {
        return new Point3d((a.x + b.x + c.x) / 3.0, (a.y + b.y + c.y) / 3.0, (a.z + b.z + c.z) / 3.0);
    }

    public static Vector3d triNormal(Point3d p1, Point3d p2, Point3d p3) {
        Vector3d v1 = new Vector3d();
        v1.sub(p2, p1);
        Vector3d v2 = new Vector3d();
        v2.sub(p3, p1);
        Vector3d normal = new Vector3d();
        normal.cross(v1, v2);
        normal.normalize();
        return normal;
    }

    public static Vector3d dirToMax(Point3d p1, Point3d p2, Point3d p3, double v1, double v2, double v3) {
        Vector3d grad = Util.gradient(p1, p2, p3, v1, v2, v3);
        Vector3d dir = new Vector3d(grad.x, grad.y, grad.z);
        return dir;
    }

    public static Vector3d dirToMin(Point3d p1, Point3d p2, Point3d p3, double v1, double v2, double v3) {
        Vector3d grad = Util.gradient(p1, p2, p3, v1, v2, v3);
        return new Vector3d(-grad.x, -grad.y, -grad.z);
    }

    private static Vector3d gradient(Point3d p1, Point3d p2, Point3d p3, double v1, double v2, double v3) {
        Matrix3d r = Util.getR(p1, p2, p3);
        Matrix3d rInv = new Matrix3d();
        rInv.invert(r);
        Vector3d x1 = new Vector3d(0.0, 0.0, 0.0);
        Vector3d x2 = new Vector3d(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
        Vector3d x3 = new Vector3d(p3.x - p1.x, p3.y - p1.y, p3.z - p1.z);
        rInv.transform(x1);
        rInv.transform(x2);
        rInv.transform(x3);
        Vector3d coef = Util.fitPlane(x1, x2, x3, v1, v2, v3);
        Vector3d grad = new Vector3d(coef.y, coef.z, 0.0);
        r.transform(grad);
        grad.normalize();
        assert (!Double.isNaN(grad.x));
        assert (!Double.isNaN(grad.y));
        assert (!Double.isNaN(grad.z));
        return grad;
    }

    private static Vector3d fitPlane(Vector3d x1, Vector3d x2, Vector3d x3, double v1, double v2, double v3) {
        Matrix3d m = new Matrix3d();
        m.m00 = 1.0;
        m.m01 = x1.x;
        m.m02 = x1.y;
        m.m10 = 1.0;
        m.m11 = x2.x;
        m.m12 = x2.y;
        m.m20 = 1.0;
        m.m21 = x3.x;
        m.m22 = x3.y;
        m.invert();
        Vector3d coef = new Vector3d(v1, v2, v3);
        m.transform(coef);
        return coef;
    }

    public static Matrix3d getR(Point3d p1, Point3d p2, Point3d p3) {
        Matrix3d r = new Matrix3d();
        Vector3d e1 = new Vector3d();
        Vector3d e2 = new Vector3d();
        Vector3d e3 = new Vector3d();
        Util.basisVectors(p1, p2, p3, e1, e2, e3);
        r.m00 = e1.x;
        r.m01 = e2.x;
        r.m02 = e3.x;
        r.m10 = e1.y;
        r.m11 = e2.y;
        r.m12 = e3.y;
        r.m20 = e1.z;
        r.m21 = e2.z;
        r.m22 = e3.z;
        return r;
    }

    public static void constrain(Vector3d v, double d) {
        if (v.length() > d) {
            Util.truncate(v, d);
        } else if (v.length() != 0.0) {
            double ratio = d / v.length();
            v.x = ratio * v.x;
            v.y = ratio * v.y;
        }
    }

    public static void makeVecParallel(Point3d loc, Vector3d vec, Plane3d plane) {
        Point3d pos = new Point3d();
        pos.add(loc, vec);
        double dist = plane.dot(pos);
        if (dist == 0.0) {
            return;
        }
        Vector3d offset = new Vector3d();
        offset.scale(-dist, plane.getNormal());
        pos.add(offset);
        double vecLen = vec.length();
        vec.sub(pos, loc);
        vec.normalize();
        vec.scale(vecLen);
    }

    public static void truncate(Vector3d v, double maxlen) {
        double vlen = v.length();
        if (vlen == 0.0) {
            return;
        }
        double ratio = 0.99999 * (maxlen / vlen);
        if (ratio < 1.0) {
            v.scale(ratio);
        }
        assert (v.length() <= maxlen);
    }

    public static void basisVectors(Point3d p1, Point3d p2, Point3d p3, Vector3d e1, Vector3d e2, Vector3d e3) {
        Vector3d v1 = new Vector3d(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
        v1.normalize();
        e1.set(v1);
        Vector3d v2 = new Vector3d(p3.x - p1.x, p3.y - p1.y, p3.z - p1.z);
        e3.cross(v1, v2);
        e3.normalize();
        e2.cross(e3, e1);
    }

    public static double triArea(Point3d a, Point3d b, Point3d c) {
        Vector3d ab = new Vector3d(b.x - a.x, b.y - a.y, b.z - a.z);
        Vector3d ac = new Vector3d(c.x - a.x, c.y - a.y, c.z - a.z);
        return Inter.cross(ab, ac).length() / 2.0;
    }

    public static double lerp(double v1, double v2, double t) {
        return v1 + (v2 - v1) * t;
    }

    public static <T extends Tuple3d> T lerp(T v1, T v2, double t, T result) {
        result.set(Util.lerp(v1.x, v2.x, t), Util.lerp(v1.y, v2.y, t), Util.lerp(v1.z, v2.z, t));
        return result;
    }

    public static double getSlope(Vector3d normal) {
        if (normal.z == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.sqrt(normal.x * normal.x + normal.y * normal.y) / normal.z;
    }

    public static double getSlope(double angle) {
        return 1.0 / Math.cos(angle);
    }

    public static WingedEdge getSharedEdge(Tri t1, Tri t2) {
        for (int m = 0; m < 3; ++m) {
            WingedEdge edge1 = t1.eu[m].wedge;
            for (int n = 0; n < 3; ++n) {
                WingedEdge edge2 = t2.eu[n].wedge;
                if (edge1 != edge2) continue;
                return edge1;
            }
        }
        return null;
    }

    public static double safeNormalize(Vector3d vec, double tol) {
        return Util3D.safeNormalize(vec, tol);
    }

    public static SeekCurve generateSeekCurve(KB kb, OccAgent agent, IParametric3D curve, boolean seeking, Predicate<WingedEdge> transientEdgeFilter) {
        Predicate<PathChange> transientPathFilter = agent.generatePathFilter(kb, Filters.acceptAll(Tri.class), transientEdgeFilter, OccAgent.PathFilterType.TRANSIENT);
        WallSlider slider = Util.getWallSlider(kb, agent, transientPathFilter);
        IParametric3D acurve = Util.adjustSeekCurve(curve, slider);
        return new SeekCurve(acurve, slider, transientPathFilter, seeking);
    }

    public static IParametric3D adjustSeekCurve(IParametric3D seekCurve, WallSlider slider) {
        Vector3d dir = seekCurve.getTangent(0.0);
        Util.safeNormalize(dir, 1.0E-9);
        Vector3d slideDir = slider.slide(dir, true);
        if (dir.equals(slideDir) || slideDir.equals(GeomConstants.VEC3D_ZERO)) {
            return seekCurve;
        }
        if (seekCurve instanceof Spline3D.Quadratic) {
            Spline3D.Quadratic quad = (Spline3D.Quadratic)seekCurve;
            double c1Dist = quad.getP1().distance(quad.getC1());
            slideDir.scale(c1Dist);
            Point3d newC1 = Util3D.add(quad.getP1(), (Tuple3d)slideDir);
            return Util.newCurve(quad.getP1(), newC1, quad.getP2());
        }
        if (seekCurve instanceof Spline3D.Cubic) {
            Spline3D.Cubic cubic = (Spline3D.Cubic)seekCurve;
            double c1Dist = cubic.getP1().distance(cubic.getC1());
            slideDir.scale(c1Dist);
            Point3d newC1 = Util3D.add(cubic.getP1(), (Tuple3d)slideDir);
            return Util.newCurve(cubic.getP1(), newC1, cubic.getC2(), cubic.getP2());
        }
        Point3d p1 = seekCurve.get(0.0);
        Point3d p2 = seekCurve.get(1.0);
        slideDir.scale(0.01);
        Point3d c = Util3D.add(p1, (Tuple3d)slideDir);
        return Util.newCurve(p1, c, p2);
    }

    public static double dot2d(Tuple3d t1, Tuple3d t2) {
        return t1.x * t2.x + t1.y * t2.y;
    }

    public static double lengthSquared2d(Tuple3d t) {
        return t.x * t.x + t.y * t.y;
    }

    public static double length2d(Tuple3d t) {
        return Math.sqrt(t.x * t.x + t.y * t.y);
    }

    public static Vector3d vector2d(Tuple3d t1, Tuple3d t2) {
        return new Vector3d(t2.x - t1.x, t2.y - t1.y, 0.0);
    }

    public static double distSquared2d(Tuple3d t1, Tuple3d t2) {
        double dx = t1.x - t2.x;
        double dy = t1.y - t2.y;
        return dx * dx + dy * dy;
    }

    public static double dist2d(Tuple3d t1, Tuple3d t2) {
        double dx = t1.x - t2.x;
        double dy = t1.y - t2.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double angle2d(Tuple3d v1, Tuple3d v2) {
        return Util2D.angle(v1.x, v1.y, v2.x, v2.y);
    }

    public static double sAngle2d(Tuple3d v1, Tuple3d v2) {
        return Util2D.sAngle(v1.x, v1.y, v2.x, v2.y);
    }

    public static boolean containsAny(Collection<?> c1, Collection<?> c2) {
        Collection<?> bigger;
        Collection<?> smaller;
        if (c1.isEmpty() || c2.isEmpty()) {
            return false;
        }
        if (c1 instanceof Set && c2 instanceof Set) {
            if (c1.size() <= c2.size()) {
                return c1.stream().anyMatch(Filters.accept(c2, Object.class));
            }
            return c2.stream().anyMatch(Filters.accept(c1, Object.class));
        }
        if (c1 instanceof Set) {
            return c2.stream().anyMatch(Filters.accept(c1, Object.class));
        }
        if (c2 instanceof Set) {
            return c1.stream().anyMatch(Filters.accept(c2, Object.class));
        }
        if (c1.size() <= c2.size()) {
            smaller = c1;
            bigger = c2;
        } else {
            smaller = c2;
            bigger = c1;
        }
        HashSet biggerSet = new HashSet(bigger);
        return smaller.stream().anyMatch(Filters.accept(biggerSet));
    }

    public static double tOnLineSeg2d(Point3d l1, Point3d l2, Point3d p) {
        double l1l2x = l2.x - l1.x;
        double l1l2y = l2.y - l1.y;
        double l1px = p.x - l1.x;
        double l1py = p.y - l1.y;
        double dot = l1l2x * l1px + l1l2y * l1py;
        double lensq = l1l2x * l1l2x + l1l2y * l1l2y;
        if (lensq == 0.0) {
            return Double.NaN;
        }
        return dot / lensq;
    }

    public static double distSq2d(Point3d p1, Point3d p2) {
        double vx = p2.x - p1.x;
        double vy = p2.y - p1.y;
        return vx * vx + vy * vy;
    }

    public static CopLineLine copLineLineSegExact(Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, double[] st) {
        double side2a = PreciseGeom.orient2d(l1a.x, l1a.y, l1b.x, l1b.y, l2a.x, l2a.y);
        double side2b = PreciseGeom.orient2d(l1a.x, l1a.y, l1b.x, l1b.y, l2b.x, l2b.y);
        if (side2a < 0.0 && side2b < 0.0 || side2a > 0.0 && side2b > 0.0) {
            return CopLineLine.NO_INTERSECT;
        }
        if (side2a == 0.0 && side2b == 0.0) {
            return CopLineLine.COLINEAR;
        }
        if (!PreciseGeom.isectLineLine(l1a.x, l1a.y, l1b.x, l1b.y, l2a.x, l2a.y, l2b.x, l2b.y, st)) {
            return CopLineLine.NO_INTERSECT;
        }
        if (side2a == 0.0) {
            st[1] = 0.0;
        } else if (side2b == 0.0) {
            st[1] = 1.0;
        } else if (st[1] < 0.0) {
            st[1] = 0.0;
        } else if (st[1] > 1.0) {
            st[1] = 1.0;
        }
        return CopLineLine.INTERSECT;
    }

    public static CopLineLine copLineSegLineSegExact(Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, double[] st) {
        double side1a = PreciseGeom.orient2d(l2a.x, l2a.y, l2b.x, l2b.y, l1a.x, l1a.y);
        double side1b = PreciseGeom.orient2d(l2a.x, l2a.y, l2b.x, l2b.y, l1b.x, l1b.y);
        if (side1a < 0.0 && side1b < 0.0 || side1a > 0.0 && side1b > 0.0) {
            return CopLineLine.NO_INTERSECT;
        }
        if (side1a == 0.0 && side1b == 0.0) {
            return CopLineLine.COLINEAR;
        }
        double side2a = PreciseGeom.orient2d(l1a.x, l1a.y, l1b.x, l1b.y, l2a.x, l2a.y);
        double side2b = PreciseGeom.orient2d(l1a.x, l1a.y, l1b.x, l1b.y, l2b.x, l2b.y);
        assert (side2a != 0.0 || side2b != 0.0);
        if (!(side2a >= 0.0 && side2b <= 0.0 || side2a <= 0.0 && side2b >= 0.0)) {
            return CopLineLine.NO_INTERSECT;
        }
        if (!PreciseGeom.isectLineLine(l1a.x, l1a.y, l1b.x, l1b.y, l2a.x, l2a.y, l2b.x, l2b.y, st)) {
            return CopLineLine.NO_INTERSECT;
        }
        if (side1a == 0.0) {
            st[0] = 0.0;
        } else if (side1b == 0.0) {
            st[0] = 1.0;
        }
        if (side2a == 0.0) {
            st[1] = 0.0;
        } else if (side2b == 0.0) {
            st[1] = 1.0;
        }
        for (int m = 0; m < 2; ++m) {
            if (st[m] < 0.0) {
                if (!theUtil.eq0(st[m], 1.0E-6)) {
                    LOGGER.log(Level.WARNING, "Inconsistent edge crossing detected.");
                }
                st[m] = 0.0;
                continue;
            }
            if (!(st[m] > 1.0)) continue;
            if (!theUtil.eq(st[m], 1.0, 1.0E-6)) {
                LOGGER.log(Level.WARNING, "Inconsistent edge crossing detected.");
            }
            st[m] = 1.0;
        }
        return CopLineLine.INTERSECT;
    }

    public static enum CopLineLine {
        COLINEAR,
        INTERSECT,
        NO_INTERSECT;

    }
}

