/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import common.geom.Intersect;
import common.geom.Trig;
import inferno.data2.CylinderShape;
import inferno.data2.IAgentBodyShape;
import inferno.data2.Mesh;
import inferno.data2.PolygonShape;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.geom.Plane3d;
import inferno.geom.Util;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class Inter {
    public static final double DBL_EPSILON = 1.0E-9;
    public static final double DBL_POINT_EPSILON = 1.0E-6;
    public static final Vector3d VEC_ZERO = new Vector3d(0.0, 0.0, 0.0);
    private static final Vector3d VEC_RIGHT = new Vector3d(1.0, 0.0, 0.0);
    private static final int SHAPE_POLYGON = 1;
    private static final int SHAPE_SPHERE = 2;
    private static final ToDoubleFunction<Point3d> s_getx = p -> p.x;
    private static final ToDoubleFunction<Point3d> s_gety = p -> p.y;

    public static double dist(Point3d v1, Point3d v2) {
        return v1.distance(v2);
    }

    public static boolean radius(Point3d center, double r, Point3d pt) {
        return Inter.dist(center, pt) <= r;
    }

    public static boolean spheresIsect(Point3d p1, double r1, Point3d p2, double r2) {
        double r1pr2 = r1 + r2;
        return p1.distanceSquared(p2) < r1pr2 * r1pr2;
    }

    public static Point3d linePlane(Point3d a, Point3d b, Point3d p0, Point3d p1, Point3d p2) {
        Matrix3d m1 = new Matrix3d(a.x - b.x, p1.x - p0.x, p2.x - p0.x, a.y - b.y, p1.y - p0.y, p2.y - p0.y, a.z - b.z, p1.z - p0.z, p2.z - p0.z);
        m1.invert();
        Point3d m2 = new Point3d(a.x - p0.x, a.y - p0.y, a.z - p0.z);
        m1.transform(m2);
        return m2;
    }

    public static void linePoint(Point3d p, Point3d pOnLine, Vector3d lineDir, double t) {
        p.set(pOnLine.x + lineDir.x * t, pOnLine.y + lineDir.y * t, pOnLine.z + lineDir.z * t);
    }

    public static Point3d linePoint(Point3d pOnLine, Vector3d lineDir, double t) {
        return new Point3d(pOnLine.x + lineDir.x * t, pOnLine.y + lineDir.y * t, pOnLine.z + lineDir.z * t);
    }

    public static Point3d lineSegPoint(Point3d p1, Point3d p2, Vector3d vec, double t) {
        if (t <= 0.0) {
            return p1;
        }
        if (t >= 1.0) {
            return p2;
        }
        return Inter.linePoint(p1, vec, t);
    }

    public static void lineSegPoint(Point3d p, Point3d p1, Point3d p2, double t) {
        if (t <= 0.0) {
            p.set(p1);
        } else if (t >= 1.0) {
            p.set(p2);
        } else {
            Inter.linePoint(p, p1, Inter.vector(p1, p2), t);
        }
    }

    public static Point3d linePlane(Point3d pOnLine, Vector3d lineDir, Plane3d plane, double tol) {
        double t = Inter.linePlaneT(pOnLine, lineDir, plane, tol);
        if (Double.isNaN(t)) {
            return null;
        }
        return Inter.linePoint(pOnLine, lineDir, t);
    }

    public static double linePlaneT(Point3d pOnLine, Vector3d lineDir, Plane3d plane, double tol) {
        return Inter.linePlaneT(pOnLine, lineDir, plane.x, plane.y, plane.z, plane.w, tol);
    }

    public static double linePlaneT(Point3d pOnLine, Vector3d lineDir, double px, double py, double pz, double pw, double tol) {
        double dot = px * lineDir.x + py * lineDir.y + pz * lineDir.z;
        if (theUtil.eq0(dot, tol)) {
            return Double.NaN;
        }
        return -(px * pOnLine.x + py * pOnLine.y + pz * pOnLine.z + pw) / dot;
    }

    public static double lineSegLineDistance(Point3d p1L1, Point3d p2L1, Point3d pL2, Vector3d dirL2, double parallelTol) {
        Point3d cl1 = new Point3d();
        Point3d cl2 = new Point3d();
        if (!Inter.lineSegLineProximity(p1L1, p2L1, pL2, dirL2, cl1, cl2, parallelTol)) {
            return Inter.nearDistToLine(p1L1, pL2, dirL2);
        }
        return cl1.distance(cl2);
    }

    public static double lineSegLineDistanceSq(Point3d p1L1, Point3d p2L1, Point3d pL2, Vector3d dirL2, double parallelTol) {
        Point3d cl1 = new Point3d();
        Point3d cl2 = new Point3d();
        if (!Inter.lineSegLineProximity(p1L1, p2L1, pL2, dirL2, cl1, cl2, parallelTol)) {
            return Inter.nearDistToLineSq(p1L1, pL2, dirL2);
        }
        return cl1.distanceSquared(cl2);
    }

    public static boolean lineSegLineProximity(Point3d p1L1, Point3d p2L1, Point3d pL2, Vector3d dirL2, Point3d closestL1, Point3d closestL2, double parallelTol) {
        double[] st = new double[]{closestL1 != null ? 0.0 : -1.0, closestL2 != null ? 0.0 : -1.0};
        if (!Inter.lineLineProximity(p1L1, Inter.vector(p1L1, p2L1), pL2, dirL2, st, parallelTol)) {
            return false;
        }
        if (closestL1 != null) {
            Inter.lineSegPoint(closestL1, p1L1, p2L1, st[0]);
        }
        if (closestL2 != null) {
            Inter.linePoint(closestL2, pL2, dirL2, st[1]);
        }
        return true;
    }

    public static boolean lineLineProximity(Point3d pL1, Vector3d dirL1, Point3d pL2, Vector3d dirL2, Point3d closestL1, Point3d closestL2, double parallelTol) {
        double[] st = new double[]{closestL1 != null ? 0.0 : -1.0, closestL2 != null ? 0.0 : -1.0};
        if (!Inter.lineLineProximity(pL1, dirL1, pL2, dirL2, st, parallelTol)) {
            return false;
        }
        if (closestL1 != null) {
            Inter.linePoint(closestL1, pL1, dirL1, st[0]);
        }
        if (closestL2 != null) {
            Inter.linePoint(closestL2, pL2, dirL2, st[1]);
        }
        return true;
    }

    public static boolean lineLineProximity(Point3d pL1, Vector3d vecL1, Point3d pL2, Vector3d vecL2, double[] st, double tol) {
        double pw;
        assert (st.length >= 2);
        Vector3d cross = new Vector3d();
        cross.cross(vecL1, vecL2);
        if (theUtil.eq0(cross.dot(cross), tol)) {
            return false;
        }
        if (st[0] != -1.0) {
            Vector3d temp2 = new Vector3d();
            temp2.cross(cross, vecL2);
            pw = Plane3d.calcD(temp2, pL2);
            st[0] = Inter.linePlaneT(pL1, vecL1, temp2.x, temp2.y, temp2.z, pw, tol);
        }
        if (st[1] != -1.0) {
            Vector3d temp1 = new Vector3d();
            temp1.cross(cross, vecL1);
            pw = Plane3d.calcD(temp1, pL1);
            st[1] = Inter.linePlaneT(pL2, vecL2, temp1.x, temp1.y, temp1.z, pw, tol);
        }
        return true;
    }

    public static Point3d lineLine(Point3d pL1, Vector3d dirL1, Point3d pL2, Vector3d dirL2, double tolerance, double parallelTol) {
        Point3d cl1 = new Point3d();
        Point3d cl2 = new Point3d();
        Inter.lineLineProximity(pL1, dirL1, pL2, dirL2, cl1, cl2, parallelTol);
        double dist = cl1.distance(cl2);
        return dist <= tolerance ? cl1 : null;
    }

    public static boolean lineSegLineSegProximity(Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, Point3d closestL1, Point3d closestL2, double parallelTol) {
        Vector3d dirL1 = Inter.vector(l1a, l1b);
        Vector3d dirL2 = Inter.vector(l2a, l2b);
        double[] st = new double[]{closestL1 != null ? 0.0 : -1.0, closestL2 != null ? 0.0 : -1.0};
        if (!Inter.lineLineProximity(l1a, dirL1, l2a, dirL2, st, parallelTol)) {
            return false;
        }
        if (closestL1 != null) {
            Inter.lineSegPoint(closestL1, l1a, l1b, st[0]);
        }
        if (closestL2 != null) {
            Inter.lineSegPoint(closestL2, l2a, l2b, st[1]);
        }
        return true;
    }

    public static Point3d lineSegLineSeg(Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, double tolerance, double parallelTol) {
        Point3d lslscl1 = new Point3d();
        Point3d lslscl2 = new Point3d();
        if (!Inter.lineSegLineSegProximity(l1a, l1b, l2a, l2b, lslscl1, lslscl2, parallelTol)) {
            return null;
        }
        double dist = lslscl1.distance(lslscl2);
        return dist <= tolerance ? new Point3d(lslscl1) : null;
    }

    public static Point3d copRayLineSeg(Point3d rbegin, Vector3d rvec, Point3d l2a, Point3d l2b, double[] st, double tol) {
        Point3d p2;
        Vector3d l2Vec = Inter.vector(l2a, l2b);
        if (!Inter.copLineLine(rbegin, rvec, l2a, l2Vec, st, tol)) {
            if (Inter.isOnLine(l2a, rbegin, rvec, tol)) {
                double t1 = Util3D.tOnLine(rbegin, rvec, l2a);
                double t2 = Util3D.tOnLine(rbegin, rvec, l2b);
                if (t1 < 0.0 && t2 > 0.0 || t1 > 0.0 && t2 < 0.0) {
                    st[0] = 0.0;
                    st[1] = Util3D.tOnLineSeg(l2a, l2b, rbegin);
                    return new Point3d(rbegin);
                }
                if (t1 >= 0.0 && t2 >= 0.0) {
                    if (t1 <= t2) {
                        st[0] = t1;
                        st[1] = 0.0;
                        return new Point3d(l2a);
                    }
                    st[0] = t2;
                    st[1] = 1.0;
                    return new Point3d(l2b);
                }
            }
            return null;
        }
        Point3d p1 = Inter.linePoint(rbegin, rvec, st[0]);
        return p1.distance(p2 = Inter.lineSegPoint(l2a, l2b, l2Vec, st[1])) <= tol ? p2 : null;
    }

    public static Point3d copLineSegLineSeg(Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, double tolerance) {
        double[] st;
        Vector3d b;
        Vector3d a = Inter.vector(l1a, l1b);
        if (!Inter.copLineLine(l1a, a, l2a, b = Inter.vector(l2a, l2b), st = new double[2], tolerance)) {
            return null;
        }
        double s = st[0];
        Point3d pl1 = s <= 0.0 ? l1a : (s >= 1.0 ? l1b : new Point3d(l1a.x + a.x * s, l1a.y + a.y * s, l1a.z + a.z * s));
        double t = st[1];
        Point3d pl2 = t <= 0.0 ? l2a : (t >= 1.0 ? l2b : new Point3d(l2a.x + b.x * t, l2a.y + b.y * t, l2a.z + b.z * t));
        double dist = pl1.distance(pl2);
        return dist <= tolerance ? new Point3d(pl1) : null;
    }

    public static boolean copLineLine(Point3d l1a, Vector3d a, Point3d l2a, Vector3d b, double[] st, double tol) {
        assert (st.length >= 2);
        Vector3d acb = Inter.cross(a, b);
        double acbLenSq = acb.lengthSquared();
        if (acbLenSq < tol) {
            return false;
        }
        double invACBLenSq = 1.0 / acbLenSq;
        Vector3d c = Inter.vector(l1a, l2a);
        Vector3d temp = new Vector3d();
        temp.cross(c, b);
        st[0] = Inter.dot(temp, acb) * invACBLenSq;
        acb.negate();
        c.negate();
        temp.cross(c, a);
        st[1] = Inter.dot(temp, acb) * invACBLenSq;
        return true;
    }

    public static boolean inTri(Tuple3d tuv) {
        return 0.0 <= tuv.y && tuv.y <= 1.0 && 0.0 <= tuv.z && tuv.z <= 1.0 && tuv.y + tuv.z <= 1.0;
    }

    public static boolean pointOnPoly(Point3d pt, Plane3d polyPlane, double tol, Point3d ... polyPoints) {
        double dist = polyPlane.dot(pt);
        if (Math.abs(dist) > 1.0E-9) {
            return false;
        }
        return Inter3D.pointInPoly(tol, pt, polyPoints);
    }

    public static Point3d nearPtTri(Point3d pt, Point3d a, Point3d b, Point3d c) {
        Vector3d n = Inter.cross(Inter.vector(a, b), Inter.vector(a, c));
        Point3d pt2 = new Point3d(pt);
        pt2.add(n);
        Point3d tuv = Inter.linePlane(pt, pt2, a, b, c);
        if (Inter.inTri(tuv)) {
            Point3d in = new Point3d(pt);
            n.scale(tuv.x);
            in.add(n);
            return in;
        }
        Point3d np1 = Inter.nearPointOnLineSeg(pt, a, b);
        Point3d np2 = Inter.nearPointOnLineSeg(pt, b, c);
        Point3d np3 = Inter.nearPointOnLineSeg(pt, c, a);
        double dist1 = Inter.dist(np1, pt);
        double dist2 = Inter.dist(np2, pt);
        double dist3 = Inter.dist(np3, pt);
        if (dist1 <= dist2 && dist1 <= dist3) {
            return np1;
        }
        if (dist2 <= dist1 && dist2 <= dist3) {
            return np2;
        }
        return np3;
    }

    public static boolean isPointOnLineSeg(Point3d pt, Point3d p1, Point3d p2, double tolerance) {
        Point3d pOnLine = Inter.nearPointOnLineSeg(pt, p1, p2);
        return pOnLine.distance(pt) <= tolerance;
    }

    public static double nearDistToLineSegSq(Point3d p, Point3d l1, Point3d l2) {
        return p.distanceSquared(Inter.nearPointOnLineSeg(p, l1, l2));
    }

    public static double nearDistToLineSeg(Point3d p, Point3d l1, Point3d l2) {
        return p.distance(Inter.nearPointOnLineSeg(p, l1, l2));
    }

    public static Point3d nearPointOnLineSeg(Point3d p, Point3d l1, Point3d l2) {
        return Inter3D.nearestPointOnLineSeg(l1, l2, p);
    }

    public static boolean isOnLine(Point3d p, Point3d l1, Vector3d ld, double distTol) {
        Point3d nearp = Inter.nearPointOnLine(p, l1, ld);
        return nearp.distance(p) <= distTol;
    }

    public static Point3d nearPointOnLine(Point3d p, Point3d l1, Vector3d ld) {
        double t = Inter.nearTOnLine(p, l1, ld);
        return Util3D.linePoint(l1, ld, t);
    }

    public static double nearTOnLine(Point3d p, Point3d l1, Vector3d ld) {
        return ((p.x - l1.x) * ld.x + (p.y - l1.y) * ld.y + (p.z - l1.z) * ld.z) / ld.dot(ld);
    }

    public static double nearDistToLine(Point3d p, Point3d pOnLine, Vector3d lineDirN) {
        return Math.sqrt(Inter.nearDistToLineSq(p, pOnLine, lineDirN));
    }

    public static double nearDistToLineSq(Point3d p, Point3d pOnLine, Vector3d lineDirN) {
        Vector3d vp = Inter.vector(pOnLine, p);
        double dot = lineDirN.dot(vp);
        double bSq = dot * dot;
        double hSq = vp.lengthSquared();
        return hSq - bSq;
    }

    public static boolean pointInInfCylinder(Point3d p, Point3d cAxisPt, Vector3d cAxis, double cRadiusSq) {
        return Inter.nearDistToLineSq(p, cAxisPt, cAxis) <= cRadiusSq;
    }

    public static boolean lineInInfCylinder(Point3d l1, Point3d l2, Point3d cAxisPt, Vector3d cAxis, double cRadiusSq) {
        Vector3d lDir = Inter.vector(l1, l2);
        Point3d closestPLine = new Point3d();
        double[] st = new double[]{0.0, -1.0};
        if (!Inter.lineLineProximity(l1, lDir, cAxisPt, cAxis, st, 1.0E-9)) {
            return Inter.pointInInfCylinder(l1, cAxisPt, cAxis, cRadiusSq) || Inter.pointInInfCylinder(l2, cAxisPt, cAxis, cRadiusSq);
        }
        Inter.lineSegPoint(closestPLine, l1, l2, st[0]);
        return Inter.pointInInfCylinder(closestPLine, cAxisPt, cAxis, cRadiusSq);
    }

    public static boolean triangleInfCylinder(Point3d t1, Point3d t2, Point3d t3, Plane3d triPlane, Point3d cAxisPt, Vector3d cAxis, double cRadiusSq, double tol) {
        if (Inter.pointInInfCylinder(t1, cAxisPt, cAxis, cRadiusSq) || Inter.pointInInfCylinder(t2, cAxisPt, cAxis, cRadiusSq) || Inter.pointInInfCylinder(t3, cAxisPt, cAxis, cRadiusSq) || Inter.lineInInfCylinder(t1, t2, cAxisPt, cAxis, cRadiusSq) || Inter.lineInInfCylinder(t2, t3, cAxisPt, cAxis, cRadiusSq) || Inter.lineInInfCylinder(t3, t1, cAxisPt, cAxis, cRadiusSq)) {
            return true;
        }
        return Inter.linePolyIntersection(cAxisPt, cAxis, triPlane, tol, t1, t2, t3) != null;
    }

    private static boolean isVecZero(Vector3d vec) {
        return vec.epsilonEquals(VEC_ZERO, 1.0E-9);
    }

    public static Point3d rayPolyIntersection(Point3d l1, Plane3d halfPlane, double distEpsilon, double tol, Plane3d polyPlane, Point3d ... polyPoints) {
        Point3d linePolyIsect = Inter.linePolyIntersection(l1, halfPlane.getNormal(), polyPlane, tol, polyPoints);
        if (linePolyIsect == null) {
            return null;
        }
        double d = halfPlane.dot(linePolyIsect);
        if (d >= -distEpsilon) {
            return linePolyIsect;
        }
        return null;
    }

    public static Point3d linePolyIntersection(Point3d l1, Vector3d lineDir, Plane3d polyPlane, double tol, Point3d ... polyPoints) {
        assert (polyPoints.length >= 3);
        Point3d intersection = Inter.linePlane(l1, lineDir, polyPlane, tol);
        if (intersection == null || !Inter3D.pointInPoly(tol, intersection, polyPoints)) {
            return null;
        }
        return intersection;
    }

    public static void projectLine(Point3d r1, Point3d r2, Point3d l1, Point3d l2, Plane3d plane) {
        plane.project(r1, l1);
        plane.project(r2, l2);
    }

    public static Vector3d normalize(Vector3d v) {
        Vector3d nv = new Vector3d(v);
        double lenSq = nv.lengthSquared();
        if (lenSq == 0.0) {
            return nv;
        }
        nv.scale(1.0 / Math.sqrt(lenSq));
        return nv;
    }

    public static Vector3d normalizeEq(Vector3d v) {
        v.normalize();
        return v;
    }

    public static Vector3d vector(Tuple3d a, Tuple3d b) {
        return new Vector3d(b.x - a.x, b.y - a.y, b.z - a.z);
    }

    public static <T extends Tuple3d> T vectorEq(T a, T b) {
        a.set(b.x - a.x, b.y - a.y, b.z - a.z);
        return a;
    }

    public static Vector3d add(Vector3d t1, Tuple3d t2) {
        return new Vector3d(t1.x + t2.x, t1.y + t2.y, t1.z + t2.z);
    }

    public static Point3d add(Point3d t1, Tuple3d t2) {
        return new Point3d(t1.x + t2.x, t1.y + t2.y, t1.z + t2.z);
    }

    public static <T extends Tuple3d> T addEq(T t1, Tuple3d t2) {
        t1.add(t1, t2);
        return t1;
    }

    public static Vector3d sub(Vector3d t1, Tuple3d t2) {
        return new Vector3d(t1.x - t2.x, t1.y - t2.y, t1.z - t2.z);
    }

    public static Point3d sub(Point3d t1, Tuple3d t2) {
        return new Point3d(t1.x - t2.x, t1.y - t2.y, t1.z - t2.z);
    }

    public static <T extends Tuple3d> T subEq(T t1, Tuple3d t2) {
        t1.sub(t1, t2);
        return t1;
    }

    public static Vector3d cross(Vector3d a, Vector3d b) {
        return new Vector3d(a.y * b.z - b.y * a.z, b.x * a.z - a.x * b.z, a.x * b.y - b.x * a.y);
    }

    public static Vector3d crossEq(Vector3d a, Vector3d b) {
        a.set(a.y * b.z - b.y * a.z, b.x * a.z - a.x * b.z, a.x * b.y - b.x * a.y);
        return a;
    }

    public static double dot(Tuple3d a, Tuple3d b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static Vector3d scale(Vector3d pt, double factor) {
        return new Vector3d(pt.x * factor, pt.y * factor, pt.z * factor);
    }

    public static <T extends Tuple3d> T scaleEq(T pt, double factor) {
        pt.scale(factor);
        return pt;
    }

    public static Vector3d negate(Vector3d vec) {
        return new Vector3d(-vec.x, -vec.y, -vec.z);
    }

    public static <T extends Tuple3d> T negateEq(T t) {
        t.negate();
        return t;
    }

    public static Point3d transform(Matrix4d xform, Point3d p) {
        p = new Point3d(p);
        xform.transform(p);
        return p;
    }

    public static Point3d transformEq(Matrix4d xform, Point3d p) {
        xform.transform(p);
        return p;
    }

    public static Vector3d transform(Matrix4d xform, Vector3d v) {
        v = new Vector3d(v);
        xform.transform(v);
        return v;
    }

    public static Vector3d transformEq(Matrix4d xform, Vector3d v) {
        xform.transform(v);
        return v;
    }

    public static double det(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    public static boolean lineAABB(Point3d l1, Vector3d lineDirN, Point3d aabbMin, Point3d aabbMax) {
        Point3d min = aabbMin;
        Point3d max = aabbMax;
        if (min.equals(max)) {
            return Inter.nearDistToLine(min, l1, lineDirN) < 1.0E-9;
        }
        return Inter.lineXFace(l1, lineDirN, min.y, max.y, min.z, max.z, min.x) != null || Inter.lineXFace(l1, lineDirN, min.y, max.y, min.z, max.z, max.x) != null || Inter.lineYFace(l1, lineDirN, min.x, max.x, min.z, max.z, min.y) != null || Inter.lineYFace(l1, lineDirN, min.x, max.x, min.z, max.z, max.y) != null || Inter.lineZFace(l1, lineDirN, min.x, max.x, min.y, max.y, min.z) != null || Inter.lineZFace(l1, lineDirN, min.x, max.x, min.y, max.y, max.z) != null;
    }

    public static Point3d lineXFace(Point3d pOnLine, Vector3d lineDirN, double ymin, double ymax, double zmin, double zmax, double x) {
        if (lineDirN.x == 0.0) {
            return null;
        }
        double t = (x - pOnLine.x) / lineDirN.x;
        double iy = pOnLine.y + lineDirN.y * t;
        double iz = pOnLine.z + lineDirN.z * t;
        if (ymin <= iy && iy <= ymax && zmin <= iz && iz <= zmax) {
            return new Point3d(x, iy, iz);
        }
        return null;
    }

    public static Point3d lineYFace(Point3d p, Vector3d dir, double xmin, double xmax, double zmin, double zmax, double y) {
        if (dir.y == 0.0) {
            return null;
        }
        double t = (y - p.y) / dir.y;
        double ix = p.x + dir.x * t;
        double iz = p.z + dir.z * t;
        if (xmin <= ix && ix <= xmax && zmin <= iz && iz <= zmax) {
            return new Point3d(ix, y, iz);
        }
        return null;
    }

    public static Point3d lineZFace(Point3d p, Vector3d dir, double xmin, double xmax, double ymin, double ymax, double z) {
        if (dir.z == 0.0) {
            return null;
        }
        double t = (z - p.z) / dir.z;
        double ix = p.x + dir.x * t;
        double iy = p.y + dir.y * t;
        if (xmin <= ix && ix <= xmax && ymin <= iy && iy <= ymax) {
            return new Point3d(ix, iy, z);
        }
        return null;
    }

    private static int getShapeId(IAgentBodyShape shape) {
        if (shape instanceof PolygonShape) {
            return 1;
        }
        if (shape instanceof CylinderShape) {
            return 2;
        }
        return 0;
    }

    public static boolean testRectRect2d(Point3d[] rect1, Point3d[] rect2, double tol) {
        assert (rect1.length == 4);
        assert (rect2.length == 4);
        for (int x = 0; x < 2; ++x) {
            Point3d[] rect = x == 0 ? rect1 : rect2;
            Point3d p1 = rect[rect.length - 1];
            for (int m = 0; m < 2; ++m) {
                Point3d p2 = rect[m];
                double normalx = p2.y - p1.y;
                double normaly = p1.x - p2.x;
                double minA = Double.MAX_VALUE;
                double maxA = -1.7976931348623157E308;
                for (Point3d p : rect1) {
                    double projected = normalx * p.x + normaly * p.y;
                    if (projected < minA) {
                        minA = projected;
                    }
                    if (!(projected > maxA)) continue;
                    maxA = projected;
                }
                double minB = Double.MAX_VALUE;
                double maxB = -1.7976931348623157E308;
                for (Point3d p : rect2) {
                    double projected = normalx * p.x + normaly * p.y;
                    if (projected < minB) {
                        minB = projected;
                    }
                    if (!(projected > maxB)) continue;
                    maxB = projected;
                }
                if (maxA < minB || maxB < minA) {
                    return false;
                }
                p1 = p2;
            }
        }
        return true;
    }

    public static boolean testRectCPoly2d(Point3d[] rect, Point3d[] cpoly, double tol) {
        assert (rect.length == 4);
        for (int x = 0; x < 2; ++x) {
            Point3d[] polygon = x == 0 ? rect : cpoly;
            int maxm = x == 0 ? 2 : cpoly.length;
            Point3d p1 = polygon[polygon.length - 1];
            for (int m = 0; m < maxm; ++m) {
                Point3d p2 = polygon[m];
                double normalx = p2.y - p1.y;
                double normaly = p1.x - p2.x;
                double minA = Double.MAX_VALUE;
                double maxA = -1.7976931348623157E308;
                for (Point3d p : rect) {
                    double projected = normalx * p.x + normaly * p.y;
                    if (projected < minA) {
                        minA = projected;
                    }
                    if (!(projected > maxA)) continue;
                    maxA = projected;
                }
                double minB = Double.MAX_VALUE;
                double maxB = -1.7976931348623157E308;
                for (Point3d p : cpoly) {
                    double projected = normalx * p.x + normaly * p.y;
                    if (projected < minB) {
                        minB = projected;
                    }
                    if (!(projected > maxB)) continue;
                    maxB = projected;
                }
                if (maxA < minB || maxB < minA) {
                    return false;
                }
                p1 = p2;
            }
        }
        return true;
    }

    public static boolean testCPolyCPoly2d(Point3d[] a, Point3d[] b, double tol) {
        if (a == null || b == null) {
            return false;
        }
        return Inter2D.testCPolyCPoly(a, b, s_getx, s_gety, tol);
    }

    public static double getOccCollision(IAgentBodyShape shape1, Vector3d v1, IAgentBodyShape shape2, Vector3d v2, double tol) {
        return Inter.getOccCollisionFull(shape1, v1, shape2, v2, tol)[0];
    }

    public static double[] getOccCollisionFull(IAgentBodyShape shape1, Vector3d v1, IAgentBodyShape shape2, Vector3d v2, double tol) {
        double[] collt;
        Point3d p1 = shape1.getCenter();
        Point3d p2 = shape2.getCenter();
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        boolean occ1Moving = !theUtil.eq0(v1.x, tol) || !theUtil.eq0(v1.y, tol);
        boolean occ2Moving = !theUtil.eq0(v2.x, tol) || !theUtil.eq0(v2.y, tol);
        int sid1 = Inter.getShapeId(shape1);
        int sid2 = Inter.getShapeId(shape2);
        int scombo = sid1 | sid2;
        if (occ1Moving && theUtil.le0(v1.x * dx + v1.y * dy, tol) || !occ1Moving && (occ2Moving || scombo != 1) && theUtil.ge0(v2.x * dx + v2.y * dy, tol)) {
            return new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        }
        switch (scombo) {
            case 1: {
                collt = Inter.movingShapeMovingShapeIsect((PolygonShape)shape1, v1, (PolygonShape)shape2, v2, tol);
                break;
            }
            case 2: {
                collt = Inter.movingShapeMovingShapeIsect((CylinderShape)shape1, v1, (CylinderShape)shape2, v2, tol);
                break;
            }
            case 3: {
                if (sid1 == 1) {
                    collt = Inter.movingShapeMovingShapeIsect((CylinderShape)shape2, v2, (PolygonShape)shape1, v1, tol);
                    break;
                }
                collt = Inter.movingShapeMovingShapeIsect((CylinderShape)shape1, v1, (PolygonShape)shape2, v2, tol);
                break;
            }
            default: {
                collt = null;
            }
        }
        if (collt == null || collt[1] <= 0.0) {
            return new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        }
        return collt;
    }

    public static double[] movingShapeMovingShapeIsect(CylinderShape shape1, Vector3d v1, PolygonShape shape2, Vector3d v2, double tol) {
        return Inter.movingCylMovingECPolyIsect(shape1.getCenter(), shape1.getOccRadius(), shape1.getHeight(), v1, shape2.getPoints(), shape2.getHeight(), v2, tol);
    }

    public static double[] movingCylMovingECPolyIsect(Point3d bot1, double r1, double h1, Vector3d v1, Point3d[] shape2, double h2, Vector3d v2, double tol) {
        Vector3d vel = Util3D.sub(v1, (Tuple3d)v2);
        return Inter.movingCylECPolyIsect(bot1, r1, h1, vel, shape2, h2, tol);
    }

    public static double[] movingCylECPolyIsect(Point3d bot1, double r1, double h1, Vector3d v1, Point3d[] points, double h2, double tol) {
        if (points.length == 0) {
            return null;
        }
        BooleanSupplier getOverlap2d = () -> Inter.testCircleCPoly2d(bot1, r1, points, tol);
        Supplier<double[]> getIsect2d = () -> Inter.movingCircleCPolyIsect2d(bot1, r1, v1, points, tol);
        return Inter.movingECShapeECShapeIsect(bot1, h1, v1, points[0], h2, getIsect2d, getOverlap2d, tol);
    }

    private static Point3d zeroZ(Point3d p, Point3d temp) {
        temp.set(p.x, p.y, 0.0);
        return temp;
    }

    public static double[] movingCircleCPolyIsect2d(Point3d center1, double r1, Vector3d v1, Point3d[] points2, double tol) {
        double[] dArray;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        Point3d temp1 = new Point3d();
        Point3d temp2 = new Point3d();
        Point3d center12d = new Point3d(center1.x, center1.y, 0.0);
        Vector3d v12d = new Vector3d(v1.x, v1.y, 0.0);
        double[] t = new double[2];
        Point3d p1 = Inter.zeroZ(points2[points2.length - 1], temp1);
        for (int i = 0; i < points2.length; ++i) {
            Point3d p2 = Inter.zeroZ(points2[i], temp2);
            boolean isect = Mesh.movingSphereLineSegIsect2d(center12d, r1, v12d, p1, p2, t, tol);
            if (isect && !Double.isNaN(t[0]) && !Double.isNaN(t[1])) {
                if (t[0] < min) {
                    min = t[0];
                }
                if (t[1] > max) {
                    max = t[1];
                }
            }
            p1 = p2;
            Point3d temp = temp1;
            temp1 = temp2;
            temp2 = temp;
        }
        if (min > max) {
            dArray = null;
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = min;
            dArray = dArray2;
            dArray2[1] = max;
        }
        return dArray;
    }

    public static boolean testCircleCPoly2d(Point3d center1, double r1, Point3d[] points2, double tol) {
        if (Inter.pointInCPoly2d(tol, center1, points2)) {
            return true;
        }
        double rsq = r1 * r1;
        Point3d p1 = points2[points2.length - 1];
        for (int i = 0; i < points2.length; ++i) {
            Point3d p2 = points2[i];
            double distsq = Inter2D.distSqToNearestPtOnLineSeg(p1.x, p1.y, p2.x, p2.y, center1.x, center1.y);
            if (theUtil.le(distsq, rsq, tol)) {
                return true;
            }
            p1 = p2;
        }
        return false;
    }

    public static boolean pointInCPoly2d(double tol, Point3d tp, Point3d ... cpoly) {
        return Inter2D.pointInConvexPoly(tol, s_getx, s_gety, tp.x, tp.y, cpoly);
    }

    public static double[] movingShapeMovingShapeIsect(PolygonShape shape1, Vector3d v1, PolygonShape shape2, Vector3d v2, double tol) {
        return Inter.movingECPolyMovingECPolyIsect(shape1.getPoints(), shape1.getHeight(), v1, shape2.getPoints(), shape2.getHeight(), v2, tol);
    }

    public static double[] movingECPolyMovingECPolyIsect(Point3d[] shape1, double h1, Vector3d v1, Point3d[] shape2, double h2, Vector3d v2, double tol) {
        Vector3d newVel1 = Util3D.sub(v1, (Tuple3d)v2);
        return Inter.movingECPolyECPolyIsect(shape1, h1, newVel1, shape2, h2, tol);
    }

    public static double[] movingECPolyECPolyIsect(Point3d[] shape1, double h1, Vector3d v1, Point3d[] shape2, double h2, double tol) {
        if (shape1.length == 0 || shape2.length == 0) {
            return null;
        }
        Supplier<double[]> getIsect2d = () -> {
            double[] t = new double[2];
            return (double[])(Inter.movingCPolyCPoly2d(shape1, v1, shape2, t, tol) ? t : null);
        };
        BooleanSupplier getOverlap2d = () -> Inter.testCPolyCPoly2d(shape1, shape2, tol);
        return Inter.movingECShapeECShapeIsect(shape1[0], h1, v1, shape2[0], h2, getIsect2d, getOverlap2d, tol);
    }

    public static boolean movingCPolyCPoly2d(Point3d[] shape1, Vector3d vel, Point3d[] shape2, double[] t, double tol) {
        Point3d[] md = Inter.minkowskiDifference(shape2, shape1);
        if (md.length == 0) {
            return false;
        }
        return Inter.rayCPoly2d(GeomConstants.PNT3D_ORIGIN, vel, md, t, tol);
    }

    private static final boolean eq02d(Tuple3d t, double tol) {
        return theUtil.eq0(t.x, tol) && theUtil.eq0(t.y, tol);
    }

    public static double[] movingShapeMovingShapeIsect(CylinderShape shape1, Vector3d v1, CylinderShape shape2, Vector3d v2, double tol) {
        return Inter.movingCylMovingCylIsect(shape1.getCenter(), shape1.getOccRadius(), shape1.getHeight(), v1, shape2.getCenter(), shape2.getOccRadius(), shape2.getHeight(), v2, tol);
    }

    public static double[] movingCylMovingCylIsect(Point3d p1, double r1, double h1, Vector3d v1, Point3d p2, double r2, double h2, Vector3d v2, double tol) {
        Vector3d newVel1 = Util3D.sub(v1, (Tuple3d)v2);
        return Inter.movingCylCylIsect(p1, r1, h1, newVel1, p2, r2, h2, tol);
    }

    public static double[] movingCylCylIsect(Point3d p1, double r1, double h1, Vector3d v1, Point3d p2, double r2, double h2, double tol) {
        return Inter.movingLinesegCylIsect(p1, h1, v1, p2, r2 + r1, h2, tol);
    }

    public static double[] movingLinesegCylIsect(Point3d p1, double h1, Vector3d v1, Point3d bot2, double r2, double h2, double tol) {
        if (theUtil.eq0(r2, tol)) {
            return null;
        }
        Supplier<double[]> isect2d = () -> Inter2D.lineCircleIsect(point3d.x, point3d.y, vector3d.x, vector3d.y, point3d2.x, point3d2.y, r2, tol);
        BooleanSupplier getOverlap2d = () -> {
            double dx = point3d.x - point3d2.x;
            double dy = point3d.y - point3d2.y;
            double distsq = dx * dx + dy * dy;
            return theUtil.le(distsq, r2 * r2, tol * tol);
        };
        return Inter.movingECShapeECShapeIsect(new Point3d(p1.x, p1.y, p1.z + h1 * 0.5), v1, new Point3d(bot2.x, bot2.y, bot2.z - h1 * 0.5), h2 + h1, isect2d, getOverlap2d, tol);
    }

    private static double[] movingECShapeECShapeIsect(Point3d bot1, double h1, Vector3d v1, Point3d bot2, double h2, Supplier<double[]> getIsect2d, BooleanSupplier getOverlap2d, double tol) {
        return Inter.movingECShapeECShapeIsect(new Point3d(bot1.x, bot1.y, bot1.z + h1 * 0.5), v1, new Point3d(bot2.x, bot2.y, bot2.z - h1 * 0.5), h2 + h1, getIsect2d, getOverlap2d, tol);
    }

    private static double[] movingECShapeECShapeIsect(Point3d r1, Vector3d v1, Point3d bot2, double h2, Supplier<double[]> getIsect2d, BooleanSupplier getOverlap2d, double tol) {
        if (theUtil.eq0(v1.lengthSquared(), tol * tol) || theUtil.eq0(h2, tol)) {
            return null;
        }
        double z1 = bot2.z;
        double z2 = bot2.z + h2;
        if (theUtil.eq0(v1.z, tol)) {
            if (theUtil.ge(r1.z, z1, tol) && theUtil.le(r1.z, z2, tol)) {
                return getIsect2d.get();
            }
            return null;
        }
        if (theUtil.eq0(v1.x, tol) && theUtil.eq0(v1.y, tol)) {
            if (getOverlap2d.getAsBoolean()) {
                double[] dArray;
                double iz = 1.0 / v1.z;
                double t1 = (z1 - r1.z) * iz;
                double t2 = (z2 - r1.z) * iz;
                if (t1 <= t2) {
                    double[] dArray2 = new double[2];
                    dArray2[0] = t1;
                    dArray = dArray2;
                    dArray2[1] = t2;
                } else {
                    double[] dArray3 = new double[2];
                    dArray3[0] = t2;
                    dArray = dArray3;
                    dArray3[1] = t1;
                }
                return dArray;
            }
            return null;
        }
        double[] isect2d = getIsect2d.get();
        if (isect2d == null) {
            return null;
        }
        double iz = 1.0 / v1.z;
        double t2ec = (z2 - r1.z) * iz;
        double t1ec = (z1 - r1.z) * iz;
        if (t2ec < t1ec) {
            double temp = t2ec;
            t2ec = t1ec;
            t1ec = temp;
        }
        if (theUtil.gt(isect2d[0], t2ec, tol) || theUtil.lt(isect2d[1], t1ec, tol)) {
            return null;
        }
        if (isect2d[0] == isect2d[1]) {
            return isect2d;
        }
        double[] isects = new double[]{isect2d[0], isect2d[1], t1ec, t2ec};
        Arrays.sort(isects);
        isect2d[0] = isects[1];
        isect2d[1] = isects[2];
        return isect2d;
    }

    public static double[] rayCylIsect(Point3d r1, Vector3d v1, Point3d bot2, double r2, double h2, double tol) {
        if (theUtil.eq0(v1.lengthSquared(), tol * tol) || theUtil.eq0(r2, tol) || theUtil.eq0(h2, tol)) {
            return null;
        }
        double z1 = bot2.z;
        double z2 = bot2.z + h2;
        if (theUtil.eq0(v1.z, tol)) {
            if (theUtil.ge(r1.z, z1, tol) && theUtil.le(r1.z, z2, tol)) {
                return Inter2D.lineCircleIsect(r1.x, r1.y, v1.x, v1.y, bot2.x, bot2.y, r2, tol);
            }
            return null;
        }
        if (theUtil.eq0(v1.x, tol) && theUtil.eq0(v1.y, tol)) {
            double dx = bot2.x - r1.x;
            double dy = bot2.y - r1.y;
            double distsq = dx * dx + dy * dy;
            if (theUtil.le(distsq, r2 * r2, tol * tol)) {
                double[] dArray;
                double iz = 1.0 / v1.z;
                double t1 = (z1 - r1.z) * iz;
                double t2 = (z2 - r1.z) * iz;
                if (t1 <= t2) {
                    double[] dArray2 = new double[2];
                    dArray2[0] = t1;
                    dArray = dArray2;
                    dArray2[1] = t2;
                } else {
                    double[] dArray3 = new double[2];
                    dArray3[0] = t2;
                    dArray = dArray3;
                    dArray3[1] = t1;
                }
                return dArray;
            }
            return null;
        }
        double[] circleIsect = Inter2D.lineCircleIsect(r1.x, r1.y, v1.x, v1.y, bot2.x, bot2.y, r2, tol);
        if (circleIsect == null) {
            return null;
        }
        double iz = 1.0 / v1.z;
        double t2ec = (z2 - r1.z) * iz;
        double t1ec = (z1 - r1.z) * iz;
        if (t2ec < t1ec) {
            double temp = t2ec;
            t2ec = t1ec;
            t1ec = temp;
        }
        if (theUtil.gt(circleIsect[0], t2ec, tol) || theUtil.lt(circleIsect[1], t1ec, tol)) {
            return null;
        }
        if (circleIsect[0] == circleIsect[1]) {
            return circleIsect;
        }
        double[] isects = new double[]{circleIsect[0], circleIsect[1], t1ec, t2ec};
        Arrays.sort(isects);
        circleIsect[0] = isects[1];
        circleIsect[1] = isects[2];
        return circleIsect;
    }

    public static double[] lineSegCapsuleIsect2d(Point3d l1, Point3d l2, Point3d c1, Point3d c2, double r, double epsilon) {
        double[] t;
        Vector3d ldir = Inter.vector(l1, l2);
        boolean result = Inter.movingSphereLineSegIsect2d(l1, r, ldir, c1, c2, t = new double[2], epsilon);
        if (!result) {
            return null;
        }
        thunderheadeng.geometry.Util.clampTs(t, 0.0, 1.0);
        if (theUtil.eq(t[0], t[1], epsilon)) {
            return null;
        }
        assert (t[0] < t[1]);
        return t;
    }

    public static boolean movingSphereLineSegIsect2d(Point3d sphereCenter, double sphereRadius, Vector3d sphereVel, Point3d l1, Point3d l2, double[] t, double epsilon) {
        if (sphereRadius == 0.0) {
            Point3d isect = Inter.copRayLineSeg(new Point3d(sphereCenter.x, sphereCenter.y, 0.0), new Vector3d(sphereVel.x, sphereVel.y, 0.0), new Point3d(l1.x, l1.y, 0.0), new Point3d(l2.x, l2.y, 0.0), t, epsilon);
            if (isect != null) {
                t[1] = t[0];
            }
            return isect != null;
        }
        double cx = (l1.x + l2.x) * 0.5;
        double cy = (l1.y + l2.y) * 0.5;
        double ax = l2.x - l1.x;
        double ay = l2.y - l1.y;
        double az = 0.0;
        double capLen = Math.sqrt(ax * ax + ay * ay);
        if (capLen != 0.0) {
            double icaplen = 1.0 / capLen;
            ax *= icaplen;
            ay *= icaplen;
        } else {
            ay = 0.0;
            ax = 0.0;
            az = 1.0;
            capLen = 1.0;
        }
        boolean isected = Inter3D.rayCapsuleIsect(sphereCenter.x, sphereCenter.y, 0.0, sphereVel.x, sphereVel.y, 0.0, cx, cy, 0.0, ax, ay, az, capLen, sphereRadius, t, epsilon);
        if (!isected) {
            return false;
        }
        return !theUtil.eq(t[0], t[1], epsilon);
    }

    public static Point3d[] minkowskiSum(Point3d[] pol1, Point3d[] pol2) {
        int i;
        PriorityQueue<MinkowskiEdge> q = new PriorityQueue<MinkowskiEdge>(pol1.length + pol2.length);
        Point3d[] result = new Point3d[pol1.length + pol2.length];
        double min1x = Double.MAX_VALUE;
        double min1y = Double.MAX_VALUE;
        double min2x = Double.MAX_VALUE;
        double min2y = Double.MAX_VALUE;
        for (i = 0; i < pol1.length; ++i) {
            if (pol1[i].x < min1x) {
                min1x = pol1[i].x;
            }
            if (pol1[i].y < min1y) {
                min1y = pol1[i].y;
            }
            q.add(new MinkowskiEdge(pol1[i], pol1[(i + 1) % pol1.length]));
        }
        for (i = 0; i < pol2.length; ++i) {
            if (pol2[i].x < min2x) {
                min2x = pol2[i].x;
            }
            if (pol2[i].y < min2y) {
                min2y = pol2[i].y;
            }
            q.add(new MinkowskiEdge(pol2[i], pol2[(i + 1) % pol2.length]));
        }
        double minx = min1x + min2x;
        double miny = min1y + min2y;
        double minMinkowskiSumx = Double.MAX_VALUE;
        double minMinkowskiSumy = Double.MAX_VALUE;
        int index = 0;
        while (!q.isEmpty()) {
            MinkowskiEdge me = (MinkowskiEdge)q.poll();
            if (index != 0) {
                me.shift(result[index - 1]);
            }
            if (((MinkowskiEdge)me).p2.x < minMinkowskiSumx) {
                minMinkowskiSumx = ((MinkowskiEdge)me).p2.x;
            }
            if (((MinkowskiEdge)me).p2.y < minMinkowskiSumy) {
                minMinkowskiSumy = ((MinkowskiEdge)me).p2.y;
            }
            result[index++] = me.p2;
        }
        for (Point3d p : result) {
            p.x += minx - minMinkowskiSumx;
            p.y += miny - minMinkowskiSumy;
        }
        return result;
    }

    public static Point3d[] minkowskiDifference(Point3d[] pol1, Point3d[] pol2) {
        Point3d[] neg = new Point3d[pol2.length];
        for (int i = 0; i < pol2.length; ++i) {
            neg[i] = new Point3d(-pol2[i].x, -pol2[i].y, pol2[i].z);
        }
        return Inter.minkowskiSum(pol1, neg);
    }

    public static boolean rayCPoly2d(Point3d rayOrigin, Vector3d rayDir, Point3d[] points, double[] st, double tol) {
        double[] linest = new double[2];
        double minT = Double.MAX_VALUE;
        double maxT = -1.7976931348623157E308;
        Point3d p1 = points[points.length - 1];
        for (int i = 0; i < points.length; ++i) {
            Point3d p2 = points[i];
            if (Inter2D.isectLineLine(rayOrigin.x, rayOrigin.y, rayDir.x, rayDir.y, p1.x, p1.y, p2.x - p1.x, p2.y - p1.y, tol, linest) && theUtil.ge0(linest[1], tol) && theUtil.le(linest[1], 1.0, tol)) {
                double t = linest[0];
                if (t < minT) {
                    minT = t;
                }
                if (t > maxT) {
                    maxT = t;
                }
            }
            p1 = p2;
        }
        if (maxT < minT) {
            return false;
        }
        st[0] = minT;
        st[1] = maxT;
        return true;
    }

    public static boolean shapesOverlap(IAgentBodyShape shape1, IAgentBodyShape shape2) {
        int sid1 = Inter.getShapeId(shape1);
        int sid2 = Inter.getShapeId(shape2);
        int scombo = sid1 | sid2;
        switch (scombo) {
            case 2: {
                return Inter3D.sphereSphereIsect(shape1.getCenter(), shape1.getEnclosingRadius(), shape2.getCenter(), shape2.getEnclosingRadius(), 1.0E-6);
            }
            case 1: {
                return Inter3D.testCoplanarCPolyCPoly(((PolygonShape)shape1).getPoints(), ((PolygonShape)shape2).getPoints(), 1.0E-6);
            }
            case 3: {
                if (sid1 == 2) {
                    return Intersect.circlePoly(shape1.getCenter(), shape1.getEnclosingRadius(), ((PolygonShape)shape2).getPoints());
                }
                return Intersect.circlePoly(shape2.getCenter(), shape2.getEnclosingRadius(), ((PolygonShape)shape1).getPoints());
            }
        }
        assert (false);
        return false;
    }

    public static double pointToLineDistance(Point3d point, Point3d l1, Point3d l2) {
        double normalLength = Math.sqrt((l2.x - l1.x) * (l2.x - l1.x) + (l2.y - l1.y) * (l2.y - l1.y));
        double shortestDist = Math.abs((point.x - l1.x) * (l2.y - l1.y) - (point.y - l1.y) * (l2.x - l1.x)) / normalLength;
        return shortestDist;
    }

    public static boolean sphereLineSegIsect(Point3d sphereCenter, double sphereRadius, Point3d p1, Point3d p2) {
        double shortestDist = Inter.pointToLineDistance(sphereCenter, p1, p2);
        return shortestDist < sphereRadius;
    }

    private static double pointToPolygonBoundaryMinDistance(Point3d p, Point3d[] points) {
        double minDist = Double.MAX_VALUE;
        for (int i = 0; i < points.length; ++i) {
            Point3d p1 = points[i];
            Point3d p2 = points[(i + 1) % points.length];
            double d = Inter.pointToLineDistance(p, p1, p2);
            if (!(d < minDist)) continue;
            minDist = d;
        }
        return minDist;
    }

    public static boolean isectLineSegPoly(Point3d l1, Point3d l2, Point3d[] polyPoints) {
        return Inter.isectLineSegPoly(l1, l2, polyPoints, 0.0);
    }

    public static boolean isectLineSegPoly(Point3d l1, Point3d l2, Point3d[] polyPoints, double tol) {
        Vector3d lineDir = new Vector3d(l2);
        lineDir.sub(l1);
        for (int i = 0; i < polyPoints.length; ++i) {
            Point3d pp1 = polyPoints[i];
            Point3d pp2 = polyPoints[(i + 1) % polyPoints.length];
            double[] isect = Inter2D.isectLineSegLineSeg(pp1.x, pp1.y, pp2.x, pp2.y, l1.x, l1.y, l2.x, l2.y, tol);
            if (isect == null) continue;
            return true;
        }
        return false;
    }

    public static void rotateTuple2D(Tuple3d p, double angle, Tuple3d around) {
        double cosAngle = Math.cos(angle);
        double sinAngle = Math.sin(angle);
        double dx = p.x - around.x;
        double dy = p.y - around.y;
        p.x = around.x + dx * cosAngle - dy * sinAngle;
        p.y = around.y + dx * sinAngle + dy * cosAngle;
    }

    public static double angleAbs(Vector3d ref, Vector3d dir) {
        if (ref == null || dir == null) {
            return 0.0;
        }
        return Math.abs(Trig.angle(ref, dir));
    }

    public static double getDistToMoveFromPath(IAgentBodyShape shape1, IAgentBodyShape shape2) {
        return shape1.getEnclosingRadius() + shape2.getEnclosingRadius();
    }

    public static double getOccGap(IAgentBodyShape shape1, IAgentBodyShape shape2) {
        double[] collt;
        int type2;
        int type1 = Inter.getShapeId(shape1);
        int ctype = type1 | (type2 = Inter.getShapeId(shape2));
        if (ctype == 2) {
            return Util.dist2d(shape1.getCenter(), shape2.getCenter()) - shape1.getEnclosingRadius() - shape2.getEnclosingRadius();
        }
        Vector3d v1 = Util3D.vector(shape1.getCenter(), shape2.getCenter());
        Util3D.safeNormalize(v1, 0.0);
        Vector3d v2 = GeomConstants.VEC3D_ZERO;
        switch (ctype) {
            case 1: {
                collt = Inter.movingShapeMovingShapeIsect((PolygonShape)shape1, v1, (PolygonShape)shape2, v2, 1.0E-6);
                break;
            }
            case 3: {
                if (type1 == 1) {
                    collt = Inter.movingShapeMovingShapeIsect((CylinderShape)shape2, v2, (PolygonShape)shape1, v1, 1.0E-6);
                    break;
                }
                collt = Inter.movingShapeMovingShapeIsect((CylinderShape)shape1, v1, (PolygonShape)shape2, v2, 1.0E-6);
                break;
            }
            default: {
                assert (false);
                return Double.POSITIVE_INFINITY;
            }
        }
        if (collt == null || collt[1] <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return collt[0];
    }

    public static boolean isConvex(List<Point3d> points) {
        if (points.size() < 4) {
            return true;
        }
        boolean sign = false;
        int n = points.size();
        for (int i = 0; i < n; ++i) {
            double dx1 = points.get((int)((i + 2) % n)).x - points.get((int)((i + 1) % n)).x;
            double dy1 = points.get((int)((i + 2) % n)).y - points.get((int)((i + 1) % n)).y;
            double dx2 = points.get((int)i).x - points.get((int)((i + 1) % n)).x;
            double dy2 = points.get((int)i).y - points.get((int)((i + 1) % n)).y;
            double zcrossproduct = dx1 * dy2 - dy1 * dx2;
            if (i == 0) {
                sign = zcrossproduct > 0.0;
                continue;
            }
            if (sign == zcrossproduct > 0.0) continue;
            return false;
        }
        return true;
    }

    public static double pointLineSegDistance(Point3d p, Point3d l1, Point3d l2) {
        return p.distance(Inter.nearPointOnLineSeg(p, l1, l2));
    }

    public static WingedEdge getEdgeForTriPoint(TriPoint tp) {
        for (WingedEdgeUse eu : tp.tri.eu) {
            if (!Inter.isPointOnLineSeg(tp.p, eu.wedge.p1(), eu.wedge.p2(), 1.0E-6)) continue;
            return eu.wedge;
        }
        return null;
    }

    public static class MinkowskiEdge
    implements Comparable<MinkowskiEdge> {
        private Point3d p1;
        private Point3d p2;
        private Double angle;

        public MinkowskiEdge(Point3d p1, Point3d p2) {
            this.p1 = new Point3d(p1);
            this.p2 = new Point3d(p2);
            Vector3d dir = new Vector3d(p2);
            dir.sub(this.p1);
            this.angle = -Math.atan2(dir.x * VEC_RIGHT.y - dir.y * VEC_RIGHT.x, dir.x * VEC_RIGHT.x + dir.y * VEC_RIGHT.y);
        }

        public void shift(Point3d shiftPoint) {
            Vector3d shiftDir = new Vector3d(shiftPoint);
            shiftDir.sub(this.p1);
            this.p1.add(shiftDir);
            this.p2.add(shiftDir);
            assert (this.p1.epsilonEquals(shiftPoint, 1.0E-4));
        }

        @Override
        public int compareTo(MinkowskiEdge other) {
            return this.angle.compareTo(other.angle);
        }
    }
}

