/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.RoomGoal;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.WanderRoom;
import inferno.sim.steering.inverse.WanderRoomSafe;
import java.io.Serializable;
import java.util.Collection;

public class WaitUntilInsideGoal
implements IIdleGoal,
Serializable {
    static final long serialVersionUID = 1L;
    private final Collection<ANode> d_goals;

    public WaitUntilInsideGoal(Collection<ANode> goals) {
        this.d_goals = goals;
    }

    public int hashCode() {
        return 0x224221 + GoalUtil.setHashCode(this.d_goals);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof WaitUntilInsideGoal && GoalUtil.setsEqual(this.d_goals, ((WaitUntilInsideGoal)obj).d_goals);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public Collection<ANode> getGoals() {
        return this.d_goals;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public static class Instance
    implements IIdleGoalInstance {
        static final long serialVersionUID = 1L;
        private WaitUntilInsideGoal waitUntilInsideGoal;

        public Instance(WaitUntilInsideGoal waitUntilInsideGoal) {
            this.waitUntilInsideGoal = waitUntilInsideGoal;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.waitUntilInsideGoal;
        }

        @Override
        public ISeekCalc getIdleSeek(KB kb, OccAgent occ) {
            RoomGoal rg = new RoomGoal(this.waitUntilInsideGoal.getGoals());
            WanderRoom wander = new WanderRoom(kb, occ, rg.getRooms(), false);
            IPathPlanner backupPlanner = rg.getPathPlanner(kb, occ);
            return new WanderRoomSafe(wander, rg.getRooms(), backupPlanner);
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            for (ANode goalNode : this.waitUntilInsideGoal.d_goals) {
                if (occ.getOcc().curNode != goalNode) continue;
                return true;
            }
            return false;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue crossedDoor) {
        }

        @Override
        public double getEndTime(KB kb) {
            return Double.POSITIVE_INFINITY;
        }
    }
}

