/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.ai.IProgressNote;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.util.function.Function;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.util.Pair;

public class SeekProgressNote
implements IProgressNote {
    private final ANode d_nextDoorInPath;
    private final boolean d_makingProgress;
    private final double d_minDistToGoal;

    public SeekProgressNote(KB kb, OccAgent src, ANode nextDoorInPath, double distToGoal, IProgressNote prevProgress) {
        this.d_nextDoorInPath = nextDoorInPath;
        Pair<Boolean, Double> progress = SeekProgressNote.isMakingProgress(kb, src, prevProgress, nextDoorInPath, distToGoal);
        this.d_makingProgress = (Boolean)progress.v1;
        this.d_minDistToGoal = (Double)progress.v2;
    }

    private static Pair<Boolean, Double> isMakingProgress(KB kb, OccAgent agent, IProgressNote prevProgress, ANode currDoor, double currGoalDist) {
        double openTime;
        if (!(prevProgress instanceof SeekProgressNote)) {
            return new Pair<Boolean, Double>(true, currGoalDist);
        }
        SeekProgressNote prevSeek = (SeekProgressNote)prevProgress;
        if (currDoor != prevSeek.d_nextDoorInPath) {
            return new Pair<Boolean, Double>(true, currGoalDist);
        }
        if (currGoalDist < prevSeek.d_minDistToGoal) {
            return new Pair<Boolean, Double>(true, currGoalDist);
        }
        currGoalDist = prevSeek.d_minDistToGoal;
        Function<Double, Pair> getProgressCloseToDoor = goalDist -> {
            double distToDoorSq = currDoor.getDoorEdges().stream().mapToDouble(e -> Inter3D.distSqToNearestPtOnLineSeg(e.base.n1.p, e.base.n2.p, agent.getPos())).min().getAsDouble();
            double distToDoor = Math.sqrt(distToDoorSq);
            return new Pair<Boolean, Double>(distToDoor < agent.getGeometryRadius() * 2.0, (Double)goalDist);
        };
        if (currDoor != null && currDoor.isClosed(kb, agent) && !Double.isInfinite(openTime = currDoor.getNextOpenTime(kb, agent))) {
            if (currDoor.isTransportDoor() && agent.getOcc().curNode.isTransportNode()) {
                return new Pair<Boolean, Double>(true, currGoalDist);
            }
            return getProgressCloseToDoor.apply(currGoalDist);
        }
        if (currDoor != null && currDoor.doorQueue.isQueueable(kb, null) && currDoor.doorQueue.contains(agent)) {
            return getProgressCloseToDoor.apply(currGoalDist);
        }
        return new Pair<Boolean, Double>(false, currGoalDist);
    }

    @Override
    public boolean isMakingProgress(KB kb, Object src, IProgressNote prevProgress) {
        return this.d_makingProgress;
    }
}

