/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.ai.ChangeBehaviorGoal;
import inferno.data2.ai.DetachGoal;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.sim.BehaviorSim;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.RegroupPlanner;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.inverse.ASeek;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.SeekPathAwayFromDoors;
import inferno.sim.steering.inverse.WanderRoom;
import inferno.sim.steering.inverse.WanderRoomSafe;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.sim.steering.locallyquickest.RoomTarget;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

public class RoomGoal
implements ISeekGoal,
Serializable {
    private static final long serialVersionUID = 3650842319151241671L;
    private final Collection<ANode> d_rooms;

    public RoomGoal(Collection<ANode> rooms) {
        assert (!rooms.contains(null)) : "Room goal list contains null.";
        this.d_rooms = rooms;
    }

    public int hashCode() {
        return -1883596 + GoalUtil.setHashCode(this.d_rooms);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RoomGoal)) {
            return false;
        }
        RoomGoal rg = (RoomGoal)obj;
        return GoalUtil.setsEqual(this.d_rooms, rg.d_rooms);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public Instance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public Collection<ANode> getRooms() {
        return this.d_rooms;
    }

    public IPathPlanner getPathPlanner(KB kb, OccAgent agent) {
        RoomTarget target = new RoomTarget(this.d_rooms);
        return new LocallyQuickest(agent, new LocalTimeEstimate.QueueSizes(), target);
    }

    public static class Instance
    implements Serializable,
    ISeekGoalInstance {
        private static final long serialVersionUID = 1L;
        private final RoomGoal d_goal;
        private transient IProgressNote d_progress;

        public Instance(RoomGoal goal) {
            this.d_goal = goal;
        }

        @Override
        public RoomGoal getGoal() {
            return this.d_goal;
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            return this.d_goal.d_rooms.contains(occ.getOcc().curNode);
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue crossedDoor) {
        }

        @Override
        public void end(KB kb, OccAgent occ) {
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            this.d_progress = GoalUtil.getSeekProgress(kb, occ, this.d_progress);
            return this.d_progress;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            IPathPlanner planner = this.d_goal.getPathPlanner(kb, agent);
            return SteerUtil.newSeekSteer(kb, agent, planner);
        }

        @Override
        public ISeekCalc getIdleSeek(KB kb, OccAgent occ) {
            boolean avoidAllDoors = false;
            if (occ.getOcc().requiresAssistance) {
                BehaviorSim.BehaviorInProgress behavior = occ.getOcc().behaviorStack.peek();
                for (int m = behavior.goalIndex + 1; m < behavior.behavior.size(); ++m) {
                    IGoal goal = behavior.behavior.get(m);
                    if (goal instanceof DetachGoal) {
                        avoidAllDoors = true;
                        break;
                    }
                    if (goal instanceof ChangeBehaviorGoal) {
                        for (BehaviorSim b : ((ChangeBehaviorGoal)goal).getAllTargetBehaviors()) {
                            if (b.deepContainsAny(ISeekGoal.class)) break;
                        }
                        continue;
                    }
                    if (goal instanceof ISeekGoal) break;
                }
            }
            return this.getIdleSeek(kb, occ, avoidAllDoors);
        }

        public ISeekCalc getIdleSeek(KB kb, OccAgent occ, boolean avoidAllDoors) {
            Predicate<ANode> wanderFilter = r -> r.getRadiusModifier() != null && r.getRadiusModifier() == 0.0 && r.getMaxOccupants() != Integer.MAX_VALUE;
            ASeek wander = this.d_goal.getRooms().stream().anyMatch(wanderFilter) ? new WanderRoom(kb, occ, this.d_goal.getRooms(), false) : new SeekPathAwayFromDoors(kb, occ, avoidAllDoors);
            IPathPlanner backupPlanner = this.d_goal.getPathPlanner(kb, occ);
            if (occ.getOcc().occupantGroup == null) {
                return new WanderRoomSafe(wander, this.d_goal.getRooms(), backupPlanner);
            }
            return new RegroupPlanner.RegroupPlannerWanderRoomSafe(occ, kb, wander, this.d_goal.getRooms(), backupPlanner);
        }

        @Override
        public boolean isUrgent(KB kb, OccAgent occ) {
            for (ANode node : this.d_goal.d_rooms) {
                if (node.getElevatorLevel() == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public TriPoint getSeekPoint(KB kb, OccAgent occ) {
            ANode seekRoom = this.d_goal.d_rooms.contains(occ.getOcc().curNode) ? occ.getOcc().curNode : (ANode)this.d_goal.d_rooms.iterator().next();
            if (seekRoom == null) {
                return occ.getLoc();
            }
            List<Tri> tris = seekRoom.getMesh();
            if (tris.isEmpty()) {
                return occ.getLoc();
            }
            Tri tri = tris.get(0);
            return new TriPoint(tri, tri.center);
        }

        @Override
        public boolean contains(KB kb, OccAgent occ, TriPoint p) {
            return this.d_goal.d_rooms.contains(p.tri.node);
        }

        @Override
        public Collection<ANode> getDestinationRooms() {
            return this.d_goal.d_rooms;
        }

        @Override
        public boolean shouldFillRoomOnDetach(KB kb, OccAgent agent) {
            return true;
        }
    }
}

