/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.QMetaQueue;
import inferno.data2.TriPoint;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.PathGen;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.RegroupPlanner;
import inferno.sim.steering.Shortest;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.Seek;
import inferno.sim.steering.inverse.Wander;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.sim.steering.locallyquickest.PointTarget;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import thunderheadeng.util.theUtil;

public class QueueGoal
implements ISeekGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public final QMetaQueue qSrc;
    private final boolean useShortestPlanner = false;

    public QueueGoal(QMetaQueue qSrc) {
        this.qSrc = qSrc;
    }

    public int hashCode() {
        return 1714717917 + Objects.hashCode(this.qSrc);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        QueueGoal qg = (QueueGoal)obj;
        return false == qg.useShortestPlanner && Objects.equals(this.qSrc, qg.qSrc);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public ISeekGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this, agent, kb);
    }

    public static class Instance
    implements ISeekGoalInstance {
        private static final long serialVersionUID = 1L;
        private final QueueGoal d_queueGoal;
        private State d_state = State.NO_PATH_CHOSEN;
        private QMetaQueue.ProcessOption d_choice;
        private double d_processTime;
        private transient IProgressNote d_progress;

        public Instance(QueueGoal queueGoal, OccAgent occ, KB kb) {
            this.d_queueGoal = queueGoal;
            this.d_state = State.NO_PATH_CHOSEN;
            this.d_processTime = this.d_queueGoal.qSrc.getProcessTime(kb, occ);
        }

        private void choosePath(KB kb, OccAgent occ) {
            QMetaQueue.ProcessOption successfulOption = this.d_queueGoal.qSrc.processOccupant(kb, occ);
            if (successfulOption == null) {
                this.d_state = State.FAILED;
                this.d_choice = null;
            } else if (successfulOption.chosenQ != null) {
                this.d_choice = successfulOption;
                this.d_choice.parentQ.addUnprocessedOccupant(occ, successfulOption);
                if (!successfulOption.temporary) {
                    this.d_state = State.QUEUING;
                }
            }
        }

        @Override
        public ISeekGoal getGoal() {
            return this.d_queueGoal;
        }

        @Override
        public boolean needsNewSteeringBehavior(KB kb, OccAgent occ) {
            switch (this.d_state) {
                case QUEUING: {
                    return this.d_choice.parentQ.shouldOccupantUpdateSteering(occ, this.d_choice.leader);
                }
                case NO_PATH_CHOSEN: {
                    return this.isTimeToChoose(kb);
                }
            }
            return false;
        }

        private boolean isTimeToChoose(KB kb) {
            return theUtil.ge(kb.getCurrentSimTime(), this.d_processTime, 1.0E-6);
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            Supplier<ISteeringBehavior> getIdleSteerInPlace = () -> SteerUtil.newIdleSteer(kb, occ, () -> new Wander(), () -> new ITpSource.ConstTpSource(occ.getLoc()));
            if (this.d_state == State.NO_PATH_CHOSEN && this.isTimeToChoose(kb)) {
                this.choosePath(kb, occ);
            }
            if (this.d_state != State.QUEUING) {
                return getIdleSteerInPlace.get();
            }
            TriPoint tp = this.d_choice.parentQ.getOccupantTriPoint(occ, this.d_choice.leader);
            if (tp == null || this.d_choice.parentQ.isOccupantIdling(occ)) {
                return getIdleSteerInPlace.get();
            }
            LocallyQuickest pathPlanner = new LocallyQuickest(occ, new LocalTimeEstimate.QueueSizes(), new PointTarget(new ITpSource.ConstTpSource(tp)));
            return SteerUtil.newSeekSteer(kb, occ, pathPlanner);
        }

        @Override
        public void end(KB kb, OccAgent occ) {
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            if (this.d_state == State.QUEUING && this.d_choice.parentQ.getOccupantReady(occ, true)) {
                this.d_state = State.REACHED;
            }
            return this.d_state.terminal;
        }

        @Override
        public ISeekCalc getIdleSeek(KB kb, OccAgent occ) {
            PathGen.PointGoal pg = new PathGen.PointGoal(this.getSeekPoint(kb, occ));
            Shortest planner = new Shortest(Arrays.asList(pg), false);
            if (occ.getOcc().occupantGroup != null) {
                RegroupPlanner regroupPlanner = RegroupPlanner.createRegroupPlanner(occ, kb, planner);
                return new Seek(kb, occ, regroupPlanner, 0.2);
            }
            return new Seek(kb, occ, planner, 0.2);
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            switch (this.d_state) {
                case QUEUING: {
                    this.d_progress = this.d_choice.parentQ.checkProgress();
                    break;
                }
                default: {
                    this.d_progress = IProgressNote.PROGRESSING;
                }
            }
            return this.d_progress;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public boolean contains(KB kb, OccAgent occ, TriPoint p) {
            switch (this.d_state) {
                case QUEUING: {
                    TriPoint storedDest = this.d_choice.parentQ.getLastKnownSteeringDest(occ, this.d_choice.leader);
                    if (storedDest != null) {
                        return p.p.distanceSquared(storedDest.p) <= 0.04000000000000001;
                    }
                    return false;
                }
            }
            return false;
        }

        @Override
        public TriPoint getSeekPoint(KB kb, OccAgent occ) {
            switch (this.d_state) {
                case QUEUING: {
                    return this.d_choice.parentQ.getLastKnownSteeringDest(occ, this.d_choice.leader);
                }
            }
            return occ.getLoc();
        }

        @Override
        public boolean isUrgent(KB kb, OccAgent occ) {
            return false;
        }

        @Override
        public Collection<ANode> getDestinationRooms() {
            return Collections.emptySet();
        }

        @Override
        public boolean shouldFillRoomOnDetach(KB kb, OccAgent agent) {
            return false;
        }

        private static enum State {
            NO_PATH_CHOSEN(false),
            QUEUING(false),
            FAILED(true),
            REACHED(true);

            public final boolean terminal;

            private State(boolean terminal) {
                this.terminal = terminal;
            }
        }
    }
}

