/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.ElevatorLevel;
import inferno.data2.IElevator;
import inferno.data2.TriPoint;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.ai.RoomGoal;
import inferno.data2.ai.WaitUntilInsideGoal;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.inverse.ElevatorSteeringBehavior;
import inferno.sim.steering.inverse.ISeekCalc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import thunderheadeng.util.theUtil;

public class ElevatorGoal
implements ISeekGoal,
Serializable {
    static final long serialVersionUID = 1L;
    private final List<IElevator> d_elevators;
    private final boolean d_useAnyElevator;

    public ElevatorGoal(KB kb, boolean useAnyElevator, List<IElevator> elevators) {
        this.d_useAnyElevator = useAnyElevator;
        this.d_elevators = elevators;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public ISeekGoalInstance begin(KB kb, OccAgent agent) {
        ArrayList<ANode> rooms = new ArrayList<ANode>();
        ArrayList<ANode> dischargeNodes = new ArrayList<ANode>();
        for (IElevator e : this.d_elevators) {
            dischargeNodes.add(e.getTargetNode());
            if (!e.isDoubleDeck()) continue;
            dischargeNodes.add(e.getUpperTargetNode());
        }
        for (IElevator e : this.d_elevators) {
            ANode dischargeNode = e.getTargetNode();
            for (ElevatorLevel level : e.getLevels()) {
                ANode node = level.pickupNode;
                if (node == dischargeNode) continue;
                rooms.add(node);
            }
        }
        ElevatorGoal.sortRooms(rooms, agent.getLoc().p.z);
        return new ElevatorGoalInstance(this, kb, rooms, dischargeNodes, agent);
    }

    private static void sortRooms(List<ANode> rooms, final double occHeight) {
        Collections.sort(rooms, new Comparator<ANode>(){

            @Override
            public int compare(ANode o1, ANode o2) {
                if (o1 == o2) {
                    return 0;
                }
                Double h1 = o1.getGeometryBounds().getCenter().z;
                Double h2 = o2.getGeometryBounds().getCenter().z;
                boolean h1Eq = theUtil.eq(h1, occHeight, 0.001);
                boolean h2Eq = theUtil.eq(h2, occHeight, 0.001);
                if (h1Eq && h2Eq) {
                    return 0;
                }
                if (h1Eq) {
                    return -1;
                }
                if (h2Eq) {
                    return 1;
                }
                int comp1 = h1.compareTo(occHeight);
                int comp2 = h2.compareTo(occHeight);
                if (comp1 == 0 && comp2 == 0) {
                    return 0;
                }
                if (comp1 == 0) {
                    return -1;
                }
                if (comp2 == 0) {
                    return 1;
                }
                if (comp1 < 0 && comp2 < 0) {
                    return h2.compareTo(h1);
                }
                return h1.compareTo(h2);
            }
        });
    }

    public int hashCode() {
        return -1883595 + GoalUtil.setHashCode(this.d_elevators);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ElevatorGoal)) {
            return false;
        }
        ElevatorGoal eg = (ElevatorGoal)obj;
        return GoalUtil.setsEqual(this.d_elevators, eg.d_elevators);
    }

    public List<IElevator> getElevators() {
        return this.d_elevators;
    }

    public boolean useAnyElevator() {
        return this.d_useAnyElevator;
    }

    public class ElevatorGoalInstance
    implements ISeekGoalInstance,
    Serializable {
        static final long serialVersionUID = 1L;
        private ElevatorGoalState d_state;
        private WaitUntilInsideGoal.Instance d_waitGoalInstance;
        private final KB d_kb;
        private boolean d_needsNewSteering;
        private ElevatorSteeringBehavior d_elevatorSteering;
        private final ElevatorGoal d_elevatorGoal;

        public ElevatorGoalInstance(ElevatorGoal elevatorGoal, KB kb, List<ANode> rooms, List<ANode> dischargeNodes, OccAgent agent) {
            this.d_elevatorGoal = elevatorGoal;
            this.d_kb = kb;
            this.d_elevatorSteering = new ElevatorSteeringBehavior(rooms, kb);
            this.d_waitGoalInstance = (WaitUntilInsideGoal.Instance)new WaitUntilInsideGoal(dischargeNodes).begin(kb, agent);
            this.d_state = ElevatorGoalState.GO_TO_ROOM;
            this.d_needsNewSteering = false;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            switch (this.d_state) {
                case GO_TO_ROOM: {
                    return this.d_elevatorSteering;
                }
                case WAIT: {
                    return this.d_waitGoalInstance.generateSteeringBehavior(kb, occ);
                }
            }
            return null;
        }

        @Override
        public boolean isSeeking(KB kb, OccAgent agent) {
            switch (this.d_state) {
                case GO_TO_ROOM: {
                    return this.d_elevatorSteering.getCurrentRoomGoal() != null ? this.d_elevatorSteering.getCurrentRoomGoal().isSeeking(kb, agent) : true;
                }
                case WAIT: {
                    return this.d_waitGoalInstance.isSeeking(kb, agent);
                }
            }
            return false;
        }

        @Override
        public void end(KB kb, OccAgent occ) {
        }

        @Override
        public boolean needsNewSteeringBehavior(KB kb, OccAgent occ) {
            return this.d_needsNewSteering;
        }

        @Override
        public void update(OccAgent agent) {
            this.d_needsNewSteering = false;
            if (this.d_state.equals((Object)ElevatorGoalState.GO_TO_ROOM) && this.d_elevatorSteering.getCurrentRoomGoal().isReached(this.d_kb, agent)) {
                this.d_state = ElevatorGoalState.WAIT;
                this.d_needsNewSteering = true;
            }
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            if (this.d_state.equals((Object)ElevatorGoalState.GO_TO_ROOM)) {
                return false;
            }
            return this.d_waitGoalInstance.isReached(kb, occ);
        }

        @Override
        public ISeekCalc getIdleSeek(KB kb, OccAgent occ) {
            switch (this.d_state) {
                case GO_TO_ROOM: 
                case WAIT: {
                    return this.d_elevatorSteering.getCurrentRoomGoal().getIdleSeek(kb, occ);
                }
                case FINISHED: {
                    return this.d_waitGoalInstance.getIdleSeek(kb, occ);
                }
            }
            return null;
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            switch (this.d_state) {
                case GO_TO_ROOM: {
                    return this.d_elevatorSteering.getCurrentRoomGoal().getProgress(kb, occ);
                }
                case WAIT: {
                    return this.d_waitGoalInstance.getProgress(kb, occ);
                }
            }
            return null;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
            switch (this.d_state) {
                case GO_TO_ROOM: {
                    this.d_elevatorSteering.getCurrentRoomGoal().doorCrossed(agent, door);
                    break;
                }
                case WAIT: {
                    this.d_waitGoalInstance.doorCrossed(agent, door);
                }
            }
        }

        @Override
        public ISeekGoal getGoal() {
            return this.d_elevatorGoal;
        }

        @Override
        public boolean contains(KB kb, OccAgent occ, TriPoint p) {
            switch (this.d_state) {
                case GO_TO_ROOM: {
                    return this.d_elevatorSteering.getCurrentRoomGoal() != null ? this.d_elevatorSteering.getCurrentRoomGoal().contains(kb, occ, p) : false;
                }
                case WAIT: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public Collection<ANode> getDestinationRooms() {
            switch (this.d_state) {
                case GO_TO_ROOM: {
                    return this.d_elevatorSteering.getCurrentRoomGoal() != null ? this.d_elevatorSteering.getCurrentRoomGoal().getDestinationRooms() : Collections.emptyList();
                }
            }
            return Collections.emptySet();
        }

        @Override
        public boolean shouldFillRoomOnDetach(KB kb, OccAgent agent) {
            return true;
        }

        @Override
        public TriPoint getSeekPoint(KB kb, OccAgent occ) {
            return this.d_elevatorSteering.getCurrentRoomGoal().getSeekPoint(kb, occ);
        }

        @Override
        public boolean isUrgent(KB kb, OccAgent occ) {
            switch (this.d_state) {
                case GO_TO_ROOM: {
                    return this.d_elevatorSteering.getCurrentRoomGoal().isUrgent(kb, occ);
                }
                case WAIT: {
                    return false;
                }
            }
            return false;
        }

        public RoomGoal.Instance getRoomGoal() {
            return this.d_elevatorSteering.getCurrentRoomGoal();
        }
    }

    private static enum ElevatorGoalState {
        GO_TO_ROOM,
        WAIT,
        FINISHED;

    }
}

