/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.OccPriority;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.geom.SeekCurve;
import inferno.geom.Util;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathGen;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.LostException;
import inferno.sim.steering.PathFollow;
import inferno.sim.steering.Shortest;
import inferno.sim.steering.Steer;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.Seek;
import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;

public class ControlledOccGoal
implements IGoal,
Serializable {
    static final long serialVersionUID = 1L;
    public static final ControlledOccGoal INSTANCE = new ControlledOccGoal();

    protected ControlledOccGoal() {
    }

    @Override
    public IGoalInstance begin(KB kb, OccAgent agent) {
        return new ControlledOccGoalInstance();
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public static class Controls
    implements ISteeringBehavior,
    Serializable {
        private Steer d_steer;

        public Controls(OccAgent oa) {
            this.d_steer = new Steer(null, new Vector3d(), oa.getDirFacing(), OccPriority.init(1, 0.0), 1.0, Filters.acceptAll(), false, new OccAgent[0]);
        }

        @Override
        public double getTimeLimit(KB kb, OccAgent agent) {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        }

        @Override
        public PathFollow getPathFollow(OccAgent agent) {
            return null;
        }

        @Override
        public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
            LineSeg3D curve = new LineSeg3D(agent.getPos(), Util3D.add(agent.getPos(), (Tuple3d)agent.getOcc().orient));
            return Util.generateSeekCurve(kb, agent, curve, true, EdgeFilters.rejectAllExits());
        }

        @Override
        public synchronized Steer steer(KB world, OccAgent agent, SeekCurve seek, Predicate<OccAgent> agentFilter) {
            return this.d_steer;
        }

        public synchronized void set(Vector3d vel, double turnVel) {
            this.d_steer = new Steer(null, vel, turnVel, this.d_steer.priority, 1.0, this.d_steer.collisionFilter, false, new OccAgent[0]);
        }
    }

    protected static class ControlledOccGoalInstance
    implements IGoalInstance,
    Serializable {
        static final long serialVersionUID = 1L;
        private boolean d_crossedExit = false;

        protected ControlledOccGoalInstance() {
        }

        @Override
        public IGoal getGoal() {
            return INSTANCE;
        }

        @Override
        public ISeekCalc getIdleSeek(KB kb, OccAgent occ) {
            PathGen.PointGoal pg = new PathGen.PointGoal(occ.getLoc());
            Shortest planner = new Shortest(Arrays.asList(pg), false);
            return new Seek(kb, occ, planner, 0.5);
        }

        @Override
        public void end(KB kb, OccAgent agent) {
        }

        @Override
        public boolean isReached(KB kb, OccAgent agent) {
            return this.d_crossedExit;
        }

        @Override
        public boolean isSeeking(KB kb, OccAgent agent) {
            return true;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue crossedDoor) {
            this.d_crossedExit = crossedDoor != null && crossedDoor.isExitDoor();
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            return IProgressNote.PROGRESSING;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            return new Controls(occ);
        }
    }
}

