/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.Tag;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.Collection;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TriConsumer;

public class ChangeTagGoal
implements IIdleGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TAG_NAME_LAST_GOAL_STARTED = "last_goal_started";
    public final Collection<Tag> tags;
    public final Op operator;

    public ChangeTagGoal(Op operator, Tag ... tags) {
        this(operator, Sets.fromArrayLHS(tags));
    }

    public ChangeTagGoal(Op operator, Collection<Tag> tags) {
        this.tags = tags;
        this.operator = operator;
    }

    public static ChangeTagGoal tag(Tag ... tags) {
        return new ChangeTagGoal(Op.TAG, tags);
    }

    public static ChangeTagGoal untag(Tag ... tags) {
        return new ChangeTagGoal(Op.UNTAG, tags);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ChangeTagGoal && ((ChangeTagGoal)obj).operator.equals((Object)this.operator) && GoalUtil.setsEqual(((ChangeTagGoal)obj).tags, this.tags);
    }

    public int hashCode() {
        return 0x12398FA ^ this.operator.hashCode() + GoalUtil.setHashCode(this.tags);
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public static class Instance
    implements IIdleGoalInstance {
        static final long serialVersionUID = 1L;
        private ChangeTagGoal changeTagGoal;

        public Instance(ChangeTagGoal changeTagGoal) {
            this.changeTagGoal = changeTagGoal;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.changeTagGoal;
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            return true;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public void end(KB kb, OccAgent occ) {
            IIdleGoalInstance.super.end(kb, occ);
            for (Tag tag : this.changeTagGoal.tags) {
                this.changeTagGoal.operator.func.accept(kb, tag, occ);
            }
        }

        @Override
        public double getEndTime(KB kb) {
            return Double.POSITIVE_INFINITY;
        }
    }

    public static enum Op {
        TAG((kb, tag, agent) -> tag.tag(kb.getCurrentSimTime(), (OccAgent)agent)),
        UNTAG((kb, tag, agent) -> tag.untag(kb.getCurrentSimTime(), (OccAgent)agent));

        public final TriConsumer<KB, Tag, OccAgent> func;

        private Op(TriConsumer<KB, Tag, OccAgent> func) {
            this.func = func;
        }
    }
}

