/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.Occupant;
import inferno.data2.QBaseQueue;
import inferno.data2.TriPoint;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;

public class QServicePoint
implements Serializable {
    static final long serialVersionUID = 1L;
    private QBaseQueue d_parent;
    private OccAgent d_curOcc;
    private TriPoint d_location;
    private boolean d_ready = true;
    private boolean d_serviceWaiting = false;
    private IDistributedVal<UnitDouble> d_waitTimeDist;
    private double d_waitTime = 4.0;
    private double d_timer = 0.0;

    public QServicePoint(TriPoint loc, IDistributedVal<UnitDouble> dist) {
        this.d_location = loc;
        this.d_waitTimeDist = dist;
    }

    protected void setParent(QBaseQueue parent) {
        this.d_parent = parent;
    }

    public void setDistTime(IDistributedVal<UnitDouble> waitTimeDist) {
        this.d_waitTimeDist = waitTimeDist;
    }

    public boolean isReady() {
        return this.d_ready;
    }

    protected void setReady(boolean ready) {
        this.d_ready = ready;
    }

    public OccAgent getServicingOcc() {
        return this.d_curOcc;
    }

    protected void setServicingOcc(OccAgent occ) {
        this.d_curOcc = occ;
    }

    public double getAvgWaitTime() {
        double time = 1.0;
        if (this.d_waitTimeDist instanceof ICurve) {
            time = ((ICurve)this.d_waitTimeDist).getAvg().getValue(SI.SECOND);
        } else if (this.d_waitTimeDist instanceof IUrn) {
            double avg = 0.0;
            Map weights = ((IUrn)this.d_waitTimeDist).getWeights();
            for (UnitDouble dub : weights.keySet()) {
                avg += dub.getValue(SI.SECOND) * weights.get(dub);
            }
            time = avg;
        }
        return time;
    }

    private void dischargeOccupant() {
        if (this.d_parent.tryDischargeOccupant(this.d_curOcc)) {
            this.d_timer = 0.0;
            this.d_serviceWaiting = false;
            this.d_ready = true;
            this.d_curOcc = null;
        }
    }

    public boolean isServicing() {
        return this.d_serviceWaiting;
    }

    public void arriveOccupant(KB kb, Occupant occ) {
        this.d_serviceWaiting = true;
        Random rnd = kb.getTimeBasedRandom(occ, 547786162991L);
        this.d_waitTime = this.d_waitTimeDist.getValue(rnd).getValue(SI.SECOND);
    }

    public TriPoint getLocation() {
        return this.d_location;
    }

    public void update(KB kb, double dt) {
        if (this.d_serviceWaiting) {
            if (this.d_timer < this.d_waitTime) {
                this.d_timer += dt;
            } else {
                this.dischargeOccupant();
            }
        } else if (this.d_curOcc != null && this.d_curOcc.getLoc().p.distance(this.d_location.p) <= this.d_parent.getEndPointRadius(this.d_curOcc)) {
            this.arriveOccupant(kb, this.d_curOcc.getOcc());
        }
    }

    public IDistributedVal<?> getServiceTimeDistribution() {
        return this.d_waitTimeDist;
    }

    protected IDistributedVal<UnitDouble> getWaitTimeDist() {
        return this.d_waitTimeDist;
    }
}

