/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.data2.Edge;
import inferno.data2.EdgeData;
import inferno.data2.Mesh;
import inferno.data2.Tri;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.geom.Util;
import inferno.sim.DoorQueue;
import java.lang.invoke.LambdaMetafactory;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.IntStream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Global;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class MeshBuilder {
    private final List<Vertex> d_verts;
    private final Map<MEdge, EdgeData> d_edgeData = new LinkedHashMap<MEdge, EdgeData>();
    private final Set<MEdge> d_reverseEdges = new HashSet<MEdge>();
    private final Map<MEdge, Edge> d_edges = new HashMap<MEdge, Edge>();
    private final SortedMap<MTri, TriInfo> d_triInfo = new TreeMap<MTri, TriInfo>();
    private List<Tri> d_tris;
    private final Map<WEdgeKey, WingedEdge> d_wingedEdges = new LinkedHashMap<WEdgeKey, WingedEdge>();
    private final Map<Integer, List<Tri>> d_vertTriAdj = new LinkedHashMap<Integer, List<Tri>>();
    private final Map<MEdge, List<Tri>> d_edgeTriAdj = new LinkedHashMap<MEdge, List<Tri>>();
    private final EdgeData d_internalED = new EdgeData(null, 0);
    private final EdgeData d_boundaryED = new EdgeData(null, 4);
    private transient MTri[] t_orderedMTris = null;
    private static final double PI2 = Math.PI * 2;

    private static int compare(Point3d p1, Point3d p2) {
        int comp = Double.compare(p1.x, p2.x);
        if (comp != 0) {
            return comp;
        }
        comp = Double.compare(p1.y, p2.y);
        if (comp != 0) {
            return comp;
        }
        return Double.compare(p1.z, p2.z);
    }

    private static int compare(int i1, int i2, List<Vertex> verts) {
        return MeshBuilder.compare(verts.get((int)i1).p, verts.get((int)i2).p);
    }

    public MeshBuilder(List<Point3d> points) {
        this.d_verts = new ArrayList<Vertex>(points.size());
        for (Point3d p : points) {
            this.d_verts.add(new Vertex(this.d_verts.size(), p));
        }
    }

    public MEdge addBoundaryEdge(int i1, int i2) {
        return this.addSpecialEdge(this.d_boundaryED, i1, i2);
    }

    public MEdge addDoorEdge(ANode doorNode, int i1, int i2) {
        EdgeData data = new EdgeData(doorNode, 1);
        return this.addSpecialEdge(data, i1, i2);
    }

    public MEdge addExitDoorEdge(ANode doorNode, int i1, int i2) {
        EdgeData data = new EdgeData(doorNode, 3);
        return this.addSpecialEdge(data, i1, i2);
    }

    private MEdge addSpecialEdge(EdgeData data, int i1, int i2) {
        if (i1 < 0 || i1 >= this.d_verts.size() || i2 < 0 || i2 >= this.d_verts.size() || i1 == i2) {
            return null;
        }
        MEdge me = new MEdge(this.d_verts, i1, i2);
        this.d_edgeData.put(me, data);
        return me;
    }

    public EdgeData getEdgeData(MEdge medge) {
        return this.d_edgeData.get(medge);
    }

    public MTri addTri(ANode node, Tri.Terrain terrain, int i1, int i2, int i3) {
        if (node == null || !this.checkRange(i1, i2, i3) || i1 == i2 || i1 == i3 || i2 == i3) {
            return null;
        }
        MTri t = new MTri(this.d_verts, i1, i2, i3);
        if (this.d_triInfo.containsKey(t)) {
            return null;
        }
        TriInfo ti = new TriInfo(node, terrain);
        this.d_triInfo.put(t, ti);
        return t;
    }

    public int indexOf(MTri mt) {
        SortedMap<MTri, TriInfo> trisBefore = this.d_triInfo.headMap(mt);
        return trisBefore.size();
    }

    private boolean checkRange(int ... ixes) {
        for (int ix : ixes) {
            if (ix >= 0 && ix < this.d_verts.size()) continue;
            return false;
        }
        return true;
    }

    public List<Vertex> getVerts() {
        return this.d_verts;
    }

    public Mesh finish(List<Error> errors, IUnitSrc lenUnit) {
        this.validateEdgeData(errors, lenUnit);
        this.buildTris();
        this.buildEdges();
        this.buildAdjacencyMaps();
        this.setAdjacency();
        this.validateEdgeAdjacency(errors, lenUnit);
        return new Mesh(this.d_wingedEdges.values(), this.d_tris);
    }

    private void validateEdgeAdjacency(List<Error> errors, IUnitSrc lenUnit) {
        for (Map.Entry<MEdge, List<Tri>> entry : this.d_edgeTriAdj.entrySet()) {
            MEdge me = entry.getKey();
            List<Tri> adjTris = entry.getValue();
            if (adjTris.size() <= 2) continue;
            String msg = String.format(Intl.intl("Edge is adjacent to more than 2 triangles.\nLocation: %s - %s"), MeshBuilder.formatPoint3d(this.d_verts.get((int)me.i1).p, "0.0#", lenUnit), MeshBuilder.formatPoint3d(this.d_verts.get((int)me.i2).p, "0.0#", lenUnit));
            String fix = Intl.intl("Check for overlapping doors/stairways and stairway clearance.");
            errors.add(new Error(ErrorLevel.MODERATE, msg, fix, me));
        }
    }

    public List<MTri> getAdjTris(MEdge edge) {
        if (this.t_orderedMTris == null) {
            this.t_orderedMTris = this.d_triInfo.keySet().toArray(new MTri[this.d_triInfo.size()]);
        }
        List<Tri> tris = this.d_edgeTriAdj.get(edge);
        ArrayList<MTri> adjTris = new ArrayList<MTri>(tris.size());
        for (Tri tri : tris) {
            adjTris.add(this.t_orderedMTris[tri.id]);
        }
        return adjTris;
    }

    private void buildTris() {
        this.d_tris = new ArrayList<Tri>(this.d_triInfo.size());
        for (Map.Entry<MTri, TriInfo> entry : this.d_triInfo.entrySet()) {
            MTri mtri = entry.getKey();
            TriInfo ti = entry.getValue();
            Vertex v1 = this.d_verts.get(mtri.v[0]);
            Vertex v2 = this.d_verts.get(mtri.v[1]);
            Vertex v3 = this.d_verts.get(mtri.v[2]);
            Tri tri = new Tri(this.d_tris.size(), ti.node, ti.terrain, v1, v2, v3);
            this.d_tris.add(tri);
        }
    }

    private void buildEdges() {
        for (MTri t : this.d_triInfo.keySet()) {
            for (int m = 0; m < 3; ++m) {
                int ia = t.v[m];
                int ib = t.v[(m + 1) % 3];
                MEdge edge = new MEdge(this.d_verts, ia, ib);
                if (this.d_reverseEdges.contains(edge)) {
                    edge = edge.reverse();
                }
                this.d_edges.put(edge, new Edge(this.d_verts.get(edge.i1), this.d_verts.get(edge.i2)));
            }
        }
    }

    private void buildAdjacencyMaps() {
        this.buildVertTriAdjMap();
        this.buildEdgeTriAdjMap();
    }

    private void buildVertTriAdjMap() {
        for (int m = 0; m < this.d_verts.size(); ++m) {
            this.d_vertTriAdj.put(m, new ArrayList());
        }
        int triix = 0;
        for (MTri tri : this.d_triInfo.keySet()) {
            for (int m = 0; m < 3; ++m) {
                int ix = tri.v[m];
                List<Tri> adjTris = this.d_vertTriAdj.get(ix);
                adjTris.add(this.d_tris.get(triix));
            }
            ++triix;
        }
    }

    private void buildEdgeTriAdjMap() {
        int triix = 0;
        for (MTri mtri : this.d_triInfo.keySet()) {
            Tri tri = this.d_tris.get(triix);
            for (int m = 0; m < 3; ++m) {
                MEdge me = new MEdge(this.d_verts, mtri.v[m], mtri.v[(m + 1) % 3]);
                List<Tri> adjTris = this.d_edgeTriAdj.get(me);
                if (adjTris == null) {
                    adjTris = new ArrayList<Tri>(2);
                    this.d_edgeTriAdj.put(me, adjTris);
                }
                adjTris.add(tri);
            }
            ++triix;
        }
    }

    private WingedEdge getWingedEdge(Tri tri, int i1, int i2) {
        WingedEdge flap;
        WEdgeKey key;
        WingedEdge existing;
        MEdge medge = new MEdge(this.d_verts, i1, i2);
        Edge edge = this.d_edges.get(medge);
        Vertex v1 = this.d_verts.get(i1);
        Vertex v2 = this.d_verts.get(i2);
        EdgeData data = this.d_edgeData.get(medge);
        Tri adjTri = this.findAdjacentTri(tri, medge, v1, v2);
        if (adjTri == null) {
            if (data == null || data.type == 1 || data.type == 0) {
                data = this.d_boundaryED;
            }
        } else if (data == null) {
            data = this.d_internalED;
        }
        if (v1 != edge.n1) {
            Tri temp = tri;
            tri = adjTri;
            adjTri = temp;
        }
        if ((existing = this.d_wingedEdges.get(key = new WEdgeKey(flap = new WingedEdge(this.d_wingedEdges.size(), data, edge, tri, adjTri)))) == null) {
            this.d_wingedEdges.put(key, flap);
            existing = flap;
        }
        return existing;
    }

    private Tri findAdjacentTri(Tri tri, MEdge medge, Vertex v1, Vertex v2) {
        Vector3d edir = Util3D.vectorN(v1.p, v2.p);
        Vector3d tangent = this.getTangent(tri, edir);
        double zAngle = MeshBuilder.getZAngle(tri, edir, edir);
        Tri closestTri = null;
        double closestAngle = Double.MAX_VALUE;
        Vector3d closestEdgeDir = null;
        List<Tri> adjTris = this.d_edgeTriAdj.get(medge);
        for (Tri adjTri : adjTris) {
            if (adjTri == tri) continue;
            Vertex[] adjEdge = this.findAdjEdge(v1, v2, adjTri);
            assert (adjEdge != null);
            Vector3d edir2 = Util3D.vectorN(adjEdge[0].p, adjEdge[1].p);
            Vector3d tan2 = this.getTangent(adjTri, edir2);
            double angle = Util3D.angle0To2PI(tangent, tan2, edir);
            if (!(angle < closestAngle)) continue;
            closestAngle = angle;
            closestTri = adjTri;
            closestEdgeDir = edir2;
        }
        if (closestTri == null) {
            return null;
        }
        double zAngle2 = MeshBuilder.getZAngle(closestTri, edir, closestEdgeDir);
        if (!MeshBuilder.areAdjacentTris(zAngle, zAngle2)) {
            return null;
        }
        return closestTri;
    }

    private static double getZAngle(Tri tri, Vector3d baseEDir, Vector3d edir) {
        if (theUtil.eq0(tri.normal.z, 1.0E-9) || theUtil.eq0(edir.x, 1.0E-9) && theUtil.eq0(edir.y, 1.0E-9)) {
            return 0.0;
        }
        Vector3d tangent = new Vector3d(-edir.y, edir.x, 0.0);
        Util.projectAlongZ(tangent, tri.plane, tangent, false);
        if (theUtil.eq0(tangent.dot(tangent), 1.0E-9)) {
            return 0.0;
        }
        Vector3d axis = new Vector3d(baseEDir.x, baseEDir.y, 0.0);
        return Util3D.angle0To2PI(GeomConstants.VEC3D_ZPOS, tangent, axis);
    }

    private static boolean areAdjacentTris(double zAngle1, double zAngle2) {
        return theUtil.eq0(zAngle1, 1.0E-9) || theUtil.eq0(zAngle2, 1.0E-9) || theUtil.eq(zAngle1, Math.PI * 2, 1.0E-9) || theUtil.eq(zAngle2, Math.PI * 2, 1.0E-9) || theUtil.eq(zAngle1, Math.PI, 1.0E-9) || theUtil.eq(zAngle2, Math.PI, 1.0E-9) || zAngle1 < Math.PI && zAngle2 > Math.PI || zAngle1 > Math.PI && zAngle2 < Math.PI;
    }

    private Vertex[] findAdjEdge(Vertex v1, Vertex v2, Tri tri) {
        if (tri.v[0] == v1 && tri.v[1] == v2 || tri.v[0] == v2 && tri.v[1] == v1) {
            return new Vertex[]{tri.v[0], tri.v[1]};
        }
        if (tri.v[1] == v1 && tri.v[2] == v2 || tri.v[1] == v2 && tri.v[2] == v1) {
            return new Vertex[]{tri.v[1], tri.v[2]};
        }
        if (tri.v[2] == v1 && tri.v[0] == v2 || tri.v[2] == v2 && tri.v[0] == v1) {
            return new Vertex[]{tri.v[2], tri.v[0]};
        }
        return null;
    }

    private Vector3d getTangent(Tri tri, Vector3d edir) {
        return Util3D.cross(tri.normal, edir);
    }

    private void setAdjacency() {
        this.setVertAdjacency();
        this.setTriAdjacency();
        this.setNodeDoorAdj();
    }

    private void setVertAdjacency() {
        for (Map.Entry<Integer, List<Tri>> entry : this.d_vertTriAdj.entrySet()) {
            List<Tri> adjTris = entry.getValue();
            Vertex v = this.d_verts.get(entry.getKey());
            v.setAdjacency(adjTris.toArray(new Tri[adjTris.size()]));
        }
    }

    private void validateEdgeData(List<Error> errors, IUnitSrc lenUnit) {
        LinkedIdentityHashMap<ANode, ArrayList<MEdge>> doorEdges = new LinkedIdentityHashMap<ANode, ArrayList<MEdge>>();
        for (Map.Entry<MEdge, EdgeData> entry : this.d_edgeData.entrySet()) {
            EdgeData ed = entry.getValue();
            MEdge edge2 = entry.getKey();
            if (ed.type != 1 && ed.type != 3) continue;
            ArrayList<MEdge> edges = (ArrayList<MEdge>)doorEdges.get(ed.node);
            if (edges == null) {
                edges = new ArrayList<MEdge>(1);
                doorEdges.put(ed.node, edges);
            }
            edges.add(edge2);
        }
        Function<MEdge, UnorderedPair> getConnection = edge -> {
            ANode doorNode = this.d_edgeData.get((Object)edge).node;
            if (doorNode == null || doorNode.doorQueue == null) {
                assert (false);
                return null;
            }
            DoorQueue queue = doorNode.doorQueue;
            return new UnorderedPair<ANode, ANode>(queue.getR1(), queue.getR2());
        };
        for (Map.Entry entry : doorEdges.entrySet()) {
            Collection<MEdge> edges = (ArrayList<MEdge>)entry.getValue();
            if (edges.size() <= 1) continue;
            LinkedHashMap<UnorderedPair, Double> connections = new LinkedHashMap<UnorderedPair, Double>();
            for (MEdge edge3 : edges) {
                UnorderedPair conn = getConnection.apply(edge3);
                assert (conn != null);
                connections.merge(conn, this.length2dSq(edge3), Double::sum);
            }
            ArrayList<MEdge> discardedEdges = new ArrayList<MEdge>();
            if (connections.size() > 1) {
                Map.Entry keep = connections.entrySet().stream().max((e1, e2) -> ((Double)e1.getValue()).compareTo((Double)e2.getValue())).orElse(null);
                assert (keep != null);
                ArrayList<MEdge> keepEdges = new ArrayList<MEdge>();
                for (MEdge edge4 : edges) {
                    UnorderedPair conn = getConnection.apply(edge4);
                    if (!conn.equals(keep.getKey())) {
                        discardedEdges.add(edge4);
                        continue;
                    }
                    keepEdges.add(edge4);
                }
                assert (!keepEdges.isEmpty());
                edges = keepEdges;
            }
            ToDoubleFunction<Collection> getTotLen = edgeSet -> edgeSet.stream().mapToDouble(e -> this.length2d((MEdge)e)).sum();
            if (edges.size() > 1) {
                LinkedHashMap<Integer, TempVertex> tempVerts = MeshBuilder.buildVertGraph(edges);
                ArrayList<Pair<Set<MEdge>, Double>> connectedEdgeSets = new ArrayList<Pair<Set<MEdge>, Double>>();
                IdentityHashSet closed = new IdentityHashSet();
                for (MEdge mEdge : edges) {
                    if (closed.contains(mEdge)) continue;
                    Set<MEdge> connected = MeshBuilder.findConnectedEdges(mEdge, (Map<Integer, TempVertex>)tempVerts);
                    closed.addAll(connected);
                    connected = this.findLongestChain(connected);
                    connectedEdgeSets.add(new Pair<Set<MEdge>, Double>(connected, getTotLen.applyAsDouble(connected)));
                }
                Set longestSet = (Set)((Pair)connectedEdgeSets.stream().max((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$validateEdgeData$518(thunderheadeng.util.Pair thunderheadeng.util.Pair ), (Lthunderheadeng/util/Pair;Lthunderheadeng/util/Pair;)I)()).get()).v1;
                for (MEdge edge6 : edges) {
                    if (longestSet.contains(edge6)) continue;
                    discardedEdges.add(edge6);
                }
                edges = longestSet;
            }
            if (!discardedEdges.isEmpty()) {
                for (MEdge edge7 : discardedEdges) {
                    this.d_edgeData.put(edge7, this.d_boundaryED);
                }
                double lostLen = getTotLen.applyAsDouble(discardedEdges);
                double keepLen = getTotLen.applyAsDouble(edges);
                String string = String.format(Intl.intl("Door, \"%s\", formed invalid edge connections."), ((ANode)entry.getKey()).name);
                String fix = String.format(Intl.intl("Only keeping edges that form the longest valid connection. Kept length = %1$s, lost length = %2$s."), MeshBuilder.format(keepLen, SI.METER, lenUnit), MeshBuilder.format(lostLen, SI.METER, lenUnit));
                errors.add(new Error(ErrorLevel.LIGHT, string, fix, (MObj[])theUtil.toArray(edges)));
            }
            this.orderDoorEdges(edges);
        }
    }

    private static LinkedHashMap<Integer, TempVertex> buildVertGraph(Collection<MEdge> edges) {
        LinkedHashMap<Integer, TempVertex> tempVerts = new LinkedHashMap<Integer, TempVertex>();
        for (MEdge edge : edges) {
            tempVerts.computeIfAbsent((Integer)Integer.valueOf((int)edge.i1), (Function<Integer, TempVertex>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$buildVertGraph$519(java.lang.Integer ), (Ljava/lang/Integer;)Linferno/data2/MeshBuilder$TempVertex;)()).edges.add(edge);
            tempVerts.computeIfAbsent((Integer)Integer.valueOf((int)edge.i2), (Function<Integer, TempVertex>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$buildVertGraph$520(java.lang.Integer ), (Ljava/lang/Integer;)Linferno/data2/MeshBuilder$TempVertex;)()).edges.add(edge);
        }
        return tempVerts;
    }

    private static Set<MEdge> findConnectedEdges(MEdge seed, Map<Integer, TempVertex> tempVerts) {
        LinkedIdentityHashSet<MEdge> result = new LinkedIdentityHashSet<MEdge>();
        ArrayDeque<MEdge> open = new ArrayDeque<MEdge>();
        open.add(seed);
        result.add(seed);
        while (!open.isEmpty()) {
            MEdge edge = (MEdge)open.removeFirst();
            for (MEdge adjEdge : tempVerts.get((Object)Integer.valueOf((int)edge.i1)).edges) {
                if (!result.add(adjEdge)) continue;
                open.addLast(adjEdge);
            }
            for (MEdge adjEdge : tempVerts.get((Object)Integer.valueOf((int)edge.i2)).edges) {
                if (!result.add(adjEdge)) continue;
                open.addLast(adjEdge);
            }
        }
        return result;
    }

    private Set<MEdge> findLongestChain(Set<MEdge> edges) {
        LinkedHashMap<Integer, TempVertex> tempVerts = MeshBuilder.buildVertGraph(edges);
        IFilteredCollection<TempVertex> branchVerts = theUtil.filter(tempVerts.values(), v -> v.edges.size() > 2);
        if (branchVerts.isEmpty()) {
            return edges;
        }
        IFilteredCollection<TempVertex> singleVerts = theUtil.filter(tempVerts.values(), v -> v.edges.size() == 1);
        ArrayDeque<DoorBranchNode> open = new ArrayDeque<DoorBranchNode>();
        if (!singleVerts.isEmpty()) {
            for (TempVertex vert : singleVerts) {
                open.add(new DoorBranchNode(this, vert, vert.edges.iterator().next()));
            }
        } else {
            for (TempVertex tvert : branchVerts) {
                for (MEdge edge : tvert.edges) {
                    open.add(new DoorBranchNode(this, tvert, edge));
                }
            }
        }
        ArrayList<DoorBranchNode> allChains = new ArrayList<DoorBranchNode>();
        while (!open.isEmpty()) {
            DoorBranchNode node = (DoorBranchNode)open.removeLast();
            TempVertex nextVert = node.nextVert(tempVerts);
            if (nextVert.edges.size() == 1) {
                allChains.add(node);
                continue;
            }
            DoorBranchNode alreadyVisited = node.find(nextVert);
            if (alreadyVisited != null) {
                if (alreadyVisited.parent == null) {
                    allChains.add(node);
                    continue;
                }
                if (node.parent == null) continue;
                allChains.add(node.parent);
                continue;
            }
            for (MEdge edge : nextVert.edges) {
                if (edge == node.edge) continue;
                open.addLast(new DoorBranchNode(this, node, nextVert, edge));
            }
        }
        DoorBranchNode longest = allChains.stream().max((b1, b2) -> Double.compare(b1.totalDist, b2.totalDist)).orElse(null);
        LinkedIdentityHashSet<MEdge> result = new LinkedIdentityHashSet<MEdge>();
        while (longest != null) {
            result.add(longest.edge);
            longest = longest.parent;
        }
        assert (MeshBuilder.buildVertGraph(result).values().stream().allMatch(tv -> tv.edges.size() <= 2)) : "The resulting door edges must connect to exactly one or zero edges at each endpoint";
        return result;
    }

    private void orderDoorEdges(Collection<MEdge> edges) {
        LinkedHashMap<Integer, TempVertex> tempVerts = MeshBuilder.buildVertGraph(edges);
        TempVertex head = tempVerts.values().stream().filter(v -> v.edges.size() == 1).findFirst().orElse((TempVertex)tempVerts.values().iterator().next());
        IdentityHashSet closed = new IdentityHashSet();
        TempVertex prevVert = head;
        while (true) {
            TempVertex nextVert = null;
            assert (prevVert.edges.size() <= 2);
            for (MEdge edge : prevVert.edges) {
                int inext;
                if (!closed.add(edge)) continue;
                if (prevVert.ix == edge.i2) {
                    inext = edge.i1;
                    this.d_reverseEdges.add(edge);
                } else {
                    inext = edge.i2;
                }
                nextVert = (TempVertex)tempVerts.get(inext);
                break;
            }
            if (nextVert == null) {
                return;
            }
            prevVert = nextVert;
        }
    }

    private double length2dSq(MEdge edge) {
        Vertex v1 = this.d_verts.get(edge.i1);
        Vertex v2 = this.d_verts.get(edge.i2);
        return MeshBuilder.dist2dSq(v1.p, v2.p);
    }

    private double length2d(MEdge edge) {
        return Math.sqrt(this.length2dSq(edge));
    }

    private static double dist2dSq(Point3d p1, Point3d p2) {
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        return dx * dx + dy * dy;
    }

    private void setTriAdjacency() {
        int triix = 0;
        for (MTri mtri : this.d_triInfo.keySet()) {
            Tri tri = this.d_tris.get(triix);
            WingedEdge flap1 = this.getWingedEdge(tri, mtri.v[0], mtri.v[1]);
            WingedEdge flap2 = this.getWingedEdge(tri, mtri.v[1], mtri.v[2]);
            WingedEdge flap3 = this.getWingedEdge(tri, mtri.v[2], mtri.v[0]);
            tri.setAdjacency(flap1, flap2, flap3);
            ++triix;
        }
    }

    private void setNodeDoorAdj() {
        LinkedIdentityHashMap<ANode, List> doorEdges = new LinkedIdentityHashMap<ANode, List>();
        LinkedIdentityHashSet roomNodes = new LinkedIdentityHashSet();
        for (WingedEdge wingedEdge : this.d_wingedEdges.values()) {
            EdgeData ed = wingedEdge.data;
            if ((ed.type & 1) <= 0) continue;
            doorEdges.computeIfAbsent(ed.node, n -> new ArrayList()).add(wingedEdge);
            for (Tri adjTri : wingedEdge.getAdjTris()) {
                if (ed.node != adjTri.node && !ed.node.isAdjacent(adjTri.node)) continue;
                adjTri.node.addDoorEdge(wingedEdge);
                roomNodes.add(adjTri.node);
            }
        }
        for (Map.Entry entry : doorEdges.entrySet()) {
            ANode door = (ANode)entry.getKey();
            List unsortedEdges = (List)entry.getValue();
            Collection<WingedEdge> edges = MeshBuilder.sortDoorEdges(unsortedEdges);
            for (WingedEdge edge : edges) {
                door.addDoorEdge(edge);
            }
            door.finalizeDoors();
        }
        roomNodes.forEach(ANode::finalizeDoors);
    }

    private static Collection<WingedEdge> sortDoorEdges(List<WingedEdge> edges) {
        Vertex nextVert;
        if (edges.size() == 1) {
            return edges;
        }
        LinkedIdentityHashMap<Vertex, List<WingedEdge>> veAdj = MeshBuilder.getVertEdgeAdjacency(edges);
        Vertex seedVert = veAdj.entrySet().stream().filter(veEntry -> ((List)veEntry.getValue()).size() == 1 && ((WingedEdge)((List)veEntry.getValue()).iterator().next()).v1() == veEntry.getKey()).map(veEntry -> (Vertex)veEntry.getKey()).findFirst().orElse(edges.get(0).v1());
        ArrayList<WingedEdge> result = new ArrayList<WingedEdge>();
        Vertex prevVert = seedVert;
        block0: do {
            nextVert = null;
            for (WingedEdge edge : (List)veAdj.get(prevVert)) {
                if (edge.v1() != prevVert) continue;
                result.add(edge);
                nextVert = edge.v2();
                continue block0;
            }
        } while ((prevVert = nextVert) != seedVert && prevVert != null);
        assert (new IdentityHashSet(result).size() == edges.size());
        assert (((List)veAdj.get(((WingedEdge)result.get(0)).v1())).size() == 1) : "The first vertex must be connected to only one door edge";
        assert (((List)veAdj.get(((WingedEdge)result.get(result.size() - 1)).v2())).size() == 1) : "The last vertex must be connected to only one door edge";
        assert (IntStream.range(1, result.size()).allMatch(i -> ((WingedEdge)result.get(i)).v1() == ((WingedEdge)result.get(i - 1)).v2())) : "The second vertex of each edge must be the same as the first vertex of the next edge";
        return result;
    }

    private static LinkedIdentityHashMap<Vertex, List<WingedEdge>> getVertEdgeAdjacency(Collection<WingedEdge> edges) {
        LinkedIdentityHashMap<Vertex, List<WingedEdge>> verts = new LinkedIdentityHashMap<Vertex, List<WingedEdge>>();
        for (WingedEdge edge : edges) {
            verts.computeIfAbsent(edge.v1(), i -> new ArrayList(2)).add(edge);
            verts.computeIfAbsent(edge.v2(), i -> new ArrayList(2)).add(edge);
        }
        return verts;
    }

    private static String formatPoint3d(Point3d pt, String pattern, IUnitSrc lenType) {
        UnitPoint3D cvtPt = MeshBuilder.getUPoint3D(pt, lenType);
        String uStr = cvtPt.getUnit().toString();
        DecimalFormat fmt = new DecimalFormat(pattern);
        return String.format("(%s %s, %s %s, %s %s)", fmt.format(cvtPt.x()), uStr, fmt.format(cvtPt.y()), uStr, fmt.format(cvtPt.z()), uStr);
    }

    private static UnitPoint3D getUPoint3D(Point3d p, IUnitSrc lenType) {
        Unit curlu = lenType.getUnit();
        return UnitPoint3D.convert(p, SI.METER, curlu);
    }

    private static String format(double v, Unit srcUnit, IUnitSrc dstUnit) {
        double v2 = UnitDouble.convert(v, srcUnit, dstUnit.getUnit());
        return Global.format(v2, dstUnit.getUnit());
    }

    private static /* synthetic */ TempVertex lambda$buildVertGraph$520(Integer i) {
        return new TempVertex(i);
    }

    private static /* synthetic */ TempVertex lambda$buildVertGraph$519(Integer i) {
        return new TempVertex(i);
    }

    private static /* synthetic */ int lambda$validateEdgeData$518(Pair p1, Pair p2) {
        return Double.compare((Double)p1.v2, (Double)p2.v2);
    }

    public static enum ErrorLevel {
        LIGHT,
        MODERATE,
        CRITICAL;

    }

    public static class Error {
        public ErrorLevel level;
        public final String msg;
        public final String fix;
        public final Collection<? extends MObj> offendingObjs;

        public Error(ErrorLevel level, String msg, String fix, MObj ... offendingObjs) {
            this(level, msg, fix, Arrays.asList(offendingObjs));
        }

        public Error(ErrorLevel level, String msg, String fix, Collection<? extends MObj> offendingObjs) {
            this.level = level;
            this.msg = msg;
            this.fix = fix;
            this.offendingObjs = offendingObjs;
        }
    }

    public static interface MObj {
    }

    private static class TempVertex {
        public final int ix;
        public final Set<MEdge> edges = new LinkedIdentityHashSet<MEdge>();

        public TempVertex(int ix) {
            this.ix = ix;
        }
    }

    private static class DoorBranchNode {
        public final DoorBranchNode parent;
        public final TempVertex vert;
        public final MEdge edge;
        public final double totalDist;

        public DoorBranchNode(MeshBuilder mb, TempVertex vert, MEdge edge) {
            this(mb, null, vert, edge);
        }

        public DoorBranchNode(MeshBuilder mb, DoorBranchNode parent, TempVertex vert, MEdge edge) {
            this.parent = parent;
            this.vert = vert;
            this.edge = edge;
            double elen = mb.length2d(edge);
            this.totalDist = parent != null ? parent.totalDist + elen : elen;
        }

        public TempVertex nextVert(Map<Integer, TempVertex> tverts) {
            int nextIx = this.edge.i1 == this.vert.ix ? this.edge.i2 : this.edge.i1;
            return tverts.get(nextIx);
        }

        public DoorBranchNode find(TempVertex v) {
            if (v == this.vert) {
                return this;
            }
            if (this.parent != null) {
                return this.parent.find(v);
            }
            return null;
        }
    }

    private static class WEdgeKey {
        public final WingedEdge wedge;

        public WEdgeKey(WingedEdge wedge) {
            this.wedge = wedge;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WEdgeKey)) {
                return false;
            }
            WEdgeKey edge = (WEdgeKey)obj;
            return this.wedge.base == edge.wedge.base && this.wedge.data.equals(edge.wedge.data) && (this.wedge.t1 == edge.wedge.t1 && this.wedge.t2 == edge.wedge.t2 || this.wedge.t1 == edge.wedge.t2 && this.wedge.t2 == edge.wedge.t1);
        }

        public int hashCode() {
            return this.wedge.base.hashCode() + this.wedge.data.hashCode() + theUtil.hashCode(this.wedge.t1) + theUtil.hashCode(this.wedge.t2);
        }
    }

    public static class MTri
    implements Comparable<MTri>,
    MObj {
        private final List<Vertex> d_verts;
        public final int[] v;

        public MTri(List<Vertex> verts, int i1, int i2, int i3) {
            int min;
            this.d_verts = verts;
            int n = min = MeshBuilder.compare(i1, i2, verts) <= 0 ? i1 : i2;
            if (MeshBuilder.compare(i3, min, verts) < 0) {
                min = i3;
            }
            this.v = min == i1 ? new int[]{i1, i2, i3} : (min == i2 ? new int[]{i2, i3, i1} : new int[]{i3, i1, i2});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            MTri tri = (MTri)obj;
            return this.v[0] == tri.v[0] && this.v[1] == tri.v[1] && this.v[2] == tri.v[2];
        }

        public int hashCode() {
            return Arrays.hashCode(this.v);
        }

        @Override
        public int compareTo(MTri o) {
            if (this.equals(o)) {
                return 0;
            }
            int comp = MeshBuilder.compare(this.v[0], o.v[0], this.d_verts);
            if (comp != 0) {
                return comp;
            }
            comp = MeshBuilder.compare(this.v[1], o.v[1], this.d_verts);
            if (comp != 0) {
                return comp;
            }
            return MeshBuilder.compare(this.v[2], o.v[2], this.d_verts);
        }
    }

    public static class MEdge
    implements MObj {
        public final int i1;
        public final int i2;

        public MEdge(List<Vertex> verts, int i1, int i2) {
            int comp = MeshBuilder.compare(i1, i2, verts);
            if (comp < 0) {
                this.i1 = i1;
                this.i2 = i2;
            } else {
                this.i1 = i2;
                this.i2 = i1;
            }
        }

        private MEdge(int i1, int i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        public MEdge reverse() {
            return new MEdge(this.i2, this.i1);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            MEdge edge = (MEdge)obj;
            return this.i1 == edge.i1 && this.i2 == edge.i2 || this.i1 == edge.i2 && this.i2 == edge.i1;
        }

        public int hashCode() {
            return this.i1 + this.i2;
        }
    }

    private static class TriInfo {
        public final ANode node;
        public final Tri.Terrain terrain;

        public TriInfo(ANode node, Tri.Terrain terrain) {
            this.node = node;
            this.terrain = terrain;
        }
    }
}

