/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.TriPoint;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import java.io.Serializable;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;

public interface IAgentBodyShape
extends Serializable {
    public int getOccId();

    public String getName();

    public AABox getAABox3D();

    public Point3d getCenter();

    public double getEnclosingRadius();

    public double getGeomRadius();

    public double getOccRadius();

    public double getLength();

    public double getWidth();

    public double getHeight();

    public double getProjectedArea();

    public double getDistToFront();

    public Point3d[] getAABox2DVerts();

    public double getMinTurnaroundTime();

    public boolean canRotate360(KB var1);

    public boolean canTravel360();

    public List<TriPoint> getVisibilityPoints(KB var1, OccAgent var2);

    public Vector3d getDir();

    public IAgentBodyShape moveInDirBy(double var1);

    default public IAgentBodyShape moveInDirBy(Vector3d dir, double distOffset) {
        double lensq = dir.lengthSquared();
        if (lensq == 0.0) {
            return this;
        }
        Vector3d add = new Vector3d(dir);
        add.scale(distOffset / Math.sqrt(lensq));
        return this.move(add);
    }

    public IAgentBodyShape move(Vector3d var1);

    public boolean contains2d(Point3d var1);

    public IAgentBodyShape orientTo(Vector3d var1);

    default public IAgentBodyShape moveTo(Point3d loc) {
        return this.adjust(loc, 1.0);
    }

    default public IAgentBodyShape adjust(double sizeFactor) {
        if (sizeFactor == 1.0) {
            return this;
        }
        return this.adjust(this.getCenter(), sizeFactor);
    }

    public IAgentBodyShape adjust(Point3d var1, double var2);

    public double getNearDist2d(Point3d var1);

    public boolean getPrefersLateralAvoidance();

    public Object getStaticHash();

    public OccProfileSim.IShapeGen toShapeGen();
}

