/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.ElevatorLevel;
import inferno.data2.IElevator;
import inferno.data2.ITimeEstimate;
import inferno.data2.Occupant;
import inferno.data2.TriPoint;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.OccAgent;
import inferno.sim.path.DoorQueueEstimate;
import inferno.sim.steering.PathFollow;
import inferno.util.ElevatorUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class EvacElevator
implements IElevator,
Serializable {
    private static final long serialVersionUID = 1L;
    private ElevatorLevel d_currentLevel;
    protected IElevator.ElevatorState d_state;
    private final String d_name;
    protected final ANode d_initNode;
    protected final Map<Integer, ElevatorLevel> d_outOfServiceLevels;
    protected final Map<Integer, ElevatorLevel> d_inServiceLevels;
    private ANode d_dischargeNode;
    private ElevatorLevel d_dischargeLevel;
    private ElevatorLevel d_activeLevel;
    private boolean d_dischargeActive;
    private boolean d_pickupActive;
    private double d_tRemPickup;
    private double d_tRemDischarge;
    private double d_tPickupClose;
    private boolean d_isDoubleDeck;
    protected ElevatorLevelPairs d_levelPairs;
    protected double d_openTime;
    protected double d_closeDelay;
    protected double d_tLastUpdate;
    protected double d_rFactor;
    protected double d_maxDensity;
    protected Vector3d d_initOffset;
    private final double d_callDistance;
    private double d_detectEnteringOccDist;
    private Comparator<ElevatorLevel> d_prioritySorter;
    private Vector3d d_currentDischargeVector;
    private boolean d_startingAtInit;

    public EvacElevator(String name, ANode dischargeNode, double openTime, double closeDelay, double rFactor, double maxDensity, ANode initNode, double callDistance, boolean isDoubleDeck) {
        this.d_name = name;
        this.d_dischargeNode = dischargeNode;
        this.d_openTime = openTime;
        this.d_closeDelay = closeDelay;
        this.d_rFactor = rFactor;
        this.d_maxDensity = maxDensity;
        this.d_initNode = initNode;
        this.d_startingAtInit = initNode != dischargeNode;
        this.d_isDoubleDeck = isDoubleDeck;
        this.d_initOffset = ElevatorUtil.getTeleportVector(this.d_dischargeNode, this.d_initNode);
        this.d_callDistance = callDistance;
        this.d_prioritySorter = new PrioritySorter(Collections.EMPTY_LIST);
        this.d_detectEnteringOccDist = 7.0;
        this.d_outOfServiceLevels = new LinkedHashMap<Integer, ElevatorLevel>();
        this.d_inServiceLevels = new LinkedHashMap<Integer, ElevatorLevel>();
        this.d_activeLevel = null;
        this.d_state = IElevator.ElevatorState.READY;
        this.d_dischargeActive = false;
        this.d_pickupActive = false;
        this.d_tLastUpdate = Double.NaN;
        this.d_currentDischargeVector = null;
    }

    @Override
    public void init() {
        ITimeEstimate openAtFloor;
        this.configureElevatorNode(this.d_dischargeNode, null, this.d_rFactor, this.d_maxDensity);
        for (ElevatorLevel elevLvl : this.d_inServiceLevels.values()) {
            openAtFloor = ElevatorUtil.getDefaultTimeEstimate(elevLvl, this.getTargetLevel());
            this.configureElevatorNode(elevLvl.pickupNode, openAtFloor, this.d_rFactor, this.d_maxDensity);
        }
        for (ElevatorLevel elevLvl : this.d_outOfServiceLevels.values()) {
            openAtFloor = ElevatorUtil.getDefaultTimeEstimate(elevLvl, this.getTargetLevel());
            this.configureElevatorNode(elevLvl.pickupNode, openAtFloor, this.d_rFactor, this.d_maxDensity);
        }
    }

    @Override
    public void endInit() {
        if (this.isDoubleDeck()) {
            this.updateLevelPairs();
        }
        this.updateElevatorPos(this.d_initOffset);
    }

    @Override
    public void update(KB kb) {
        double t = kb.getCurrentSimTime();
        if (Double.isNaN(this.d_tLastUpdate)) {
            this.d_tLastUpdate = t;
        }
        assert (this.d_tLastUpdate <= t);
        this.updateLevelsInService(kb);
        this.updateState(kb);
    }

    @Override
    public void addLevel(ElevatorLevel elevLvl) {
        if (elevLvl.tFirstAvailable <= 0.0) {
            this.d_inServiceLevels.put(elevLvl.levelId, elevLvl);
        } else {
            this.d_outOfServiceLevels.put(elevLvl.levelId, elevLvl);
        }
        if (elevLvl.pickupNode == this.d_dischargeNode) {
            this.d_dischargeLevel = elevLvl;
            this.d_dischargeLevel.isDischargeLevel = true;
        }
    }

    @Override
    public ElevatorLevel getCurrentLevel() {
        return this.d_currentLevel;
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    @Override
    public IElevator.ElevatorState getState() {
        return this.d_state;
    }

    @Override
    public ElevatorLevel getLevel(int id) {
        Integer iid = id;
        ElevatorLevel level = this.d_inServiceLevels.get(iid);
        if (level != null) {
            return level;
        }
        return this.d_outOfServiceLevels.get(iid);
    }

    @Override
    public List<ElevatorLevel> getLevels() {
        ArrayList<ElevatorLevel> levels = new ArrayList<ElevatorLevel>(this.d_inServiceLevels.size() + this.d_outOfServiceLevels.size());
        for (ElevatorLevel el : this.d_inServiceLevels.values()) {
            levels.add(el);
        }
        for (ElevatorLevel el : this.d_outOfServiceLevels.values()) {
            levels.add(el);
        }
        return levels;
    }

    private void configureElevatorNode(ANode node, ITimeEstimate nextOpenEst, Double szFactor, double dMax) {
        node.setDoorsClosed(nextOpenEst);
        node.setRadiusModifier(szFactor);
        int n = Math.max(1, KnownFuncs.maxPersons(node.getArea(), dMax));
        node.setMaxOccupants(n, false);
    }

    public boolean getDischargeActive() {
        return this.d_dischargeActive;
    }

    public boolean getPickupActive() {
        return this.d_pickupActive;
    }

    @Override
    public double getOpenTime() {
        return this.d_openTime;
    }

    @Override
    public double getCloseDelay() {
        return this.d_closeDelay;
    }

    @Override
    public double getSizeFactor() {
        return this.d_rFactor;
    }

    @Override
    public double getMaxDensity() {
        return this.d_maxDensity;
    }

    @Override
    public double getCallDistance() {
        return this.d_callDistance;
    }

    @Override
    public ANode getInitNode() {
        return this.d_initNode;
    }

    @Override
    public int getNominalLoad() {
        return KnownFuncs.maxPersons(this.d_dischargeNode.getArea(), this.d_maxDensity);
    }

    @Override
    public boolean isDoubleDeck() {
        return this.d_isDoubleDeck;
    }

    public ElevatorLevel getTargetLevel(ElevatorLevel level) {
        return !this.isDoubleDeck() ? level : this.d_levelPairs.getLowerLevel(level);
    }

    public ElevatorLevel getActiveLevel() {
        return this.d_activeLevel;
    }

    @Override
    public ANode getTargetNode() {
        return this.d_dischargeNode;
    }

    @Override
    public ElevatorLevel getTargetLevel() {
        return this.d_dischargeLevel != null ? this.d_dischargeLevel : this.d_activeLevel;
    }

    @Override
    public ElevatorLevel getUpperTargetLevel() {
        return this.d_levelPairs.getUpperLevel(this.getTargetLevel());
    }

    @Override
    public ANode getUpperTargetNode() {
        return this.getUpperTargetLevel().pickupNode;
    }

    @Override
    public ANode getTargetNodeFor(ElevatorLevel level) {
        if (!this.isDoubleDeck()) {
            return this.getTargetNode();
        }
        return this.getDoubleDeckLevelPairs().isLowerLevel(level) ? this.getTargetNode() : this.getUpperTargetNode();
    }

    public ElevatorLevelPairs getDoubleDeckLevelPairs() {
        return this.d_levelPairs;
    }

    private Vector3d getUpperLevelOffset(Vector3d elevatorOffset) {
        Vector3d diff = ElevatorUtil.getTeleportVector(this.d_activeLevel.pickupNode, this.d_levelPairs.getUpperLevel((ElevatorLevel)this.d_activeLevel).pickupNode);
        Vector3d upperLevelOffset = new Vector3d(elevatorOffset);
        upperLevelOffset.add(diff);
        return upperLevelOffset;
    }

    @Override
    public void beginState(KB kb, IElevator.ElevatorState state) {
        this.d_state = state;
        switch (state) {
            case MOVING_TO_FLOOR: {
                if (this.d_pickupActive) {
                    this.setTimesForBeginPickup(kb.getCurrentSimTime(), this.getMovingToPickupTime(true));
                    break;
                }
                if (!this.d_dischargeActive) break;
                double tDischargeOpenAgain = kb.getCurrentSimTime() + this.d_activeLevel.getDischargeTimeTot(this.getTargetLevel());
                this.d_dischargeNode.setDoorsClosed(new ITimeEstimate.Specific(tDischargeOpenAgain));
                double tBeforeAvail = tDischargeOpenAgain + this.d_openTime;
                ITimeEstimate.Specific beforeAvail = new ITimeEstimate.Specific(tBeforeAvail);
                ITimeEstimate.FutureFixed openAtFloor = new ITimeEstimate.FutureFixed(beforeAvail, this.d_activeLevel.getPickupTimeTot(this.getTargetLevel()));
                this.d_activeLevel.pickupNode.setDoorsClosed(openAtFloor);
                if (this.isDoubleDeck()) {
                    ElevatorLevel upperLevel = this.d_levelPairs.getUpperLevel(this.d_activeLevel);
                    assert (this.d_activeLevel != upperLevel) : "Error: Upper level in a double-deck elevator must not be the active level";
                    upperLevel.pickupNode.setDoorsClosed(openAtFloor);
                }
                this.d_tRemDischarge = this.d_activeLevel.getDischargeTimeTot(this.getTargetLevel());
                this.d_currentDischargeVector = ElevatorUtil.getTeleportVector(this.d_activeLevel.pickupNode, this.d_dischargeNode);
                break;
            }
            case AT_FLOOR: {
                if (this.d_pickupActive) {
                    double tDischargeOpenAgain = kb.getCurrentSimTime() + this.d_openTime + this.d_activeLevel.getDischargeTimeTot(this.getTargetLevel());
                    ITimeEstimate.Specific dischargeOpenAgain = new ITimeEstimate.Specific(tDischargeOpenAgain);
                    this.d_dischargeNode.setDoorsClosed(dischargeOpenAgain);
                    if (this.isDoubleDeck()) {
                        this.getUpperTargetNode().setDoorsClosed(dischargeOpenAgain);
                    }
                    this.d_tPickupClose = kb.getCurrentSimTime() + this.d_openTime;
                    Vector3d offset = this.getElevatorOffset();
                    this.updateElevatorPos(offset);
                    this.d_startingAtInit = false;
                    break;
                }
                if (!this.d_dischargeActive) break;
                this.d_dischargeNode.setDoorsClosed(null);
                if (this.isDoubleDeck()) {
                    this.getUpperTargetNode().setDoorsClosed(null);
                }
                Vector3d offset = this.getElevatorOffset();
                this.updateElevatorPos(offset);
                this.updateOccupantLoc(offset);
                this.performDischarge(kb);
                break;
            }
            case READY: {
                ITimeEstimate.FutureFixed timeEst = new ITimeEstimate.FutureFixed(null, 1.0);
                this.d_dischargeNode.setDoorsClosed(timeEst);
                if (this.isDoubleDeck()) {
                    this.getUpperTargetNode().setDoorsClosed(timeEst);
                }
                this.d_activeLevel = null;
                this.d_pickupActive = false;
                this.d_dischargeActive = false;
                break;
            }
        }
    }

    @Override
    public void updateState(KB kb) {
        double t = kb.getCurrentSimTime();
        double dt = Double.isNaN(this.d_tLastUpdate) ? t : t - this.d_tLastUpdate;
        this.d_tLastUpdate = t;
        switch (this.d_state) {
            case AT_FLOOR: {
                if (this.d_pickupActive) {
                    double tEntered = this.detectOccEntered();
                    this.d_tPickupClose = Math.max(this.d_tPickupClose, tEntered + this.d_closeDelay);
                    double tEntering = this.detectOccEntering(kb);
                    this.d_tPickupClose = Math.max(this.d_tPickupClose, tEntering + this.d_closeDelay);
                    int nominalLoad = KnownFuncs.maxPersons(this.d_activeLevel.pickupNode.getArea(), this.d_maxDensity);
                    ElevatorUtil.processLevelForPickup(this.d_activeLevel, nominalLoad);
                    if (this.isDoubleDeck()) {
                        ElevatorLevel upperLevel = this.d_levelPairs.getUpperLevel(this.d_activeLevel);
                        assert (upperLevel != this.d_activeLevel) : "Error: Upper level in a double-deck elevator must not be the active level";
                        ElevatorUtil.processLevelForPickup(upperLevel, nominalLoad);
                    }
                    if (!theUtil.ge(kb.getCurrentSimTime(), this.d_tPickupClose, 1.0E-6)) break;
                    this.d_dischargeActive = true;
                    this.d_pickupActive = false;
                    this.beginState(kb, IElevator.ElevatorState.MOVING_TO_FLOOR);
                    break;
                }
                if (!this.d_dischargeActive || !this.d_dischargeNode.getCurrentUsage().isEmpty() || this.isDoubleDeck() && !this.getUpperTargetNode().getCurrentUsage().isEmpty()) break;
                this.beginState(kb, IElevator.ElevatorState.READY);
                break;
            }
            case MOVING_TO_FLOOR: {
                if (this.d_pickupActive) {
                    this.d_tRemPickup -= dt;
                    if (this.d_tRemPickup <= 0.0) {
                        this.beginState(kb, IElevator.ElevatorState.AT_FLOOR);
                        break;
                    }
                    Vector3d offset = this.getElevatorOffset();
                    this.updateElevatorPos(offset);
                    break;
                }
                if (!this.d_dischargeActive) break;
                this.d_tRemDischarge -= dt;
                if (this.d_tRemDischarge <= 0.0) {
                    this.beginState(kb, IElevator.ElevatorState.AT_FLOOR);
                    break;
                }
                Vector3d offset = this.getElevatorOffset();
                this.updateElevatorPos(offset);
                this.updateOccupantLoc(offset);
                break;
            }
        }
    }

    protected void updateLevelsInService(KB kb) {
        double t = kb.getCurrentSimTime();
        LinkedHashMap<Integer, ElevatorLevel> nowInService = Collections.EMPTY_MAP;
        for (ElevatorLevel elevLevel : this.d_outOfServiceLevels.values()) {
            if (!(elevLevel.tFirstAvailable <= t)) continue;
            if (nowInService.isEmpty()) {
                nowInService = new LinkedHashMap<Integer, ElevatorLevel>();
            }
            nowInService.put(elevLevel.levelId, elevLevel);
        }
        if (!nowInService.isEmpty()) {
            this.d_outOfServiceLevels.keySet().removeAll(nowInService.keySet());
            this.d_inServiceLevels.putAll((Map<Integer, ElevatorLevel>)nowInService);
        }
    }

    protected void updateElevatorPos(Vector3d offset) {
        this.d_dischargeNode.setAnimationXform(offset, this.d_dischargeNode.getAnimRot());
        if (this.isDoubleDeck()) {
            ANode upperLevel = this.getUpperTargetNode();
            upperLevel.setAnimationXform(offset, upperLevel.getAnimRot());
        }
    }

    private Vector3d getElevatorOffset() {
        Vector3d travelVec = ElevatorUtil.getTeleportVector(this.d_startingAtInit ? this.d_initNode : this.d_dischargeNode, this.d_activeLevel.pickupNode);
        double t = 0.0;
        switch (this.d_state) {
            case AT_FLOOR: {
                if (this.d_dischargeActive) {
                    t = 0.0;
                    break;
                }
                if (!this.d_pickupActive) break;
                t = 1.0;
                break;
            }
            case MOVING_TO_FLOOR: {
                double tTrav;
                if (this.d_pickupActive) {
                    tTrav = this.getMovingToPickupTime(true) - Math.max(0.0, this.d_tRemPickup);
                    double startMoveTime = this.getTargetLevel().closeTime;
                    double stopMoveTime = startMoveTime + this.getMovingToPickupTime(false);
                    if (tTrav > startMoveTime && tTrav < stopMoveTime) {
                        t = (tTrav - startMoveTime) / this.getMovingToPickupTime(false);
                        break;
                    }
                    if (!(tTrav >= stopMoveTime)) break;
                    t = 1.0;
                    break;
                }
                if (!this.d_dischargeActive) break;
                tTrav = this.d_activeLevel.getDischargeTimeTot(this.getTargetLevel()) - Math.max(0.0, this.d_tRemDischarge);
                double startMoveTime = this.d_activeLevel.closeTime;
                double stopMoveTime = startMoveTime + this.d_activeLevel.getDischargeTime();
                if (tTrav > startMoveTime && tTrav < stopMoveTime) {
                    t = 1.0 - (tTrav - startMoveTime) / this.d_activeLevel.getDischargeTime();
                    break;
                }
                if (!(tTrav <= startMoveTime)) break;
                t = 1.0;
            }
        }
        if (travelVec != null) {
            Vector3d offset = Util3D.scale(travelVec, t);
            if (this.d_startingAtInit) {
                offset.add(this.d_initOffset);
            }
            return offset;
        }
        return this.d_dischargeNode.getAnimOffset();
    }

    public boolean isLevelInService(int levelId) {
        return this.d_inServiceLevels.containsKey(levelId);
    }

    @Override
    public void beginPickup(KB kb, int levelId) {
        assert (this.d_state == IElevator.ElevatorState.READY);
        assert (this.isLevelInService(levelId));
        ElevatorLevel target = this.d_inServiceLevels.get(levelId);
        this.d_activeLevel = this.getTargetLevel(target);
        this.d_pickupActive = true;
        this.beginState(kb, IElevator.ElevatorState.MOVING_TO_FLOOR);
    }

    @Override
    public void changePickupTo(double currentSimTime, int levelId) {
        assert (this.d_state == IElevator.ElevatorState.MOVING_TO_FLOOR && this.d_pickupActive);
        assert (this.isLevelInService(levelId));
        ElevatorLevel prevLvl = this.d_activeLevel;
        ElevatorLevel target = this.d_inServiceLevels.get(levelId);
        this.d_activeLevel = this.getTargetLevel(target);
        assert (prevLvl != null);
        if (prevLvl == null) {
            return;
        }
        double tAlreadyServed = prevLvl.getPickupTimeTot(this.getTargetLevel()) - this.d_tRemPickup;
        double tPickupTimeTotAdj = this.getMovingToPickupTime(true) - tAlreadyServed;
        this.setTimesForBeginPickup(currentSimTime, tPickupTimeTotAdj);
        if (prevLvl != this.d_activeLevel) {
            prevLvl.pickupNode.setDoorsClosed(ElevatorUtil.getDefaultTimeEstimate(prevLvl, this.getTargetLevel()));
        }
    }

    public double getPickupProgress() {
        assert (this.d_state == IElevator.ElevatorState.MOVING_TO_FLOOR && this.d_pickupActive);
        double pickupTime = this.d_activeLevel.getPickupTimeTot(this.getTargetLevel());
        return (pickupTime - this.d_tRemPickup) / pickupTime;
    }

    public boolean isOpeningForPickup() {
        return this.d_state == IElevator.ElevatorState.MOVING_TO_FLOOR && this.d_tRemPickup < this.d_activeLevel.openTime;
    }

    private double detectOccEntered() {
        return this.d_activeLevel.pickupNode.getTimeLastPersonEntered();
    }

    private double detectOccEntering(KB kb) {
        if (!this.d_activeLevel.pickupNode.getEnteringAgents().isEmpty()) {
            return kb.getCurrentSimTime();
        }
        if (!this.d_activeLevel.pickupNode.hasRoomForOneMore(kb)) {
            return Double.NEGATIVE_INFINITY;
        }
        for (ANode door : this.d_activeLevel.pickupNode.getDoors()) {
            DoorDir enterDir;
            DoorQueueEstimate.OccQueue queue;
            DoorQueueEstimate dqueue;
            if (door.isInternalDoor() || door.isExitDoor() || (dqueue = kb.getPathEstimates().getQueue(door)) == null || (queue = dqueue.getQueue(enterDir = door.doorQueue.getDir(this.d_activeLevel.pickupNode))).size() == 0) continue;
            DoorQueueEstimate.OccDist od = queue.get(0);
            if (od.dist > this.d_detectEnteringOccDist) continue;
            if (!kb.getParams().reactive_steering && od.occ.getOcc().formationLeader == null) {
                return kb.getCurrentSimTime();
            }
            int queueBegin = queue.getQueueBegin();
            if (queueBegin != -1 && queueBegin <= 0) continue;
            return kb.getCurrentSimTime();
        }
        return Double.NEGATIVE_INFINITY;
    }

    private void updateOccupantLoc(Vector3d elevatorOffset) {
        Vector3d occOffset = Util3D.add(this.d_currentDischargeVector, (Tuple3d)elevatorOffset);
        Matrix4d xform = Util.translateMat(occOffset.x, occOffset.y, occOffset.z);
        BiConsumer<ElevatorLevel, Matrix4d> processLevel = (lvl, transform) -> {
            for (OccAgent agent : lvl.pickupNode.getCurrentUsage()) {
                agent.getOcc().xform = transform;
            }
        };
        processLevel.accept(this.d_activeLevel, xform);
        if (this.isDoubleDeck()) {
            ElevatorLevel upperLevel = this.d_levelPairs.getUpperLevel(this.d_activeLevel);
            assert (upperLevel != this.d_activeLevel) : "Error: Upper level in a double-deck elevator must not be the active level";
            occOffset = Util3D.add(ElevatorUtil.getTeleportVector(upperLevel.pickupNode, this.d_dischargeNode), (Tuple3d)this.getUpperLevelOffset(elevatorOffset));
            xform = Util.translateMat(occOffset.x, occOffset.y, occOffset.z);
            processLevel.accept(upperLevel, xform);
        }
    }

    private void performDischarge(KB kb) {
        ANode intake = this.getActiveLevel().pickupNode;
        ANode discharge = this.getTargetNode();
        BiConsumer<ANode, ANode> performDischarge = (intakeNode, dischargeNode) -> {
            LinkedHashSet<OccAgent> occsToMove = new LinkedHashSet<OccAgent>(intakeNode.getCurrentUsage());
            for (OccAgent oa : occsToMove) {
                Occupant occ = oa.getOcc();
                if (occ.xform != null) {
                    occ.loc = Util3D.xform(occ.xform, occ.loc);
                    occ.xform = null;
                }
                occ.tri = kb.getMesh().getTri(occ.loc);
                occ.displayLoc = new TriPoint(occ.tri, occ.loc);
                oa.moveToNode(kb, null, (ANode)dischargeNode, kb.getCurrentSimTime());
                PathFollow pathfollow = oa.getPathFollow();
                if (pathfollow == null) continue;
                pathfollow.getPathPlanner().setRoom((ANode)dischargeNode, oa);
            }
        };
        performDischarge.accept(intake, discharge);
        if (this.isDoubleDeck()) {
            ANode upperIntake = this.d_levelPairs.getUpperLevel((ElevatorLevel)this.getActiveLevel()).pickupNode;
            ANode upperDischarge = this.getUpperTargetNode();
            performDischarge.accept(upperIntake, upperDischarge);
        }
    }

    private double getMovingToPickupTime(boolean total) {
        if (!this.d_startingAtInit) {
            return total ? this.d_activeLevel.getPickupTimeTot(this.getTargetLevel()) : this.d_activeLevel.getPickupTime();
        }
        double distDischargeToActive = ElevatorUtil.getTeleportVector(this.d_dischargeNode, this.d_activeLevel.pickupNode).length();
        double distInitToActive = ElevatorUtil.getTeleportVector(this.d_initNode, this.d_activeLevel.pickupNode).length();
        double fraction = distInitToActive / distDischargeToActive;
        if (total) {
            double pickupTime = this.d_activeLevel.getPickupTime();
            return this.getTargetLevel().closeTime + fraction * pickupTime + this.d_activeLevel.openTime;
        }
        return fraction * this.d_activeLevel.getPickupTime();
    }

    private void setTimesForBeginPickup(double currentSimTime, double pickupTimeRemaining) {
        double tPickupOpen = currentSimTime + pickupTimeRemaining;
        ITimeEstimate.Specific pickupOpenEst = new ITimeEstimate.Specific(tPickupOpen);
        this.d_activeLevel.pickupNode.setDoorsClosed(pickupOpenEst);
        double tDischargeOpenAgain = tPickupOpen + this.d_openTime + this.d_activeLevel.getDischargeTimeTot(this.getTargetLevel());
        this.d_dischargeNode.setDoorsClosed(new ITimeEstimate.Specific(tDischargeOpenAgain));
        if (this.isDoubleDeck()) {
            ElevatorLevel upperLevel = this.d_levelPairs.getUpperLevel(this.d_activeLevel);
            assert (this.d_activeLevel != upperLevel) : "Error: Upper level in a double-deck elevator must not be the active level";
            upperLevel.pickupNode.setDoorsClosed(pickupOpenEst);
        }
        this.d_tRemPickup = pickupTimeRemaining;
    }

    @Override
    public void setTopPriorityFloors(List<Integer> priorityFloors) {
        this.d_prioritySorter = new PrioritySorter(priorityFloors);
    }

    @Override
    public List<Integer> getTopPriorityFloors() {
        return Collections.unmodifiableList(((PrioritySorter)this.d_prioritySorter).d_priorityFloors);
    }

    public Comparator<ElevatorLevel> getFloorSorter() {
        return this.d_prioritySorter;
    }

    private void updateLevelPairs() {
        ArrayList<ElevatorLevel> levels = new ArrayList<ElevatorLevel>(this.getLevels());
        assert (levels.size() % 2 == 0);
        levels.sort((l1, l2) -> {
            double z1 = l1.pickupNode.getGeometryBounds().getMinZ();
            double z2 = l2.pickupNode.getGeometryBounds().getMinZ();
            return Double.compare(z1, z2);
        });
        this.d_levelPairs = new ElevatorLevelPairs();
        for (int i = 0; i < levels.size(); i += 2) {
            this.d_levelPairs.put(levels.get(i), levels.get(i + 1));
        }
    }

    @Override
    public Collection<ElevatorLevel> getInServiceLevels() {
        return this.d_inServiceLevels.values();
    }

    @Override
    public Collection<ElevatorLevel> getOutOfServiceLevels() {
        return this.d_outOfServiceLevels.values();
    }

    private void updateCurrentLevel() {
        double currentElevZ = this.d_initNode.getAnimOffset().z;
        ElevatorLevel closestLevel = null;
        for (ElevatorLevel level : this.d_inServiceLevels.values()) {
            if (closestLevel == null) {
                closestLevel = level;
                continue;
            }
            if (!(Math.abs(currentElevZ - level.pickupNode.getGeometryBounds().getVerts()[0].z) < Math.abs(currentElevZ - closestLevel.pickupNode.getGeometryBounds().getVerts()[0].z))) continue;
            closestLevel = level;
        }
        this.d_currentLevel = closestLevel;
    }

    public static class ElevatorLevelPairs
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<ElevatorLevel, ElevatorLevel> lowerToUpper = new LinkedHashMap<ElevatorLevel, ElevatorLevel>();
        private final Map<ElevatorLevel, ElevatorLevel> upperToLower = new LinkedHashMap<ElevatorLevel, ElevatorLevel>();

        public void put(ElevatorLevel lowerLevel, ElevatorLevel upperLevel) {
            this.lowerToUpper.put(lowerLevel, upperLevel);
            this.upperToLower.put(upperLevel, lowerLevel);
        }

        public ElevatorLevel getLowerLevel(ElevatorLevel level) {
            return this.upperToLower.getOrDefault(level, level);
        }

        public ElevatorLevel getUpperLevel(ElevatorLevel level) {
            return this.lowerToUpper.getOrDefault(level, level);
        }

        public boolean isLowerLevel(ElevatorLevel level) {
            return this.lowerToUpper.containsKey(level);
        }

        public boolean isUpperLevel(ElevatorLevel level) {
            return this.upperToLower.containsKey(level);
        }
    }

    private static class PrioritySorter
    implements Comparator<ElevatorLevel>,
    Serializable {
        private static final long serialVersionUID = 8286020726476684997L;
        private List<Integer> d_priorityFloors;

        public PrioritySorter(List<Integer> priorityFloors) {
            this.d_priorityFloors = priorityFloors;
        }

        @Override
        public int compare(ElevatorLevel elevLvl1, ElevatorLevel elevLvl2) {
            int priorityIndex1 = this.d_priorityFloors.indexOf(elevLvl1.levelId);
            int priorityIndex2 = this.d_priorityFloors.indexOf(elevLvl2.levelId);
            if (priorityIndex1 != -1 && priorityIndex2 != -1) {
                return priorityIndex1 - priorityIndex2;
            }
            if (priorityIndex1 != -1 && priorityIndex2 == -1) {
                return -1;
            }
            if (priorityIndex1 == -1 && priorityIndex2 != -1) {
                return 1;
            }
            double z1 = elevLvl1.pickupNode.getGeometryBounds().getMinZ();
            double z2 = elevLvl2.pickupNode.getGeometryBounds().getMinZ();
            return -Double.compare(z1, z2);
        }
    }
}

