/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.DoorDir;
import inferno.data2.DoorGeom;
import inferno.data2.EdgeData;
import inferno.data2.ElevatorLevel;
import inferno.data2.IAnimSrc;
import inferno.data2.IElevator;
import inferno.data2.ITimeEstimate;
import inferno.data2.Occupant;
import inferno.data2.StairData;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.geom.ConnectedMesh;
import inferno.geom.EmptyDensityField;
import inferno.geom.IDensityField;
import inferno.geom.NodeUtil;
import inferno.geom.Util;
import inferno.geom.ValueFld;
import inferno.geom.VectorFld;
import inferno.geom.VorDensityField;
import inferno.sim.DoorQueue;
import inferno.sim.ElevatorModel;
import inferno.sim.IDoorFlowrate;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.OccAgent;
import inferno.sim.OccSource;
import inferno.sim.Param;
import inferno.sim.path.DoorQueueEstimate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.TriInterpolator3d;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.theUtil;

public class ANode
implements Serializable,
IAnimSrc {
    static final long serialVersionUID = 1L;
    private static final double DT_DIST_MAP = 1.0;
    private static final double ACTIVE_DOOR_DIST = 1.0;
    private static final double T_DOOR_ACTIVE_MEMORY = 15.0;
    public final String name;
    public StairData stairData = null;
    private double d_tForFirstPersonEntering;
    private double d_tForLastPersonEntering;
    private double d_tForLastPersonExiting;
    private double d_area;
    private int d_numOccupants;
    private int d_correspondingNumOccupants;
    private int d_peakOccupants;
    private int d_maxOccupants;
    private transient OccAgent d_lastPersonExiting;
    private boolean d_maxOccupantsDefinedByUser;
    private int d_numExitedVia;
    private int d_tsEntered;
    private int d_tsCorrespondingEntered;
    private int d_enteringCount;
    private transient HashSet<OccAgent> d_enteringAgents = new HashSet();
    private ITimeEstimate d_closedFor;
    private DoorDir d_doorDir;
    private Set<DoorDir> d_doorDirOverride;
    public transient DoorQueue doorQueue = null;
    private transient List<Tri> d_mesh;
    private transient List<ANode> d_adjNodes;
    private transient List<WingedEdge> d_doorEdges;
    private transient Set<ANode> d_doors = Collections.emptySet();
    private transient DoorGeom d_doorGeom;
    private transient Map<Occupant, Double> d_totalUsage;
    private transient Set<OccAgent> d_currentUsage;
    private transient IDensityField d_densityField;
    private transient AABox d_geometryBounds;
    private transient Set<ANode> d_doorsOutOfRoom;
    private int d_animationId;
    private Vector3d d_animOffset;
    private Quat4d d_animRot;
    private ElevatorLevel d_elevatorLevel;
    private Double d_occRadMod;
    private List<Tag> d_tags;
    private transient Object d_subMeshLock = new Object();
    private transient SubMesh d_subMesh;
    private transient Object d_distMapLock = new Object();
    private double d_tDistMapUpdate;
    private Set<ANode> d_activeDistMapDoors;
    private Map<Set<ANode>, Integer> d_distMapIds;
    private Map<ANode, Double> d_doorTLastObservedActive;
    private transient SoftReference<DistFldInfo> d_distMap;
    private transient Map<Set<ANode>, SoftReference<DistFldInfo>> d_doorsDistFlds;
    private transient TriInterpolator3d[] d_subMeshTriInfo;
    private List<OccSource> d_occSources;
    private Map<IElevator, Set<ANode>> d_elevatorRestrictions;
    private Capacity d_capacity;
    private boolean d_maxCapacityReached;
    private boolean d_updateMaxCapacity = false;

    public ANode(String name) {
        this.name = name;
        this.d_tForFirstPersonEntering = Double.MAX_VALUE;
        this.d_tForLastPersonEntering = Double.MAX_VALUE;
        this.d_tForLastPersonExiting = 0.0;
        this.d_area = Double.NaN;
        this.d_numOccupants = 0;
        this.d_correspondingNumOccupants = 0;
        this.d_maxOccupants = Integer.MAX_VALUE;
        this.d_numExitedVia = 0;
        this.d_tsEntered = 0;
        this.d_tsCorrespondingEntered = 0;
        this.d_enteringCount = 0;
        this.d_lastPersonExiting = null;
        this.d_closedFor = null;
        this.d_doorDir = null;
        this.d_doorDirOverride = new LinkedHashSet<DoorDir>(2);
        this.d_maxCapacityReached = false;
        this.d_mesh = new Vector<Tri>();
        this.d_adjNodes = new ArrayList<ANode>();
        this.d_doorEdges = new ArrayList<WingedEdge>();
        this.d_totalUsage = new IdentityHashMap<Occupant, Double>();
        this.d_currentUsage = new IdentityHashSet<OccAgent>();
        this.d_densityField = EmptyDensityField.INSTANCE;
        this.d_distMapIds = new HashMap<Set<ANode>, Integer>();
        this.d_doorsDistFlds = new HashMap<Set<ANode>, SoftReference<DistFldInfo>>();
        this.d_doorTLastObservedActive = new IdentityHashMap<ANode, Double>();
        this.d_animationId = -1;
        this.d_animOffset = new Vector3d(0.0, 0.0, 0.0);
        this.d_animRot = new Quat4d();
        this.d_tags = Collections.emptyList();
        this.d_occRadMod = null;
        this.d_tDistMapUpdate = 0.0;
    }

    public void writeSelfRefData(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.doorQueue);
        oos.writeObject(this.d_mesh);
        oos.writeObject(this.d_adjNodes);
        oos.writeObject(this.d_doorEdges);
        oos.writeObject(this.d_totalUsage);
        oos.writeObject(this.d_densityField);
        oos.writeObject(this.d_currentUsage);
        oos.writeObject(this.d_enteringAgents);
        oos.writeObject(this.d_lastPersonExiting);
        oos.writeObject(this.d_doors);
    }

    public void readSelfRefData(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.doorQueue = (DoorQueue)ois.readObject();
        this.d_mesh = (List)ois.readObject();
        this.d_adjNodes = (List)ois.readObject();
        this.d_doorEdges = (List)ois.readObject();
        this.d_totalUsage = (Map)ois.readObject();
        this.d_densityField = (IDensityField)ois.readObject();
        this.d_currentUsage = (Set)ois.readObject();
        this.d_enteringAgents = (HashSet)ois.readObject();
        this.d_lastPersonExiting = (OccAgent)ois.readObject();
        this.d_doors = (Set)ois.readObject();
        this.finalizeDoorGeom();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_distMapLock = new Object();
        this.d_subMeshLock = new Object();
        this.d_doorsDistFlds = new HashMap<Set<ANode>, SoftReference<DistFldInfo>>();
        if (this.d_doorTLastObservedActive == null) {
            this.d_doorTLastObservedActive = new IdentityHashMap<ANode, Double>();
        }
        if (this.d_distMapIds == null) {
            this.d_distMapIds = new HashMap<Set<ANode>, Integer>();
        }
    }

    public synchronized Set<ANode> getDoorsOutOfRoom() {
        if (this.isDoor()) {
            return Collections.emptySet();
        }
        if (this.d_doorsOutOfRoom == null) {
            Set<ANode> doors = this.getDoors();
            this.d_doorsOutOfRoom = new LinkedIdentityHashSet<ANode>();
            this.d_doorsOutOfRoom.addAll(theUtil.filter(doors, door -> !door.doorQueue.isInternal()));
        }
        return this.d_doorsOutOfRoom;
    }

    public void setRadiusModifier(Double occRadMod) {
        this.d_occRadMod = occRadMod;
    }

    public Double getRadiusModifier() {
        return this.d_occRadMod;
    }

    public void setElevatorLevel(ElevatorLevel level) {
        this.d_elevatorLevel = level;
    }

    public ElevatorLevel getElevatorLevel() {
        return this.d_elevatorLevel;
    }

    public void setTags(List<Tag> tags) {
        this.d_tags = tags;
    }

    public List<Tag> getTags() {
        return this.d_tags;
    }

    private static boolean calcIsBoundaryPosition(NodeUtil.TriangulateResult triangulation, ConnectedMesh.Vertex vert) {
        for (ConnectedMesh.Tri tri : vert.tris) {
            for (int n = 0; n < 3; ++n) {
                ConnectedMesh.Vertex e1 = tri.verts[n];
                ConnectedMesh.Vertex e2 = tri.verts[Util.PLUS1MOD3[n]];
                if (e1 != vert && e2 != vert) continue;
                EdgeData ed = triangulation.triEdgeData[tri.id * 3 + n];
                if (ed.type == 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDoorDistMap() {
        return this.d_distMap != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAllDoorDistMap(KB kb) {
        Object object = this.d_distMapLock;
        synchronized (object) {
            IdentityHashSet<ANode> doors = new IdentityHashSet<ANode>(this.getValidIngressDoors(this.getSubMesh(kb), kb));
            return this.getDoorDistancesUncached(doors) != null;
        }
    }

    private DistFldInfo getDoorDistancesUncached(Set<ANode> doors) {
        SoftReference<DistFldInfo> pDistMap = this.d_doorsDistFlds.get(doors);
        return ANode.get(pDistMap);
    }

    private DistFldInfo getDoorDistances(KB kb, Set<ANode> doors) {
        VectorFld vecFld;
        double maxDistTolerance = 0.25;
        DistFldInfo distInfo = this.getDoorDistancesUncached(doors);
        if (distInfo != null) {
            return distInfo;
        }
        SubMesh smesh = this.getSubMesh(kb);
        Function<Set, Integer> getId = dset -> this.d_distMapIds.computeIfAbsent((Set<ANode>)dset, dmap -> this.d_distMapIds.size());
        Function<ANode, DistFldInfo> getDoorDists = d2 -> {
            Set<ANode> dset = Collections.singleton(d2);
            SoftReference<DistFldInfo> pfld = this.d_doorsDistFlds.get(dset);
            DistFldInfo fld = ANode.get(pfld);
            if (fld != null) {
                return fld;
            }
            int id = (Integer)getId.apply(dset);
            TriInterpolator3d[] triInterp = this.getSubMeshTriInfo(smesh);
            ValueFld dists = NodeUtil.getNodeDoorDistances(id, subMesh.mesh, triInterp, subMesh.doorVerts.getOrDefault(d2, Collections.emptyList()));
            VectorFld maxDistDirs = NodeUtil.calcMaxDistVectorFld(subMesh.mesh, triInterp, dists, maxDistTolerance);
            fld = new DistFldInfo(dists, maxDistDirs);
            pfld = new SoftReference<DistFldInfo>(fld);
            this.d_doorsDistFlds.put(dset, pfld);
            return fld;
        };
        List doorDistInfos = doors.stream().map(getDoorDists).collect(Collectors.toList());
        int fieldId = getId.apply(doors);
        ValueFld distFld = NodeUtil.getMinValues(fieldId, theUtil.map(doorDistInfos, di -> di.dists));
        if (distFld == null) {
            distFld = new ValueFld(fieldId, smesh.mesh, this.getSubMeshTriInfo(smesh), new ConstantVertVals(0.0), new double[]{0.0, 0.0});
            vecFld = NodeUtil.calcSinkVectorFld(smesh.mesh, this.getSubMeshTriInfo(smesh), Collections.emptyList());
        } else {
            vecFld = doorDistInfos.size() == 1 ? ((DistFldInfo)doorDistInfos.get((int)0)).maxDistDirs : NodeUtil.calcMaxDistVectorFld(smesh.mesh, this.getSubMeshTriInfo(smesh), distFld, maxDistTolerance);
        }
        distInfo = new DistFldInfo(distFld, vecFld);
        SoftReference<DistFldInfo> pDistMap = new SoftReference<DistFldInfo>(distInfo);
        this.d_doorsDistFlds.put(doors, pDistMap);
        return distInfo;
    }

    private Collection<ANode> getValidIngressDoors(SubMesh smesh, KB kb) {
        Function<ANode, Boolean> includeExit = door -> {
            if (!door.isExitDoor()) {
                return false;
            }
            if (door.getOccSources() == null) {
                return false;
            }
            for (OccSource source : door.getOccSources()) {
                if (source.getComponent() != door || !(source.getFlowrate(kb.getCurrentSimTime()) > 0.0)) continue;
                return true;
            }
            return false;
        };
        return theUtil.filter(this.getDoors(), door -> {
            if (door.isExitDoor() && !((Boolean)includeExit.apply((ANode)door)).booleanValue()) {
                return false;
            }
            List doorVerts = subMesh.doorVerts.getOrDefault(door, Collections.emptyList());
            return !doorVerts.isEmpty();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistFldInfo getAllDoorsDistMap(KB kb) {
        Object object = this.d_distMapLock;
        synchronized (object) {
            return this.getDoorDistances(kb, new IdentityHashSet<ANode>(this.getValidIngressDoors(this.getSubMesh(kb), kb)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistFldInfo getDoorDistMap(KB kb) {
        Object object = this.d_distMapLock;
        synchronized (object) {
            DistFldInfo distMap;
            if (this.d_activeDistMapDoors == null || kb.getCurrentSimTime() >= this.d_tDistMapUpdate) {
                SubMesh smesh = this.getSubMesh(kb);
                LinkedIdentityHashSet<ANode> newActiveDistMapDoors = new LinkedIdentityHashSet<ANode>();
                for (ANode door : this.getValidIngressDoors(smesh, kb)) {
                    Double tLastActive;
                    if (!door.isExitDoor()) {
                        DoorQueueEstimate dq = kb.getPathEstimates().getQueue(door);
                        if (dq == null) continue;
                        DoorQueueEstimate.OccQueue q = dq.getQueue(door.doorQueue.getDir(this));
                        if (q.size() != 0) {
                            boolean active;
                            DoorQueueEstimate.OccDist firstInLine = q.get(0);
                            double distTol = firstInLine.occ.getOcc().bodyShape.getEnclosingRadius() + Math.max(firstInLine.occ.getComfortDist(kb) * 2.0, 1.0);
                            boolean bl = active = firstInLine.dist <= distTol;
                            if (active) {
                                this.d_doorTLastObservedActive.put(door, kb.getCurrentSimTime());
                            }
                        }
                    } else {
                        this.d_doorTLastObservedActive.put(door, kb.getCurrentSimTime());
                    }
                    if ((tLastActive = this.d_doorTLastObservedActive.get(door)) == null) continue;
                    double tElapsedSinceActive = kb.getCurrentSimTime() - tLastActive;
                    if (tElapsedSinceActive > 15.0) {
                        this.d_doorTLastObservedActive.remove(door);
                        continue;
                    }
                    newActiveDistMapDoors.add(door);
                }
                if (!newActiveDistMapDoors.equals(this.d_activeDistMapDoors)) {
                    this.d_distMap = null;
                    this.d_activeDistMapDoors = newActiveDistMapDoors;
                }
                this.d_tDistMapUpdate = kb.getCurrentSimTime() + 1.0;
            }
            if ((distMap = ANode.get(this.d_distMap)) != null) {
                return distMap;
            }
            distMap = this.getDoorDistances(kb, this.d_activeDistMapDoors);
            this.d_distMap = new SoftReference<DistFldInfo>(distMap);
            return distMap;
        }
    }

    private static <T> T get(SoftReference<T> ref) {
        return ref == null ? null : (T)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubMesh getSubMesh(KB kb) {
        Object object = this.d_subMeshLock;
        synchronized (object) {
            if (this.d_subMesh == null) {
                NodeUtil.TriangulateResult mesh = NodeUtil.triangulate(this, kb.getMinOccArea() * 1.0);
                RTree<ConnectedMesh.Vertex> positionSearch = new RTree<ConnectedMesh.Vertex>();
                VertData[] positionData = new VertData[mesh.mesh.verts.length];
                ((Stream)Stream.of(mesh.mesh.verts).parallel()).forEach(v -> {
                    Tri tri = kb.getMesh().getTri(v.p);
                    boolean isBoundary = ANode.calcIsBoundaryPosition(mesh, v);
                    vertDataArray[v.id] = new VertData(tri, isBoundary);
                    AABox bounds = new AABox(v.p);
                    RTree rTree2 = positionSearch;
                    synchronized (rTree2) {
                        positionSearch.insert(bounds, (ConnectedMesh.Vertex)v);
                    }
                });
                this.d_subMesh = new SubMesh(mesh, positionSearch, positionData);
            }
        }
        return this.d_subMesh;
    }

    public boolean hasSubMesh() {
        return this.d_subMesh != null;
    }

    private TriInterpolator3d[] getSubMeshTriInfo(SubMesh smesh) {
        if (this.d_subMeshTriInfo == null) {
            this.d_subMeshTriInfo = ValueFld.calcTriInfo(smesh.mesh);
        }
        return this.d_subMeshTriInfo;
    }

    public synchronized AABox getGeometryBounds() {
        if (this.d_geometryBounds == null) {
            AABox bounds = new AABox();
            for (Tri tri : this.d_mesh) {
                for (Vertex v : tri.v) {
                    bounds.add(v.p);
                }
            }
            this.d_geometryBounds = bounds;
        }
        return this.d_geometryBounds;
    }

    public void setDoorDir(DoorDir dir) {
        this.d_doorDir = dir;
    }

    public synchronized DoorDir getOnewayDir() {
        return this.d_doorDirOverride.isEmpty() ? this.d_doorDir : this.d_doorDirOverride.iterator().next();
    }

    public synchronized boolean addDoorDirOverride(DoorDir dir) {
        return this.d_doorDirOverride.add(dir);
    }

    public synchronized boolean removeDoorDirOverride(DoorDir dir) {
        return this.d_doorDirOverride.remove((Object)dir);
    }

    public void setClosed(ITimeEstimate closedFor) {
        this.d_closedFor = closedFor;
    }

    public boolean isClosed(KB kb, OccAgent closedForAgent) {
        if (this.isCapacityClosed()) {
            return true;
        }
        if (this.d_closedFor == null) {
            return false;
        }
        return this.d_closedFor.getTime(kb, closedForAgent) > kb.getCurrentSimTime();
    }

    public boolean isPhysicallyClosed() {
        if (this.isCapacityClosed()) {
            return true;
        }
        if (this.d_closedFor == null) {
            return false;
        }
        return this.d_closedFor.isPhysicallyClosed();
    }

    private boolean isCapacityClosed() {
        return this.d_doorDirOverride.size() == 2 || !this.d_doorDirOverride.isEmpty() && this.d_doorDir != null && this.d_doorDirOverride.iterator().next().opposite() == this.d_doorDir;
    }

    public double getNextOpenTime(KB kb, OccAgent agent) {
        if (this.d_closedFor == null) {
            return kb.getCurrentSimTime();
        }
        return this.d_closedFor.getTime(kb, agent);
    }

    public ITimeEstimate getNextOpenTimeEst() {
        return this.d_closedFor;
    }

    public void setDoorsClosed(ITimeEstimate nextOpenEst) {
        for (ANode door : this.getDoors()) {
            door.setClosed(nextOpenEst);
        }
    }

    public void updateDensityField(KB kb) {
        if (this.isDoor()) {
            return;
        }
        AABox bb = new AABox(this.getGeometryBounds());
        if (!bb.isValid() || bb.getWidth() == 0.0 || bb.getDepth() == 0.0) {
            return;
        }
        LinkedHashSet<LineSeg> nodeGeom = new LinkedHashSet<LineSeg>();
        for (Tri tri : this.getMesh()) {
            for (int m = 0; m < 3; ++m) {
                WingedEdge edge = tri.eu[m].wedge;
                if (edge.isInternal() && !edge.isBoundary()) continue;
                nodeGeom.add(new LineSeg(edge.p1(), edge.p2()));
            }
        }
        bb = bb.scale(10.0);
        LinkedHashSet<LineSeg> bounds = new LinkedHashSet<LineSeg>();
        Point3d a = new Point3d(bb.getMinX(), bb.getMaxY(), bb.getMinZ());
        Point3d b = new Point3d(bb.getMaxX(), bb.getMaxY(), bb.getMinZ());
        Point3d c = new Point3d(bb.getMaxX(), bb.getMinY(), bb.getMinZ());
        Point3d d = new Point3d(bb.getMinX(), bb.getMinY(), bb.getMinZ());
        bounds.add(new LineSeg(a, b));
        bounds.add(new LineSeg(b, c));
        bounds.add(new LineSeg(c, d));
        bounds.add(new LineSeg(d, a));
        VorDensityField.Builder builder = new VorDensityField.Builder(bounds);
        for (OccAgent agent : kb.getActiveAgents()) {
            ANode node = agent.getOcc().curNode;
            if (node != this) continue;
            Point3d loc = agent.getOcc().loc;
            builder.add(new Point2d(loc.x, loc.y), 1.0, agent);
        }
        VorDensityField field = builder.build(nodeGeom);
        if (field != null) {
            this.d_densityField = field;
        } else {
            System.err.printf("Could not build density field for node %s at time %g%n", this.name, kb.getCurrentSimTime());
        }
    }

    public IDensityField getDensityField() {
        return this.d_densityField;
    }

    public boolean isStairs() {
        return this.stairData != null;
    }

    public void createStairData(KB kb, double rise, double tread) {
        this.stairData = new StairData(rise, tread);
        kb.registerStair(this);
    }

    public void createDoorQueueData(KB kb, Param p, ANode node1, ANode node2, IDoorFlowrate flowrate, double effWid, IDistributedVal<UnitDouble> waitTime) {
        this.doorQueue = new DoorQueue(p, this, node1, node2, flowrate, effWid, waitTime);
        if (node1 != null) {
            node1.addAdjacentNode(this);
            this.addAdjacentNode(node1);
        }
        if (node2 != null) {
            node2.addAdjacentNode(this);
            this.addAdjacentNode(node2);
        }
        kb.registerDoor(this);
    }

    private void addAdjacentNode(ANode node) {
        if (node != null && node != this && !this.d_adjNodes.contains(node)) {
            this.d_adjNodes.add(node);
        }
    }

    public Collection<ANode> getAdjacentNodes() {
        return Collections.unmodifiableCollection(this.d_adjNodes);
    }

    public boolean isAdjacent(ANode node) {
        return this.d_adjNodes.contains(node);
    }

    public void addDoorEdge(WingedEdge edge) {
        if (edge != null && !this.d_doorEdges.contains(edge)) {
            this.d_doorEdges.add(edge);
        }
    }

    public void finalizeDoors() {
        this.finalizeDoorGeom();
        Supplier<Set> getDoors = () -> {
            if (this.isDoor()) {
                return Collections.singleton(this);
            }
            LinkedIdentityHashSet doors = new LinkedIdentityHashSet();
            for (WingedEdge doorEdge : this.getDoorEdges()) {
                doors.add(doorEdge.getDoorQueue().getNode());
            }
            if (doors.isEmpty()) {
                return Collections.emptySet();
            }
            if (doors.size() == 1) {
                return Collections.singleton(doors.iterator().next());
            }
            return doors;
        };
        this.d_doors = getDoors.get();
    }

    private void finalizeDoorGeom() {
        if (this.isDoor() && !this.d_doorEdges.isEmpty()) {
            this.d_doorGeom = new DoorGeom(this.d_doorEdges);
        }
    }

    public List<WingedEdge> getDoorEdges() {
        return this.d_doorEdges;
    }

    public DoorGeom getDoorGeom() {
        return this.d_doorGeom;
    }

    public Optional<DoorGeom> getOptionalDoorGeom() {
        return Optional.ofNullable(this.d_doorGeom);
    }

    public Set<ANode> getDoors() {
        return this.d_doors;
    }

    public void setAnimationId(int id) {
        this.d_animationId = id;
    }

    public int getAnimationId() {
        return this.d_animationId;
    }

    public void setAnimationXform(Vector3d offset, Quat4d rot) {
        this.d_animOffset = offset;
        this.d_animRot = rot;
    }

    public Vector3d getAnimOffset() {
        return this.d_animOffset;
    }

    public Quat4d getAnimRot() {
        return this.d_animRot;
    }

    public Matrix4d getAnimXform() {
        Matrix4d xform = new Matrix4d();
        xform.setIdentity();
        xform.setTranslation(this.d_animOffset);
        Matrix4d rotMat = new Matrix4d();
        rotMat.setIdentity();
        rotMat.setRotation(this.d_animRot);
        xform.mul(rotMat);
        return xform;
    }

    public double getArea() {
        return this.d_area;
    }

    public void setArea(double area) {
        this.d_area = area;
    }

    public void setMaxOccDensity(double dmax, boolean definedByUser) {
        this.setMaxOccupants(Density.calcMaxOccupants(dmax, this.d_area), definedByUser);
    }

    public void setMaxOccupants(int numOccs, boolean definedByUser) {
        assert (0 <= numOccs);
        this.d_maxOccupants = numOccs;
        this.d_maxOccupantsDefinedByUser |= definedByUser;
    }

    public boolean hasOccLimit() {
        return this.d_maxOccupants < Integer.MAX_VALUE;
    }

    public int getMaxOccupants() {
        return this.d_maxOccupants;
    }

    public boolean hasRoomForOneMore(KB kb) {
        if (!this.hasOccLimit()) {
            return true;
        }
        int contains = this.getCorrespondingNumOccupants() + this.d_enteringCount;
        return this.getMaxOccupants() - contains > 0;
    }

    public boolean hasRoomFor(OccAgent agent, KB kb) {
        if (!this.hasOccLimit()) {
            return true;
        }
        if (this.d_enteringAgents.contains(agent)) {
            return true;
        }
        boolean reactiveSteering = kb.getParams().reactive_steering;
        boolean isUserDefinedLimitedNode = this.d_maxOccupantsDefinedByUser && this.getMaxOccupants() != Integer.MAX_VALUE;
        boolean correspondingCount = reactiveSteering || isUserDefinedLimitedNode || this.getElevatorLevel() != null;
        int contains = this.getCorrespondingTotalNumOccupants(correspondingCount);
        int formationSize = correspondingCount ? agent.getFormationCorrespondingOccCount() : agent.getFormationSize();
        return this.getMaxOccupants() - contains - formationSize >= 0;
    }

    private int getCorrespondingTotalNumOccupants(boolean correspondingCount) {
        HashSet<OccAgent> agents = new HashSet<OccAgent>();
        HashSet<OccAgent> enteringAndInside = new HashSet<OccAgent>();
        enteringAndInside.addAll(this.getEnteringAgents());
        enteringAndInside.addAll(this.getCurrentUsage());
        for (OccAgent a : enteringAndInside) {
            if (a.getOcc().formationLeader != null) {
                agents.addAll(a.getOcc().formationLeader.getFormation());
                continue;
            }
            agents.add(a);
        }
        if (!correspondingCount) {
            return agents.size();
        }
        int count = 0;
        for (OccAgent a : agents) {
            count += a.getCorrespondingOccCount();
        }
        return count;
    }

    public void updateOccupantCounts(KB kb) {
        this.d_numOccupants += this.d_tsEntered;
        this.d_correspondingNumOccupants += this.d_tsCorrespondingEntered;
        this.d_tsEntered = 0;
        this.d_tsCorrespondingEntered = 0;
        this.d_peakOccupants = Math.max(this.d_peakOccupants, this.d_numOccupants);
        this.d_enteringCount = 0;
        if (this.d_updateMaxCapacity) {
            this.d_updateMaxCapacity = false;
            this.updateMaxCapacityReached(kb);
        }
    }

    public void willEnter(OccAgent o) {
        if (this.d_enteringAgents.add(o)) {
            this.d_enteringCount += o.getCorrespondingOccCount();
        }
    }

    public void willExit(OccAgent o) {
        if (this.d_enteringAgents.remove(o)) {
            this.d_enteringCount -= o.getCorrespondingOccCount();
        }
    }

    public int getNumOccupants() {
        return this.d_numOccupants;
    }

    public int getCorrespondingNumOccupants() {
        return this.d_correspondingNumOccupants;
    }

    public int getEnteringCount() {
        return this.d_enteringCount;
    }

    public HashSet<OccAgent> getEnteringAgents() {
        return this.d_enteringAgents;
    }

    public int getPeakNumberOfOccupants() {
        return this.d_peakOccupants;
    }

    public Set<Occupant> getTotalUsageSet() {
        return this.d_totalUsage.keySet();
    }

    public double getExitedTime(Occupant occ) {
        return this.d_totalUsage.getOrDefault(occ, Double.NaN);
    }

    public int getTotalUsage() {
        return this.d_totalUsage.size();
    }

    public double getTimeFirstPersonEntered() {
        return this.d_tForFirstPersonEntering == Double.MAX_VALUE ? 0.0 : this.d_tForFirstPersonEntering;
    }

    public double getTimeLastPersonEntered() {
        return this.d_tForLastPersonEntering == Double.MAX_VALUE ? 0.0 : this.d_tForLastPersonEntering;
    }

    public double getTimeLastPersonExited() {
        return this.d_tForLastPersonExiting;
    }

    public String getNameLastPersonExited() {
        return this.d_lastPersonExiting != null ? this.d_lastPersonExiting.getName() : null;
    }

    public synchronized void enter(KB kb, OccAgent agent, DoorQueue door, double t) {
        ++this.d_tsEntered;
        this.d_tsCorrespondingEntered += agent.getCorrespondingOccCount();
        this.d_enteringAgents.remove(agent);
        this.d_currentUsage.add(agent);
        if (door != null && !this.isDoor()) {
            this.d_doorTLastObservedActive.put(door.getNode(), t);
        }
        this.d_updateMaxCapacity = true;
        if (t < this.d_tForFirstPersonEntering) {
            this.d_tForFirstPersonEntering = t;
        }
        this.d_tForLastPersonEntering = t;
        if (this.d_occRadMod != null) {
            agent.getOcc().nodeSqueezeFactor = this.d_occRadMod.floatValue();
        }
    }

    private synchronized void updateMaxCapacityReached(KB kb) {
        boolean reachedMax;
        if (!this.d_maxOccupantsDefinedByUser || this.isDoor() || !this.hasOccLimit()) {
            return;
        }
        boolean changed = false;
        int contains = this.getCorrespondingTotalNumOccupants(true);
        boolean bl = reachedMax = this.getMaxOccupants() - contains <= 0;
        if (!this.d_maxCapacityReached && reachedMax) {
            for (ANode door : this.getDoors()) {
                DoorDir outDir = door.doorQueue.getDir(door.doorQueue.getAdjNode(this));
                boolean change = door.getOnewayDir() != outDir;
                boolean added = door.addDoorDirOverride(outDir);
                changed |= change && added;
            }
            this.d_maxCapacityReached = true;
        } else if (this.d_maxCapacityReached && !reachedMax) {
            for (ANode door : this.getDoors()) {
                DoorDir outDir = door.doorQueue.getDir(door.doorQueue.getAdjNode(this));
                boolean change = door.getOnewayDir() != null;
                boolean removed = door.removeDoorDirOverride(outDir);
                changed |= change && removed;
            }
            this.d_maxCapacityReached = false;
        }
        if (changed) {
            kb.getPathEstimates().resetDoors();
        }
    }

    public synchronized void passThrough(KB kb, OccAgent agent, DoorQueue door, double t) {
        this.enter(kb, agent, door, t);
        this.exit(kb, agent, door, t);
    }

    public int getExitedVia() {
        return this.d_numExitedVia;
    }

    public synchronized void incrementExitCount() {
        ++this.d_numExitedVia;
    }

    public synchronized void exit(KB kb, OccAgent agent, DoorQueue door, double t) {
        --this.d_tsEntered;
        this.d_tsCorrespondingEntered -= agent.getCorrespondingOccCount();
        this.d_totalUsage.put(agent.getOcc(), t);
        this.d_currentUsage.remove(agent);
        if (agent.getOcc().formationLeader != null) {
            for (OccAgent a : agent.getOcc().formationLeader.getFormation()) {
                this.willExit(a);
            }
        }
        this.d_updateMaxCapacity = true;
        if (this.d_lastPersonExiting == null || t > this.d_tForLastPersonExiting) {
            this.d_lastPersonExiting = agent;
            this.d_tForLastPersonExiting = t;
        } else if (t == this.d_tForLastPersonExiting && theUtil.gt(agent.getPriority(kb), this.d_lastPersonExiting.getPriority(kb), 1.0E-6)) {
            this.d_lastPersonExiting = agent;
            this.d_tForLastPersonExiting = t;
        }
        if (this.d_occRadMod != null) {
            agent.getOcc().nodeSqueezeFactor = 1.0f;
        }
        if (this.doorQueue != null && this.doorQueue.isExitDoor()) {
            this.incrementExitCount();
        }
    }

    public void addMeshElem(Tri mt) {
        assert (!this.d_mesh.contains(mt));
        this.d_mesh.add(mt);
    }

    public List<Tri> getMesh() {
        return Collections.unmodifiableList(this.d_mesh);
    }

    public String toString() {
        return this.name;
    }

    public boolean isDoor() {
        return this.doorQueue != null;
    }

    public boolean isInternalDoor() {
        return this.doorQueue != null && this.doorQueue.getR1() == this.doorQueue.getR2();
    }

    public boolean isExitDoor() {
        return this.doorQueue != null && (this.doorQueue.getR1() == null || this.doorQueue.getR2() == null);
    }

    public boolean isElevatorDoor() {
        if (!this.isDoor()) {
            return false;
        }
        return this.doorQueue.isElevatorDoor();
    }

    public boolean isTransportDoor() {
        return this.isElevatorDoor();
    }

    public DoorDir getExitDir() {
        assert (this.isExitDoor());
        return DoorDir.getExitDir(this);
    }

    public ANode getDestNode(DoorDir dir) {
        assert (this.isDoor());
        return this.doorQueue.dest(dir);
    }

    public Set<OccAgent> getCurrentUsage() {
        return this.d_currentUsage;
    }

    public double getDensity() {
        return (double)this.d_numOccupants / this.d_area;
    }

    public synchronized void changeCorrespondingOccCount(KB kb, OccAgent agent, int delta) {
        this.d_correspondingNumOccupants += delta;
        this.d_updateMaxCapacity = true;
    }

    public Set<ANode> getActiveDistanceMapDoors() {
        return this.d_activeDistMapDoors;
    }

    public void addOccSource(OccSource occSource) {
        if (this.d_occSources == null) {
            this.d_occSources = new ArrayList<OccSource>();
        }
        this.d_occSources.add(occSource);
    }

    public List<OccSource> getOccSources() {
        return this.d_occSources;
    }

    public Optional<ElevatorLevel> getConnectedElevatorLevel() {
        assert (this.isDoor());
        if (this.doorQueue.getR1() != null && this.doorQueue.getR1().getElevatorLevel() != null) {
            return Optional.of(this.doorQueue.getR1().getElevatorLevel());
        }
        if (this.doorQueue.getR2() != null && this.doorQueue.getR2().getElevatorLevel() != null) {
            return Optional.of(this.doorQueue.getR2().getElevatorLevel());
        }
        return Optional.empty();
    }

    public void calcElevatorRestrictions(ElevatorModel elevatorModel) {
        LinkedIdentityHashMap<IElevator, Set> curNodeElevators = null;
        if (this.getElevatorLevel() == null) {
            for (ANode e : this.getDoors()) {
                Optional<ElevatorLevel> lvl = e.getConnectedElevatorLevel();
                if (!lvl.isPresent()) continue;
                if (curNodeElevators == null) {
                    curNodeElevators = new LinkedIdentityHashMap<IElevator, Set>();
                }
                curNodeElevators.compute(elevatorModel.findElevator(lvl.get()), (key, set) -> {
                    if (set == null) {
                        set = new LinkedHashSet<ANode>();
                    }
                    set.add(e);
                    return set;
                });
            }
        }
        this.d_elevatorRestrictions = curNodeElevators != null ? Collections.unmodifiableMap(curNodeElevators) : null;
    }

    public Map<IElevator, Set<ANode>> getElevatorRestrictions() {
        return this.d_elevatorRestrictions;
    }

    public boolean isTransportNode() {
        return this.getElevatorLevel() != null;
    }

    public boolean shouldExitTransport() {
        ElevatorLevel level = this.getElevatorLevel();
        if (level != null) {
            return level.isDischargeLevel;
        }
        return false;
    }

    public void setCapacity(Capacity capacity) {
        this.d_capacity = capacity;
    }

    public Capacity getCapacity() {
        return this.d_capacity;
    }

    public void updateMaxOccCount(boolean forceUpdate) {
        if (this.d_capacity == null) {
            return;
        }
        int maxOccs = this.d_capacity.getMaxOccCount();
        if (forceUpdate || theUtil.le(maxOccs, this.getMaxOccupants(), 0.0)) {
            this.setMaxOccupants(maxOccs, true);
        }
    }

    public Tri.Terrain getTerrain() {
        if (this.d_mesh.isEmpty()) {
            return null;
        }
        return this.d_mesh.get((int)0).terrain;
    }

    public Point3d getNearestLocOnDoor(Point3d p) {
        if (this.d_doorGeom == null) {
            return null;
        }
        Pair<WingedEdge, Point3d> info = this.d_doorGeom.getNearestInfoOnDoor(p);
        if (info == null) {
            return null;
        }
        return (Point3d)info.v2;
    }

    public static final class Density
    implements Capacity,
    Serializable {
        static final long serialVersionUID = 1L;
        private final double density;
        private final ANode node;

        public Density(double density, ANode node) {
            this.density = density;
            this.node = node;
        }

        @Override
        public int getMaxOccCount() {
            return Density.calcMaxOccupants(this.density, this.node.getArea());
        }

        public double getDensity() {
            return this.density;
        }

        private static int calcMaxOccupants(double dmax, double area) {
            if (Double.isInfinite(dmax)) {
                return Integer.MAX_VALUE;
            }
            return Math.max(1, KnownFuncs.maxPersons(area, dmax));
        }
    }

    public static final class Count
    implements Capacity,
    Serializable {
        static final long serialVersionUID = 1L;
        private final int count;

        public Count(int count) {
            this.count = count;
        }

        @Override
        public int getMaxOccCount() {
            return this.count;
        }
    }

    public static interface Capacity {
        public int getMaxOccCount();
    }

    public static class SubMesh
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final ConnectedMesh mesh;
        public final Map<ANode, List<ConnectedMesh.Vertex>> doorVerts;
        public final EdgeData[] triEdgeData;
        public final RTree<ConnectedMesh.Vertex> positionSearch;
        public final VertData[] positionData;

        public SubMesh(NodeUtil.TriangulateResult trResult, RTree<ConnectedMesh.Vertex> positionSearch, VertData[] positionData) {
            this.mesh = trResult.mesh;
            this.doorVerts = trResult.doorVerts;
            this.triEdgeData = trResult.triEdgeData;
            this.positionSearch = positionSearch;
            this.positionData = positionData;
        }

        public boolean isBoundaryPosition(int pid) {
            return this.positionData[pid].isBoundary;
        }

        public Tri getPositionTri(int pid) {
            return this.positionData[pid].tri;
        }
    }

    public static class VertData
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final Tri tri;
        public final boolean isBoundary;

        public VertData(Tri tri, boolean isBoundary) {
            this.tri = tri;
            this.isBoundary = isBoundary;
        }
    }

    private static class ConstantVertVals
    implements Serializable,
    IntToDoubleFunction {
        private static final long serialVersionUID = 1L;
        public final double val;

        public ConstantVertVals(double val) {
            this.val = val;
        }

        @Override
        public double applyAsDouble(int value) {
            return this.val;
        }
    }

    public static class DistFldInfo
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final ValueFld dists;
        public final VectorFld maxDistDirs;

        public DistFldInfo(ValueFld dists, VectorFld maxDistDirs) {
            this.dists = dists;
            this.maxDistDirs = maxDistDirs;
        }
    }
}

