/*
 * Decompiled with CFR 0.152.
 */
package fpserver;

import fpserver.AsyncUpdates;
import fpserver.Config;
import fpserver.IPacket;
import fpserver.IServer;
import fpserver.Prob;
import fpserver.RealTimeTweak;
import fpserver.ServerState;
import fpserver.SetAi;
import fpserver.Status;
import inferno.data2.ANode;
import inferno.data2.AppearanceMod;
import inferno.data2.Blockage;
import inferno.data2.Camera;
import inferno.data2.DoorGeom;
import inferno.data2.IAnimSrc;
import inferno.data2.ITimeEstimate;
import inferno.data2.Obscuration;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.sim.CameraAgent;
import inferno.sim.Engine;
import inferno.sim.EngineOp;
import inferno.sim.GeomVisWriter;
import inferno.sim.IRelation;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccVisWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.Sphere;
import thunderheadeng.util.CSVLineParser;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.UncUtil;
import thunderheadeng.util.theUtil;

public class Api {
    private Config d_config;
    private TeciProps d_appPrefs;
    private Prob d_prob;
    private Map<Integer, OccAgent> d_controlledIdToAgentMap = new HashMap<Integer, OccAgent>();
    private Map<Integer, OccAgent> d_npcIdToAgentMap = new HashMap<Integer, OccAgent>();
    private IServer d_asyncServer;

    public Api(Config cfg, TeciProps appPrefs, IServer asyncServer) {
        this.d_config = cfg;
        this.d_appPrefs = appPrefs;
        this.d_asyncServer = asyncServer;
    }

    public Pair<Integer, String> invoke(IServer server, IPacket msgRecv) {
        List<String> toks = CSVLineParser.parse(msgRecv.getMsg(), " ", "\"");
        if (toks.isEmpty()) {
            return new Pair<Integer, String>(0, "");
        }
        String func = toks.get(0);
        toks.remove(0);
        try {
            Method m = null;
            try {
                m = Api.class.getMethod(func, IServer.class, IPacket.class, List.class);
            }
            catch (NoSuchMethodException e) {
                return new Pair<Integer, String>(-1, "Unknown Command: " + func);
            }
            Pair imsg = (Pair)m.invoke((Object)this, server, msgRecv, toks);
            return imsg;
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getCause();
            }
            StringWriter stackTraceStr = new StringWriter();
            PrintWriter writer = new PrintWriter(stackTraceStr);
            t.printStackTrace(writer);
            return new Pair<Integer, String>(-1, stackTraceStr.toString());
        }
    }

    public Pair<Integer, String> quit(IServer server, IPacket recvPacket, List<String> args) {
        System.exit(0);
        return null;
    }

    public Pair<Integer, String> load(IServer server, IPacket recvPacket, List<String> args) {
        File probfile;
        if (this.d_prob != null) {
            return new Pair<Integer, String>(-1, "Problem already loaded.");
        }
        String probPath = this.d_config.getString("PTH_FILE");
        if (!args.isEmpty()) {
            probPath = args.get(0);
        }
        if (!(probfile = new File(probPath)).exists()) {
            return new Pair<Integer, String>(-1, "File not found: " + probPath);
        }
        try {
            this.d_prob = new Prob(this.d_appPrefs, "elbit-prob", probfile, new RealTimeTweak());
        }
        catch (Throwable t) {
            return new Pair<Integer, String>(-1, "Error loading model: " + t.getClass().getName() + ": " + t.getMessage());
        }
        if (this.d_prob.getEngine() == null) {
            return new Pair<Integer, String>(-1, "Unable to load model: " + probfile.getName());
        }
        AsyncUpdates updates = new AsyncUpdates(this.d_prob.getEngine(), this.d_asyncServer, this.d_prob.getOccTracker());
        this.d_prob.getEngine().setTimedCallback(0.0, updates);
        return new Pair<Integer, String>(0, "Loaded model: " + probfile.getName());
    }

    public Pair<Integer, String> get_blockages_csv(IServer server, IPacket recvPacket, List<String> args) {
        return this.invokeOperation(server, recvPacket, args, new GetBlockagesCSV());
    }

    public Pair<Integer, String> get_num_blockages(IServer server, IPacket recvPacket, List<String> args) {
        return this.invokeOperation(server, recvPacket, args, new GetNumBlockages());
    }

    public Pair<Integer, String> get_agent_position(IServer server, IPacket recvPacket, List<String> args) {
        int id;
        OccAgent agent;
        Point3d agentPosition = null;
        if (this.d_prob != null && (agent = this.d_controlledIdToAgentMap.get(id = Integer.parseInt(args.get(0)))) != null) {
            agentPosition = agent.getPos();
        }
        return this.invokeOperation(server, recvPacket, args, new GetAgentPosition(agentPosition));
    }

    public Pair<Integer, String> get_blockage(IServer server, IPacket recvPacket, List<String> args) {
        return this.invokeOperation(server, recvPacket, args, new GetBlockage());
    }

    public Pair<Integer, String> create_appearance_mod(IServer server, IPacket recvPacket, List<String> args) {
        try {
            AppearanceMod.Type amType;
            Prob prob = this.getProblem();
            TokenIterator tokens = new TokenIterator(args);
            try {
                int type = tokens.nextInt();
                switch (type) {
                    case 0: {
                        amType = AppearanceMod.Type.DAMAGE_SLIGHT;
                        break;
                    }
                    case 1: {
                        amType = AppearanceMod.Type.DAMAGE_MODERATE;
                        break;
                    }
                    case 2: {
                        amType = AppearanceMod.Type.DAMAGE_SEVERE;
                        break;
                    }
                    default: {
                        throw new IOException(String.format("Unknown appearance modification: %d", type));
                    }
                }
            }
            catch (NumberFormatException e) {
                tokens.rewind(1);
                String typeStr = tokens.next();
                if (typeStr.equalsIgnoreCase("damage_slight")) {
                    amType = AppearanceMod.Type.DAMAGE_SLIGHT;
                }
                if (typeStr.equalsIgnoreCase("damage_moderate")) {
                    amType = AppearanceMod.Type.DAMAGE_MODERATE;
                }
                if (typeStr.equalsIgnoreCase("damage_severe")) {
                    amType = AppearanceMod.Type.DAMAGE_SEVERE;
                }
                throw new IOException(String.format("Unknown appearance modification: %s", typeStr));
            }
            Map<Status.StatusArg, Object> statusArgs = Status.procArgs(args.subList(tokens.tix, args.size()));
            Status.SphereData sd = (Status.SphereData)statusArgs.get((Object)Status.StatusArg.SPHERE);
            if (sd == null) {
                throw new IOException("Region for appearance modification must be specified with \"-sphere cx cy cz r\"");
            }
            CreateAppearanceModOp op = new CreateAppearanceModOp(amType, Arrays.asList(new Sphere(new Point3d(sd.x, sd.y, sd.z), sd.r)));
            prob.getEngine().pushOp(op);
            return new Pair<Integer, String>(1, "Queued new appearance modification.");
        }
        catch (Exception e) {
            return this.getErrorResult(e);
        }
    }

    public Pair<Integer, String> delete_appearance_mod(IServer server, IPacket recvPacket, List<String> args) {
        try {
            Prob prob = this.getProblem();
            TokenIterator tokens = new TokenIterator(args);
            int id = tokens.nextInt();
            DeleteAppearanceModOp op = new DeleteAppearanceModOp(id);
            prob.getEngine().pushOp(op);
            return new Pair<Integer, String>(0, "Queued appearance modification deletion");
        }
        catch (Exception e) {
            return this.getErrorResult(e);
        }
    }

    public Pair<Integer, String> create_obscuration(IServer server, IPacket recvPacket, List<String> args) {
        try {
            Prob prob = this.getProblem();
            int argix = 0;
            String floorName = args.get(argix++);
            int r = Integer.parseInt(args.get(argix++));
            int g = Integer.parseInt(args.get(argix++));
            int b = Integer.parseInt(args.get(argix++));
            Color color = new Color(r, g, b);
            double density = Double.parseDouble(args.get(argix++));
            boolean initState = Boolean.parseBoolean(args.get(argix++));
            CreateObscurationOp op = new CreateObscurationOp(floorName, color, density, initState);
            prob.getEngine().pushOp(op);
            return new Pair<Integer, String>(1, "Queued new obscuration.");
        }
        catch (Exception e) {
            return this.getErrorResult(e);
        }
    }

    public Pair<Integer, String> delete_obscuration(IServer server, IPacket recvPacket, List<String> args) {
        try {
            Prob prob = this.getProblem();
            int id = Integer.parseInt(args.get(0));
            DeleteObscurationOp op = new DeleteObscurationOp(id);
            prob.getEngine().pushOp(op);
            return new Pair<Integer, String>(0, "Queued obscuration deletion");
        }
        catch (Exception e) {
            return this.getErrorResult(e);
        }
    }

    public Pair<Integer, String> set_obscuration_active(IServer server, IPacket recvPacket, List<String> args) {
        try {
            Prob prob = this.getProblem();
            int id = Integer.parseInt(args.get(0));
            boolean state = Boolean.parseBoolean(args.get(1));
            ActivateObscurationOp op = new ActivateObscurationOp(id, state);
            prob.getEngine().pushOp(op);
            return new Pair<Integer, String>(1, "Setting obscuration active.");
        }
        catch (Exception e) {
            return this.getErrorResult(e);
        }
    }

    public Pair<Integer, String> set_obscuration_params(IServer server, IPacket recvPacket, List<String> args) {
        try {
            Prob prob = this.getProblem();
            int argix = 0;
            int id = Integer.parseInt(args.get(argix++));
            int r = Integer.parseInt(args.get(argix++));
            int g = Integer.parseInt(args.get(argix++));
            int b = Integer.parseInt(args.get(argix++));
            Color color = new Color(r, g, b);
            double density = Double.parseDouble(args.get(argix++));
            SetObscurationParamsOp op = new SetObscurationParamsOp(id, color, density);
            prob.getEngine().pushOp(op);
            return new Pair<Integer, String>(1, "Setting obscuration params.");
        }
        catch (Exception e) {
            return this.getErrorResult(e);
        }
    }

    public Pair<Integer, String> mod_cam(IServer server, IPacket recvPacket, List<String> args) {
        try {
            double[] params;
            Prob prob = this.getProblem();
            CameraAgent camera = Api.getCameraByName(prob.getEngine().getKB(), args.get(0));
            String modeStr = args.get(1);
            double weight = Double.parseDouble(args.get(2));
            CameraAgent.IModifier currModifier = camera.getModifier();
            if (currModifier instanceof CameraAgent.PTZModifier) {
                CameraAgent.PTZModifier ptz = (CameraAgent.PTZModifier)currModifier;
                params = new double[]{ptz.panWt, ptz.tiltWt, ptz.zoomWt};
            } else {
                params = new double[]{0.0, 0.0, 0.0};
            }
            int ix = modeStr.equalsIgnoreCase("pan") ? 0 : (modeStr.equalsIgnoreCase("tilt") ? 1 : 2);
            params[ix] = weight;
            System.out.printf("%g %g %g%n", params[0], params[1], params[2]);
            camera.setModifier(new CameraAgent.PTZModifier(params[0], params[1], params[2]));
            return new Pair<Integer, String>(0, "");
        }
        catch (Exception e) {
            return this.getErrorResult(e);
        }
    }

    public Pair<Integer, String> camera_to(IServer server, IPacket recvPacket, List<String> args) {
        try {
            Prob prob = this.getProblem();
            CameraAgent camera = Api.getCameraByName(prob.getEngine().getKB(), args.get(0));
            double xref = Double.parseDouble(args.get(1));
            double yref = Double.parseDouble(args.get(2));
            double zref = Double.parseDouble(args.get(3));
            camera.setModifier(new CameraAgent.AimAt(new Point3d(xref, yref, zref)));
            return new Pair<Integer, String>(0, "");
        }
        catch (Exception e) {
            return this.getErrorResult(e);
        }
    }

    private static CameraAgent getCameraByName(KB kb, String name) throws IOException {
        if (!name.startsWith("\"") && !name.endsWith("\"")) {
            try {
                int id = Integer.parseInt(name);
                if (id < 0 || id >= kb.getCameraAgents().size()) {
                    throw new IOException(String.format("Invalid camera id: %d", id));
                }
                return kb.getCameraAgents().get(id);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        for (CameraAgent camera : kb.getCameraAgents()) {
            if (!camera.getCamera().get(Camera.PROP_NAME).equals(name)) continue;
            return camera;
        }
        throw new IOException(String.format("Invalid camera name: %s", name));
    }

    protected Pair<Integer, String> getErrorResult(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        return new Pair<Integer, String>(-1, e.getLocalizedMessage());
    }

    protected Prob getProblem() throws ApiException {
        if (this.d_prob == null) {
            throw new ApiException("No problem loaded.");
        }
        return this.d_prob;
    }

    public Pair<Integer, String> pause(IServer server, IPacket recvPacket, List<String> args) {
        return this.invokeOperation(server, recvPacket, args, new Pause());
    }

    public Pair<Integer, String> stop(IServer server, IPacket recvPacket, List<String> args) {
        if (this.d_prob == null) {
            return new Pair<Integer, String>(-1, "No problem loaded - Api.stop().");
        }
        Engine e = this.d_prob.getEngine();
        if (e.isFinished()) {
            return new Pair<Integer, String>(-1, "problem already finished");
        }
        e.cancel();
        try {
            e.waitUntilFinished(100L);
        }
        catch (ExecutionException t) {
            throw new RuntimeException(t.getCause());
        }
        catch (FileNotFoundException t) {
            throw new RuntimeException(t);
        }
        this.d_prob = null;
        this.d_controlledIdToAgentMap.clear();
        this.d_npcIdToAgentMap.clear();
        return new Pair<Integer, String>(0, "simulation stopped");
    }

    public Pair<Integer, String> resume(IServer server, IPacket recvPacket, List<String> args) {
        if (this.d_prob == null) {
            return new Pair<Integer, String>(-1, "No problem loaded - Api.resume().");
        }
        Engine e = this.d_prob.getEngine();
        if (e.isFinished()) {
            return new Pair<Integer, String>(-1, "problem already finished");
        }
        e.resume();
        return new Pair<Integer, String>(0, "simulation resumed");
    }

    public Pair<Integer, String> status(IServer server, IPacket recvPacket, List<String> args) {
        if (this.d_prob == null) {
            return new Pair<Integer, String>(-1, "No problem loaded - Api.status().");
        }
        return this.invokeOperation(server, recvPacket, args, new GetStatus());
    }

    public Pair<Integer, String> get_event_port(IServer server, IPacket recvPacket, List<String> args) {
        int port = this.d_config.getInt("PORT_ASYNC");
        MessageStream out = new MessageStream();
        DataOutputStream os = new DataOutputStream(out);
        try {
            os.writeInt(port);
            os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        out.asyncSend(server, recvPacket);
        return new Pair<Integer, String>(0, "Event port: " + port);
    }

    public Pair<Integer, String> get_animated_nodes(IServer server, IPacket recvPacket, List<String> args) {
        return this.invokeOperation(server, recvPacket, args, new GetAnimatedNodes());
    }

    public Pair<Integer, String> get_active_agents(IServer server, IPacket recvPacket, List<String> args) {
        return this.invokeOperation(server, recvPacket, args, new GetActiveAgents());
    }

    public Pair<Integer, String> request_async_update(IServer server, IPacket recvPacket, List<String> args) {
        return this.invokeOperation(server, recvPacket, args, new RequestAsyncUpdate());
    }

    public Pair<Integer, String> add_agent(IServer server, IPacket recvPacket, List<String> args) {
        return this.invokeOperation(server, recvPacket, args, new AddAgent());
    }

    private static Map<AgentProp, Object> getDefaultOccProps() {
        HashMap<AgentProp, Object> props = new HashMap<AgentProp, Object>();
        for (AgentProp prop : AgentProp.values()) {
            if (prop.defVal == null) continue;
            props.put(prop, prop.defVal);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, String> remove_agent(IServer server, IPacket recvPacket, List<String> args) {
        if (this.d_prob == null) {
            return new Pair<Integer, String>(-1, "No problem loaded - Api.remove_agent().");
        }
        Engine e = this.d_prob.getEngine();
        e.pause(true);
        try {
            for (String strId : args) {
                int id = Integer.parseInt(strId);
                OccAgent agent = this.d_controlledIdToAgentMap.get(id);
                if (agent == null) {
                    Pair<Integer, String> pair = new Pair<Integer, String>(-1, "Agent not found.");
                    return pair;
                }
                agent.finishNoExit(e.getKB());
            }
        }
        finally {
            e.resume();
        }
        e.scheduleCallbackNotification();
        return new Pair<Integer, String>(0, "Removed: " + args.toString());
    }

    public Pair<Integer, String> move(IServer server, IPacket recvPacket, List<String> args) {
        double abhMaxVel;
        IRelation.Assisting assistRel;
        if (this.d_prob == null) {
            return new Pair<Integer, String>(-1, "No problem loaded - Api.move().");
        }
        int id = Integer.parseInt(args.get(0));
        OccAgent agent = this.d_controlledIdToAgentMap.get(id);
        if (agent == null) {
            return new Pair<Integer, String>(-1, "Agent not found.");
        }
        Vector3d vel = new Vector3d();
        double turnVel = 0.0;
        if (4 <= args.size()) {
            vel.x = Double.parseDouble(args.get(1));
            vel.y = Double.parseDouble(args.get(2));
            vel.z = Double.parseDouble(args.get(3));
        } else {
            vel.x = Math.random() * 2.0 - 1.0;
            vel.y = Math.random() * 2.0 - 1.0;
            vel.z = 0.0;
        }
        if (vel.lengthSquared() > 0.0) {
            Engine engine = this.d_prob.getEngine();
            KB kb = engine.getKB();
            double maxVel = OccAgent.getMaxVel(kb, agent.getOcc(), vel);
            vel.scale(maxVel);
        }
        if ((assistRel = (IRelation.Assisting)agent.getRelation(IRelation.Assisting.class)) != null && (abhMaxVel = (double)assistRel.agentBeingHelped.getOcc().maxVel) < vel.length()) {
            vel.normalize();
            vel.scale(abhMaxVel);
        }
        if (5 <= args.size()) {
            turnVel = 2.0 * Double.parseDouble(args.get(4));
        }
        agent.impell(vel, turnVel);
        return new Pair<Integer, String>(0, "");
    }

    public Pair<Integer, String> get_results_path(IServer server, IPacket recvPacket, List<String> args) {
        return this.invokeOperation(server, recvPacket, args, new GetResultsPath());
    }

    public Pair<Integer, String> get_state(IServer server, IPacket recvPacket, List<String> args) {
        return this.invokeOperation(server, recvPacket, args, new GetState());
    }

    public Pair<Integer, String> get_time(IServer server, IPacket recvPacket, List<String> args) {
        return this.invokeOperation(server, recvPacket, args, new GetTime());
    }

    private static Collection<ANode> getDoorNodeByName(KB kb, String name) {
        try {
            int id = Integer.parseInt(name);
            ANode node = kb.getAnimatedNode(id);
            if (node != null && node.isDoor()) {
                return Arrays.asList(node);
            }
        }
        catch (NumberFormatException id) {
            // empty catch block
        }
        ArrayDeque<ANode> nodes = new ArrayDeque<ANode>();
        for (ANode door : kb.getDoorNodes()) {
            if (!door.name.equals(name)) continue;
            nodes.add(door);
        }
        return nodes;
    }

    public Pair<Integer, String> open_door(IServer server, IPacket recvPacket, List<String> args) {
        if (this.d_prob == null) {
            return new Pair<Integer, String>(-1, "No problem loaded - Api.open_door().");
        }
        Engine e = this.d_prob.getEngine();
        try {
            final Collection<ANode> doors = this.getDoorsFromArgs(args);
            e.pushOp(new EngineOp(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(Engine e) {
                    KB kb = e.getKB();
                    for (ANode door : doors) {
                        door.setClosed(null);
                        kb.getPathEstimates().resetDoors();
                    }
                    e.scheduleCallbackNotification();
                }
            });
        }
        catch (IOException ex) {
            return new Pair<Integer, String>(-1, ex.getLocalizedMessage());
        }
        return new Pair<Integer, String>(0, String.format("Scheduled Open: %s", args.toString()));
    }

    public Pair<Integer, String> close_door(IServer server, IPacket recvPacket, List<String> args) {
        if (this.d_prob == null) {
            return new Pair<Integer, String>(-1, "No problem loaded - Api.close_door().");
        }
        Engine e = this.d_prob.getEngine();
        try {
            final Collection<ANode> doors = this.getDoorsFromArgs(args);
            e.pushOp(new EngineOp(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(Engine e) {
                    KB kb = e.getKB();
                    for (ANode door : doors) {
                        door.setClosed(ITimeEstimate.FOREVER);
                        kb.getPathEstimates().resetDoors();
                    }
                    e.scheduleCallbackNotification();
                }
            });
        }
        catch (IOException ex) {
            return new Pair<Integer, String>(-1, ex.getLocalizedMessage());
        }
        return new Pair<Integer, String>(0, String.format("Scheduled Closed: %s", args.toString()));
    }

    private Collection<ANode> getDoorsFromArgs(List<String> args) throws IOException {
        if (args.size() == 1 && args.get(0).equals("*")) {
            Predicate<ANode> filter = new Predicate<ANode>(){

                @Override
                public boolean test(ANode o) {
                    return o.getAnimationId() >= 0;
                }
            };
            return theUtil.filter(this.d_prob.getEngine().getKB().getDoorNodes(), filter);
        }
        ArrayList<ANode> nodes = new ArrayList<ANode>(args.size());
        KB kb = this.d_prob.getEngine().getKB();
        for (String doorName : args) {
            Collection<ANode> doors = Api.getDoorNodeByName(kb, doorName);
            if (doors.isEmpty()) {
                throw new IOException(String.format("Door not found: %s", doorName));
            }
            nodes.addAll(doors);
        }
        return nodes;
    }

    public Pair<Integer, String> init_client_data(IServer server, IPacket recvPacket, List<String> args) {
        return new Pair<Integer, String>(-1, "");
    }

    public Pair<Integer, String> update_client_data(IServer server, IPacket recvPacket, List<String> args) {
        return new Pair<Integer, String>(-1, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, String> add_blockage(IServer server, IPacket recvPacket, List<String> args) {
        if (this.d_prob == null) {
            return new Pair<Integer, String>(-1, "No problem loaded - Api.add().");
        }
        Engine e = this.d_prob.getEngine();
        KB kb = e.getKB();
        e.pause(true);
        int added = 0;
        try {
            for (String blkgId : args) {
                List<Blockage> blockages = kb.getBlockages(blkgId);
                if (blockages.isEmpty()) {
                    System.err.println("[add] Ignoring unknown blockage: " + blkgId);
                    continue;
                }
                for (Blockage blkg : blockages) {
                    e.pushOp(new EngineOp.AddBlockage(blkg));
                }
                ++added;
            }
        }
        finally {
            e.resume();
        }
        return 0 < added ? new Pair<Integer, String>(0, "Added " + added + " blockages.") : new Pair<Integer, String>(-1, "No blockage added");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, String> remove_blockage(IServer server, IPacket recvPacket, List<String> args) {
        if (this.d_prob == null) {
            return new Pair<Integer, String>(-1, "No problem loaded - Api.remove().");
        }
        Engine e = this.d_prob.getEngine();
        KB kb = e.getKB();
        e.pause(true);
        int removed = 0;
        try {
            for (String blkgId : args) {
                List<Blockage> blockages = kb.getBlockages(blkgId);
                if (blockages.isEmpty()) {
                    System.err.println("[add] Ignoring unknown blockage: " + blkgId);
                    continue;
                }
                for (Blockage blkg : blockages) {
                    e.pushOp(new EngineOp.RemoveBlockage(blkg));
                }
                ++removed;
            }
        }
        finally {
            e.resume();
        }
        return 0 < removed ? new Pair<Integer, String>(0, "Removed " + removed + " blockage(s).") : new Pair<Integer, String>(-1, "No blockage added");
    }

    private OccAgent getAgentById(KB kb, int id) {
        if (this.d_controlledIdToAgentMap.containsKey(id)) {
            return this.d_controlledIdToAgentMap.get(id);
        }
        if (this.d_npcIdToAgentMap.containsKey(id)) {
            return this.d_npcIdToAgentMap.get(id);
        }
        for (OccAgent agent : kb.getAgents()) {
            if (agent.getOcc().id != id) continue;
            this.d_npcIdToAgentMap.put(id, agent);
            return agent;
        }
        throw new IllegalArgumentException(String.format("Agent id=%d not found.", id));
    }

    private IRelation parseRelation(KB kb, List<String> args) {
        String relname;
        int nextArg = 0;
        if ((relname = args.get(nextArg++)).equalsIgnoreCase("ASSISTED_BY")) {
            int helperId = Integer.parseInt(args.get(nextArg++));
            OccAgent helper = this.getAgentById(kb, helperId);
            return new IRelation.AssistedBy(helper);
        }
        if (relname.equalsIgnoreCase("ASSISTING")) {
            int needsHelpId = Integer.parseInt(args.get(nextArg++));
            OccAgent needsHelp = this.getAgentById(kb, needsHelpId);
            return new IRelation.Assisting(needsHelp);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, String> add_relation(IServer server, IPacket recvPacket, List<String> args) {
        block5: {
            if (this.d_prob == null) {
                return new Pair<Integer, String>(-1, "No problem loaded - Api.add_relation().");
            }
            Engine e = this.d_prob.getEngine();
            KB kb = e.getKB();
            e.pause();
            try {
                int targetId = Integer.parseInt(args.get(0));
                OccAgent target = this.getAgentById(kb, targetId);
                IRelation relation = this.parseRelation(kb, args.subList(1, args.size()));
                if (relation != null) {
                    e.pushOp(new EngineOp.AddRelation(target, relation));
                    break block5;
                }
                Pair<Integer, String> pair = new Pair<Integer, String>(-1, "[Api.add_relation()] Unable to parse relation.");
                return pair;
            }
            finally {
                e.resume();
            }
        }
        return new Pair<Integer, String>(0, "Relation added to Occupant " + args.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, String> remove_relation(IServer server, IPacket recvPacket, List<String> args) {
        block5: {
            if (this.d_prob == null) {
                return new Pair<Integer, String>(-1, "No problem loaded - Api.remove_relation().");
            }
            Engine e = this.d_prob.getEngine();
            KB kb = e.getKB();
            e.pause();
            try {
                int targetId = Integer.parseInt(args.get(0));
                OccAgent target = this.getAgentById(kb, targetId);
                IRelation relation = this.parseRelation(kb, args.subList(1, args.size()));
                if (relation != null) {
                    e.pushOp(new EngineOp.RemoveRelation(target, relation));
                    break block5;
                }
                Pair<Integer, String> pair = new Pair<Integer, String>(-1, "[Api.remove_relation()] Unable to parse relation.");
                return pair;
            }
            finally {
                e.resume();
            }
        }
        return new Pair<Integer, String>(0, "Relation removed from Occupant " + args.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, String> leave(IServer server, IPacket recvPacket, List<String> args) {
        if (this.d_prob == null) {
            return new Pair<Integer, String>(-1, "No problem loaded - Api.leave().");
        }
        Engine e = this.d_prob.getEngine();
        KB kb = e.getKB();
        e.pause();
        try {
            String msg;
            TokenIterator tik = new TokenIterator(args);
            int occId = tik.nextInt();
            String doorName = tik.next();
            OccAgent agent = this.getAgentById(kb, occId);
            Collection<ANode> doors = Api.getDoorNodeByName(kb, doorName);
            if (doors.isEmpty()) {
                throw new IllegalArgumentException(String.format("Door, %s, not found.", doorName));
            }
            if (doors.size() > 1) {
                throw new IllegalArgumentException(String.format("%s refers to multiple doors. Use a door ID instead.", doorName));
            }
            ANode door = doors.iterator().next();
            if (door != null) {
                if (!door.isExitDoor()) {
                    throw new IllegalArgumentException(String.format("Door, %s, is not an exit door.", doorName));
                }
                msg = String.format("Occupant %d left via door %s.", occId, door.name);
            } else {
                msg = String.format("Occupant %d left the simulation.", occId);
            }
            e.pushOp(new EngineOp.Leave(agent, doors.iterator().next()));
            Pair<Integer, String> pair = new Pair<Integer, String>(0, msg);
            return pair;
        }
        finally {
            e.resume();
        }
    }

    public Pair<Integer, String> set_ai(IServer server, IPacket recvPacket, List<String> args) {
        if (this.d_prob == null) {
            return new Pair<Integer, String>(-1, "No problem loaded - Api.set_ai().");
        }
        return this.invokeOperation(server, recvPacket, args, new SetAi.Operation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, String> idle(IServer server, IPacket recvPacket, List<String> args) {
        block6: {
            if (this.d_prob == null) {
                return new Pair<Integer, String>(-1, "No problem loaded - Api.idle().");
            }
            Engine e = this.d_prob.getEngine();
            e.pause(true);
            try {
                if (args.get(0).equalsIgnoreCase("on")) {
                    e.pushOp(new EngineOp.SetForceIdle(true));
                    break block6;
                }
                if (args.get(0).equalsIgnoreCase("off")) {
                    e.pushOp(new EngineOp.SetForceIdle(false));
                    break block6;
                }
                Pair<Integer, String> pair = new Pair<Integer, String>(-1, "Invalid command: " + args.get(0));
                return pair;
            }
            finally {
                e.resume();
            }
        }
        return new Pair<Integer, String>(0, "Idle set to: " + args.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Pair<Integer, String> invokeOperation(IServer server, IPacket recvPacket, List<String> args, IOperation<T> getter) {
        Pair<Integer, String> response = null;
        Object result = null;
        try {
            Prob prob = this.getProblem();
            result = getter.performOp(this, server, recvPacket, args, prob);
        }
        catch (Exception e) {
            result = getter.getErrorResponse(server, recvPacket, args);
            Pair<Integer, String> pair = this.getErrorResult(e);
            return pair;
        }
        finally {
            MessageStream stream = new MessageStream();
            try {
                response = getter.writeResponse(this, result, stream);
                stream.asyncSend(server, recvPacket);
            }
            catch (IOException e) {
                e.printStackTrace();
                response = new Pair<Integer, String>(-1, "Error writing response.");
            }
        }
        return response;
    }

    private static class TokenIterator {
        public final List<String> tokens;
        public int tix;

        public TokenIterator(String[] tokens) {
            this(Arrays.asList(tokens), 0);
        }

        public TokenIterator(String[] tokens, int tix) {
            this(Arrays.asList(tokens), tix);
        }

        public TokenIterator(List<String> tokens) {
            this(tokens, 0);
        }

        public TokenIterator(List<String> tokens, int tix) {
            this.tokens = tokens;
            this.tix = tix;
        }

        public String next() {
            return this.tokens.get(this.tix++);
        }

        public int nextInt() throws NumberFormatException {
            return Integer.parseInt(this.next());
        }

        public double nextDouble() throws NumberFormatException {
            return Double.parseDouble(this.next());
        }

        public boolean hasMore() {
            return this.tix < this.tokens.size();
        }

        public int getRemaining() {
            return this.tokens.size() - this.tix;
        }

        public void rewind(int count) {
            this.tix -= count;
        }
    }

    protected static class MessageStream
    extends ByteArrayOutputStream {
        protected MessageStream() {
        }

        public void asyncSend(IServer server, IPacket recvPacket) {
            server.asyncSend(recvPacket, this.buf, 0, this.count, null);
        }
    }

    protected static interface IOperation<T> {
        public T performOp(Api var1, IServer var2, IPacket var3, List<String> var4, Prob var5) throws ApiException;

        public T getErrorResponse(IServer var1, IPacket var2, List<String> var3);

        public Pair<Integer, String> writeResponse(Api var1, T var2, OutputStream var3) throws IOException;
    }

    protected static class ApiException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ApiException() {
        }

        public ApiException(String msg) {
            super(msg);
        }

        public ApiException(Throwable cause) {
            super(cause);
        }

        public ApiException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static class GetTime
    implements IOperation<Double> {
        private GetTime() {
        }

        @Override
        public Double getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return 0.0;
        }

        @Override
        public Double performOp(Api api, IServer server, IPacket recvPacket, List<String> args, Prob prob) throws ApiException {
            return prob.getEngine().getKB().getCurrentSimTime();
        }

        @Override
        public Pair<Integer, String> writeResponse(Api api, Double data, OutputStream out) throws IOException {
            DataOutputStream ds = new DataOutputStream(out);
            ds.writeDouble(data);
            ds.flush();
            return new Pair<Integer, String>(0, String.format("Sim Time = %.2f", data));
        }
    }

    private static class GetState
    implements IOperation<ServerState> {
        private GetState() {
        }

        @Override
        public ServerState getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return ServerState.UNLOADED;
        }

        @Override
        public ServerState performOp(Api api, IServer server, IPacket recvPacket, List<String> args, Prob prob) throws ApiException {
            return ServerState.get(prob.getEngine());
        }

        @Override
        public Pair<Integer, String> writeResponse(Api api, ServerState data, OutputStream out) throws IOException {
            DataOutputStream strmBin = new DataOutputStream(out);
            strmBin.writeInt(data.ordinal());
            strmBin.flush();
            return new Pair<Integer, String>(0, data.toString());
        }
    }

    private static class GetResultsPath
    implements IOperation<String> {
        private GetResultsPath() {
        }

        @Override
        public String getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return "";
        }

        @Override
        public String performOp(Api api, IServer server, IPacket recvPacket, List<String> args, Prob prob) throws ApiException {
            Engine engine = prob.getEngine();
            File file = new File(engine.getKB().getParams().out_results);
            try {
                return UncUtil.convertToUnc(file.getAbsolutePath());
            }
            catch (Throwable e) {
                String msg = String.format("Could not determine UNC path for \"%s\".", engine.getKB().getParams().out_results);
                throw new ApiException(msg, e);
            }
        }

        @Override
        public Pair<Integer, String> writeResponse(Api api, String uncPath, OutputStream out) throws IOException {
            DataOutputStream strmBin = new DataOutputStream(out);
            byte[] bytes = uncPath.getBytes();
            strmBin.writeInt(bytes.length);
            strmBin.write(bytes);
            strmBin.flush();
            return new Pair<Integer, String>(0, uncPath);
        }
    }

    private static enum AgentProp {
        NAME("-name", "controlled-1"),
        MODELID("-avatar", "Mannequin"),
        RADIUS("-radius", Util.inchesToMeters(9.0)),
        MAXVEL("-maxvel", 3.0),
        LOC("-loc", null),
        DOOR("-door", null);

        public final String argSwitch;
        public final Object defVal;

        private AgentProp(String argSwitch, Object defVal) {
            this.argSwitch = argSwitch;
            this.defVal = defVal;
        }
    }

    private static class AddAgent
    implements IOperation<Integer> {
        private AddAgent() {
        }

        @Override
        public Integer getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer performOp(Api api, IServer server, IPacket recvPacket, List<String> args, Prob prob) throws ApiException {
            int m;
            Map props = Api.getDefaultOccProps();
            try {
                for (m = 0; m < args.size(); ++m) {
                    String arg = args.get(m);
                    if (arg.equalsIgnoreCase(AgentProp.NAME.argSwitch)) {
                        props.put(AgentProp.NAME, args.get(++m));
                        continue;
                    }
                    if (arg.equalsIgnoreCase(AgentProp.MODELID.argSwitch)) {
                        props.put(AgentProp.MODELID, args.get(++m));
                        continue;
                    }
                    if (arg.equalsIgnoreCase(AgentProp.MAXVEL.argSwitch)) {
                        props.put(AgentProp.MAXVEL, Double.parseDouble(args.get(++m)));
                        continue;
                    }
                    if (arg.equalsIgnoreCase(AgentProp.RADIUS.argSwitch)) {
                        props.put(AgentProp.RADIUS, Double.parseDouble(args.get(++m)));
                        continue;
                    }
                    if (arg.equalsIgnoreCase(AgentProp.LOC.argSwitch)) {
                        props.put(AgentProp.LOC, new Point3d(Double.parseDouble(args.get(++m)), Double.parseDouble(args.get(++m)), Double.parseDouble(args.get(++m))));
                        continue;
                    }
                    if (!arg.equalsIgnoreCase(AgentProp.DOOR.argSwitch)) continue;
                    props.put(AgentProp.DOOR, args.get(++m));
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new ApiException(String.format("Missing argument after %s%n", args.get(m - 1)));
            }
            Engine e = prob.getEngine();
            e.pause(true);
            OccAgent agent = null;
            try {
                if (props.containsKey((Object)AgentProp.LOC) && props.containsKey((Object)AgentProp.DOOR)) {
                    throw new ApiException(String.format("Location overspecifid: use LOC or DOOR, not both", new Object[0]));
                }
                if (!props.containsKey((Object)AgentProp.LOC) && !props.containsKey((Object)AgentProp.DOOR)) {
                    throw new ApiException(String.format("Location underspecified: LOC or DOOR required", new Object[0]));
                }
                if (props.containsKey((Object)AgentProp.LOC) && !props.containsKey((Object)AgentProp.DOOR)) {
                    agent = e.getKB().addControlledAgent((String)props.get((Object)AgentProp.NAME), (String)props.get((Object)AgentProp.MODELID), (Point3d)props.get((Object)AgentProp.LOC), (Double)props.get((Object)AgentProp.RADIUS), (Double)props.get((Object)AgentProp.MAXVEL), new Vector3d(0.0, 1.0, 0.0));
                } else if (!props.containsKey((Object)AgentProp.LOC) && props.containsKey((Object)AgentProp.DOOR)) {
                    Tri tfacing;
                    String doorName = (String)props.get((Object)AgentProp.DOOR);
                    Collection doors = Api.getDoorNodeByName(e.getKB(), doorName);
                    if (doors.size() != 1) {
                        throw new ApiException(String.format("Invalid Door Name (name=%s, found=%s)", doorName, doors.size()));
                    }
                    ANode door = (ANode)doors.iterator().next();
                    DoorGeom dg = door.getDoorGeom();
                    if (dg == null) {
                        throw new ApiException(String.format("Door is not connected to any mesh triangles.", new Object[0]));
                    }
                    Pair<Integer, Point3d> doorPt = dg.get(0.5);
                    WingedEdge edge = dg.edges.get((Integer)doorPt.v1);
                    Point3d center = (Point3d)doorPt.v2;
                    Tri tri = tfacing = edge.t1 != null ? edge.t1 : edge.t2;
                    if (tfacing == null) {
                        throw new ApiException(String.format("Door is not connected to any mesh triangles.", new Object[0]));
                    }
                    Vector3d edgeDir = new Vector3d(edge.p1());
                    edgeDir.sub(edge.p2());
                    Vector3d facingApprox = new Vector3d(tfacing.center);
                    facingApprox.sub(center);
                    Vector3d orient = Util3D.cross(GeomConstants.VEC3D_ZPOS, edgeDir);
                    if (Util3D.dot(orient, facingApprox) < 0.0) {
                        orient = Util3D.cross(GeomConstants.VEC3D_ZNEG, edgeDir);
                    }
                    orient.normalize();
                    double radius = (Double)props.get((Object)AgentProp.RADIUS);
                    Vector3d offset = new Vector3d(orient);
                    offset.scale(radius);
                    center.add(offset);
                    agent = e.getKB().addControlledAgent((String)props.get((Object)AgentProp.NAME), (String)props.get((Object)AgentProp.MODELID), center, radius, (Double)props.get((Object)AgentProp.MAXVEL), orient);
                }
            }
            finally {
                e.resume();
            }
            int agentId = -1;
            if (agent != null) {
                agentId = agent.getOcc().id;
                api.d_controlledIdToAgentMap.put(agentId, agent);
            }
            e.scheduleCallbackNotification();
            assert (agentId != -1);
            return agentId;
        }

        @Override
        public Pair<Integer, String> writeResponse(Api api, Integer agentId, OutputStream out) throws IOException {
            DataOutputStream strmBin = new DataOutputStream(out);
            strmBin.writeInt(agentId);
            strmBin.flush();
            return new Pair<Integer, String>(0, "Added agent id=" + agentId);
        }
    }

    private static class RequestAsyncUpdate
    implements IOperation<Integer> {
        private RequestAsyncUpdate() {
        }

        @Override
        public Integer getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return 0;
        }

        @Override
        public Integer performOp(Api api, IServer server, IPacket recvPacket, List<String> args, Prob prob) throws ApiException {
            prob.getEngine().scheduleCallbackNotification();
            return 0;
        }

        @Override
        public Pair<Integer, String> writeResponse(Api api, Integer data, OutputStream out) throws IOException {
            return new Pair<Integer, String>(0, "");
        }
    }

    private static class GetActiveAgents
    implements IOperation<ActiveAgentsInfo> {
        private GetActiveAgents() {
        }

        @Override
        public ActiveAgentsInfo getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return new ActiveAgentsInfo();
        }

        @Override
        public ActiveAgentsInfo performOp(Api api, IServer server, IPacket recvPacket, List<String> args, Prob prob) throws ApiException {
            prob.getEngine().pause(true);
            ActiveAgentsInfo aai = new ActiveAgentsInfo();
            aai.agents = prob.getEngine().getKB().getActiveAgents();
            aai.relations = OccVisWriter.getRelations(aai.agents);
            aai.prob = prob;
            return aai;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pair<Integer, String> writeResponse(Api api, ActiveAgentsInfo data, OutputStream out) throws IOException {
            DataOutputStream os = new DataOutputStream(out);
            try {
                OccVisWriter.writeAgentsAdded(os, data.prob.getOccTracker(), data.agents, false);
                OccVisWriter.writeRelationsAdded(os, data.relations);
                os.flush();
            }
            finally {
                if (data.prob != null) {
                    data.prob.getEngine().resume();
                }
            }
            return new Pair<Integer, String>(0, "");
        }
    }

    private static class ActiveAgentsInfo {
        public Prob prob = null;
        public Collection<OccAgent> agents = Collections.EMPTY_LIST;
        public Collection<OccVisWriter.Relation> relations = Collections.EMPTY_LIST;

        private ActiveAgentsInfo() {
        }
    }

    private static class GetAnimatedNodes
    implements IOperation<AnimatedNodesInfo> {
        private GetAnimatedNodes() {
        }

        @Override
        public AnimatedNodesInfo getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return new AnimatedNodesInfo();
        }

        @Override
        public AnimatedNodesInfo performOp(Api api, IServer server, IPacket recvPacket, List<String> args, Prob prob) throws ApiException {
            prob.getEngine().pause(true);
            AnimatedNodesInfo ani = new AnimatedNodesInfo();
            ani.animatedObjs = GeomVisWriter.getAllObjs(prob.getEngine().getKB());
            ani.prob = prob;
            return ani;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pair<Integer, String> writeResponse(Api api, AnimatedNodesInfo data, OutputStream out) throws IOException {
            DataOutputStream os = new DataOutputStream(out);
            try {
                GeomVisWriter.writeGeomsAdded(os, data.animatedObjs);
                os.flush();
            }
            finally {
                if (data.prob != null) {
                    data.prob.getEngine().resume();
                }
            }
            return new Pair<Integer, String>(0, "");
        }
    }

    private static class AnimatedNodesInfo {
        public Prob prob = null;
        public Collection<? extends IAnimSrc> animatedObjs = Collections.EMPTY_LIST;

        private AnimatedNodesInfo() {
        }
    }

    private static class GetStatus
    implements IOperation<String> {
        private long d_tbegin;

        private GetStatus() {
        }

        @Override
        public String getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return "";
        }

        @Override
        public String performOp(Api api, IServer server, IPacket recvPacket, List<String> rawArgs, Prob prob) throws ApiException {
            this.d_tbegin = System.nanoTime();
            if (rawArgs.isEmpty()) {
                return Status.getNoArg(prob.getEngine());
            }
            Map<Status.StatusArg, Object> args = Status.procArgs(rawArgs);
            String selector = rawArgs.remove(0);
            if (selector.toLowerCase().startsWith("agent")) {
                return Status.getAgents(prob.getEngine(), (String)args.get((Object)Status.StatusArg.NAME), (Integer)args.get((Object)Status.StatusArg.ID), (String)args.get((Object)Status.StatusArg.ROOM), (Status.SphereData)args.get((Object)Status.StatusArg.SPHERE));
            }
            if (selector.toLowerCase().startsWith("door")) {
                return Status.getDoors(prob.getEngine(), (String)args.get((Object)Status.StatusArg.NAME), (Integer)args.get((Object)Status.StatusArg.ID));
            }
            if (selector.toLowerCase().startsWith("stair")) {
                return Status.getStairs(prob.getEngine(), (String)args.get((Object)Status.StatusArg.NAME), (Integer)args.get((Object)Status.StatusArg.ID));
            }
            if (selector.toLowerCase().startsWith("elevator")) {
                return Status.getElevators(prob.getEngine(), (Integer)args.get((Object)Status.StatusArg.ID));
            }
            if (selector.toLowerCase().startsWith("room")) {
                return Status.getRooms(prob.getEngine(), (String)args.get((Object)Status.StatusArg.NAME), (Integer)args.get((Object)Status.StatusArg.ID), (Status.SphereData)args.get((Object)Status.StatusArg.SPHERE));
            }
            if (selector.toLowerCase().startsWith("obscuration")) {
                return Status.getObscuration(prob.getEngine(), (String)args.get((Object)Status.StatusArg.NAME), (Integer)args.get((Object)Status.StatusArg.ID));
            }
            if (selector.toLowerCase().startsWith("blockage")) {
                return Status.getBlockages(prob.getEngine(), (String)args.get((Object)Status.StatusArg.NAME), (Integer)args.get((Object)Status.StatusArg.ID), (Status.SphereData)args.get((Object)Status.StatusArg.SPHERE));
            }
            throw new ApiException(String.format("Unknown selector: %s%n", selector));
        }

        @Override
        public Pair<Integer, String> writeResponse(Api api, String response, OutputStream out) throws IOException {
            DataOutputStream strmBin = new DataOutputStream(out);
            byte[] bytes = response.getBytes();
            strmBin.writeInt(bytes.length);
            strmBin.write(bytes);
            strmBin.flush();
            double ms = (double)(System.nanoTime() - this.d_tbegin) / 1000000.0;
            return new Pair<Integer, String>(0, String.format("status completed in %.3f ms", ms));
        }
    }

    private static class Pause
    implements IOperation<Integer> {
        private Pause() {
        }

        @Override
        public Integer getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return Pause.getWait(args) ? Integer.valueOf(0) : null;
        }

        @Override
        public Integer performOp(Api api, IServer server, IPacket recvPacket, List<String> args, Prob prob) throws ApiException {
            boolean wait = Pause.getWait(args);
            Engine e = prob.getEngine();
            if (e.isFinished()) {
                throw new ApiException("problem already finished");
            }
            e.pause(wait);
            return wait ? Integer.valueOf(1) : null;
        }

        @Override
        public Pair<Integer, String> writeResponse(Api api, Integer result, OutputStream out) throws IOException {
            if (result != null) {
                DataOutputStream ds = new DataOutputStream(out);
                ds.writeInt(1);
                ds.flush();
            }
            return new Pair<Integer, String>(0, "simulation paused");
        }

        private static boolean getWait(List<String> args) {
            if (args.size() > 0) {
                return args.get(0).equalsIgnoreCase("wait");
            }
            return false;
        }
    }

    public static class ModifyCameraOp
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final CameraAgent camera;
        public final CameraAgent.IModifier modifier;

        public ModifyCameraOp(CameraAgent cam, CameraAgent.IModifier modifier) {
            this.camera = cam;
            this.modifier = modifier;
        }

        @Override
        public void run(Engine e) {
            this.camera.setModifier(this.modifier);
        }
    }

    public static class SetObscurationParamsOp
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final int id;
        public final Color color;
        public final double density;

        public SetObscurationParamsOp(int id, Color color) {
            this(id, color, Double.NaN);
        }

        public SetObscurationParamsOp(int id, double density) {
            this(id, null, density);
        }

        public SetObscurationParamsOp(int id, Color color, double density) {
            this.id = id;
            this.color = color;
            this.density = density;
        }

        @Override
        public void run(Engine e) {
            Obscuration obsc = e.getKB().getObscuration(this.id);
            if (obsc != null) {
                if (this.color != null) {
                    obsc.color = this.color;
                }
                if (!Double.isNaN(this.density)) {
                    obsc.density = this.density;
                }
                e.scheduleCallbackNotification();
            }
        }
    }

    public static class ActivateObscurationOp
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final int id;
        public final boolean state;

        public ActivateObscurationOp(int id, boolean state) {
            this.id = id;
            this.state = state;
        }

        @Override
        public void run(Engine e) {
            Obscuration obsc = e.getKB().getObscuration(this.id);
            if (obsc != null) {
                obsc.active = this.state;
                e.scheduleCallbackNotification();
            }
        }
    }

    private static class DeleteObscurationOp
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final int obscId;

        public DeleteObscurationOp(int obscId) {
            this.obscId = obscId;
        }

        @Override
        public void run(Engine e) {
            Obscuration obsc = e.getKB().getObscuration(this.obscId);
            if (obsc == null) {
                System.err.format("Could not find obscuration with id=%d%n", this.obscId);
                return;
            }
            e.getKB().removeObscuration(obsc);
            e.scheduleCallbackNotification();
        }
    }

    private static class CreateObscurationOp
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        private final String d_floorName;
        private final Color d_color;
        private final double d_density;
        private final boolean d_initState;

        public CreateObscurationOp(String floorName, Color color, double density, boolean initState) {
            this.d_floorName = floorName;
            this.d_color = color;
            this.d_density = density;
            this.d_initState = initState;
        }

        @Override
        public void run(Engine e) {
            int nextId = e.getKB().getNextObscurationId();
            Obscuration obsc = new Obscuration(nextId, this.d_floorName, this.d_color, this.d_density);
            obsc.active = this.d_initState;
            e.getKB().addObscuration(obsc);
            e.scheduleCallbackNotification();
        }
    }

    private static class DeleteAppearanceModOp
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        public final int appId;

        public DeleteAppearanceModOp(int appId) {
            this.appId = appId;
        }

        @Override
        public void run(Engine e) {
            AppearanceMod appMod = null;
            for (AppearanceMod mod : e.getKB().getAppearanceMods()) {
                if (mod.id != this.appId) continue;
                appMod = mod;
                break;
            }
            if (appMod == null) {
                System.err.format("Could not find appearance modification with id=%d%n", this.appId);
                return;
            }
            e.getKB().removeAppearanceMod(appMod);
            e.scheduleCallbackNotification();
        }
    }

    private static class CreateAppearanceModOp
    implements EngineOp {
        private static final long serialVersionUID = 1L;
        private final AppearanceMod.Type d_type;
        private final List<Sphere> d_regions;

        public CreateAppearanceModOp(AppearanceMod.Type type, List<Sphere> regions) {
            this.d_type = type;
            this.d_regions = regions;
        }

        @Override
        public void run(Engine e) {
            for (Sphere region : this.d_regions) {
                int nextId = e.getKB().getNextAppearanceModId();
                AppearanceMod appMod = new AppearanceMod(nextId, this.d_type, region);
                e.getKB().addAppearanceMod(appMod);
            }
            e.scheduleCallbackNotification();
        }
    }

    private static class GetBlockage
    implements IOperation<BlockageInfo> {
        private GetBlockage() {
        }

        @Override
        public BlockageInfo getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return new BlockageInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BlockageInfo performOp(Api api, IServer server, IPacket recvPacket, List<String> args, Prob prob) throws ApiException {
            if (args.isEmpty()) {
                throw new ApiException("No arguments - Api.get_blockage().");
            }
            prob.getEngine().pause();
            try {
                String numstr = args.get(0);
                int num = Integer.parseInt(numstr);
                Set<String> nameSet = prob.getEngine().getKB().getBlockageNames();
                if (num >= nameSet.size()) {
                    throw new ApiException("Request too large - Api.get_blockage().");
                }
                Iterator<String> itr = nameSet.iterator();
                for (int count = 0; count < num; ++count) {
                    itr.next();
                }
                String name = itr.next();
                List<Blockage> blockages = prob.getEngine().getKB().getBlockages(name);
                assert (!blockages.isEmpty());
                Blockage blockage = blockages.get(0);
                BlockageInfo bi = new BlockageInfo();
                bi.id = num;
                bi.name = name;
                bi.active = blockage.isActive() ? 1 : 0;
                bi.velFactor = blockage.getVelFactor();
                BlockageInfo blockageInfo = bi;
                return blockageInfo;
            }
            finally {
                prob.getEngine().resume();
            }
        }

        @Override
        public Pair<Integer, String> writeResponse(Api api, BlockageInfo bi, OutputStream out) throws IOException {
            DataOutputStream strmBin = new DataOutputStream(out);
            byte[] bytes = bi.name.getBytes();
            strmBin.writeInt(bytes.length);
            strmBin.write(bytes);
            strmBin.writeInt(bi.active);
            strmBin.writeDouble(bi.velFactor);
            strmBin.flush();
            return new Pair<Integer, String>(1, "Returned blockage " + bi.id);
        }
    }

    private static class BlockageInfo {
        public int id = -1;
        public String name = "";
        public int active = 0;
        public double velFactor = 1.0;

        private BlockageInfo() {
        }
    }

    private static class GetAgentPosition
    implements IOperation<Integer> {
        private final Point3d d_agentPosition;

        public GetAgentPosition(Point3d agentPosition) {
            this.d_agentPosition = agentPosition;
        }

        @Override
        public Integer getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return 0;
        }

        @Override
        public Integer performOp(Api api, IServer server, IPacket recvPacket, List<String> args, Prob prob) throws ApiException {
            return 0;
        }

        @Override
        public Pair<Integer, String> writeResponse(Api api, Integer count, OutputStream out) throws IOException {
            int valid = this.d_agentPosition != null ? 1 : 0;
            double x = this.d_agentPosition != null ? this.d_agentPosition.x : -1.0;
            double y = this.d_agentPosition != null ? this.d_agentPosition.y : -1.0;
            double z = this.d_agentPosition != null ? this.d_agentPosition.z : -1.0;
            DataOutputStream strmBin = new DataOutputStream(out);
            strmBin.writeInt(valid);
            strmBin.writeDouble(x);
            strmBin.writeDouble(y);
            strmBin.writeDouble(z);
            strmBin.flush();
            return new Pair<Integer, String>(count, "Returned num blockages.");
        }
    }

    private static class GetNumBlockages
    implements IOperation<Integer> {
        private GetNumBlockages() {
        }

        @Override
        public Integer getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer performOp(Api api, IServer server, IPacket recvPacket, List<String> args, Prob prob) throws ApiException {
            prob.getEngine().pause();
            try {
                Set<String> blockageNames = prob.getEngine().getKB().getBlockageNames();
                Integer n = blockageNames.size();
                return n;
            }
            finally {
                prob.getEngine().resume();
            }
        }

        @Override
        public Pair<Integer, String> writeResponse(Api api, Integer count, OutputStream out) throws IOException {
            DataOutputStream strmBin = new DataOutputStream(out);
            strmBin.writeInt(count);
            strmBin.flush();
            return new Pair<Integer, String>(count, "Returned num blockages.");
        }
    }

    private static class GetBlockagesCSV
    implements IOperation<Collection<String>> {
        private GetBlockagesCSV() {
        }

        @Override
        public Collection<String> getErrorResponse(IServer server, IPacket recvPacket, List<String> args) {
            return Collections.EMPTY_LIST;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<String> performOp(Api api, IServer server, IPacket recvPacket, List<String> args, Prob prob) throws ApiException {
            prob.getEngine().pause(true);
            try {
                ArrayList<String> arrayList = new ArrayList<String>(prob.getEngine().getKB().getBlockageNames());
                return arrayList;
            }
            finally {
                prob.getEngine().resume();
            }
        }

        @Override
        public Pair<Integer, String> writeResponse(Api api, Collection<String> nameSet, OutputStream out) throws IOException {
            Iterator<String> itr = nameSet.iterator();
            StringBuilder names = new StringBuilder();
            while (itr.hasNext()) {
                String name = itr.next();
                names.append(name);
                if (!itr.hasNext()) continue;
                names.append(",");
            }
            String namesStr = names.toString();
            DataOutputStream strmBin = new DataOutputStream(out);
            byte[] bytes = namesStr.getBytes();
            strmBin.writeInt(bytes.length);
            strmBin.write(bytes);
            strmBin.flush();
            return new Pair<Integer, String>(nameSet.size(), "Returned blockages.");
        }
    }
}

