/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.mv;

import java.awt.Dimension;
import java.util.List;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import results.nativebuffered.gui.MovieDlg;
import results.nativebuffered.gui.ScreenshotDlg;
import results.nativebuffered.mv.VideoCompressorPrefs;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.video.IVideoCompressor;

public class MVPrefs {
    private static final Unit FPS_UNIT = Unit.ONE.divide(SI.SECOND);
    public static final VideoCompressorPrefs LIVEVIDEO_COMPRESSOR = new VideoCompressorPrefs("RTVideo");
    public static final VideoCompressorPrefs MOVIE_COMPRESSOR = new VideoCompressorPrefs("VideoCreate");
    public static final TypedProp<Integer> MOVIE_WIDTH = new TypedProp<Integer>((Object)"VideoCreate.width", 1920);
    public static final TypedProp<Integer> MOVIE_HEIGHT = new TypedProp<Integer>((Object)"VideoCreate.height", 1080);
    public static final TypedProp<Double> MOVIE_FRAMERATE = new TypedProp<Double>((Object)"VideoCreate.framerate", 30.0);
    public static final TypedProp<Boolean> MOVIE_LOD = new TypedProp<Boolean>((Object)"VideoCreate.enableLOD", false);
    public static final TypedProp<Boolean> MOVIE_WATCH_WHEN_FINISHED = new TypedProp<Boolean>((Object)"VideoCreate.watchWhenFinished", true);
    public static final TypedProp<Integer> SCREENSHOT_WIDTH = new TypedProp<Integer>((Object)"SSCreate.width", 1920);
    public static final TypedProp<Integer> SCREENSHOT_HEIGHT = new TypedProp<Integer>((Object)"SSCreate.height", 1080);
    public static final TypedProp<Boolean> SCREENSHOT_LOD = new TypedProp<Boolean>((Object)"SSCreate.enableLOD", false);
    public static final TypedProp<Boolean> SCREENSHOT_VIEW_WHEN_FINISHED = new TypedProp<Boolean>((Object)"SSCreate.viewWhenFinished", true);

    public static IPropertySet loadMoviePrefs(TeciProps prefs, List<IVideoCompressor> compressors) {
        PropertySet props = new PropertySet();
        props.setIfNotDefault(MovieDlg.MoviePnl.COMPRESSOR, MOVIE_COMPRESSOR.load(prefs, compressors));
        props.setIfNotDefault(MovieDlg.MoviePnl.FRAMERATE, new UnitDouble(prefs.get(MOVIE_FRAMERATE), FPS_UNIT));
        props.setIfNotDefault(MovieDlg.MoviePnl.SIZE, new Dimension(prefs.get(MOVIE_WIDTH), prefs.get(MOVIE_HEIGHT)));
        props.setIfNotDefault(MovieDlg.MoviePnl.LOD, prefs.get(MOVIE_LOD));
        props.setIfNotDefault(MovieDlg.MoviePnl.WATCH_WHEN_FINISHED, prefs.get(MOVIE_WATCH_WHEN_FINISHED));
        return props;
    }

    public static void saveMoviePrefs(TeciProps prefs, IPropertySet props) {
        MOVIE_COMPRESSOR.save(prefs, props.get(MovieDlg.MoviePnl.COMPRESSOR));
        prefs.setIfNotDefault(MOVIE_WIDTH, props.get(MovieDlg.MoviePnl.SIZE).width);
        prefs.setIfNotDefault(MOVIE_HEIGHT, props.get(MovieDlg.MoviePnl.SIZE).height);
        prefs.setIfNotDefault(MOVIE_FRAMERATE, props.get(MovieDlg.MoviePnl.FRAMERATE).get(FPS_UNIT));
        prefs.setIfNotDefault(MOVIE_LOD, props.get(MovieDlg.MoviePnl.LOD));
        prefs.setIfNotDefault(MOVIE_WATCH_WHEN_FINISHED, props.get(MovieDlg.MoviePnl.WATCH_WHEN_FINISHED));
    }

    public static IPropertySet loadScreenshotPrefs(TeciProps prefs) {
        PropertySet props = new PropertySet();
        props.setIfNotDefault(ScreenshotDlg.ScreenshotPnl.SIZE, new Dimension(prefs.get(SCREENSHOT_WIDTH), prefs.get(SCREENSHOT_HEIGHT)));
        props.setIfNotDefault(ScreenshotDlg.ScreenshotPnl.LOD, prefs.get(SCREENSHOT_LOD));
        props.setIfNotDefault(ScreenshotDlg.ScreenshotPnl.VIEW_WHEN_FINISHED, prefs.get(SCREENSHOT_VIEW_WHEN_FINISHED));
        return props;
    }

    public static void saveScreenshotPrefs(TeciProps prefs, IPropertySet props) {
        prefs.setIfNotDefault(SCREENSHOT_WIDTH, props.get(ScreenshotDlg.ScreenshotPnl.SIZE).width);
        prefs.setIfNotDefault(SCREENSHOT_HEIGHT, props.get(ScreenshotDlg.ScreenshotPnl.SIZE).height);
        prefs.setIfNotDefault(SCREENSHOT_LOD, props.get(ScreenshotDlg.ScreenshotPnl.LOD));
        prefs.setIfNotDefault(SCREENSHOT_VIEW_WHEN_FINISHED, props.get(ScreenshotDlg.ScreenshotPnl.VIEW_WHEN_FINISHED));
    }
}

