/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import montecarlo.CreateCases;

public class ProcessResults {
    public static void main(String[] args) throws Exception {
        ArrayList<Path> outputFiles = new ArrayList<Path>();
        for (String fn : args) {
            outputFiles.add(Paths.get(fn, new String[0]));
        }
        ProcessResults.processNonItemizedData(outputFiles, Arrays.asList("Completion Times for All Occupants (s)", "Travel Distances for All Occupants (m)"));
        ProcessResults.processItemizedData(outputFiles, Arrays.asList("Completion Times by Behavior (s)", "Completion Times by Profile (s)", "Movement Distance by Behavior (m)", "Movement Distance by Profile (m)"));
    }

    public static void processNonItemizedData(List<Path> outputFiles, List<String> headers) throws Exception {
        File outputFolder = null;
        for (String header : headers) {
            StringBuilder data = new StringBuilder();
            int i = 1;
            for (Path fp : outputFiles) {
                if (outputFolder == null) {
                    outputFolder = fp.getParent().toFile();
                }
                try {
                    NonItemizedResult nir = ProcessResults.parseNonItemizedData(fp, header);
                    String dataRow = String.format("%3s  %.2f  %.2f  %.2f%n", i, nir.min, nir.max, nir.avg);
                    data.append(dataRow);
                    ++i;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            String template = ProcessResults.loadTemplate("non-itemized-result.plt.template");
            template = template.replace("{DATA}", data.toString());
            template = template.replace("{TITLE}", header);
            String fn = new File(outputFolder, header + ".plt").getPath();
            Files.write(Paths.get(fn, new String[0]), template.getBytes(), new OpenOption[0]);
        }
    }

    private static String loadTemplate(String fn) throws Exception {
        StringBuilder data = new StringBuilder();
        InputStream instrm = CreateCases.class.getResourceAsStream(fn);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(instrm));){
            String line = reader.readLine();
            while (line != null) {
                data.append(line).append("\n");
                line = reader.readLine();
            }
        }
        return data.toString();
    }

    private static NonItemizedResult parseNonItemizedData(Path fn, String header) throws Exception {
        String summaryFn = fn.toString().replace(".pth", "_summary.txt");
        try (BufferedReader reader = new BufferedReader(new FileReader(summaryFn));){
            while (!reader.readLine().startsWith(header)) {
            }
            NonItemizedResult nonItemizedResult = new NonItemizedResult(fn.getFileName().toString(), ProcessResults.parseDoubleRobust(reader.readLine().trim().split("[ \t]+")[1]), ProcessResults.parseDoubleRobust(reader.readLine().trim().split("[ \t]+")[1]), ProcessResults.parseDoubleRobust(reader.readLine().trim().split("[ \t]+")[1]));
            return nonItemizedResult;
        }
    }

    public static double parseDoubleRobust(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            NumberFormat localizedFormatter = str.contains(",") ? NumberFormat.getInstance(Locale.GERMANY) : (str.contains(".") ? NumberFormat.getInstance(Locale.ENGLISH) : NumberFormat.getInstance());
            try {
                return localizedFormatter.parse(str).doubleValue();
            }
            catch (ParseException ee) {
                throw new RuntimeException(ee);
            }
        }
    }

    public static void processItemizedData(List<Path> outputFiles, List<String> headers) {
    }

    public static class NonItemizedResult {
        public final double min;
        public final double max;
        public final double avg;
        public final String fn;

        public NonItemizedResult(String fn, double min, double max, double avg) {
            this.fn = fn;
            this.min = min;
            this.max = max;
            this.avg = avg;
        }
    }
}

