/*
 * Decompiled with CFR 0.152.
 */
package merlin.util;

import java.awt.Color;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import javax.vecmath.Point3d;
import merlin.EntryPointFactory;
import merlin.MerlinApp;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.AEgressComp;
import merlin.geom.Geometry;
import merlin.util.AStar;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class MerlinUtil
extends theUtil {
    public static final boolean USE_ASTAR_SEARCH = false;

    public static UnitPoint3D getUPoint3D(Point3d p) {
        Unit curlu = MerlinApp.getApp().getUnitSystem().getLength();
        return UnitPoint3D.convert(p, Geometry.LENGTH_UNIT, curlu);
    }

    public static String format(double v, Unit from, Unit to) {
        return Global.format(UnitDouble.convert(v, from, to), to);
    }

    public static String format(double v, Unit from, IUnitSrc unitType) {
        return MerlinUtil.format(v, from, unitType.getUnit());
    }

    public static String format(double v, Unit from, int unitType) {
        return MerlinUtil.format(v, from, MerlinApp.getApp().getUnitSystem().getUnit(unitType));
    }

    public static String format(UnitDouble v, Unit to) {
        return MerlinUtil.format(v.getValueNoUnit(), v.getUnit(), to);
    }

    public static String format(UnitDouble v, IUnitSrc unitType) {
        return MerlinUtil.format(v.getValueNoUnit(), v.getUnit(), unitType.getUnit());
    }

    public static String format(UnitDouble v, int unitType) {
        return MerlinUtil.format(v.getValueNoUnit(), v.getUnit(), unitType);
    }

    public static String getName(IMerlinObj obj) {
        return EntryPointFactory.get(obj).tvEntryPoint.getName(MerlinApp.getApp().getData(), obj);
    }

    public static <T> Collection<T> flatten(Collection<? extends IMerlinObj> objs, Class<T> type) {
        return new DeepCollection<T>(objs, type, Filters.acceptAll());
    }

    public static <T> Collection<T> flatten(Collection<? extends IMerlinObj> objs, Class<T> type, Predicate<? super T> filter) {
        return new DeepCollection<T>(objs, type, filter);
    }

    public static Collection<ICompElement> flattenComposites(Collection<? extends IMerlinObj> objs) {
        return MerlinUtil.flatten(objs, ICompElement.class, CompositeFilter.INSTANCE);
    }

    public static boolean test(int options, int option) {
        return (options & option) == option;
    }

    public static boolean isConnected(IEgressObj source, IEgressObj ... targets) {
        return MerlinUtil.isConnected(source, Arrays.asList(targets));
    }

    public static boolean isConnected(IEgressObj source, Collection<? extends IEgressObj> targets) {
        return MerlinUtil.isConnectedBruteForce(source, targets);
    }

    private static boolean isConnectedAStar(IEgressObj source, Collection<? extends IEgressObj> targets) {
        for (IEgressObj iEgressObj : targets) {
            if (!MerlinUtil.isConnectedAStarImpl(source, Collections.singleton(iEgressObj))) continue;
            return true;
        }
        return false;
    }

    private static boolean isConnectedAStarImpl(IEgressObj source, Collection<? extends IEgressObj> targets) {
        Set<? extends IEgressObj> targetsSet = MerlinUtil.toSet(targets);
        AStarNode start = new AStarNode(source, source.astarGetTestPoint());
        Function<AStarNode, Collection> getAdjNodes = node -> {
            Collection<? extends IEgressObj> adj = ((IEgressObj)node.v1).getConnections();
            adj = theUtil.filter(adj, (? super T obj) -> !(obj instanceof AEgressComp) || ((AEgressComp)obj).isEnabled());
            return theUtil.map(adj, (InT obj) -> new AStarNode((IEgressObj)obj, obj.astarGetSharedPt((IEgressObj)aStarNode.v1)));
        };
        ToDoubleFunction<AStarNode> heuristic = node -> {
            double minDistSq = Double.POSITIVE_INFINITY;
            for (IEgressObj target : targets) {
                Point3d p = target.astarProject((IEgressObj)node.v1, (Point3d)node.v2);
                double distsq = ((Point3d)node.v2).distanceSquared(p);
                if (!(distsq < minDistSq)) continue;
                minDistSq = distsq;
            }
            return Double.isInfinite(minDistSq) ? minDistSq : Math.sqrt(minDistSq);
        };
        ToDoubleBiFunction<AStarNode, AStarNode> cost = (nsource, ntarget) -> ((Point3d)nsource.v2).distance((Point3d)ntarget.v2);
        Predicate<AStarNode> goalReached = node -> targetsSet.contains(node.v1);
        AStar.IAStarResult result = AStar.getPath(start, getAdjNodes, heuristic, cost, goalReached);
        return result instanceof AStar.AStarSuccess;
    }

    private static Set<? extends IEgressObj> toSet(Collection<? extends IEgressObj> objs) {
        if (objs instanceof Set) {
            return (Set)objs;
        }
        if (objs.isEmpty()) {
            return Collections.emptySet();
        }
        if (objs.size() == 1) {
            return Collections.singleton(objs.iterator().next());
        }
        return new IdentityHashSet<IEgressObj>(objs);
    }

    private static boolean isConnectedBruteForce(IEgressObj obj1, Collection<? extends IEgressObj> targets) {
        for (IEgressObj iEgressObj : targets) {
            if (!MerlinUtil.isConnectedBruteForce(obj1, iEgressObj)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConnectedBruteForce(IEgressObj obj1, IEgressObj obj2) {
        if (obj1 == obj2) {
            return true;
        }
        IdentityHashSet closed = new IdentityHashSet();
        ArrayDeque<IEgressObj> open = new ArrayDeque<IEgressObj>();
        open.push(obj1);
        closed.add(obj1);
        while (!open.isEmpty()) {
            IEgressObj comp = (IEgressObj)open.pop();
            for (IEgressObj iEgressObj : comp.getConnections()) {
                if (iEgressObj instanceof AEgressComp && !((AEgressComp)iEgressObj).isEnabled()) continue;
                if (iEgressObj == obj2) {
                    return true;
                }
                if (!closed.add(iEgressObj)) continue;
                open.push(iEgressObj);
            }
        }
        return false;
    }

    public static Color newRandomOccColor() {
        return MerlinUtil.newRandomOccColor(new Random());
    }

    public static Color newRandomOccColor(Random r) {
        return new Color(r.nextInt(256), r.nextInt(256), r.nextInt(256));
    }

    private static class AStarNode
    extends Pair<IEgressObj, Point3d> {
        public AStarNode(IEgressObj obj, Point3d pt) {
            super(obj, pt);
        }

        @Override
        public int hashCode() {
            return 0x3298FA ^ ((IEgressObj)this.v1).hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof AStarNode && ((IEgressObj)((AStarNode)obj).v1).equals(this.v1);
        }
    }

    public static class CompositeFilter<T>
    implements Predicate<T> {
        public static final CompositeFilter<Object> INSTANCE = new CompositeFilter();

        @Override
        public boolean test(T o) {
            return !(o instanceof Composite);
        }
    }

    private static class DeepIterator<T>
    implements Iterator<T> {
        private final Class<T> d_typeFilter;
        private final Predicate<? super T> d_filter;
        private final Stack<Iterator<? extends IMerlinObj>> d_iteratorStack;
        private T d_nextObj;

        public DeepIterator(Collection<? extends IMerlinObj> objs, Class<T> typeFilter, Predicate<? super T> filter) {
            this.d_typeFilter = typeFilter;
            this.d_filter = filter;
            this.d_iteratorStack = new Stack();
            this.d_iteratorStack.push(objs.iterator());
            this.prefetchNext();
        }

        private void prefetchNext() {
            while (!this.d_iteratorStack.isEmpty()) {
                Iterator<? extends IMerlinObj> curIt = this.d_iteratorStack.peek();
                while (curIt.hasNext()) {
                    Collection<? extends IMerlinObj> children;
                    boolean found = false;
                    IMerlinObj next = curIt.next();
                    if (this.d_typeFilter.isInstance(next) && this.d_filter.test(next)) {
                        this.d_nextObj = next;
                        found = true;
                    }
                    if (!(children = next.getChildren()).isEmpty()) {
                        curIt = children.iterator();
                        this.d_iteratorStack.push(curIt);
                    }
                    if (!found) continue;
                    return;
                }
                this.d_iteratorStack.pop();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.d_iteratorStack.isEmpty();
        }

        @Override
        public T next() {
            T next = this.d_nextObj;
            this.prefetchNext();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class DeepCollection<T>
    extends AbstractCollection<T> {
        private int d_size = -1;
        private final Class<T> d_typeFilter;
        private final Predicate<? super T> d_filter;
        private final Collection<? extends IMerlinObj> d_objs;

        public DeepCollection(IMerlinObj root, Class<T> typeFilter, Predicate<? super T> filter) {
            this(Arrays.asList(root), typeFilter, filter);
        }

        public DeepCollection(Collection<? extends IMerlinObj> objs, Class<T> typeFilter, Predicate<? super T> filter) {
            this.d_typeFilter = typeFilter;
            this.d_filter = filter;
            this.d_objs = objs;
        }

        @Override
        public Iterator<T> iterator() {
            return new DeepIterator<T>(this.d_objs, this.d_typeFilter, this.d_filter);
        }

        @Override
        public int size() {
            if (this.d_size == -1) {
                this.d_size = 0;
                Iterator<T> it = this.iterator();
                while (it.hasNext()) {
                    ++this.d_size;
                    it.next();
                }
            }
            return this.d_size;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }
    }
}

