/*
 * Decompiled with CFR 0.152.
 */
package merlin.util;

import java.awt.Component;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import merlin.MerlinApp;
import merlin.data.MerlinData;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;

public class MerlinSelectionLogic {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSelectionSingle(MerlinApp app, MerlinData data, Component owner, Point ptScreen, boolean addToSel, boolean selectParent, boolean editObjs, boolean showMeta, Collection<? extends Object> hitObjs) {
        data.beginWrite();
        try {
            Object selObj = null;
            if (!hitObjs.isEmpty()) {
                selObj = hitObjs.iterator().next();
            }
            if (!showMeta || showMeta && (selObj == null || !data.selection.isSelected(selObj))) {
                this.handleSelection(addToSel, selectParent, Arrays.asList(selObj));
            }
        }
        finally {
            data.endWrite();
        }
        if (showMeta) {
            data.beginRead();
            try {
                this.showContextMenu(app, data, owner, ptScreen);
            }
            finally {
                data.endRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSelectionMultiple(MerlinApp app, MerlinData data, Component owner, Point ptScreen, boolean addToSel, boolean selectParent, boolean editObjs, boolean showMeta, Collection<?> hitObjs) {
        data.beginWrite();
        try {
            this.handleSelection(addToSel, selectParent, hitObjs);
        }
        finally {
            data.endWrite();
        }
        if (showMeta) {
            data.beginRead();
            try {
                this.showContextMenu(app, data, owner, ptScreen);
            }
            finally {
                data.endRead();
            }
        }
    }

    private void showContextMenu(MerlinApp app, MerlinData md, Component owner, Point ptScreen) {
        JPopupMenu menu = MerlinApp.getContextMenu();
        if (menu != null) {
            md.ui(() -> {
                Point pt = new Point(point.x, point.y);
                SwingUtilities.convertPointFromScreen(pt, owner);
                menu.show(owner, pt.x, pt.y);
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleSelection(boolean addToSel, boolean selectParent, Collection<? extends Object> objs) {
        MerlinData data = MerlinApp.getApp().getData();
        if (!addToSel) {
            data.selection.clear();
        }
        if (objs != null) {
            IdentityHashSet<? extends Object> hitObjs = new IdentityHashSet<Object>(objs);
            LinkedIdentityHashSet objsToSelect = new LinkedIdentityHashSet();
            LinkedIdentityHashSet objsToDeselect = new LinkedIdentityHashSet();
            for (Object object : objs) {
                void var9_9;
                Object parent;
                if (object == null) continue;
                boolean select = true;
                if (selectParent && (parent = data.hierarchy.getParent(object)) != null) {
                    Object object2 = parent;
                }
                if (addToSel) {
                    Object[] pathFromRoot = data.hierarchy.getPath(var9_9);
                    pathFromRoot = Arrays.copyOf(pathFromRoot, pathFromRoot.length - 1);
                    boolean foundSelectedParent = false;
                    if (pathFromRoot != null && !selectParent) {
                        for (int j = 0; j < pathFromRoot.length; ++j) {
                            if (!foundSelectedParent && !data.selection.isSelected(pathFromRoot[j])) continue;
                            foundSelectedParent = true;
                            objsToSelect.remove(pathFromRoot[j]);
                            objsToDeselect.add(pathFromRoot[j]);
                            for (Object member : data.hierarchy.getChildren(pathFromRoot[j])) {
                                if ((j >= pathFromRoot.length - 1 || member == pathFromRoot[j + 1]) && (j != pathFromRoot.length - 1 || hitObjs.contains(member))) continue;
                                objsToDeselect.remove(member);
                                objsToSelect.add(member);
                            }
                        }
                        select = false;
                    }
                    if (!foundSelectedParent) {
                        boolean bl = select = !data.selection.isSelected(var9_9);
                    }
                }
                if (select) {
                    objsToDeselect.remove(var9_9);
                    objsToSelect.add(var9_9);
                    continue;
                }
                objsToSelect.remove(var9_9);
                objsToDeselect.add(var9_9);
            }
            data.selection.deselectAll(objsToDeselect);
            data.selection.selectAll(objsToSelect);
        }
    }
}

