/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.manip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.vecmath.Matrix4d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public abstract class ATransformMgr {
    private final IDisplayMgr<? super IMutableGeomSrc> d_dispMgr;
    private List<?> d_xformObjs;
    private Matrix4d[] d_xforms;
    private List<IDisplayMgr<? super IMutableGeomSrc>> d_xformDispMgrs;
    private IDOF d_dof;

    public ATransformMgr(IDisplayMgr<? super IMutableGeomSrc> dispMgr) {
        this.d_dispMgr = dispMgr;
        this.d_xformObjs = Collections.EMPTY_LIST;
        this.d_xforms = null;
    }

    public List<?> getXformObjects() {
        return this.d_xformObjs;
    }

    public boolean canTransform() {
        return !this.d_xformObjs.isEmpty();
    }

    public boolean isTransforming() {
        return !this.d_xformObjs.isEmpty();
    }

    public boolean isTransforming(Object o) {
        return this.isTransforming() && this.d_xforms.length == 1 && this.d_xformObjs.contains(o);
    }

    public boolean isTransformValid() {
        if (!this.isTransforming() || this.d_xforms == null) {
            return false;
        }
        for (Matrix4d xform : this.d_xforms) {
            if (xform.equals(GeomConstants.IDENTITY4d)) continue;
            return true;
        }
        return false;
    }

    public void setTransformObjs(Collection<?> objs) {
        this.d_xformObjs = new ArrayList(objs);
    }

    public IDOF getDOF() {
        if (this.d_dof == null) {
            this.d_dof = ATransformMgr.getDOF(theUtil.filter(this.d_xformObjs, IMutableGeomSrc.class));
        }
        return this.d_dof;
    }

    private static IDOF getDOF(Collection<? extends IMutableGeomSrc> geoms) {
        HashSet<IDOF> dofs = new HashSet<IDOF>();
        for (IMutableGeomSrc iMutableGeomSrc : geoms) {
            dofs.add(iMutableGeomSrc.getGeom().getDOF());
        }
        return IDOF.group(dofs);
    }

    public void modify(Matrix4d ... xforms) {
        try {
            for (Matrix4d xform : xforms) {
                Matrix4d temp = new Matrix4d(xform);
                temp.invert();
            }
        }
        catch (Throwable e) {
            System.err.println("Cannot invert matrix.  Skipping transform.");
            return;
        }
        if (this.isTransforming() || !ATransformMgr.areAllIdentity(xforms)) {
            if (this.d_xforms == null || this.d_xforms.length != xforms.length) {
                for (IDisplayMgr<? super IMutableGeomSrc> mgr : this.d_xformDispMgrs) {
                    mgr.removeAll();
                }
                this.d_xformDispMgrs = Collections.EMPTY_LIST;
                int numMgrs = xforms.length > 1 ? xforms.length - 1 : 1;
                this.d_xformDispMgrs = Arrays.asList(this.generateDispMgrs(numMgrs));
                Collection<IMutableGeomSrc> objs = this.filterObjs();
                for (IDisplayMgr<? super IMutableGeomSrc> mgr : this.d_xformDispMgrs) {
                    mgr.addDisplays(objs);
                }
            }
            this.setOriginalsVisible(xforms.length > 1);
            if (xforms.length > 1) {
                for (int m = 1; m < xforms.length; ++m) {
                    this.d_xformDispMgrs.get(m - 1).setTransform(xforms[m]);
                }
            } else if (xforms.length == 1) {
                this.d_xformDispMgrs.get(0).setTransform(xforms[0]);
            }
            this.d_xforms = xforms;
        }
    }

    protected Collection<IMutableGeomSrc> filterObjs() {
        return theUtil.filter(this.d_xformObjs, IMutableGeomSrc.class);
    }

    protected static boolean areAllIdentity(Matrix4d[] xforms) {
        for (Matrix4d xform : xforms) {
            if (xform.equals(GeomConstants.IDENTITY4d)) continue;
            return false;
        }
        return true;
    }

    public void end(boolean commit) {
        List<?> xformObjs = this.d_xformObjs;
        Matrix4d[] xforms = this.d_xforms;
        if (commit && xforms != null && ATransformMgr.areAllIdentity(xforms)) {
            xforms = null;
            commit = false;
        }
        for (IDisplayMgr<? super IMutableGeomSrc> dm : this.d_xformDispMgrs) {
            dm.removeAll();
            dm.setTransform(null);
        }
        this.setOriginalsVisible(true);
        this.d_xforms = null;
        this.d_xformObjs = Collections.EMPTY_LIST;
        this.d_dof = null;
        if (commit && xforms != null && !xformObjs.isEmpty()) {
            this.commit(xformObjs, xforms);
        }
    }

    private void setOriginalsVisible(boolean visible) {
        IFilteredCollection<IMutableGeomSrc> objs = theUtil.filter(this.d_xformObjs, IMutableGeomSrc.class);
        if (!visible) {
            this.d_dispMgr.removeFromScene(objs);
        } else {
            this.d_dispMgr.addToScene(objs);
        }
    }

    protected abstract IDisplayMgr<? super IMutableGeomSrc>[] generateDispMgrs(int var1);

    protected abstract void commit(List<?> var1, Matrix4d[] var2);
}

