/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import merlin.Intl;
import merlin.data.egress.scripting.IWaitUntilSrc;
import merlin.gui.stat.guiCurveUtil;

public class guiWaitSrcUtil {
    public static String format(IWaitUntilSrc src, boolean verbose) {
        if (src instanceof IWaitUntilSrc.SimpleWaitUntilSrc) {
            IWaitUntilSrc.SimpleWaitUntilSrc sSrc = (IWaitUntilSrc.SimpleWaitUntilSrc)src;
            String curveStr = guiCurveUtil.format(sSrc.d_waitTime, 1);
            return String.format(Intl.intl("%s"), curveStr);
        }
        if (src instanceof IWaitUntilSrc.CycledWaitUntilSrc) {
            IWaitUntilSrc.CycledWaitUntilSrc cSrc = (IWaitUntilSrc.CycledWaitUntilSrc)src;
            String curveStr = String.format("[%s, %s]", guiCurveUtil.format(cSrc.d_initialTime, 1), guiCurveUtil.format(cSrc.d_intervalTime, 1));
            return String.format(Intl.intl("Periodic: %s"), curveStr);
        }
        if (src instanceof IWaitUntilSrc.ListedWaitUntilSrc) {
            IWaitUntilSrc.ListedWaitUntilSrc lSrc = (IWaitUntilSrc.ListedWaitUntilSrc)src;
            StringBuilder str = new StringBuilder();
            str.append('[');
            int count = lSrc.d_goTimes.size();
            if (!verbose && count > 1) {
                count = 1;
            }
            for (int m = 0; m < count; ++m) {
                if (m != 0) {
                    str.append(',');
                }
                str.append(guiCurveUtil.format(lSrc.d_goTimes.get(m), 1));
            }
            if (lSrc.d_goTimes.size() > count) {
                str.append(",...");
            }
            str.append(']');
            String curveStr = str.toString();
            return String.format(Intl.intl("Scheduled: %s"), curveStr);
        }
        return "";
    }
}

