/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import java.awt.Dimension;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.builders.OccGroupBuilder;
import merlin.data.MerlinData;
import merlin.data.OccGroupObj;
import merlin.gui.APropEditPanel;
import merlin.gui.MerlinComboBox;
import merlin.mv.gui.behaviors.ActionCreatePnl;
import merlin.mv.gui.behaviors.BehaviorPnl;
import merlin.util.Property;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiLabel;

public class NewJoinGroupPnl
extends APropEditPanel<OccGroupBuilder> {
    public NewJoinGroupPnl(Type type) {
        super(new Object[0]);
        MerlinData md = MerlinApp.getApp().getData();
        this.addSection(new BehaviorPnl());
        this.addSeparator();
        this.addSection(new OccGroupsPanel(md, type));
        this.addSeparator();
        this.addSection(new ActionCreatePnl());
    }

    public static enum Type {
        JOIN_OCC_GROUP,
        OCC_GROUP_LEADER;

    }

    private static class OccGroupsPanel
    extends APropEditPanel<OccGroupBuilder> {
        private final MerlinComboBox<OccGroupObj> d_chooser;

        public OccGroupsPanel(MerlinData md, Type type) {
            super(OccGroupBuilder.GROUP_CHANGED);
            this.d_chooser = new MerlinComboBox<OccGroupObj>(md, OccGroupObj.class);
            this.d_chooser.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.getUpdateToCommand().updateProp(this.d_chooser, true);
                }
            });
            this.d_chooser.setPreferredSize(new Dimension(120, (int)this.d_chooser.getPreferredSize().getHeight()));
            GridBagHelper gb = new GridBagHelper(this);
            guiLabel lbl = new guiLabel(Intl.intl("Group:"));
            switch (type) {
                case JOIN_OCC_GROUP: {
                    lbl.setToolTipText(Intl.intl("The group that the occupants will join."));
                    break;
                }
                case OCC_GROUP_LEADER: {
                    lbl.setToolTipText(Intl.intl("The group that the occupant will lead."));
                }
            }
            gb.addRow(lbl, this.d_chooser);
        }

        @Override
        protected void updateFromProps(OccGroupBuilder builder) {
            this.d_chooser.setSelectedItem(Property.of(builder.getGroup()));
        }

        @Override
        protected void updateToProps(OccGroupBuilder props) {
            props.setGroup((OccGroupObj)this.d_chooser.getSelectedItem());
        }
    }
}

