/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import java.util.Observable;
import java.util.Observer;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.builders.GotoActionBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.GotoRooms;
import merlin.gui.APropEditPanel;
import merlin.gui.RoomChooser;
import merlin.mv.gui.behaviors.ActionCreatePnl;
import merlin.mv.gui.behaviors.BehaviorPnl;
import thunderheadeng.gui.GridBagHelper;

public class NewGotoRoomsPnl
extends APropEditPanel<GotoActionBuilder> {
    public NewGotoRoomsPnl() {
        super(new Object[0]);
        MerlinData md = MerlinApp.getApp().getData();
        this.addSection(new BehaviorPnl());
        this.addSeparator();
        this.addSection(new RoomsPanel(md));
        this.addSeparator();
        this.addSection(new ActionCreatePnl());
    }

    private static class RoomsPanel
    extends APropEditPanel<GotoActionBuilder> {
        private final RoomChooser d_chooser;

        public RoomsPanel(MerlinData md) {
            super(GotoActionBuilder.DEST_CHANGED);
            this.d_chooser = new RoomChooser(md);
            this.d_chooser.addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    this.getUpdateToCommand().updateProp(d_chooser, true);
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Rooms:"), this.d_chooser);
        }

        @Override
        protected void updateFromProps(GotoActionBuilder props) {
            this.d_chooser.setObjs(props.getRooms());
            this.d_chooser.setFilter(props.getRoomsFilter());
            this.d_chooser.setAnyAllowed(GotoRooms.getAnyAllowed(props.getRoomsFilter()));
        }

        @Override
        protected void updateToProps(GotoActionBuilder props) {
            props.setRoomsDest(this.d_chooser.getRooms());
        }
    }
}

