/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import merlin.Intl;
import merlin.builders.WallSubBuilder;
import merlin.data.MerlinData;
import merlin.geom.Geometry;
import merlin.gui.APropEditPanel;
import merlin.gui.IPropEditCommand;
import merlin.gui.MerlinUDF;
import merlin.mv.gui.NewPlanarGeomPanel;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;

public class NewWallPanel
extends NewPlanarGeomPanel<WallSubBuilder> {
    private ThicknessPanel d_tPan;

    public NewWallPanel(MerlinData data) {
        super(data, 1);
        this.addSeparator();
        this.d_tPan = new ThicknessPanel();
        this.add(this.d_tPan);
    }

    @Override
    public void setProps(WallSubBuilder props) {
        super.setProps(props);
        this.d_tPan.setProps(props);
    }

    private class ThicknessPanel
    extends APropEditPanel<WallSubBuilder> {
        public guiUnitDoubleField d_thicknessFld;

        public ThicknessPanel() {
            super(WallSubBuilder.WIDTH);
            guiLabel thicknessLbl = new guiLabel(Intl.intl("Thickness:"));
            this.d_thicknessFld = this.initValueField(new MerlinUDF(0.0, SI.METER), new IPropEditCommand[0]);
            GridBagUtil.add(this, thicknessLbl, 0, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_thicknessFld, 1, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
        }

        @Override
        protected void updateFromProps(WallSubBuilder props) {
            double width = props.getWidth();
            UnitDouble value = new UnitDouble(width, SI.METER).convert(Geometry.LENGTH_UNIT);
            this.d_thicknessFld.setValue(value);
        }

        @Override
        protected void updateToProps(WallSubBuilder props) {
            double width = ((UnitDouble)this.d_thicknessFld.getValue()).convert(SI.METER).getValueNoUnit();
            ((WallSubBuilder)this.props()).setWidth(width);
        }
    }
}

