/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.gui.APropEditPanel;
import merlin.gui.IPropEditCommand;
import merlin.manip.ATransformManip;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.util.IntVR;

public abstract class ATransformPanel<T extends ATransformManip>
extends APropEditPanel<T> {
    private final MerlinData d_data;
    private final ModePanel d_modePnl;
    private final CompletionPanel d_completionPanel;

    protected abstract String getXformName();

    public ATransformPanel(MerlinData data, int maxAllowableCopies) {
        super(new Object[0]);
        this.d_data = data;
        this.d_completionPanel = new CompletionPanel(this.getXformName());
        if (maxAllowableCopies > 0) {
            this.d_modePnl = new ModePanel(maxAllowableCopies);
            this.addSection(this.d_modePnl);
        } else {
            this.d_modePnl = null;
        }
    }

    protected void addCompletionPanel() {
        this.addSeparator();
        this.addSection(this.d_completionPanel);
    }

    private static class CompletionPanel
    extends APropEditPanel<ATransformManip> {
        private final JButton d_xformBtn;
        private final JButton d_cancelBtn;
        private final String d_baseXformName;

        public CompletionPanel(String xformName) {
            super(ATransformManip.CANCELLED, ATransformManip.OBJS_TRANSFORMED, ATransformManip.TRANSFORM_CHANGED, ATransformManip.COPY_MODE_CHANGED);
            this.d_baseXformName = xformName;
            this.d_xformBtn = this.initButton(new JButton(this.getCopyModeName()), new IPropEditCommand(){

                @Override
                public void updateProp(Component c, boolean hardValidate) {
                    ((ATransformManip)this.props()).transform(c);
                }
            });
            this.d_cancelBtn = this.initButton(new JButton(Intl.intl("Cancel")), new IPropEditCommand(){

                @Override
                public void updateProp(Component c, boolean hardValidate) {
                    ((ATransformManip)this.props()).cancel();
                }
            });
            GridBagUtil.add(this, this.d_xformBtn, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_cancelBtn, 0, 1, 1, 1, 6, 0, 0, 0, 0, 0.0, 0.0, 17);
            int btnHt = this.d_xformBtn.getPreferredSize().height;
            int maxWidth = Math.max(this.d_xformBtn.getPreferredSize().width, this.d_cancelBtn.getPreferredSize().width);
            Dimension size = new Dimension(maxWidth, btnHt);
            this.d_xformBtn.setPreferredSize(size);
            this.d_cancelBtn.setPreferredSize(size);
        }

        private String getCopyModeName() {
            return Intl.intl("Copy") + "/" + this.d_baseXformName;
        }

        @Override
        protected void updateFromProps(ATransformManip props) {
            this.d_xformBtn.setEnabled(props.canTransform());
            this.d_cancelBtn.setEnabled(props.canTransform());
            String xformName = props.getNumCopies() == 0 ? this.d_baseXformName : this.getCopyModeName();
            this.d_xformBtn.setText(xformName);
        }
    }

    private static class ModePanel
    extends APropEditPanel<ATransformManip> {
        private final guiRadioButton d_normalBtn = this.initButton(new guiRadioButton(Intl.intl("Normal Mode")), new IPropEditCommand[0]);
        private final guiRadioButton d_copyBtn = this.initButton(new guiRadioButton(Intl.intl("Copy Mode")), new IPropEditCommand[0]);
        private final guiIntField d_copiesFld;
        private final guiCheckBox d_randomizeAgentCopiesCB;

        public ModePanel(int maxCopies) {
            super(ATransformManip.COPY_MODE_CHANGED);
            this.d_copiesFld = this.initValueField(new guiIntField(IntVR.between(1, maxCopies, true, true)), new IPropEditCommand[0]);
            this.d_randomizeAgentCopiesCB = this.initButton(new guiCheckBox(Intl.intl("Randomize Occupant Profile Parameters")), new IPropEditCommand[0]);
            guiLabel copiesLbl = new guiLabel(Intl.intl("Copies") + ":");
            LinkStatus.link((AbstractButton)this.d_copyBtn, this.d_copiesFld, copiesLbl, this.d_randomizeAgentCopiesCB);
            new guiButtonGroup(this.d_normalBtn, this.d_copyBtn);
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            gb.addRow(this.d_normalBtn, 0);
            if (maxCopies > 1) {
                gb.addRow(this.d_copyBtn, copiesLbl, this.d_copiesFld);
            } else {
                gb.addRow(this.d_copyBtn, 0);
            }
            gb.addIdentRow(this.d_randomizeAgentCopiesCB, 0);
        }

        @Override
        protected void updateToProps(ATransformManip props) {
            props.pause();
            int numCopies = this.d_copyBtn.isSelected() ? (Integer)this.d_copiesFld.getValue() : 0;
            props.setNumCopies(numCopies);
            props.setRandomizeAgentCopies(this.d_randomizeAgentCopiesCB.isSelected());
            props.resume();
        }

        @Override
        protected void updateFromProps(ATransformManip props) {
            int numCopies = props.getNumCopies();
            if (numCopies > 0) {
                this.d_copyBtn.setSelected(true);
                this.d_copiesFld.setValue(numCopies);
            } else {
                this.d_normalBtn.setSelected(true);
            }
            this.d_randomizeAgentCopiesCB.setSelected(props.getRandomizeAgentCopies());
        }
    }
}

