/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.awt.Color;
import merlin.MerlinApp;
import merlin.data.MerlinData;
import merlin.mv.displays.AMerlinDispMgr;
import merlin.mv.displays.GeomDispMgr;
import merlin.mv.displays.MerlinDispProps;
import merlin.mv.displays.scenefinders.DefSceneFinder;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.ModelScene;

public class HandleDispMgr
extends AMerlinDispMgr<IHandle, GeomDispMgr.Display> {
    public HandleDispMgr(MerlinData md, ModelScene handleScene) {
        super(md, IHandle.class, new DefSceneFinder(handleScene));
    }

    @Override
    protected GeomDispMgr.Display createDisplay(IHandle obj, boolean visible, boolean selected) {
        MerlinDispProps dispProps = MerlinApp.getApp().getModelView().getDisplayProps();
        DisplayableHandle dh = new DisplayableHandle(obj);
        GeomDispMgr.Display disp = new GeomDispMgr.Display(dispProps, dh);
        disp.setVisible(visible);
        disp.setSelected(selected);
        return disp;
    }

    public void updateSelected(IHandle obj, boolean selected) {
        GeomDispMgr.Display disp = (GeomDispMgr.Display)this.getDisplay(obj);
        if (disp != null) {
            disp.setSelected(selected);
        }
    }

    public static class DisplayableHandle
    implements IDisplayableGeomSrc {
        private final IHandle d_handle;
        private boolean d_visible;

        public DisplayableHandle(IHandle handle) {
            this.d_handle = handle;
            this.d_visible = true;
        }

        public IHandle getHandle() {
            return this.d_handle;
        }

        @Override
        public AABox getBounds() {
            return this.d_handle.getGeom().getBoundingBox(new AABox());
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps props) {
            IGeomNode geom = this.d_handle.getGeom();
            int alpha = 255;
            if (geom.getNumPrims(1) > 0) {
                alpha = 50;
            }
            IPrimProps.GenericProps dprops = new IPrimProps.GenericProps(new Color(0, 0, 255, alpha), null, 3.0, IPrimProps.DEF_STIPPLE, 7.0, 0);
            return new DisplayGeom(geom, (IPrimProps)dprops);
        }

        @Override
        public boolean isVisible() {
            return this.d_visible;
        }

        @Override
        public void setVisible(boolean visible) {
            this.d_visible = visible;
        }
    }
}

