/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import merlin.data.ImportedGeom;
import merlin.data.MeasurementRegionObj;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.camera.ICameraObj;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.IElevatorComp;
import merlin.data.egress.geom.EgressBlockage;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.mv.ModelView;
import merlin.mv.displays.AgentDispMgr;
import merlin.mv.displays.AgentDisplayType;
import merlin.mv.displays.AgentRenderer;
import merlin.mv.displays.BehaviorActionDispMgr;
import merlin.mv.displays.FloorDispMgr;
import merlin.mv.displays.GeomDispMgr;
import merlin.mv.displays.IMerlinDispMgr;
import merlin.mv.displays.ImageDispMgr;
import merlin.mv.displays.scenefinders.DefSceneFinder;
import merlin.mv.displays.scenefinders.ISceneFinder;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class GlobalDisplayMgr
implements IMerlinDispMgr<Object> {
    private final List<Pair<IMerlinDispMgr<?>, Predicate<?>>> d_managers = new ArrayList();

    public GlobalDisplayMgr(MerlinData md, ModelView mv, AgentRenderer agentRenderer, ModelScene importedGeomScene, ModelScene bgImageScene, ModelScene behaviorScene, ModelScene elevatorScene, ModelScene egressScene, ModelScene cameraScene) {
        GlobalDisplayMgr.add(this.d_managers, new GeomDispMgr<ImportedGeom>(md, mv, ImportedGeom.class, new DefSceneFinder(importedGeomScene)));
        GlobalDisplayMgr.add(this.d_managers, new ImageDispMgr(md, mv, bgImageScene));
        GlobalDisplayMgr.add(this.d_managers, new AgentDispMgr(md, egressScene, agentRenderer, AgentDisplayType.HUMAN));
        GlobalDisplayMgr.add(this.d_managers, new AgentDispMgr(md, egressScene, agentRenderer, AgentDisplayType.VEHICLE));
        GlobalDisplayMgr.add(this.d_managers, new BehaviorActionDispMgr(md, mv, new DefSceneFinder<GotoWaypoint>(behaviorScene)));
        GlobalDisplayMgr.add(this.d_managers, new FloorDispMgr(md, importedGeomScene, bgImageScene, elevatorScene));
        GlobalDisplayMgr.add(this.d_managers, new GeomDispMgr<EgressBlockage>(md, mv, EgressBlockage.class, new DefSceneFinder(egressScene)));
        GlobalDisplayMgr.add(this.d_managers, new GeomDispMgr<IEgressComp>(md, mv, IEgressComp.class, GlobalDisplayMgr.getEgressSceneFinder(egressScene, elevatorScene)));
        GlobalDisplayMgr.add(this.d_managers, new GeomDispMgr<Elevator>(md, mv, Elevator.class, new DefSceneFinder(elevatorScene)));
        GlobalDisplayMgr.add(this.d_managers, new GeomDispMgr<MeasurementRegionObj>(md, mv, MeasurementRegionObj.class, new DefSceneFinder(importedGeomScene)));
        GlobalDisplayMgr.add(this.d_managers, new GeomDispMgr<OccSourceObj>(md, mv, OccSourceObj.class, new DefSceneFinder(importedGeomScene)));
        GlobalDisplayMgr.add(this.d_managers, new GeomDispMgr<ICameraObj>(md, mv, ICameraObj.class, new DefSceneFinder(cameraScene)));
    }

    private static void add(List<Pair<IMerlinDispMgr<?>, Predicate<?>>> list, IMerlinDispMgr<?> mgr) {
        list.add(new Pair(mgr, mgr.getFilter()));
    }

    private static ISceneFinder<IEgressComp> getEgressSceneFinder(final ModelScene egressScene, final ModelScene elevatorScene) {
        return new ISceneFinder<IEgressComp>(){

            @Override
            public Predicate<IEgressComp> getFilter(ModelScene scene) {
                if (scene == egressScene) {
                    return new Predicate<IEgressComp>(){

                        @Override
                        public boolean test(IEgressComp o) {
                            return !(o instanceof IElevatorComp);
                        }
                    };
                }
                return new Predicate<IEgressComp>(){

                    @Override
                    public boolean test(IEgressComp o) {
                        return o instanceof IElevatorComp;
                    }
                };
            }

            @Override
            public ModelScene[] getPossibleScenes() {
                return new ModelScene[]{egressScene, elevatorScene};
            }
        };
    }

    public Collection<IMerlinDispMgr<?>> getManagers() {
        return theUtil.map(this.d_managers, obj -> (IMerlinDispMgr)obj.v1);
    }

    @Override
    public Predicate<Object> getFilter() {
        return Filters.acceptAll();
    }

    @Override
    public Class<Object> getType() {
        return Object.class;
    }

    @Override
    public void removeAll() {
        for (Pair<IMerlinDispMgr<?>, Predicate<?>> mgr : this.d_managers) {
            ((IMerlinDispMgr)mgr.v1).removeAll();
        }
    }

    private static <T> Collection<T> filter(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        return theUtil.filter(objs, mgr.getType(), mgr.getFilter());
    }

    private static <T> void filterAddDisplays(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        mgr.addDisplays(GlobalDisplayMgr.filter(mgr, objs));
    }

    private static <T> void filterUpdateDisplays(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        mgr.updateDisplays(GlobalDisplayMgr.filter(mgr, objs));
    }

    private static <T> void filterRemoveDisplays(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        mgr.removeDisplays(GlobalDisplayMgr.filter(mgr, objs));
    }

    private static <T> void filterRemoveFromScene(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        mgr.removeFromScene(GlobalDisplayMgr.filter(mgr, objs));
    }

    private static <T> void filterAddToScene(IMerlinDispMgr<T> mgr, Collection<?> objs) {
        mgr.addToScene(GlobalDisplayMgr.filter(mgr, objs));
    }

    @Override
    public void addDisplays(Collection<? extends Object> objs) {
        for (Pair<IMerlinDispMgr<?>, Predicate<?>> mgr : this.d_managers) {
            GlobalDisplayMgr.filterAddDisplays((IMerlinDispMgr)mgr.v1, objs);
        }
    }

    @Override
    public void updateDisplays(Collection<? extends Object> objs) {
        for (Pair<IMerlinDispMgr<?>, Predicate<?>> mgr : this.d_managers) {
            GlobalDisplayMgr.filterUpdateDisplays((IMerlinDispMgr)mgr.v1, objs);
        }
    }

    @Override
    public void removeDisplays(Collection<? extends Object> objs) {
        for (Pair<IMerlinDispMgr<?>, Predicate<?>> mgr : this.d_managers) {
            GlobalDisplayMgr.filterRemoveDisplays((IMerlinDispMgr)mgr.v1, objs);
        }
    }

    @Override
    public void removeFromScene(Collection<? extends Object> objs) {
        for (Pair<IMerlinDispMgr<?>, Predicate<?>> mgr : this.d_managers) {
            GlobalDisplayMgr.filterRemoveFromScene((IMerlinDispMgr)mgr.v1, objs);
        }
    }

    @Override
    public void addToScene(Collection<? extends Object> objs) {
        for (Pair<IMerlinDispMgr<?>, Predicate<?>> mgr : this.d_managers) {
            GlobalDisplayMgr.filterAddToScene((IMerlinDispMgr)mgr.v1, objs);
        }
    }

    @Override
    public void setTransform(Matrix4d xform) {
        for (Pair<IMerlinDispMgr<?>, Predicate<?>> mgr : this.d_managers) {
            ((IMerlinDispMgr)mgr.v1).setTransform(xform);
        }
    }

    @Override
    public void update(Events events) {
        for (Pair<IMerlinDispMgr<?>, Predicate<?>> mgr : this.d_managers) {
            ((IMerlinDispMgr)mgr.v1).update(events);
        }
    }

    @Override
    public void updateAll() {
        for (Pair<IMerlinDispMgr<?>, Predicate<?>> mgr : this.d_managers) {
            ((IMerlinDispMgr)mgr.v1).updateAll();
        }
    }
}

