/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import java.util.function.IntToDoubleFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.property.Function1dProp;
import merlin.data.value.IFunction1d;
import merlin.data.value.PiecewiseFunction1d;
import merlin.gui.value.AValEditor;
import merlin.unitsystem.UnitSystem;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.Graph;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LWSeries;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.theUtil;

public class PiecewiseFunction1dEditor
extends AValEditor<PiecewiseFunction1d> {
    private final Function1dProp d_prop;
    private final guiTable d_table;
    private final Graph d_graph;
    private LWSeries d_loadedSeries;
    private final Semaphore d_valLock;

    public PiecewiseFunction1dEditor(final Function1dProp prop) {
        super(PiecewiseFunction1d.class);
        this.d_prop = prop;
        this.d_valLock = new Semaphore(1);
        String[] headers = new String[]{prop.x.desc, prop.y.desc};
        guiTableEditor ed = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, new Class[]{UnitDouble.class, UnitDouble.class}), 30);
        this.d_table = ed.getTable();
        this.d_table.setNullValuesAllowed(true);
        ArrayList<JButton> loadBtns = new ArrayList<JButton>(prop.predef.length);
        for (final Function1dProp.PredefFunction predefFunc : prop.predef) {
            JButton btn = new JButton(predefFunc.longDesc);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int sel = JOptionPane.showConfirmDialog(PiecewiseFunction1dEditor.this, Intl.intl("The current values will be overwritten. Do you want to continue?"), Intl.intl("Reset Values?"), 0);
                    if (sel == 0) {
                        Component c;
                        IFunction1d func;
                        TableCellEditor ced = PiecewiseFunction1dEditor.this.d_table.getCellEditor();
                        if (ced != null) {
                            ced.cancelCellEditing();
                        }
                        if ((func = predefFunc.func.apply(c = evt.getSource() instanceof Component ? (Component)evt.getSource() : Application.getApp().getActiveFrame())) != null) {
                            PiecewiseFunction1dEditor.this.setValue(func.toPiecewise(UnitSystem.getType(prop.x.unitType, false).getUnit()));
                        }
                    }
                }
            });
            loadBtns.add(btn);
        }
        UnitSystem us = MerlinApp.getApp().getUnitSystem();
        Unit xUnit = us.getUnit(prop.x.unitType);
        Unit yUnit = us.getUnit(prop.y.unitType);
        this.d_table.getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(xUnit));
        this.d_table.getColumnModel().getColumn(1).setCellEditor(new guiTable.UnitDoubleEditor(yUnit));
        this.d_table.autoSizeColumns(700);
        this.d_table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.d_table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, Math.max(300, this.d_table.getPreferredSize().height)));
        this.d_graph = new Graph();
        this.d_graph.setTitle(prop.desc);
        this.d_graph.setAutoRangeX(true);
        this.d_graph.setAutoRangeY(true);
        this.d_graph.setLegendVisible(true);
        this.d_graph.setXTitle(xUnit.toString().isEmpty() ? prop.x.desc : String.format("%s (%s)", prop.x.desc, xUnit.toString()));
        this.d_graph.setYTitle(yUnit.toString().isEmpty() ? prop.y.desc : String.format("%s (%s)", prop.y.desc, yUnit.toString()));
        guiPanel graphComp = new guiPanel();
        graphComp.add((Component)this.d_graph, "Center");
        graphComp.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        graphComp.setPreferredSize(new Dimension(ed.getPreferredSize().width * 3 / 2, 1));
        LWSeries[] currSeries = new LWSeries[]{null};
        this.d_table.getModel().addTableModelListener(e -> {
            if (!this.validateData(false, false)) {
                return;
            }
            PiecewiseFunction1d func = this.saveValue();
            this.removeSeries(currSeries[0]);
            lWSeriesArray[0] = PiecewiseFunction1dEditor.toSeries(prop, func, Intl.intl("New Values"), Color.BLUE);
            this.addSeries(currSeries[0]);
        });
        this.d_table.getModel().addTableModelListener(e -> {
            if (this.d_valLock.tryAcquire()) {
                this.updateValue();
                this.d_valLock.release();
            }
        });
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(ed, new double[]{0.0, 1.0}, new int[]{1, 1}, graphComp, new double[]{1.0, 1.0}, new int[]{1, 1});
        guiPanel btnPnl = new guiPanel();
        GridBagHelper gb2 = new GridBagHelper(btnPnl);
        for (JButton btn : loadBtns) {
            gb2.addRow(btn, 1.0, 0);
        }
        gb2.finalizeRows();
        gb.addRow(btnPnl, 0);
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.addRow(this, 1.0);
    }

    private void removeSeries(LWSeries series) {
        if (series == null) {
            return;
        }
        this.d_graph.removeSeries(series);
        EventQueue.invokeLater(() -> series.close());
        EventQueue.invokeLater(() -> this.d_graph.repaint());
    }

    private void addSeries(LWSeries series) {
        if (series == null) {
            return;
        }
        series.open();
        this.d_graph.addSeries(series);
        EventQueue.invokeLater(() -> this.d_graph.repaint());
    }

    private static LWSeries toSeries(Function1dProp prop, PiecewiseFunction1d func, String name, Color color) {
        UnitSystem us = MerlinApp.getApp().getUnitSystem();
        Unit xUnit = us.getUnit(prop.x.unitType);
        Unit yUnit = us.getUnit(prop.y.unitType);
        UnitDouble xrange = func.entries[func.entries.length - 1].x.sub(func.entries[0].x);
        Supplier<IntStream> ixes = () -> IntStream.range(0, piecewiseFunction1d.entries.length + 2);
        Supplier<IntToDoubleFunction> x = () -> {
            UnitDouble inc = xrange.scale(1000000.0);
            return i -> {
                UnitDouble v = i == 0 || i == piecewiseFunction1d.entries.length + 1 ? (i == 0 ? piecewiseFunction1d.entries[0].x.sub(inc) : piecewiseFunction1d.entries[piecewiseFunction1d.entries.length - 1].x.add(inc)) : piecewiseFunction1d.entries[i - 1].x;
                return v.get(xUnit);
            };
        };
        Supplier<IntToDoubleFunction> y = () -> i -> {
            if (i == 0) {
                ++i;
            } else if (i == piecewiseFunction1d.entries.length + 1) {
                --i;
            }
            return piecewiseFunction1d.entries[i - 1].y.get(yUnit);
        };
        double xscale = xrange.get(xUnit) * 0.1;
        final double maxx = func.entries[func.entries.length - 1].x.get(xUnit) + xscale;
        return new LWSeries(ixes, x, y, name, color, 14, 0, 1){

            @Override
            public double getMinX() {
                return 0.0;
            }

            @Override
            public double getMaxX() {
                return maxx;
            }

            @Override
            public double getMinY() {
                return 0.0;
            }
        };
    }

    private UnitDouble getValue(int row) {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        Object val = model.getValueAt(row, 1);
        return (UnitDouble)val;
    }

    private void setValue(int row, UnitDouble value) {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        model.setValueAt(value, row, 1);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        int numRows = model.getRowCount();
        if (this.d_prop.x.filter != Filters.acceptAll(UnitDouble.class) || this.d_prop.y.filter != Filters.acceptAll(UnitDouble.class)) {
            for (int row = 0; row < numRows; ++row) {
                for (int col = 0; col < 2; ++col) {
                    Predicate<UnitDouble> filter;
                    UnitDouble val = (UnitDouble)model.getValueAt(row, col);
                    if (val == null) continue;
                    Predicate<UnitDouble> predicate = filter = col == 0 ? this.d_prop.x.filter : this.d_prop.y.filter;
                    if (filter.test(val)) continue;
                    if (allowModify) {
                        this.d_table.setRowSelectionInterval(row, row);
                        this.d_table.setColumnSelectionInterval(col, col);
                    }
                    if (showWarn) {
                        String msg = String.format(Intl.intl("Error in table at row %d, col %d:%n%s"), row + 1, col + 1, filter.toString());
                        this.d_table.flagInvalidCell(row, col, showWarn, allowModify, msg);
                    }
                    return false;
                }
            }
        }
        HashMap<UnitDouble, UnitDouble> vals = new HashMap<UnitDouble, UnitDouble>();
        for (int row = 0; row < numRows; ++row) {
            UnitDouble x = (UnitDouble)model.getValueAt(row, 0);
            UnitDouble y = (UnitDouble)model.getValueAt(row, 1);
            if (x == null || y == null) continue;
            if (vals.get(x) != null && !((UnitDouble)vals.get(x)).equals(y)) {
                String msg = String.format(Intl.intl("Multiple values specified for %1$s=%2$s"), this.d_prop.x.desc, MerlinUtil.format(x, this.d_prop.x.unitType));
                this.d_table.flagInvalidCell(row, 0, showWarn, allowModify, msg);
                return false;
            }
            vals.put(x, y);
        }
        if (vals.size() < 2) {
            if (showWarn) {
                JOptionPane.showMessageDialog(this, Intl.intl("There must be at least two entries."), Intl.intl("Not Enough Entries"), 0);
            }
            return false;
        }
        return true;
    }

    @Override
    protected void loadValue(PiecewiseFunction1d var) {
        if (!this.d_valLock.tryAcquire()) {
            return;
        }
        if (this.d_loadedSeries == null) {
            this.d_loadedSeries = PiecewiseFunction1dEditor.toSeries(this.d_prop, var, Intl.intl("Previous Values"), Color.RED);
            this.addSeries(this.d_loadedSeries);
        }
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        int count = model.getRowCount();
        for (int m = count - 1; m >= 0; --m) {
            model.removeRow(m);
        }
        if (var != null) {
            PiecewiseFunction1d.Entry[] entries = var.entries;
            for (int i = 0; i < entries.length; ++i) {
                PiecewiseFunction1d.Entry entry = entries[i];
                Unit ux = MerlinApp.getApp().getUnitSystem().getUnit(this.d_prop.x.unitType);
                Unit uy = MerlinApp.getApp().getUnitSystem().getUnit(this.d_prop.y.unitType);
                model.setValueAt(entry.x.convert(ux), i, 0);
                model.setValueAt(entry.y.convert(uy), i, 1);
            }
        }
        this.setModified(false);
        this.d_valLock.release();
    }

    @Override
    protected PiecewiseFunction1d saveValue() {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        int rows = model.getRowCount();
        HashMap<UnitDouble, UnitDouble> vals = new HashMap<UnitDouble, UnitDouble>();
        for (int row = 0; row < rows; ++row) {
            UnitDouble x = (UnitDouble)model.getValueAt(row, 0);
            UnitDouble y = (UnitDouble)model.getValueAt(row, 1);
            if (x == null || y == null) continue;
            vals.put(x, y);
        }
        ArrayList<PiecewiseFunction1d.Entry> entries = new ArrayList<PiecewiseFunction1d.Entry>(theUtil.map(vals.entrySet(), e -> new PiecewiseFunction1d.Entry((UnitDouble)e.getKey(), (UnitDouble)e.getValue())));
        Collections.sort(entries);
        return new PiecewiseFunction1d(theUtil.toArray(entries, PiecewiseFunction1d.Entry.class));
    }
}

