/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.scripting;

import java.awt.Component;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.scripting.ScriptObj;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiPanel;

public class ScriptEditorPanel
extends guiPanel
implements IEditor<ScriptObj> {
    private final RSyntaxTextArea d_textArea = new RSyntaxTextArea(20, 80);
    private boolean d_modified;

    public ScriptEditorPanel() {
        this.d_textArea.setSyntaxEditingStyle("text/javascript");
        this.d_textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed(e);
            }

            private void changed(DocumentEvent e) {
                ScriptEditorPanel.this.setModified(true);
            }
        });
        this.d_textArea.setEnabled(false);
        RTextScrollPane sp = new RTextScrollPane(this.d_textArea);
        this.add((Component)sp, "Center");
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        this.d_modified = modified;
    }

    @Override
    public boolean isModified() {
        return this.d_modified || super.isModified();
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public ScriptObj preview(ScriptObj previewObj) {
        return previewObj;
    }

    @Override
    public void init(ScriptObj dataObj) {
        if (dataObj == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            this.d_textArea.setText(dataObj.getScript());
            this.setModified(false);
        }
    }

    @Override
    public ScriptObj commit(final ScriptObj dataObj) {
        if (dataObj != null) {
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    Undo.begin(Intl.intl("Edit JSON Object"));
                    md.beginWrite();
                    try {
                        Undo.insertUndoEntry_restore(md, dataObj);
                        dataObj.setScript(ScriptEditorPanel.this.d_textArea.getText());
                    }
                    finally {
                        Undo.end(MerlinApp.getApp().getData());
                        md.endWrite();
                    }
                }
            };
            UIHook.run(this, "JsonPnl.commit", op, 2);
        }
        this.setModified(false);
        return dataObj;
    }
}

